/*
 * Decompiled with CFR 0.152.
 */
package org.wbemservices.wbem.apps.cimworkshop;

import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.wbem.cim.CIMClass;
import javax.wbem.cim.CIMElement;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMMethod;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.client.CIMClient;
import org.wbemservices.wbem.apps.cimworkshop.InvokeMethodDialog;
import org.wbemservices.wbem.apps.cimworkshop.QualifierWindow;
import org.wbemservices.wbem.apps.common.ActionString;
import org.wbemservices.wbem.apps.common.CIMClientObject;
import org.wbemservices.wbem.apps.common.CIMErrorDialog;
import org.wbemservices.wbem.apps.common.Util;

public class CIMMethodsPanel
extends JScrollPane
implements MouseListener,
ActionListener {
    private DefaultListModel listModel;
    private JList methodsList;
    protected JPopupMenu popupMenu;
    protected JMenuItem mnuInvokeMethod;
    protected CIMClient cimClient;
    protected boolean newElement;
    protected boolean isInstance = false;
    protected CIMElement cimElement;

    public CIMMethodsPanel() {
        this(false);
    }

    public CIMMethodsPanel(boolean nElement) {
        this.newElement = nElement;
        this.listModel = new DefaultListModel(){

            public Object getElementAt(int index) {
                CIMMethod method = (CIMMethod)super.getElementAt(index);
                return method.toString();
            }
        };
        this.methodsList = new JList(this.listModel);
        this.methodsList.getSelectionModel().setSelectionMode(0);
        this.methodsList.setBackground(this.getBackground());
        this.methodsList.addMouseListener(this);
        this.setViewportView(this.methodsList);
        this.popupMenu = new JPopupMenu();
        ActionString asQualifiers = new ActionString("LBL_QUALIFIERS");
        ActionString asInvoke = new ActionString("MNU_INVOKE_METHOD");
        JMenuItem menuItem = this.popupMenu.add(new JMenuItem(asQualifiers.getString()));
        menuItem.setActionCommand("QUALIFIERS");
        menuItem.addActionListener(this);
        this.mnuInvokeMethod = new JMenuItem(asInvoke.getString());
        this.mnuInvokeMethod.setActionCommand("INVOKE_METHOD");
        this.mnuInvokeMethod.addActionListener(this);
        this.mnuInvokeMethod.setEnabled(CIMClientObject.userHasWritePermission());
    }

    public void actionPerformed(ActionEvent evt) {
        String actionCmd = evt.getActionCommand();
        if (actionCmd.equals("QUALIFIERS")) {
            this.showQualifiers();
        } else if (actionCmd.equals("INVOKE_METHOD")) {
            this.invokeMethod();
        }
    }

    public void showQualifiers() {
        int index = this.methodsList.getMinSelectionIndex();
        CIMMethod method = (CIMMethod)this.listModel.elementAt(index);
        QualifierWindow qualifierWindow = new QualifierWindow(Util.getFrame(this), this.cimClient, (CIMElement)method, this.newElement);
    }

    public void populateList(CIMClient cc, CIMElement pElement) {
        this.cimClient = cc;
        Vector methods = new Vector();
        Util.setWaitCursor(this);
        this.cimElement = pElement;
        this.listModel.removeAllElements();
        if (pElement != null) {
            if (pElement instanceof CIMInstance) {
                if (this.popupMenu.getComponentIndex(this.mnuInvokeMethod) == -1) {
                    this.popupMenu.add(this.mnuInvokeMethod);
                }
                this.isInstance = true;
                try {
                    CIMObjectPath op = new CIMObjectPath(((CIMInstance)pElement).getClassName());
                    CIMClass cl = this.cimClient.getClass(op, false, true, true, null);
                    methods = cl.getMethods();
                }
                catch (CIMException exc) {
                    CIMErrorDialog.display(this, exc);
                }
            } else if (pElement instanceof CIMClass) {
                methods = ((CIMClass)pElement).getMethods();
            }
            Enumeration enumeration = methods.elements();
            while (enumeration.hasMoreElements()) {
                CIMMethod method = (CIMMethod)enumeration.nextElement();
                this.listModel.addElement(method);
            }
        }
        if (this.listModel.size() > 0) {
            this.methodsList.setSelectedIndex(0);
        }
        Util.setDefaultCursor(this);
    }

    public void invokeMethod() {
        Util.setWaitCursor(this);
        CIMMethod method = (CIMMethod)this.listModel.elementAt(this.methodsList.getSelectedIndex());
        CIMObjectPath op = ((CIMInstance)this.cimElement).getObjectPath();
        InvokeMethodDialog dlg = new InvokeMethodDialog(Util.getFrame(this), method, op);
        Util.setDefaultCursor(this);
    }

    public void mousePressed(MouseEvent evt) {
        if (evt.isPopupTrigger()) {
            this.showPopupMenu(evt.getPoint());
        }
    }

    public void mouseReleased(MouseEvent evt) {
        if (evt.isPopupTrigger()) {
            this.showPopupMenu(evt.getPoint());
        }
    }

    public void mouseClicked(MouseEvent evt) {
        if (evt.isPopupTrigger()) {
            this.showPopupMenu(evt.getPoint());
        } else if (evt.getClickCount() <= 1 || this.isInstance) {
            // empty if block
        }
    }

    public void mouseEntered(MouseEvent evt) {
    }

    public void mouseExited(MouseEvent evt) {
    }

    public CIMMethod getSelectedMethod() {
        int i = this.methodsList.getSelectedIndex();
        if (i >= 0) {
            return (CIMMethod)this.listModel.elementAt(i);
        }
        return null;
    }

    public boolean isSelectionEmpty() {
        return this.methodsList.isSelectionEmpty();
    }

    protected void showPopupMenu(Point point) {
        int index = this.methodsList.locationToIndex(point);
        if (index == -1) {
            return;
        }
        this.methodsList.setSelectedIndex(index);
        Point vpLocation = this.getViewport().getViewPosition();
        this.popupMenu.show(this, point.x - vpLocation.x + 10, point.y - vpLocation.y);
    }
}

