/*
 * Decompiled with CFR 0.152.
 */
package org.wbemservices.wbem.apps.cimworkshop;

import java.awt.Point;
import java.awt.event.ActionEvent;
import java.util.Vector;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableModelListener;
import javax.wbem.cim.CIMClass;
import javax.wbem.cim.CIMDataType;
import javax.wbem.cim.CIMElement;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMProperty;
import javax.wbem.client.CIMClient;
import org.wbemservices.wbem.apps.cimworkshop.AddPropertyDialog;
import org.wbemservices.wbem.apps.cimworkshop.CIMElementsTable;
import org.wbemservices.wbem.apps.cimworkshop.QualifierWindow;
import org.wbemservices.wbem.apps.common.ActionString;
import org.wbemservices.wbem.apps.common.I18N;
import org.wbemservices.wbem.apps.common.Util;

public class CIMPropertiesPanel
extends CIMElementsTable {
    JMenuItem mnuDeleteProp;

    public CIMPropertiesPanel() {
        this(false);
    }

    public CIMPropertiesPanel(boolean nElement) {
        super(0, nElement);
        if (nElement) {
            ActionString asAdd = new ActionString("MNU_ADD_PROPERTY");
            ActionString asDelete = new ActionString("MNU_DELETE_PROPERTY");
            JMenuItem menuItem = this.popupMenu.add(new JMenuItem(asAdd.getString()));
            menuItem.setActionCommand("ADD_PROPERTY");
            menuItem.addActionListener(this);
            this.mnuDeleteProp = this.popupMenu.add(new JMenuItem(asDelete.getString()));
            this.mnuDeleteProp.setActionCommand("DELETE_PROPERTY");
            this.mnuDeleteProp.addActionListener(this);
        } else {
            ActionString asQualifiers = new ActionString("LBL_QUALIFIERS");
            ActionString asShow = new ActionString("MNU_SHOW_VALUE");
            JMenuItem menuItem = this.popupMenu.add(new JMenuItem(asQualifiers.getString()));
            menuItem.setActionCommand("QUALIFIERS");
            menuItem.addActionListener(this);
            menuItem = this.popupMenu.add(new JMenuItem(asShow.getString()));
            menuItem.setActionCommand("SHOW_VALUE");
            menuItem.addActionListener(this);
            this.table.addMouseListener(this);
        }
    }

    public void populateTable(CIMClient cc, CIMElement pElement) {
        this.cimClient = cc;
        this.parentElement = pElement;
        Util.setWaitCursor(this);
        if (pElement == null) {
            this.cimElements = new Vector();
        } else if (this.parentElement instanceof CIMInstance) {
            this.setAccessState(2);
            this.cimElements = ((CIMInstance)this.parentElement).getProperties();
        } else if (this.parentElement instanceof CIMClass) {
            this.cimElements = ((CIMClass)this.parentElement).getProperties();
            this.isClass = true;
        }
        if (this.elementsDataModel != null && this.cimElements != null) {
            this.elementsDataModel.setNumRows(this.cimElements.size());
            this.table.repaint();
            if (this.cimElements.size() > 0) {
                this.table.setRowSelectionInterval(0, 0);
            }
        } else {
            this.elementsDataModel.setNumRows(0);
            this.table.repaint();
        }
        Util.setDefaultCursor(this);
    }

    public void actionPerformed(ActionEvent evt) {
        Util.setWaitCursor(this);
        super.actionPerformed(evt);
        String actionCmd = evt.getActionCommand();
        if (actionCmd.equals("QUALIFIERS")) {
            this.showQualifiers();
        } else if (actionCmd.equals("ADD_PROPERTY")) {
            String name;
            AddPropertyDialog dlg;
            boolean done;
            do {
                done = true;
                dlg = new AddPropertyDialog(Util.getFrame(this));
                name = dlg.getName();
                if (!this.isNameDefined(name)) continue;
                JOptionPane.showMessageDialog(this, I18N.loadStringFormat("ERR_DUP_PROPERTY", name), I18N.loadString("TTL_CIM_ERROR"), 0);
                done = false;
            } while (!done);
            if (name != null) {
                String value = dlg.getType();
                CIMProperty prop = new CIMProperty(name);
                CIMDataType cdt = value.indexOf(95) > 0 ? new CIMDataType(value) : new CIMDataType(this.cimTypes.getCIMType(value));
                prop.setType(cdt);
                this.cimElements.addElement(prop);
                this.elementsDataModel.setNumRows(this.cimElements.size());
            }
        } else if (actionCmd.equals("DELETE_PROPERTY")) {
            this.cimElements.removeElementAt(this.getSelectedRow());
            this.elementsDataModel.setNumRows(this.cimElements.size());
        }
        Util.setDefaultCursor(this);
    }

    public void showQualifiers() {
        CIMProperty property = (CIMProperty)this.cimElements.elementAt(this.getSelectedRow());
        boolean b = this.newElement;
        if (this.uneditableRows.contains(new Integer(this.getSelectedRow()))) {
            b = false;
        }
        QualifierWindow qualifierWindow = new QualifierWindow(Util.getFrame(this), this.cimClient, (CIMElement)property, b);
    }

    public void valueChanged(ListSelectionEvent evt) {
        if (evt.getValueIsAdjusting()) {
            return;
        }
        if (this.mnuDeleteProp != null) {
            boolean b = true;
            if (this.uneditableRows.contains(new Integer(this.getSelectedRow()))) {
                b = false;
            }
            this.mnuDeleteProp.setEnabled(b);
        }
    }

    protected void createPopupMenu(Point point) {
        int currentRow = this.table.rowAtPoint(point);
        CIMProperty prop = (CIMProperty)this.cimElements.elementAt(currentRow);
        this.table.setRowSelectionInterval(currentRow, currentRow);
        Point vpLocation = this.getViewport().getViewPosition();
        this.popupMenu.show(this, point.x - vpLocation.x + 10, point.y - vpLocation.y);
    }

    public void addTableModelListener(TableModelListener tml) {
        this.elementsDataModel.addTableModelListener(tml);
    }

    public Vector getProperties() {
        return this.cimElements;
    }
}

