/*
 * Decompiled with CFR 0.152.
 */
package org.wbemservices.wbem.apps.cimworkshop;

import java.awt.event.ActionEvent;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.event.TableModelEvent;
import javax.wbem.cim.CIMClass;
import javax.wbem.cim.CIMElement;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMMethod;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMProperty;
import javax.wbem.cim.CIMQualifier;
import javax.wbem.cim.CIMQualifierType;
import javax.wbem.client.CIMClient;
import org.wbemservices.wbem.apps.cimworkshop.AddQualifierDialog;
import org.wbemservices.wbem.apps.cimworkshop.CIMElementsTable;
import org.wbemservices.wbem.apps.cimworkshop.CIMFlavorDialog;
import org.wbemservices.wbem.apps.cimworkshop.CIMScopeDialog;
import org.wbemservices.wbem.apps.common.ActionString;
import org.wbemservices.wbem.apps.common.CIMErrorDialog;
import org.wbemservices.wbem.apps.common.I18N;
import org.wbemservices.wbem.apps.common.Util;

public class CIMQualifiersPanel
extends CIMElementsTable {
    public CIMQualifiersPanel(CIMClient cc, CIMElement pElement, boolean nElement) {
        super(1, nElement);
        this.newElement = nElement;
        this.populateTable(cc, pElement);
        ActionString asQualifiers = new ActionString("LBL_QUALIFIERS");
        JLabel lQualifiers = new JLabel(asQualifiers.getString() + ":");
        lQualifiers.setDisplayedMnemonic(asQualifiers.getMnemonic());
        this.setColumnHeaderView(lQualifiers);
        lQualifiers.setLabelFor(this.table);
        this.table.addMouseListener(this);
        ActionString asScope = new ActionString("MNU_SCOPE");
        ActionString asFlavors = new ActionString("MNU_FLAVOR");
        JMenuItem menuItem = this.popupMenu.add(new JMenuItem(asScope.getString()));
        menuItem.setActionCommand("SCOPE");
        menuItem.addActionListener(this);
        menuItem = this.popupMenu.add(new JMenuItem(asFlavors.getString()));
        menuItem.setActionCommand("FLAVOR");
        menuItem.addActionListener(this);
        if (nElement) {
            ActionString asAdd = new ActionString("MNU_ADD_QUALIFIER");
            ActionString asDelete = new ActionString("MNU_DELETE_QUALIFIER");
            menuItem = this.popupMenu.add(new JMenuItem(asAdd.getString()));
            menuItem.setActionCommand("ADD_QUALIFIER");
            menuItem.addActionListener(this);
            menuItem = this.popupMenu.add(new JMenuItem(asDelete.getString()));
            menuItem.setActionCommand("DELETE_QUALIFIER");
            menuItem.addActionListener(this);
        } else {
            ActionString asShow = new ActionString("MNU_SHOW_VALUE");
            menuItem = this.popupMenu.add(new JMenuItem(asShow.getString()));
            menuItem.setActionCommand("SHOW_VALUE");
            menuItem.addActionListener(this);
        }
    }

    public void actionPerformed(ActionEvent evt) {
        super.actionPerformed(evt);
        String actionCmd = evt.getActionCommand();
        if (actionCmd.equals("ADD_QUALIFIER")) {
            try {
                String name;
                boolean done;
                Enumeration e = this.cimClient.enumQualifierTypes(new CIMObjectPath(""));
                Vector<String> qTypes = new Vector<String>();
                while (e.hasMoreElements()) {
                    CIMQualifierType cq = (CIMQualifierType)e.nextElement();
                    qTypes.addElement(cq.getName());
                }
                Util.sortVector(qTypes);
                do {
                    done = true;
                    AddQualifierDialog dlg = new AddQualifierDialog(Util.getFrame(this), qTypes);
                    name = dlg.getName();
                    if (!this.isNameDefined(name)) continue;
                    JOptionPane.showMessageDialog(this, I18N.loadStringFormat("ERR_DUP_QUALIFIER", name), I18N.loadString("TTL_CIM_ERROR"), 0);
                    done = false;
                } while (!done);
                if (name != null) {
                    CIMQualifierType cqt = this.cimClient.getQualifierType(new CIMObjectPath(name));
                    CIMQualifier qualifier = new CIMQualifier(name, cqt);
                    this.cimElements.addElement(qualifier);
                    this.elementsDataModel.setNumRows(this.cimElements.size());
                }
            }
            catch (CIMException e) {
                CIMErrorDialog.display(this, e);
            }
        } else if (actionCmd.equals("DELETE_QUALIFIER")) {
            this.cimElements.removeElementAt(this.getSelectedRow());
            this.elementsDataModel.setNumRows(this.cimElements.size());
        } else if (actionCmd.equals("SCOPE")) {
            CIMQualifier cq = (CIMQualifier)this.cimElements.elementAt(this.getSelectedRow());
            CIMObjectPath op = new CIMObjectPath(cq.getName());
            try {
                CIMQualifierType cqt = this.cimClient.getQualifierType(op);
                Vector scope = cqt.getScope();
                CIMScopeDialog dlg = new CIMScopeDialog(Util.getFrame(this), scope, cq.getName(), false);
            }
            catch (CIMException exc) {
                CIMErrorDialog.display(this, exc);
            }
        } else if (actionCmd.equals("FLAVOR")) {
            CIMQualifier cq = (CIMQualifier)this.cimElements.elementAt(this.getSelectedRow());
            CIMObjectPath op = new CIMObjectPath(cq.getName());
            try {
                CIMQualifierType cqt = this.cimClient.getQualifierType(op);
                Vector flavor = cqt.getFlavor();
                CIMFlavorDialog dlg = new CIMFlavorDialog(Util.getFrame(this), flavor, cq.getName(), false);
            }
            catch (CIMException exc) {
                CIMErrorDialog.display(this, exc);
            }
        }
    }

    public void populateTable(CIMClient cc, CIMElement pElement) {
        Util.setWaitCursor(this);
        this.cimClient = cc;
        this.parentElement = pElement;
        if (pElement == null) {
            this.cimElements = null;
        } else if (pElement instanceof CIMInstance) {
            this.cimElements = ((CIMInstance)this.parentElement).getQualifiers();
        } else if (pElement instanceof CIMClass) {
            this.cimElements = ((CIMClass)this.parentElement).getQualifiers();
        } else if (pElement instanceof CIMProperty) {
            this.cimElements = ((CIMProperty)this.parentElement).getQualifiers();
        } else if (pElement instanceof CIMMethod) {
            this.cimElements = ((CIMMethod)this.parentElement).getQualifiers();
        }
        if (this.elementsDataModel != null && this.cimElements != null) {
            this.elementsDataModel.setNumRows(this.cimElements.size());
            this.table.repaint();
        } else {
            this.elementsDataModel.setNumRows(0);
            this.table.repaint();
        }
        Util.setDefaultCursor(this);
    }

    public Vector getQualifiers() {
        return this.cimElements;
    }

    public void tableChanged(TableModelEvent e) {
    }
}

