/*
 * Decompiled with CFR 0.152.
 */
package org.wbemservices.wbem.apps.cimworkshop;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.wbem.cim.CIMScope;
import org.wbemservices.wbem.apps.cimworkshop.ScopeTypes;
import org.wbemservices.wbem.apps.common.ActionString;
import org.wbemservices.wbem.apps.common.AdminDialog;
import org.wbemservices.wbem.apps.common.ColumnLayout;
import org.wbemservices.wbem.apps.common.ContextHelpListener;
import org.wbemservices.wbem.apps.common.GenInfoPanel;
import org.wbemservices.wbem.apps.common.I18N;
import org.wbemservices.wbem.apps.common.LAYOUT_ALIGNMENT;
import org.wbemservices.wbem.apps.common.Util;

public class CIMScopeDialog
extends AdminDialog
implements ListSelectionListener {
    protected JButton btnOK;
    protected JButton btnCancel;
    protected GenInfoPanel infoPanel = this.getInfoPanel();
    protected JList list;
    protected Vector scope = null;
    protected boolean newElement;

    public CIMScopeDialog(Frame parent, Vector prevScope, String name, boolean nElement) {
        super(parent, I18N.loadStringFormat("TTL_SCOPE", name), false);
        JPanel mainPanel = this.getRightPanel();
        this.newElement = nElement;
        mainPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        JPanel centerPanel = new JPanel(new ColumnLayout(LAYOUT_ALIGNMENT.EXPAND));
        centerPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        ScopeTypes scopeTypes = new ScopeTypes();
        this.list = new JList(scopeTypes.getTypes());
        this.list.getSelectionModel().setSelectionMode(2);
        Enumeration e = prevScope.elements();
        while (e.hasMoreElements()) {
            CIMScope cimScope = (CIMScope)e.nextElement();
            int i = cimScope.getScope();
            this.list.addSelectionInterval(i, i);
        }
        JScrollPane scrollList = new JScrollPane(this.list);
        ActionString asScope = new ActionString("MNU_SCOPE");
        JLabel lScope = new JLabel(asScope.getString() + ":");
        lScope.setDisplayedMnemonic(asScope.getMnemonic());
        lScope.setLabelFor(this.list);
        centerPanel.add(lScope);
        centerPanel.add(scrollList);
        this.btnCancel = this.getCancelBtn();
        this.btnCancel.addActionListener(new ButtonListener());
        this.btnOK = this.getOKBtn();
        if (nElement) {
            this.btnOK.addActionListener(new ButtonListener());
            lScope.setDisplayedMnemonic(asScope.getMnemonic());
            lScope.setLabelFor(this.list);
        } else {
            this.getbuttonPanel().remove(this.btnOK);
            this.btnCancel.setText(I18N.loadString("LBL_CLOSE", "org.wbemservices.wbem.apps.common.common"));
        }
        mainPanel.add(centerPanel);
        this.list.setEnabled(nElement);
        this.setDefaultFocusListener(new ContextHelpListener(this.infoPanel, "cimworkshop", "scope_000.htm"), true);
        this.pack();
        this.setLocation(Util.getCenterPoint(parent, this));
        this.setVisible(true);
    }

    public Vector getSelectedScope() {
        return this.scope;
    }

    public void valueChanged(ListSelectionEvent evt) {
        if (evt.getValueIsAdjusting()) {
            return;
        }
    }

    public void cancelClicked() {
        this.scope = null;
        this.dispose();
    }

    public void okClicked() {
        if (this.newElement) {
            int[] selScope = this.list.getSelectedIndices();
            this.scope = new Vector();
            for (int i = 0; i < selScope.length; ++i) {
                this.scope.addElement(new CIMScope(selScope[i]));
            }
        }
        this.dispose();
    }

    public void windowOpened(WindowEvent evt) {
        super.windowOpened(evt);
        if (this.newElement) {
            this.list.requestFocus();
        } else {
            this.btnCancel.requestFocus();
        }
    }

    class ButtonListener
    implements ActionListener {
        ButtonListener() {
        }

        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == CIMScopeDialog.this.btnCancel) {
                CIMScopeDialog.this.cancelClicked();
            } else if (e.getSource() == CIMScopeDialog.this.btnOK) {
                CIMScopeDialog.this.okClicked();
            }
        }
    }
}

