/*
 * Decompiled with CFR 0.152.
 */
package org.wbemservices.wbem.apps.cimworkshop;

import java.awt.Frame;
import java.awt.event.WindowEvent;
import javax.swing.JOptionPane;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMNameSpace;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.client.CIMClient;
import org.wbemservices.wbem.apps.common.CIMClientObject;
import org.wbemservices.wbem.apps.common.CIMErrorDialog;
import org.wbemservices.wbem.apps.common.ContextHelpListener;
import org.wbemservices.wbem.apps.common.DefaultProperties;
import org.wbemservices.wbem.apps.common.I18N;
import org.wbemservices.wbem.apps.common.LoginDialog;
import org.wbemservices.wbem.apps.common.Util;

public class CWSLoginDialog
extends LoginDialog {
    private static String hostname;

    public CWSLoginDialog(Frame parent) {
        this(parent, null, null);
    }

    public CWSLoginDialog(Frame parent, String servername, String interopns) {
        super(parent, 29, 17);
        if (this.interop != null) {
            if (interopns == null || interopns.trim().length() == 0) {
                interopns = CIMClientObject.getInteropNameSpace();
            }
            this.interop.setText(interopns);
        }
        CIMNameSpace ci = new CIMNameSpace();
        String sName = "";
        sName = servername != null ? servername : ci.getHost();
        this.hname.setText("http://" + sName + "/" + interopns);
        this.setDefaultFocusListener(new ContextHelpListener(this.infoPanel, "cimworkshop", "login_000.htm"), true);
        try {
            this.infoPanel.setUrl(DefaultProperties.getHelpUrl("login_000.htm"));
        }
        catch (Exception e) {
            // empty catch block
        }
        this.hname.addFocusListener(new ContextHelpListener(this.infoPanel, "cimworkshop", "login_010.htm"));
        this.interop.addFocusListener(new ContextHelpListener(this.infoPanel, "cimworkshop", "login_060.htm"));
        this.uname.addFocusListener(new ContextHelpListener(this.infoPanel, "cimworkshop", "login_030.htm"));
        this.pass.addFocusListener(new ContextHelpListener(this.infoPanel, "cimworkshop", "login_040.htm"));
        if (CIMClientObject.getUserName() != null) {
            this.setUserName(CIMClientObject.getUserName());
        }
        this.show();
    }

    public void okClicked() {
        this.setCursor(Util.waitCursor);
        if (CIMClientObject.initialize(this.getHostName(), "", this.getUserName(), this.getPassword(), "")) {
            CIMClient cc = CIMClientObject.getClient();
            String namespace = CIMClientObject.getNameSpace();
            try {
                cc.enumQualifierTypes(new CIMObjectPath("", namespace));
            }
            catch (CIMException e) {
                if (e.getID().equals("XMLERROR")) {
                    JOptionPane.showMessageDialog(this, I18N.loadStringFormat("ERR_HTTP_CONNECT", this.getHostName()), I18N.loadString("TTL_CIM_ERROR"), 0);
                    this.setCursor(Util.defaultCursor);
                    return;
                }
                if (e.getID().equals("CIM_ERR_ACCESS_DENIED")) {
                    CIMErrorDialog.display(this, new CIMException("INVALID_CREDENTIAL"));
                    this.setCursor(Util.defaultCursor);
                    return;
                }
                CIMErrorDialog.display(this, new CIMException("CIM_ERR_INVALID_NAMESPACE", namespace));
                this.setCursor(Util.defaultCursor);
                return;
            }
            this.setLoggedIn(true);
            this.dispose();
        }
        this.setCursor(Util.defaultCursor);
    }

    public void cancelClicked() {
        this.setLoggedIn(false);
        this.dispose();
    }

    public void windowOpened(WindowEvent evt) {
        if (this.getUserName().length() < 1) {
            this.uname.requestFocus();
        } else {
            this.pass.requestFocus();
        }
    }
}

