/*
 * Decompiled with CFR 0.152.
 */
package org.wbemservices.wbem.apps.cimworkshop;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Properties;

public class CWSProperties {
    private static Properties props = new Properties();

    public static String getProperty(String prop) {
        return props.getProperty(prop);
    }

    public static String getProperty(String prop, String defaultProp) {
        return props.getProperty(prop, defaultProp);
    }

    public static void setProperty(String prop, String val) {
        props.put(prop, val);
    }

    public static int getInt(String prop) {
        try {
            return Integer.parseInt(CWSProperties.getProperty(prop));
        }
        catch (NumberFormatException ex) {
            return 0;
        }
    }

    public static int getInt(String prop, int defaultProp) {
        try {
            return Integer.parseInt(CWSProperties.getProperty(prop));
        }
        catch (NumberFormatException ex) {
            return defaultProp;
        }
    }

    public static void setProperty(String prop, int i) {
        props.put(prop, String.valueOf(i));
    }

    public static boolean getBoolean(String prop) {
        boolean b = false;
        String s = CWSProperties.getProperty(prop);
        if (s != null && (s.startsWith("t") || s.startsWith("y"))) {
            b = true;
        }
        return b;
    }

    public static void setProperty(String prop, boolean b) {
        props.put(prop, String.valueOf(b));
    }

    public static Font getFont(String font) {
        return Font.decode(CWSProperties.getProperty(font));
    }

    public static Dimension getSize(String prop) {
        try {
            int width = Integer.parseInt(CWSProperties.getProperty(prop + ".width"));
            int height = Integer.parseInt(CWSProperties.getProperty(prop + ".height"));
            return new Dimension(width, height);
        }
        catch (NumberFormatException ex) {
            return null;
        }
    }

    public static void setProperty(String prop, Dimension d) {
        props.put(prop + ".width", String.valueOf(d.width));
        props.put(prop + ".height", String.valueOf(d.height));
    }

    public static Point getPoint(String prop) {
        try {
            int x = Integer.parseInt(CWSProperties.getProperty(prop + ".x"));
            int y = Integer.parseInt(CWSProperties.getProperty(prop + ".y"));
            return new Point(x, y);
        }
        catch (NumberFormatException ex) {
            return null;
        }
    }

    public static void setProperty(String prop, Point p) {
        props.put(prop + ".x", String.valueOf(p.x));
        props.put(prop + ".y", String.valueOf(p.y));
    }

    public static Rectangle getRect(String prop) {
        Point p = CWSProperties.getPoint(prop);
        Dimension d = CWSProperties.getSize(prop);
        if (p == null || d == null) {
            return null;
        }
        return new Rectangle(p, d);
    }

    public static void setProperty(String prop, Rectangle r) {
        CWSProperties.setProperty(prop, r.getLocation());
        CWSProperties.setProperty(prop, r.getSize());
    }

    public static boolean contains(String prop, int x, int y) {
        Rectangle r = CWSProperties.getRect(prop);
        if (r == null) {
            return false;
        }
        return r.contains(x, y);
    }

    public static Insets getInsets(String prop) {
        try {
            int top = Integer.parseInt(CWSProperties.getProperty(prop + ".top"));
            int left = Integer.parseInt(CWSProperties.getProperty(prop + ".left"));
            int bottom = Integer.parseInt(CWSProperties.getProperty(prop + ".bottom"));
            int right = Integer.parseInt(CWSProperties.getProperty(prop + ".right"));
            return new Insets(top, left, bottom, right);
        }
        catch (NumberFormatException ex) {
            return null;
        }
    }
}

