/*
 * Decompiled with CFR 0.152.
 */
package org.wbemservices.wbem.apps.cimworkshop;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Enumeration;
import java.util.Stack;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.client.CIMClient;
import org.wbemservices.wbem.apps.common.ActionString;
import org.wbemservices.wbem.apps.common.CIMClientObject;
import org.wbemservices.wbem.apps.common.CIMErrorDialog;
import org.wbemservices.wbem.apps.common.I18N;
import org.wbemservices.wbem.apps.common.Util;

public class ClassTreePane
extends JScrollPane
implements ActionListener,
TreeSelectionListener,
TreeExpansionListener,
MouseListener {
    protected JTree tree;
    protected DefaultTreeSelectionModel selectionModel;
    protected DefaultTreeModel treeModel;
    protected JComboBox objectBox;
    protected JScrollPane thisPane = this;
    protected CIMClient cimClient = null;
    protected RootTreeNode root;
    protected JPopupMenu popupMenu = new JPopupMenu();
    protected JPopupMenu rootPopupMenu = new JPopupMenu();
    protected ImageIcon classIcon;

    public ClassTreePane() {
        this.root = new RootTreeNode(new CIMObjectPath());
        this.treeModel = new DefaultTreeModel(this.root);
        this.tree = new JTree(this.treeModel);
        this.tree.addTreeSelectionListener(this);
        this.tree.addTreeExpansionListener(this);
        this.tree.addMouseListener(this);
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.setRootVisible(true);
        this.tree.setBorder(BorderFactory.createBevelBorder(1));
        this.selectionModel = (DefaultTreeSelectionModel)this.tree.getSelectionModel();
        this.classIcon = Util.loadImageIcon("class.gif");
        TreeCellRenderer cellRenderer = this.tree.getCellRenderer();
        if (cellRenderer instanceof DefaultTreeCellRenderer) {
            CustomBasicRenderer cbr = new CustomBasicRenderer();
            this.tree.setCellRenderer(cbr);
        }
        ActionString asSchema = new ActionString("LBL_CLASS_SCHEMA");
        JLabel lSchema = new JLabel(asSchema.getString() + ":");
        lSchema.setDisplayedMnemonic(asSchema.getMnemonic());
        this.setTreeLabel(lSchema);
        this.setViewportView(this.tree);
    }

    public void valueChanged(TreeSelectionEvent e) {
    }

    public void addTreeSelectionListener(TreeSelectionListener listener) {
        this.tree.addTreeSelectionListener(listener);
    }

    public void treeExpanded(TreeExpansionEvent e) {
        TreePath path = e.getPath();
        ClassTreeNode node = (ClassTreeNode)path.getLastPathComponent();
        if (!node.isExplored()) {
            Cursor oldCursor = this.getCursor();
            Util.setWaitCursor(this);
            this.exploreNode(node);
            Util.setCursor(this, oldCursor);
        }
    }

    public void treeCollapsed(TreeExpansionEvent e) {
    }

    public ClassTreeNode getSelectedNode() {
        if (this.tree.getSelectionPath() == null) {
            return null;
        }
        return (ClassTreeNode)this.tree.getSelectionPath().getLastPathComponent();
    }

    public String getSelectedNodeString() {
        ClassTreeNode node = this.getSelectedNode();
        if (node == null) {
            return null;
        }
        return node.toString();
    }

    /*
     * Enabled aggressive block sorting
     */
    public void actionPerformed(ActionEvent e) {
        Util.setWaitCursor(this);
        String action = e.getActionCommand();
        if (action.equals("FIND_CLASS")) {
            String className = JOptionPane.showInputDialog(this, (Object)I18N.loadString("ASK_FIND_CLASS"));
            if (className != null && !className.equals("")) {
                Stack s = new Stack();
                Util.setWaitCursor(this);
                if (this.findClass(new CIMObjectPath(""), className, s)) {
                    Stack s1 = (Stack)s.clone();
                    if (!this.selectNode(s1)) {
                        this.refreshTree(this.root);
                        if (this.selectNode(s)) {
                            // empty if block
                        }
                    }
                } else {
                    JOptionPane.showMessageDialog(this, I18N.loadStringFormat("ERR_FIND_CLASS", className), I18N.loadString("TTL_CIM_ERROR"), 1);
                }
                Util.setDefaultCursor(this);
            }
        } else if (action.equals("REFRESH")) {
            this.refreshTree(this.getSelectedNode());
        }
        Util.setDefaultCursor(this);
    }

    private void exploreNode(ClassTreeNode node) {
        Enumeration childList = node.getChildList();
        if (childList == null) {
            node.setChildList();
            childList = node.getChildList();
        }
        if (!node.isExplored() && childList != null) {
            int i = 0;
            DefaultTreeModel model = (DefaultTreeModel)this.tree.getModel();
            while (childList.hasMoreElements()) {
                CIMObjectPath op = (CIMObjectPath)childList.nextElement();
                ClassTreeNode childNode = new ClassTreeNode(op);
                model.insertNodeInto(childNode, node, i++);
            }
            node.setExplored();
        }
    }

    protected void generateTree(ClassTreeNode node) {
        this.cleanTree(node);
        this.exploreNode(node);
    }

    protected void cleanTree(ClassTreeNode node) {
        DefaultTreeModel model = (DefaultTreeModel)this.tree.getModel();
        TreePath path = new TreePath(node.getPath());
        this.tree.setSelectionPath(path);
        while (model.getChildCount(node) > 0) {
            ClassTreeNode child = (ClassTreeNode)model.getChild(node, 0);
            model.removeNodeFromParent(child);
        }
        node.clear();
    }

    public void mousePressed(MouseEvent evt) {
        if (evt.isPopupTrigger()) {
            this.showPopupMenu(evt.getPoint());
        }
    }

    public void mouseReleased(MouseEvent evt) {
        if (evt.isPopupTrigger()) {
            this.showPopupMenu(evt.getPoint());
        }
    }

    public void mouseClicked(MouseEvent evt) {
        if (evt.isPopupTrigger()) {
            this.showPopupMenu(evt.getPoint());
        }
    }

    public void mouseEntered(MouseEvent evt) {
    }

    public void mouseExited(MouseEvent evt) {
    }

    protected void showPopupMenu(Point point) {
        TreePath path = this.tree.getPathForLocation(point.x, point.y);
        if (path == null) {
            return;
        }
        this.tree.setSelectionPath(path);
        JPopupMenu popup = this.getSelectedNode() == this.root ? this.rootPopupMenu : this.popupMenu;
        Point vpLocation = this.getViewport().getViewPosition();
        popup.show(this, point.x - vpLocation.x + 10, point.y - vpLocation.y);
    }

    protected void deleteSelectedNode() {
        ClassTreeNode selectedNode = this.getSelectedNode();
        DefaultTreeModel model = (DefaultTreeModel)this.tree.getModel();
        ClassTreeNode parent = (ClassTreeNode)selectedNode.getParent();
        ClassTreeNode newSelectionNode = (ClassTreeNode)parent.getChildBefore(selectedNode);
        if (newSelectionNode == null) {
            newSelectionNode = (ClassTreeNode)parent.getChildAfter(selectedNode);
        }
        if (newSelectionNode == null) {
            newSelectionNode = parent;
            parent.setLeaf(true);
        }
        TreePath path = new TreePath(newSelectionNode.getPath());
        this.tree.setSelectionPath(path);
        model.removeNodeFromParent(selectedNode);
        model.reload(parent);
        this.tree.expandPath(path);
        this.tree.scrollPathToVisible(path);
        this.tree.setSelectionPath(path);
    }

    public boolean isRootSelected() {
        return this.getSelectedNode() instanceof RootTreeNode;
    }

    public void setTreeLabel(JLabel label) {
        this.setColumnHeaderView(label);
        label.setLabelFor(this.tree);
    }

    protected boolean findClass(CIMObjectPath objectPath, String className, Stack searchStack) {
        searchStack.push(objectPath);
        if (objectPath.getObjectName().equalsIgnoreCase(className)) {
            return true;
        }
        try {
            Enumeration e = this.cimClient.enumerateClassNames(objectPath, false);
            while (e.hasMoreElements()) {
                CIMObjectPath op = (CIMObjectPath)e.nextElement();
                if (!this.findClass(op, className, searchStack)) continue;
                return true;
            }
        }
        catch (CIMException exc) {
            // empty catch block
        }
        searchStack.pop();
        return false;
    }

    public void refreshTree() {
        this.cimClient = CIMClientObject.getClient();
        this.root.setLabel(CIMClientObject.getNameSpace());
        this.tree.setSelectionRow(0);
        this.refreshTree(this.root);
    }

    public void refreshTree(ClassTreeNode node) {
        this.generateTree(node);
        this.tree.expandPath(new TreePath(node));
        this.tree.repaint();
    }

    public void refreshSelectedNode() {
        this.refreshTree(this.getSelectedNode());
    }

    protected boolean selectNode(Stack s) {
        s.removeElementAt(0);
        boolean foundNode = false;
        ClassTreeNode node = this.root;
        for (int i = 0; i < s.size(); ++i) {
            foundNode = false;
            String opName = ((CIMObjectPath)s.elementAt(i)).getObjectName();
            Enumeration<TreeNode> e = node.children();
            while (e.hasMoreElements()) {
                node = (ClassTreeNode)e.nextElement();
                if (!opName.equals(node.toString())) continue;
                foundNode = true;
                break;
            }
            this.exploreNode(node);
        }
        if (foundNode) {
            TreePath path = new TreePath(node.getPath());
            this.tree.setSelectionPath(path);
            this.tree.expandPath(path);
            this.tree.scrollPathToVisible(path);
        }
        return foundNode;
    }

    public ClassTreeNode addNodeToSelected(String nodeName) {
        ClassTreeNode newNode = new ClassTreeNode(new CIMObjectPath(nodeName));
        return this.addNodeToSelected(newNode);
    }

    public ClassTreeNode addNodeToSelected(ClassTreeNode newNode) {
        ClassTreeNode selectedNode = this.getSelectedNode();
        DefaultTreeModel model = (DefaultTreeModel)this.tree.getModel();
        Enumeration<TreeNode> e = selectedNode.children();
        int insertIndex = 0;
        while (e.hasMoreElements() && newNode.toString().compareToIgnoreCase(e.nextElement().toString()) >= 0) {
            ++insertIndex;
        }
        model.insertNodeInto(newNode, selectedNode, insertIndex);
        selectedNode.setLeaf(false);
        return newNode;
    }

    class RootTreeNode
    extends ClassTreeNode {
        private String label = "root";

        public RootTreeNode(CIMObjectPath op) {
            super(op);
        }

        public void setLabel(String l) {
            this.label = l;
        }

        public String toString() {
            return this.label;
        }
    }

    class ClassTreeNode
    extends DefaultMutableTreeNode {
        protected boolean explored = false;
        protected boolean leaf = false;
        protected Enumeration childList = null;

        public ClassTreeNode() {
        }

        public ClassTreeNode(CIMObjectPath op) {
            this.setUserObject(op);
            this.setChildList();
        }

        public void clear() {
            this.explored = false;
            this.childList = null;
        }

        public CIMObjectPath getObjectPath() {
            return (CIMObjectPath)this.getUserObject();
        }

        public String toString() {
            CIMObjectPath op = (CIMObjectPath)this.getUserObject();
            return op.getObjectName().toString();
        }

        public boolean isLeaf() {
            return this.leaf;
        }

        public void setLeaf(boolean b) {
            this.leaf = b;
        }

        public boolean isExplored() {
            return this.explored;
        }

        public void setExplored() {
            this.explored = true;
        }

        public void setExplored(boolean b) {
            this.explored = b;
        }

        public Enumeration getChildList() {
            return this.childList;
        }

        public void setChildList() {
            try {
                if (ClassTreePane.this.cimClient != null) {
                    Enumeration e = ClassTreePane.this.cimClient.enumerateClassNames(this.getObjectPath(), false);
                    this.childList = Util.sortEnumeration(e);
                    this.leaf = !this.childList.hasMoreElements();
                } else {
                    this.leaf = true;
                }
            }
            catch (CIMException exc) {
                CIMErrorDialog.display(ClassTreePane.this.thisPane, exc);
                return;
            }
        }
    }

    protected class CustomBasicRenderer
    extends DefaultTreeCellRenderer {
        protected CustomBasicRenderer() {
        }

        public Component getTreeCellRendererComponent(JTree theTree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            Component c = super.getTreeCellRendererComponent(theTree, value, selected, expanded, leaf, row, hasFocus);
            if (c instanceof JLabel) {
                JLabel l = (JLabel)c;
                if (leaf && row != 0) {
                    l.setIcon(ClassTreePane.this.classIcon);
                }
            }
            return c;
        }
    }
}

