/*
 * Decompiled with CFR 0.152.
 */
package org.wbemservices.wbem.apps.cimworkshop;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.wbem.cim.CIMClass;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMProperty;
import javax.wbem.cim.CIMValue;
import javax.wbem.client.CIMClient;
import org.wbemservices.wbem.apps.cimworkshop.CIMKeyPropertiesPanel;
import org.wbemservices.wbem.apps.common.ActionString;
import org.wbemservices.wbem.apps.common.AdminDialog;
import org.wbemservices.wbem.apps.common.ContextHelpListener;
import org.wbemservices.wbem.apps.common.GenInfoPanel;
import org.wbemservices.wbem.apps.common.I18N;
import org.wbemservices.wbem.apps.common.Util;

public class CreateInstanceDialog
extends AdminDialog
implements ActionListener,
TableModelListener {
    protected JButton btnOK;
    protected JButton btnCancel;
    protected GenInfoPanel infoPanel;
    protected CIMClient cimClient;
    protected CIMInstance newInstance;
    protected String selectedNameSpace;
    protected CIMKeyPropertiesPanel table;
    protected JTextArea msg;
    protected Vector properties;

    public CreateInstanceDialog(Frame parent, CIMClient cc, CIMClass cClass) {
        super(parent, "", false);
        this.setTitle(I18N.loadStringFormat("TTL_ADD_INSTANCE", cClass.getName()));
        this.cimClient = cc;
        this.infoPanel = this.getInfoPanel();
        JPanel pane = this.getRightPanel();
        pane.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        pane.setLayout(new BorderLayout());
        ActionString asProps = new ActionString("LBL_PROPERTIES");
        JLabel lProps = new JLabel(asProps.getString() + ":");
        lProps.setDisplayedMnemonic(asProps.getMnemonic());
        this.newInstance = cClass.newInstance();
        this.table = new CIMKeyPropertiesPanel(this.cimClient, this.newInstance);
        this.table.setPreferredSize(new Dimension(300, 200));
        lProps.setLabelFor(this.table.getTable());
        lProps.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.table.addTableListener(this);
        this.btnOK = this.getOKBtn();
        this.btnOK.addActionListener(new OKCancelButtonListener());
        this.btnCancel = this.getCancelBtn();
        this.btnCancel.addActionListener(new OKCancelButtonListener());
        pane.add("North", lProps);
        pane.add("Center", this.table);
        this.setDefaultFocusListener(new ContextHelpListener(this.infoPanel, "cimworkshop", "AddInstance_000.htm"), true);
        this.btnOK.addFocusListener(new ContextHelpListener(this.infoPanel, "cimworkshop", "AddInstance_000.htm"));
        this.btnCancel.addFocusListener(new ContextHelpListener(this.infoPanel, "cimworkshop", "AddInstance_000.htm"));
        this.pack();
        this.enableOKBtn();
        this.setLocation(Util.getCenterPoint(parent, this));
        this.setVisible(true);
    }

    protected void enableOKBtn() {
        Vector newProperties = this.table.getProperties();
        Enumeration e = newProperties.elements();
        while (e.hasMoreElements()) {
            CIMValue cv;
            CIMProperty cp = (CIMProperty)e.nextElement();
            if (!cp.isKey() || (cv = cp.getValue()) != null && cv.getValue() != null) continue;
            this.btnOK.setEnabled(false);
            return;
        }
        this.btnOK.setEnabled(true);
    }

    public void tableChanged(TableModelEvent evt) {
        this.enableOKBtn();
    }

    public CIMInstance getInstance() {
        return this.newInstance;
    }

    public void okClicked() {
        Vector newProperties = this.table.getProperties();
        try {
            this.newInstance.updatePropertyValues(newProperties);
        }
        catch (CIMException ex) {
            ex.printStackTrace();
        }
        this.dispose();
    }

    public void cancelClicked() {
        this.newInstance = null;
        this.dispose();
    }

    public void windowOpened(WindowEvent evt) {
        super.windowOpened(evt);
        JTable propTable = this.table.getTable();
        propTable.requestFocus();
        if (propTable.getRowCount() > 0) {
            propTable.setRowSelectionInterval(0, 0);
        }
    }

    class OKCancelButtonListener
    implements ActionListener {
        OKCancelButtonListener() {
        }

        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == CreateInstanceDialog.this.btnCancel) {
                CreateInstanceDialog.this.cancelClicked();
            } else if (e.getSource() == CreateInstanceDialog.this.btnOK) {
                CreateInstanceDialog.this.okClicked();
            }
        }
    }
}

