/*
 * Decompiled with CFR 0.152.
 */
package org.wbemservices.wbem.apps.cimworkshop;

import java.awt.Frame;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Enumeration;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.wbem.cim.CIMClass;
import javax.wbem.cim.CIMElement;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMObjectPath;
import org.wbemservices.wbem.apps.cimworkshop.CIMTableTabbedPane;
import org.wbemservices.wbem.apps.cimworkshop.CreateInstanceDialog;
import org.wbemservices.wbem.apps.cimworkshop.InstanceFrame;
import org.wbemservices.wbem.apps.cimworkshop.InstancePanel;
import org.wbemservices.wbem.apps.cimworkshop.ReferenceTraversalDialog;
import org.wbemservices.wbem.apps.common.ActionString;
import org.wbemservices.wbem.apps.common.CIMClientObject;
import org.wbemservices.wbem.apps.common.CIMErrorDialog;
import org.wbemservices.wbem.apps.common.I18N;
import org.wbemservices.wbem.apps.common.Util;

public class InstanceActionPanel
extends InstancePanel
implements MouseListener,
ListSelectionListener,
ActionListener,
ListDataListener,
TableModelListener {
    private CIMTableTabbedPane tablePane;
    private JPopupMenu popupMenu;
    private JMenuItem mnuDeleteInstance;
    private InstanceFrame instanceFrame;
    private boolean propertyChanged;
    private boolean writePermission = false;
    private int prevInstanceIndex = -1;

    public InstanceActionPanel(CIMTableTabbedPane tp, InstanceFrame iFrame, CIMClass cClass) {
        this(tp, iFrame, cClass, false);
    }

    public InstanceActionPanel(CIMTableTabbedPane tp, InstanceFrame iFrame, CIMClass cClass, boolean deepEnum) {
        super(cClass, deepEnum);
        this.tablePane = tp;
        this.instanceFrame = iFrame;
        this.tablePane.addPropertyTableModelListener(this);
        this.writePermission = CIMClientObject.userHasWritePermission();
        this.popupMenu = new JPopupMenu();
        ActionString asRefresh = new ActionString("MNU_REFRESH", "org.wbemservices.wbem.apps.common.common");
        ActionString asAdd = new ActionString("MNU_ADD_INSTANCE");
        ActionString asDelete = new ActionString("MNU_DELETE_INSTANCE");
        JMenuItem popupMenuItem = this.popupMenu.add(new JMenuItem(asRefresh.getString()));
        popupMenuItem.setActionCommand("REFRESH");
        popupMenuItem.addActionListener(this);
        popupMenuItem = this.popupMenu.add(new JMenuItem(asAdd.getString()));
        popupMenuItem.setActionCommand("ADD_INSTANCE");
        popupMenuItem.addActionListener(this);
        popupMenuItem.setEnabled(this.writePermission);
        this.mnuDeleteInstance = this.popupMenu.add(new JMenuItem(asDelete.getString()));
        this.mnuDeleteInstance.addActionListener(this);
        this.mnuDeleteInstance.setActionCommand("DELETE_INSTANCE");
        this.mnuDeleteInstance.setEnabled(false);
        this.listModel.addListDataListener(this);
        this.instanceList.addMouseListener(this);
        this.instanceList.getSelectionModel().addListSelectionListener(this);
        this.setVisible(true);
    }

    public void actionPerformed(ActionEvent e) {
        String actionCmd = e.getActionCommand();
        if (actionCmd.equals("ADD_INSTANCE")) {
            CreateInstanceDialog dlg = new CreateInstanceDialog(Util.getFrame(this), this.cimClient, this.cimClass);
            CIMInstance newInstance = dlg.getInstance();
            if (newInstance != null) {
                try {
                    CIMObjectPath newObjectPath = newInstance.getObjectPath();
                    this.cimClient.createInstance(newObjectPath, newInstance);
                    this.refreshInstanceList();
                    this.instanceList.setSelectedIndex(this.listModel.size() - 1);
                }
                catch (CIMException exc) {
                    CIMErrorDialog.display(this, exc);
                }
            }
        } else if (actionCmd.equals("DELETE_INSTANCE")) {
            int option;
            int i;
            if (this.propertyChanged) {
                this.saveCurrentInstance(true);
            }
            if ((i = this.instanceList.getSelectedIndex()) >= 0 && (option = JOptionPane.showConfirmDialog(this, I18N.loadStringFormat("ASK_DELETE_INSTANCE", this.listModel.getElementAt(i)), I18N.loadString("TTL_DLG_CIM_WORKSHOP"), 2, 3)) == 0) {
                try {
                    this.cimClient.deleteInstance((CIMObjectPath)this.listModel.elementAt(i));
                    this.listModel.removeElementAt(i);
                }
                catch (CIMException exc) {
                    CIMErrorDialog.display(this, exc);
                }
            }
        } else if (actionCmd.equals("ASSOC_TRAVERSAL")) {
            int i;
            if (this.propertyChanged) {
                this.saveCurrentInstance(true);
            }
            if ((i = this.instanceList.getSelectedIndex()) >= 0) {
                CIMObjectPath op = (CIMObjectPath)this.listModel.elementAt(i);
                ReferenceTraversalDialog refDialog = new ReferenceTraversalDialog((Frame)this.instanceFrame, op, this.cimClient);
            }
        } else if (actionCmd.equals("SAVE_INSTANCE")) {
            this.saveCurrentInstance(false);
        } else {
            super.actionPerformed(e);
        }
    }

    public void saveCurrentInstance(boolean askToSave) {
        this.saveInstance(this.instanceList.getSelectedIndex(), askToSave);
    }

    public void saveInstance(int index, boolean askToSave) {
        int option = 0;
        if (index >= 0) {
            CIMObjectPath instanceOP = (CIMObjectPath)this.listModel.elementAt(index);
            if (askToSave) {
                option = JOptionPane.showConfirmDialog(this, I18N.loadStringFormat("ASK_SAVE_INSTANCE_PROPERTIES", instanceOP.toString()), I18N.loadString("TTL_DLG_CIM_WORKSHOP"), 2, 3);
            }
            if (option == 0) {
                try {
                    CIMInstance ci = this.cimClient.getInstance(instanceOP, false, true, true, null);
                    ci.updatePropertyValues(this.tablePane.getProperties());
                    this.cimClient.setInstance(instanceOP, ci);
                }
                catch (CIMException exc) {
                    CIMErrorDialog.display(this, exc);
                }
            }
        }
        this.instanceFrame.enableSaveInstanceMenu(false);
        this.propertyChanged = false;
    }

    public void valueChanged(ListSelectionEvent evt) {
        int i;
        if (evt.getValueIsAdjusting()) {
            return;
        }
        if (this.propertyChanged) {
            this.saveInstance(this.prevInstanceIndex, true);
        }
        this.prevInstanceIndex = i = this.instanceList.getSelectedIndex();
        Util.setWaitCursor(this);
        if (!this.listModel.isEmpty() && i >= 0 && i < this.listModel.size()) {
            try {
                boolean bAssocMenu;
                block8: {
                    CIMObjectPath op = (CIMObjectPath)this.listModel.elementAt(i);
                    CIMInstance ci = this.cimClient.getInstance(op, false, true, true, null);
                    this.tablePane.populateTables(this.cimClient, (CIMElement)ci);
                    bAssocMenu = false;
                    try {
                        Enumeration e = this.cimClient.referenceNames(op, "", "");
                        bAssocMenu = e != null;
                    }
                    catch (CIMException e) {
                        if (!e.getID().equals("NOT_ASSOCIATOR_PROVIDER")) break block8;
                        bAssocMenu = true;
                    }
                }
                this.instanceFrame.enableAssocMenu(bAssocMenu);
            }
            catch (CIMException exc) {
                this.tablePane.populateTables(null, null);
                CIMErrorDialog.display(this, exc);
            }
        } else {
            this.tablePane.populateTables(null, null);
        }
        Util.setDefaultCursor(this);
    }

    public void mousePressed(MouseEvent evt) {
        if (evt.isPopupTrigger()) {
            this.showPopupMenu(evt.getPoint());
        }
    }

    public void mouseReleased(MouseEvent evt) {
        if (evt.isPopupTrigger()) {
            this.showPopupMenu(evt.getPoint());
        }
    }

    public void mouseClicked(MouseEvent evt) {
        if (evt.isPopupTrigger()) {
            this.showPopupMenu(evt.getPoint());
        }
    }

    public void mouseEntered(MouseEvent evt) {
    }

    public void refreshInstanceList() {
        if (this.propertyChanged) {
            this.saveCurrentInstance(true);
        }
        super.refreshInstanceList();
        boolean b = this.listModel.size() > 0;
        this.instanceFrame.enableAssocMenu(b);
        this.instanceFrame.enablePropMenu(b);
        b = b && this.writePermission;
        this.instanceFrame.enableDeleteInstanceMenu(b);
        this.mnuDeleteInstance.setEnabled(b);
    }

    public void mouseExited(MouseEvent evt) {
    }

    protected void showPopupMenu(Point point) {
        int index = this.instanceList.locationToIndex(point);
        if (index == -1) {
            return;
        }
        this.instanceList.setSelectedIndex(index);
        Point vpLocation = this.getViewport().getViewPosition();
        this.popupMenu.show(this, point.x - vpLocation.x + 10, point.y - vpLocation.y);
    }

    public void intervalAdded(ListDataEvent e) {
        this.mnuDeleteInstance.setEnabled(this.writePermission);
        this.instanceFrame.enableDeleteInstanceMenu(this.writePermission);
        this.instanceFrame.enablePropMenu(true);
    }

    public void intervalRemoved(ListDataEvent e) {
        this.setViewPort();
        if (this.listModel.size() <= 0) {
            this.mnuDeleteInstance.setEnabled(false);
            this.instanceFrame.enableDeleteInstanceMenu(false);
            this.instanceFrame.enableAssocMenu(false);
            this.instanceFrame.enablePropMenu(false);
            this.tablePane.populateTables(null, null);
            return;
        }
        int index = e.getIndex0();
        if (index > 0) {
            --index;
        }
        this.instanceList.setSelectedIndex(index);
    }

    public void contentsChanged(ListDataEvent e) {
    }

    public void tableChanged(TableModelEvent evt) {
        int evtType = evt.getType();
        if (evtType == 0) {
            this.instanceFrame.enableSaveInstanceMenu(this.writePermission);
            this.propertyChanged = true;
        }
    }
}

