/*
 * Decompiled with CFR 0.152.
 */
package org.wbemservices.wbem.apps.cimworkshop;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.wbem.cim.CIMClass;
import javax.wbem.client.CIMClient;
import org.wbemservices.wbem.apps.cimworkshop.CIMTableTabbedPane;
import org.wbemservices.wbem.apps.cimworkshop.InstanceActionPanel;
import org.wbemservices.wbem.apps.common.AboutDialog;
import org.wbemservices.wbem.apps.common.ActionString;
import org.wbemservices.wbem.apps.common.CIMClientObject;
import org.wbemservices.wbem.apps.common.I18N;
import org.wbemservices.wbem.apps.common.ToolBarPanel;
import org.wbemservices.wbem.apps.common.Util;

public class InstanceFrame
extends JFrame
implements WindowListener,
ActionListener {
    private CIMTableTabbedPane tablePane;
    InstanceActionPanel instancePanel;
    private JSplitPane desktop;
    private JButton btnDeleteInstance;
    private JButton btnSaveInstance;
    private JButton btnAddInstance;
    private JMenu mnuInstanceEditor;
    private JMenu mnuAction;
    private JMenu mnuProperties;
    private JMenu mnuMethods;
    private JMenu mnuHelp;
    private JMenuItem mnuExit;
    private JMenuItem mnuAddInstance;
    private JMenuItem mnuDeleteInstance;
    private JMenuItem mnuSaveInstance;
    private JMenuItem mnuAssocTraversal;
    private JMenuItem mnuRefresh;
    private JMenuItem mnuPropQualifiers;
    private JMenuItem mnuShowValue;
    private JMenuItem mnuMethodQualifiers;
    private JMenuItem mnuInvokeMethod;
    private JMenuItem mnuHelpAbout;

    public InstanceFrame(Frame parent, CIMClient cimClient, CIMClass cimClass) {
        this(parent, cimClient, cimClass, false);
    }

    public InstanceFrame(Frame parent, CIMClient cimClient, CIMClass cimClass, boolean deep) {
        this.setTitle(I18N.loadStringFormat("TTL_INSTANCES", cimClass.getName()));
        JPanel pane = (JPanel)this.getContentPane();
        pane.setLayout(new BorderLayout());
        this.desktop = new JSplitPane(1);
        this.tablePane = new CIMTableTabbedPane();
        this.instancePanel = new InstanceActionPanel(this.tablePane, this, cimClass, deep);
        this.instancePanel.setPreferredSize(new Dimension(300, 200));
        this.tablePane.setPreferredSize(new Dimension(300, 200));
        this.desktop.setLeftComponent(this.instancePanel);
        this.desktop.setRightComponent(this.tablePane);
        pane.add("Center", this.desktop);
        this.createMenuBar();
        this.createToolBar(pane);
        this.instancePanel.refreshInstanceList();
        this.addWindowListener(this);
        this.setBounds(100, 100, 600, 400);
        this.show();
    }

    public void actionPerformed(ActionEvent e) {
        String actionCmd = e.getActionCommand();
        if (actionCmd.equals("EXIT")) {
            this.dispose();
        } else if (actionCmd.equals("ABOUT_INSTANCE_EDITOR")) {
            ActionString asProd = new ActionString("MNU_INSTANCE_EDITOR");
            String prod = asProd.getString();
            String versionString = "1.0.0 11/01/04:10:48";
            AboutDialog dlg = new AboutDialog(this, prod, versionString, "Copyright 2002 Sun Microsystems, Inc.\nAll rights reserved.", "");
        }
    }

    private void createMenuBar() {
        boolean writePermission = CIMClientObject.userHasWritePermission();
        JMenuBar menuBar = new JMenuBar();
        this.setJMenuBar(menuBar);
        ActionString asInstanceEditor = new ActionString("MNU_INSTANCE_EDITOR");
        ActionString asAction = new ActionString("MNU_ACTION", "org.wbemservices.wbem.apps.common.common");
        ActionString asProperties = new ActionString("MNU_PROPERTIES");
        ActionString asMethods = new ActionString("MNU_METHODS");
        ActionString asHelp = new ActionString("MNU_HELP", "org.wbemservices.wbem.apps.common.common");
        ActionString asExit = new ActionString("MNU_EXIT", "org.wbemservices.wbem.apps.common.common");
        ActionString asRefresh = new ActionString("MNU_REFRESH", "org.wbemservices.wbem.apps.common.common");
        ActionString asAdd = new ActionString("MNU_ADD_INSTANCE");
        ActionString asDelete = new ActionString("MNU_DELETE_INSTANCE");
        ActionString asSave = new ActionString("MNU_SAVE_INSTANCE");
        ActionString asAssoc = new ActionString("MNU_ASSOC_TRAVERSAL");
        ActionString asQualifiers = new ActionString("MNU_QUALIFIERS");
        ActionString asShowValue = new ActionString("MNU_SHOW_VALUE");
        ActionString asInvokeMethod = new ActionString("MNU_INVOKE_METHOD");
        ActionString asHelpAbout = new ActionString("MNU_ABOUT_INSTANCE_EDITOR");
        this.mnuInstanceEditor = new JMenu(asInstanceEditor.getString());
        this.mnuInstanceEditor.setMnemonic(asInstanceEditor.getMnemonic());
        this.mnuAction = new JMenu(asAction.getString());
        this.mnuAction.setMnemonic(asAction.getMnemonic());
        this.mnuProperties = new JMenu(asProperties.getString());
        this.mnuProperties.setMnemonic(asProperties.getMnemonic());
        this.mnuMethods = new JMenu(asMethods.getString());
        this.mnuMethods.setMnemonic(asMethods.getMnemonic());
        this.mnuHelp = new JMenu(asHelp.getString());
        this.mnuHelp.setMnemonic(asHelp.getMnemonic());
        menuBar.add(this.mnuInstanceEditor);
        menuBar.add(this.mnuAction);
        menuBar.add(this.mnuHelp);
        this.mnuExit = new JMenuItem(asExit.getString());
        this.mnuExit.setMnemonic(asExit.getMnemonic());
        this.mnuExit.setActionCommand("EXIT");
        this.mnuExit.addActionListener(this);
        this.mnuAddInstance = new JMenuItem(asAdd.getString());
        this.mnuAddInstance.setMnemonic(asAdd.getMnemonic());
        this.mnuAddInstance.setActionCommand("ADD_INSTANCE");
        this.mnuAddInstance.addActionListener(this.instancePanel);
        this.mnuAddInstance.setEnabled(writePermission);
        this.mnuAssocTraversal = new JMenuItem(asAssoc.getString());
        this.mnuAssocTraversal.setMnemonic(asAssoc.getMnemonic());
        this.mnuAssocTraversal.setActionCommand("ASSOC_TRAVERSAL");
        this.mnuAssocTraversal.addActionListener(this.instancePanel);
        this.mnuAssocTraversal.setEnabled(false);
        this.mnuDeleteInstance = new JMenuItem(asDelete.getString());
        this.mnuDeleteInstance.setMnemonic(asDelete.getMnemonic());
        this.mnuDeleteInstance.setActionCommand("DELETE_INSTANCE");
        this.mnuDeleteInstance.addActionListener(this.instancePanel);
        this.mnuDeleteInstance.setEnabled(false);
        this.mnuSaveInstance = new JMenuItem(asSave.getString());
        this.mnuSaveInstance.setMnemonic(asSave.getMnemonic());
        this.mnuSaveInstance.setActionCommand("SAVE_INSTANCE");
        this.mnuSaveInstance.addActionListener(this.instancePanel);
        this.mnuSaveInstance.setEnabled(false);
        this.mnuRefresh = new JMenuItem(asRefresh.getString());
        this.mnuRefresh.setMnemonic(asRefresh.getMnemonic());
        this.mnuRefresh.setActionCommand("REFRESH");
        this.mnuRefresh.addActionListener(this.instancePanel);
        this.mnuPropQualifiers = new JMenuItem(asQualifiers.getString());
        this.mnuPropQualifiers.setMnemonic(asQualifiers.getMnemonic());
        this.mnuPropQualifiers.setActionCommand("QUALIFIERS");
        this.mnuPropQualifiers.addActionListener(this.tablePane.getPropertiesTable());
        this.mnuShowValue = new JMenuItem(asShowValue.getString());
        this.mnuShowValue.setMnemonic(asShowValue.getMnemonic());
        this.mnuShowValue.setActionCommand("SHOW_VALUE");
        this.mnuShowValue.addActionListener(this.tablePane.getPropertiesTable());
        this.mnuMethodQualifiers = new JMenuItem(asQualifiers.getString());
        this.mnuMethodQualifiers.setMnemonic(asQualifiers.getMnemonic());
        this.mnuMethodQualifiers.setActionCommand("QUALIFIERS");
        this.mnuMethodQualifiers.addActionListener(this.tablePane.getMethodsTable());
        this.mnuInvokeMethod = new JMenuItem(asInvokeMethod.getString());
        this.mnuInvokeMethod.setMnemonic(asInvokeMethod.getMnemonic());
        this.mnuInvokeMethod.setActionCommand("INVOKE_METHOD");
        this.mnuInvokeMethod.addActionListener(this.tablePane.getMethodsTable());
        this.mnuHelpAbout = new JMenuItem(asHelpAbout.getString());
        this.mnuHelpAbout.setMnemonic(asHelpAbout.getMnemonic());
        this.mnuHelpAbout.setActionCommand("ABOUT_INSTANCE_EDITOR");
        this.mnuHelpAbout.addActionListener(this);
        this.mnuInstanceEditor.add(this.mnuExit);
        this.mnuAction.add(this.mnuAddInstance);
        this.mnuAction.add(this.mnuDeleteInstance);
        this.mnuAction.add(this.mnuSaveInstance);
        this.mnuAction.addSeparator();
        this.mnuAction.add(this.mnuProperties);
        this.mnuAction.add(this.mnuMethods);
        this.mnuAction.addSeparator();
        this.mnuAction.add(this.mnuAssocTraversal);
        this.mnuAction.addSeparator();
        this.mnuAction.add(this.mnuRefresh);
        this.mnuProperties.add(this.mnuPropQualifiers);
        this.mnuProperties.add(this.mnuShowValue);
        this.mnuMethods.add(this.mnuMethodQualifiers);
        this.mnuMethods.add(this.mnuInvokeMethod);
        this.mnuHelp.add(this.mnuHelpAbout);
    }

    private void createToolBar(JPanel pane) {
        ToolBarPanel toolbar = new ToolBarPanel();
        this.btnAddInstance = toolbar.createButton(Util.loadImageIcon("instances.gif"), I18N.loadString("TIP_ADD_INSTANCE"), "ADD_INSTANCE", this.instancePanel);
        this.btnAddInstance.setEnabled(CIMClientObject.userHasWritePermission());
        this.btnDeleteInstance = toolbar.createButton(Util.loadImageIcon("delete.gif"), I18N.loadString("TIP_DELETE_INSTANCE"), "DELETE_INSTANCE", this.instancePanel);
        this.btnDeleteInstance.setEnabled(false);
        this.btnSaveInstance = toolbar.createButton(Util.loadImageIcon("save.gif"), I18N.loadString("TIP_SAVE_INSTANCE"), "SAVE_INSTANCE", this.instancePanel);
        this.btnSaveInstance.setEnabled(false);
        toolbar.createButton(Util.loadImageIcon("refresh.gif"), I18N.loadString("TIP_REFRESH_INSTANCES"), "REFRESH", this.instancePanel);
        pane.add("North", toolbar);
    }

    public void windowActivated(WindowEvent evt) {
    }

    public void windowClosed(WindowEvent evt) {
    }

    public void windowClosing(WindowEvent evt) {
        if (this.btnSaveInstance.isEnabled()) {
            this.instancePanel.saveCurrentInstance(true);
        }
    }

    public void windowDeactivated(WindowEvent evt) {
    }

    public void windowDeiconified(WindowEvent evt) {
    }

    public void windowIconified(WindowEvent evt) {
    }

    public void windowOpened(WindowEvent evt) {
        this.desktop.setDividerLocation(0.4);
    }

    public void enableDeleteInstanceMenu(boolean b) {
        this.mnuDeleteInstance.setEnabled(b);
        this.btnDeleteInstance.setEnabled(b);
    }

    public void enableSaveInstanceMenu(boolean b) {
        this.mnuSaveInstance.setEnabled(b);
        this.btnSaveInstance.setEnabled(b);
    }

    public void enableAssocMenu(boolean b) {
        this.mnuAssocTraversal.setEnabled(b);
    }

    public void enablePropMenu(boolean haveInstances) {
        boolean propSelected = haveInstances && this.tablePane.isPropertySelected();
        boolean methodSelected = haveInstances && this.tablePane.isMethodSelected();
        this.mnuPropQualifiers.setEnabled(propSelected);
        this.mnuShowValue.setEnabled(propSelected);
        this.mnuMethodQualifiers.setEnabled(methodSelected);
        this.mnuInvokeMethod.setEnabled(methodSelected);
    }
}

