/*
 * Decompiled with CFR 0.152.
 */
package org.wbemservices.wbem.apps.cimworkshop;

import java.awt.event.ActionEvent;
import java.util.Enumeration;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.wbem.cim.CIMClass;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.client.CIMClient;
import org.wbemservices.wbem.apps.common.ActionString;
import org.wbemservices.wbem.apps.common.CIMClientObject;
import org.wbemservices.wbem.apps.common.CIMErrorDialog;
import org.wbemservices.wbem.apps.common.I18N;

public class InstancePanel
extends JScrollPane {
    protected DefaultListModel listModel;
    protected JList instanceList;
    protected JTextArea emptyInstances;
    protected CIMClient cimClient = CIMClientObject.getClient();
    protected CIMClass cimClass;
    protected JLabel lInstances;

    public InstancePanel(CIMClass cClass) {
        this(cClass, false);
    }

    public InstancePanel(CIMClass cClass, boolean deepEnum) {
        this.cimClass = cClass;
        String className = "";
        if (this.cimClass != null) {
            className = this.cimClass.getName();
        }
        this.emptyInstances = new JTextArea(I18N.loadStringFormat("ERR_NO_INSTANCES", className));
        this.emptyInstances.setLineWrap(true);
        this.emptyInstances.setWrapStyleWord(true);
        this.emptyInstances.setBackground(this.getBackground());
        this.listModel = new DefaultListModel();
        this.instanceList = new JList(this.listModel);
        this.instanceList.getSelectionModel().setSelectionMode(0);
        this.instanceList.setBackground(this.getBackground());
        this.instanceList.setBorder(BorderFactory.createBevelBorder(1));
        ActionString asInstances = new ActionString("LBL_INSTANCES");
        this.lInstances = new JLabel(asInstances.getString() + ":");
        this.lInstances.setDisplayedMnemonic(asInstances.getMnemonic());
        this.setColumnHeaderView(this.lInstances);
        this.lInstances.setLabelFor(this.instanceList);
        this.setViewPort();
        this.setVisible(true);
    }

    public void actionPerformed(ActionEvent e) {
        String actionCmd = e.getActionCommand();
        if (actionCmd.equals("REFRESH")) {
            this.refreshInstanceList();
        }
    }

    public JList getInstanceList() {
        return this.instanceList;
    }

    public void setViewPort() {
        boolean b = this.hasInstances();
        if (b) {
            this.setViewportView(this.instanceList);
        } else {
            this.setViewportView(this.emptyInstances);
        }
        this.lInstances.setEnabled(b);
    }

    public boolean hasInstances() {
        return this.listModel.size() > 0;
    }

    public void refreshInstanceList() {
        this.listModel.removeAllElements();
        try {
            CIMObjectPath className = new CIMObjectPath(this.cimClass.getName());
            Enumeration e = this.cimClient.enumerateInstanceNames(className);
            while (e.hasMoreElements()) {
                CIMObjectPath nextInstance = (CIMObjectPath)e.nextElement();
                this.listModel.addElement(nextInstance);
            }
        }
        catch (CIMException exc) {
            CIMErrorDialog.display(this, exc);
        }
        if (this.listModel.size() > 0) {
            this.instanceList.setSelectedIndex(0);
        }
        this.setViewPort();
    }

    public void setListLabel(JLabel label) {
    }
}

