/*
 * Decompiled with CFR 0.152.
 */
package org.wbemservices.wbem.apps.cimworkshop;

import java.awt.Frame;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.wbemservices.wbem.apps.cimworkshop.CIMEditDialog;
import org.wbemservices.wbem.apps.cimworkshop.IntegerField;
import org.wbemservices.wbem.apps.common.ActionString;
import org.wbemservices.wbem.apps.common.ColumnLayout;
import org.wbemservices.wbem.apps.common.ContextHelpListener;
import org.wbemservices.wbem.apps.common.SizedIntegerDocument;
import org.wbemservices.wbem.apps.common.TextFieldFocusListener;
import org.wbemservices.wbem.apps.common.Util;

class IntegerFieldDialog
extends CIMEditDialog {
    public IntegerFieldDialog(Frame parent, String name, String type, String value) {
        this(parent, name, type, value, true);
    }

    public IntegerFieldDialog(Frame parent, String name, String type, String value, boolean enabled) {
        super(parent, name, type, enabled);
        String tmpValue = value;
        if (tmpValue == null) {
            tmpValue = "";
        }
        JPanel fieldPanel = new JPanel(new ColumnLayout());
        this.valueField = new JTextField(20);
        String defaultHelp = "ShowValue_000.htm";
        ActionString asValue = new ActionString("LBL_VALUE");
        JLabel valueLabel = new JLabel(asValue.getString() + ":");
        if (enabled) {
            String tfHelp;
            long min = 0L;
            long max = 255L;
            switch (this.cimType) {
                case 1: {
                    tfHelp = "Int_010.htm";
                    min = -128L;
                    max = 127L;
                    break;
                }
                case 3: {
                    tfHelp = "Int_020.htm";
                    min = -32768L;
                    max = 32767L;
                    break;
                }
                case 5: {
                    tfHelp = "Int_030.htm";
                    min = Integer.MIN_VALUE;
                    max = Integer.MAX_VALUE;
                    break;
                }
                case 7: {
                    tfHelp = "Int_040.htm";
                    min = Long.MIN_VALUE;
                    max = Long.MAX_VALUE;
                    break;
                }
                case 0: {
                    tfHelp = "Int_050.htm";
                    break;
                }
                case 2: {
                    tfHelp = "Int_060.htm";
                    max = 65535L;
                    break;
                }
                case 4: {
                    tfHelp = "Int_070.htm";
                    max = 0xFFFFFFFFL;
                    break;
                }
                case 6: {
                    tfHelp = "Int_080.htm";
                    this.valueField = new IntegerField(tmpValue, false);
                    break;
                }
                default: {
                    tfHelp = "Int_000.htm";
                }
            }
            valueLabel.setDisplayedMnemonic(asValue.getMnemonic());
            valueLabel.setLabelFor(this.valueField);
            this.valueField.getDocument().addDocumentListener(this);
            this.valueField.addFocusListener(new TextFieldFocusListener());
            this.valueField.addFocusListener(new ContextHelpListener(this.getInfoPanel(), "cimworkshop", tfHelp));
            defaultHelp = "Int_000.htm";
            if (this.cimType != 6) {
                SizedIntegerDocument valueDoc = new SizedIntegerDocument(this.valueField, min, max);
                this.valueField.setDocument(valueDoc);
            }
        } else {
            this.valueField.setEnabled(false);
        }
        this.valueField.setText(tmpValue);
        this.setDefaultHelp(defaultHelp);
        fieldPanel.add(valueLabel);
        fieldPanel.setBorder(BorderFactory.createEmptyBorder(15, 0, 0, 0));
        fieldPanel.add(this.valueField);
        JPanel mainPanel = this.getMainPanel();
        mainPanel.add(fieldPanel);
        this.pack();
        this.setLocation(Util.getCenterPoint(parent, this));
        this.setVisible(true);
    }
}

