/*
 * Decompiled with CFR 0.152.
 */
package org.wbemservices.wbem.apps.cimworkshop;

import java.awt.Component;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import javax.wbem.cim.CIMArgument;
import javax.wbem.cim.CIMDataType;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMMethod;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMParameter;
import javax.wbem.cim.CIMQualifier;
import javax.wbem.cim.CIMValue;
import javax.wbem.client.CIMClient;
import org.wbemservices.wbem.apps.cimworkshop.CIMTypes;
import org.wbemservices.wbem.apps.cimworkshop.CIMValueDialog;
import org.wbemservices.wbem.apps.common.ActionString;
import org.wbemservices.wbem.apps.common.AdminDialog;
import org.wbemservices.wbem.apps.common.CIMClientObject;
import org.wbemservices.wbem.apps.common.CIMErrorDialog;
import org.wbemservices.wbem.apps.common.CancelObject;
import org.wbemservices.wbem.apps.common.ColumnLayout;
import org.wbemservices.wbem.apps.common.ContextHelpListener;
import org.wbemservices.wbem.apps.common.GenInfoPanel;
import org.wbemservices.wbem.apps.common.I18N;
import org.wbemservices.wbem.apps.common.LAYOUT_ALIGNMENT;
import org.wbemservices.wbem.apps.common.RowLayout;
import org.wbemservices.wbem.apps.common.Util;

public class InvokeMethodDialog
extends AdminDialog
implements TableModelListener {
    protected JButton invokeBtn;
    protected JButton closeBtn;
    protected ParametersDataModel paramDataModel;
    protected JTable paramTable;
    protected String[] tableHeading;
    protected ArrayList methodParams;
    protected Frame parentFrame;
    protected JLabel returnValue;
    protected CIMMethod cimMethod;
    protected CIMObjectPath cimObjectPath;
    protected CIMTypes cimTypes;
    private final int INPUT_PARAM = 1;
    private final int OUTPUT_PARAM = 2;
    private final int INPUT_OUTPUT_PARAM = 3;

    public InvokeMethodDialog(Frame parent, CIMMethod cm, CIMObjectPath op) {
        super(parent, I18N.loadStringFormat("TTL_INVOKE_METHOD", cm.getName()), false);
        GenInfoPanel infoPanel = this.getInfoPanel();
        ActionString asInvoke = new ActionString("MNU_INVOKE_METHOD");
        this.invokeBtn = this.getOKBtn();
        this.invokeBtn.addActionListener(new ButtonListener());
        this.invokeBtn.setText(asInvoke.getString());
        this.invokeBtn.setMnemonic(asInvoke.getMnemonic());
        this.invokeBtn.setActionCommand("INVOKE_METHOD");
        this.closeBtn = this.getCancelBtn();
        this.closeBtn.addActionListener(new ButtonListener());
        this.closeBtn.setText(I18N.loadString("LBL_CLOSE", "org.wbemservices.wbem.apps.common.common"));
        JPanel mainPanel = this.getRightPanel();
        this.cimMethod = cm;
        this.cimObjectPath = op;
        this.parentFrame = parent;
        this.cimTypes = new CIMTypes();
        mainPanel.setBorder(BorderFactory.createEmptyBorder(25, 15, 15, 15));
        mainPanel.setLayout(new ColumnLayout(LAYOUT_ALIGNMENT.EXPAND));
        JPanel retValPanel = new JPanel(new RowLayout());
        retValPanel.add(new JLabel(I18N.loadString("LBL_RETURN_VALUE") + ": "));
        this.returnValue = new JLabel();
        retValPanel.add(this.returnValue);
        mainPanel.add(retValPanel);
        ActionString asName = new ActionString("LBL_NAME", "org.wbemservices.wbem.apps.common.common");
        ActionString asCIMType = new ActionString("LBL_CIM_TYPE");
        ActionString asParamType = new ActionString("LBL_PARAM_TYPE");
        ActionString asInputValue = new ActionString("LBL_INPUT_VALUE");
        ActionString asOutputValue = new ActionString("LBL_OUTPUT_VALUE");
        this.tableHeading = new String[5];
        this.tableHeading[0] = asName.getString();
        this.tableHeading[1] = asCIMType.getString();
        this.tableHeading[2] = asParamType.getString();
        this.tableHeading[3] = asInputValue.getString();
        this.tableHeading[4] = asOutputValue.getString();
        this.paramDataModel = new ParametersDataModel();
        this.paramDataModel.addTableModelListener(this);
        this.paramTable = new JTable(this.paramDataModel){

            public String getToolTipText(MouseEvent e) {
                Point p = e.getPoint();
                int col = this.columnAtPoint(p);
                int row = this.rowAtPoint(p);
                if (row < 0 || row >= InvokeMethodDialog.this.paramDataModel.getRowCount()) {
                    return "";
                }
                String s = InvokeMethodDialog.this.paramDataModel.getValueAt(row, col).toString();
                if (s.trim().length() == 0) {
                    return null;
                }
                return s;
            }
        };
        this.paramTable.setBackground(this.getBackground());
        this.paramTable.getSelectionModel().setSelectionMode(0);
        this.paramTable.getTableHeader().setReorderingAllowed(false);
        this.paramTable.setCellSelectionEnabled(true);
        ActionString asParams = new ActionString("LBL_PARAMETERS");
        JLabel lbParams = new JLabel(asParams.getString() + ":");
        JScrollPane scrollPane = new JScrollPane(this.paramTable);
        mainPanel.add(Box.createVerticalStrut(20));
        mainPanel.add(lbParams);
        mainPanel.add(scrollPane);
        for (int i = 0; i < 5; ++i) {
            TableColumn col = this.paramTable.getColumnModel().getColumn(i);
            col.setCellEditor(new DefaultCellEditor(new JTextField()){

                public boolean isCellEditable(EventObject evt) {
                    return false;
                }
            });
        }
        TableColumn inputColumn = this.paramTable.getColumnModel().getColumn(3);
        inputColumn.setCellEditor(new InputParamCellEditor(new JTextField()));
        this.setDefaultFocusListener(new ContextHelpListener(infoPanel, "cimworkshop", "Methods_000.htm"), true);
        this.paramTable.addFocusListener(new ContextHelpListener(infoPanel, "cimworkshop", "Methods_010.htm"));
        this.initialize(this.cimMethod);
        this.invokeBtn.setEnabled(this.isInputComplete());
        this.pack();
        this.setLocation(Util.getCenterPoint(parent, this));
        this.show();
    }

    public boolean isInputComplete() {
        Iterator iter = this.methodParams.iterator();
        while (iter.hasNext()) {
            Object[] params = (Object[])iter.next();
            int inputType = (Integer)params[2];
            if ((inputType & 1) == 0 || params[3] != null) continue;
            return false;
        }
        return true;
    }

    public void tableChanged(TableModelEvent e) {
        this.invokeBtn.setEnabled(this.isInputComplete());
    }

    private void initialize(CIMMethod method) {
        this.methodParams = new ArrayList();
        Vector params = method.getParameters();
        Enumeration e = params.elements();
        while (e.hasMoreElements()) {
            Object[] paramInfo = new Object[5];
            CIMParameter cimParam = (CIMParameter)e.nextElement();
            paramInfo[0] = cimParam.getName();
            paramInfo[1] = cimParam.getType();
            int inOutType = 0;
            if (this.isQualifierTrue(cimParam, "IN")) {
                inOutType |= 1;
            }
            if (this.isQualifierTrue(cimParam, "OUT")) {
                inOutType |= 2;
            }
            paramInfo[2] = new Integer(inOutType);
            paramInfo[3] = null;
            paramInfo[4] = null;
            this.methodParams.add(paramInfo);
        }
        this.paramDataModel.setNumRows(this.methodParams.size());
        this.paramTable.repaint();
    }

    private boolean isQualifierTrue(CIMParameter param, String name) {
        CIMValue cv;
        boolean ret = false;
        CIMQualifier qual = param.getQualifier(name);
        if (qual != null && (cv = qual.getValue()) != null && cv.equals((Object)CIMValue.TRUE)) {
            ret = true;
        }
        return ret;
    }

    private void invokeMethod() {
        CIMArgument[] input = this.getInputParams();
        CIMArgument[] output = new CIMArgument[this.methodParams.size()];
        CIMClient client = CIMClientObject.getClient();
        try {
            CIMValue retVal = client.invokeMethod(this.cimObjectPath, this.cimMethod.getName(), input, output);
            if (retVal != null) {
                this.returnValue.setText(retVal.toString());
            } else {
                this.returnValue.setText(I18N.loadString("LBL_NULL", "org.wbemservices.wbem.apps.common.common"));
            }
            this.displayOutputValues(output);
        }
        catch (CIMException exc) {
            CIMErrorDialog.display(this, exc);
        }
    }

    private CIMArgument[] getInputParams() {
        ArrayList<CIMArgument> argList = new ArrayList<CIMArgument>();
        Iterator iter = this.methodParams.iterator();
        while (iter.hasNext()) {
            Object[] param = (Object[])iter.next();
            int inputType = (Integer)param[2];
            if ((inputType & 1) == 0) continue;
            CIMArgument arg = new CIMArgument((String)param[0]);
            arg.setType((CIMDataType)param[1]);
            CIMValue value = (CIMValue)param[3];
            if (value != null) {
                arg.setType(value.getType());
                arg.setValue(value);
            }
            argList.add(arg);
        }
        return argList.toArray(new CIMArgument[argList.size()]);
    }

    private void displayOutputValues(CIMArgument[] args) {
        int argIndex = 0;
        for (int i = 0; i < this.methodParams.size(); ++i) {
            CIMArgument arg;
            Object[] param = (Object[])this.methodParams.get(i);
            int outputType = (Integer)param[2];
            if ((outputType & 2) == 0 || (arg = args[argIndex++]) == null) continue;
            param[4] = arg.getValue();
        }
        this.paramTable.repaint();
    }

    class ButtonListener
    implements ActionListener {
        ButtonListener() {
        }

        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == InvokeMethodDialog.this.invokeBtn) {
                InvokeMethodDialog.this.invokeMethod();
            } else if (e.getSource() == InvokeMethodDialog.this.closeBtn) {
                InvokeMethodDialog.this.dispose();
            }
        }
    }

    public class InputParamCellEditor
    extends DefaultCellEditor {
        Object currentValue;
        String currentName;
        CIMDataType currentDataType = null;
        boolean isInputType = true;

        public InputParamCellEditor(JTextField textField) {
            super(textField);
        }

        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            ((JTextField)this.editorComponent).setEditable(false);
            Object[] param = (Object[])InvokeMethodDialog.this.methodParams.get(row);
            this.currentName = (String)param[0];
            this.currentDataType = (CIMDataType)param[1];
            this.currentValue = param[3];
            this.isInputType = ((Integer)param[2] & 1) != 0;
            return this.editorComponent;
        }

        public Object getCellEditorValue() {
            return this.currentValue;
        }

        public boolean isCellEditable(EventObject evt) {
            return true;
        }

        public boolean stopCellEditing() {
            return true;
        }

        public void cancelCellEditing() {
        }

        public boolean shouldSelectCell(EventObject evt) {
            if (this.isInputType) {
                Object value = null;
                if (this.currentValue != null) {
                    value = ((CIMValue)this.currentValue).getValue();
                }
                if ((value = CIMValueDialog.showDialog(Util.getFrame(InvokeMethodDialog.this.paramTable), value, this.currentName, this.currentDataType, true)) instanceof CancelObject) {
                    this.fireEditingCanceled();
                } else {
                    if (value != null) {
                        this.currentValue = new CIMValue(value);
                    }
                    this.fireEditingStopped();
                }
            }
            return false;
        }
    }

    class ParametersDataModel
    extends DefaultTableModel {
        ParametersDataModel() {
        }

        public int getColumnCount() {
            return 5;
        }

        public Object getValueAt(int row, int col) {
            Object[] param = (Object[])InvokeMethodDialog.this.methodParams.get(row);
            Object ret = null;
            if (param != null && (ret = param[col]) != null) {
                if (col == 1) {
                    int type = 30;
                    CIMDataType cdt = (CIMDataType)ret;
                    if (cdt != null) {
                        type = cdt.getType();
                    }
                    ret = InvokeMethodDialog.this.cimTypes.getCIMType(type);
                }
                if (col == 2) {
                    switch ((Integer)ret) {
                        case 1: {
                            ret = I18N.loadString("LBL_INPUT");
                            break;
                        }
                        case 2: {
                            ret = I18N.loadString("LBL_OUTPUT");
                            break;
                        }
                        case 3: {
                            ret = I18N.loadString("LBL_INPUT_OUTPUT");
                            break;
                        }
                        default: {
                            ret = "";
                            break;
                        }
                    }
                } else if (col == 3 || col == 4) {
                    String val = "";
                    CIMValue cv = (CIMValue)ret;
                    if (cv != null) {
                        val = cv.getValue().toString();
                    }
                    ret = val;
                }
            }
            if (ret == null) {
                ret = "";
            }
            return ret;
        }

        public void setValueAt(Object value, int row, int col) {
            Object[] param = (Object[])InvokeMethodDialog.this.methodParams.get(row);
            param[col] = value;
            this.fireTableCellUpdated(row, col);
        }

        public String getColumnName(int col) {
            return InvokeMethodDialog.this.tableHeading[col];
        }

        public Class getColumnClass(int col) {
            return this.getValueAt(0, col).getClass();
        }
    }
}

