/*
 * Decompiled with CFR 0.152.
 */
package org.wbemservices.wbem.apps.cimworkshop;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.wbem.cim.CIMElement;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMObjectPath;
import org.wbemservices.wbem.apps.cimworkshop.CIMTableTabbedPane;
import org.wbemservices.wbem.apps.cimworkshop.InstancePanel;
import org.wbemservices.wbem.apps.cimworkshop.QueryFrame;
import org.wbemservices.wbem.apps.common.CIMErrorDialog;
import org.wbemservices.wbem.apps.common.I18N;
import org.wbemservices.wbem.apps.common.Util;

public class QueryActionPanel
extends InstancePanel
implements ListSelectionListener,
ActionListener {
    private CIMTableTabbedPane tablePane;
    private QueryFrame queryFrame;
    private String queryString = null;

    public QueryActionPanel(CIMTableTabbedPane tp, QueryFrame qFrame, String query) {
        super(null, true);
        this.emptyInstances.setText(I18N.loadString("ERR_QUERY_RESULT"));
        this.queryString = query;
        this.tablePane = tp;
        this.queryFrame = qFrame;
        this.instanceList.getSelectionModel().addListSelectionListener(this);
        this.setVisible(true);
    }

    public void actionPerformed(ActionEvent e) {
    }

    public void valueChanged(ListSelectionEvent evt) {
        if (evt.getValueIsAdjusting()) {
            return;
        }
        int i = this.instanceList.getSelectedIndex();
        Util.setWaitCursor(this);
        if (!this.listModel.isEmpty() && i >= 0 && i < this.listModel.size()) {
            try {
                CIMObjectPath op = (CIMObjectPath)this.listModel.elementAt(i);
                CIMInstance ci = this.cimClient.getInstance(op, false, true, true, null);
                this.tablePane.populateTables(this.cimClient, (CIMElement)ci);
            }
            catch (CIMException exc) {
                this.tablePane.populateTables(null, null);
                CIMErrorDialog.display(this, exc);
            }
        } else {
            this.tablePane.populateTables(null, null);
        }
        Util.setDefaultCursor(this);
    }

    public void refreshInstanceList() {
        this.listModel.removeAllElements();
        try {
            Enumeration e = this.cimClient.execQuery(new CIMObjectPath(), this.queryString, "WQL");
            while (e.hasMoreElements()) {
                CIMInstance nextInstance = (CIMInstance)e.nextElement();
                CIMObjectPath op = nextInstance.getObjectPath();
                this.listModel.addElement(op);
            }
        }
        catch (CIMException exc) {
            CIMErrorDialog.display(this, exc);
        }
        if (this.listModel.size() > 0) {
            this.instanceList.setSelectedIndex(0);
        }
        this.setViewPort();
    }
}

