/*
 * Decompiled with CFR 0.152.
 */
package org.wbemservices.wbem.apps.cimworkshop;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.wbemservices.wbem.apps.common.ActionString;
import org.wbemservices.wbem.apps.common.AdminDialog;
import org.wbemservices.wbem.apps.common.ColumnLayout;
import org.wbemservices.wbem.apps.common.ContextHelpListener;
import org.wbemservices.wbem.apps.common.GenInfoPanel;
import org.wbemservices.wbem.apps.common.I18N;
import org.wbemservices.wbem.apps.common.LAYOUT_ALIGNMENT;
import org.wbemservices.wbem.apps.common.Util;

public class QueryInputDialog
extends AdminDialog
implements DocumentListener {
    private JButton execBtn;
    private JButton cancelBtn;
    private GenInfoPanel infoPanel = super.getInfoPanel();
    String queryString = null;
    JTextArea textArea;

    public QueryInputDialog(Frame parent) {
        super(parent, I18N.loadString("TTL_QUERY_STRING"), false);
        this.cancelBtn = this.getCancelBtn();
        this.cancelBtn.addActionListener(new OKCancelButtonListener());
        this.execBtn = this.getOKBtn();
        this.execBtn.setText(I18N.loadString("LBL_EXECUTE"));
        this.execBtn.addActionListener(new OKCancelButtonListener());
        JPanel mainPanel = this.getRightPanel();
        mainPanel.setBorder(BorderFactory.createEmptyBorder(25, 15, 15, 15));
        mainPanel.setLayout(new ColumnLayout(LAYOUT_ALIGNMENT.EXPAND));
        ActionString asQueryString = new ActionString("LBL_QUERY_STRING");
        JLabel lQueryString = new JLabel(asQueryString.getString() + ":");
        lQueryString.setDisplayedMnemonic(asQueryString.getMnemonic());
        this.textArea = new JTextArea(4, 25);
        this.textArea.setWrapStyleWord(true);
        lQueryString.setLabelFor(this.textArea);
        this.textArea.getDocument().addDocumentListener(this);
        this.textArea.addFocusListener(new ContextHelpListener(this.getInfoPanel(), "cimworkshop", "QueryString_010.htm"));
        this.setDefaultFocusListener(new ContextHelpListener(this.infoPanel, "cimworkshop", "QueryString_000.htm"), true);
        this.execBtn.addFocusListener(new ContextHelpListener(this.infoPanel, "cimworkshop", "QueryString_000.htm"));
        this.cancelBtn.addFocusListener(new ContextHelpListener(this.infoPanel, "cimworkshop", "QueryString_000.htm"));
        mainPanel.add(lQueryString);
        mainPanel.add(new JScrollPane(this.textArea));
        this.pack();
        this.setLocation(Util.getCenterPoint(parent, this));
        this.setVisible(true);
    }

    public void okClicked() {
        this.queryString = this.textArea.getText();
        this.dispose();
    }

    public void cancelClicked() {
        this.queryString = null;
        this.dispose();
    }

    public void changedUpdate(DocumentEvent evt) {
        this.setOKEnabled();
    }

    public void insertUpdate(DocumentEvent evt) {
        this.setOKEnabled();
    }

    public void removeUpdate(DocumentEvent evt) {
        this.setOKEnabled();
    }

    private void setOKEnabled() {
        this.execBtn.setEnabled(this.textArea.getText().trim().length() != 0);
    }

    public String getQueryString() {
        return this.queryString;
    }

    public void windowOpened(WindowEvent evt) {
        super.windowOpened(evt);
        this.textArea.requestFocus();
    }

    class OKCancelButtonListener
    implements ActionListener {
        OKCancelButtonListener() {
        }

        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == QueryInputDialog.this.cancelBtn) {
                QueryInputDialog.this.cancelClicked();
            } else if (e.getSource() == QueryInputDialog.this.execBtn) {
                QueryInputDialog.this.okClicked();
            }
        }
    }
}

