/*
 * Decompiled with CFR 0.152.
 */
package org.wbemservices.wbem.apps.cimworkshop;

import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.wbem.cim.CIMClass;
import javax.wbem.cim.CIMDataType;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMProperty;
import javax.wbem.cim.CIMValue;
import javax.wbem.client.CIMClient;
import org.wbemservices.wbem.apps.cimworkshop.CIMEditDialog;
import org.wbemservices.wbem.apps.cimworkshop.CIMKeyPropertiesPanel;
import org.wbemservices.wbem.apps.cimworkshop.CIMTypes;
import org.wbemservices.wbem.apps.cimworkshop.InstancePanel;
import org.wbemservices.wbem.apps.common.ActionString;
import org.wbemservices.wbem.apps.common.CIMClientObject;
import org.wbemservices.wbem.apps.common.CIMErrorDialog;
import org.wbemservices.wbem.apps.common.ColumnLayout;
import org.wbemservices.wbem.apps.common.I18N;
import org.wbemservices.wbem.apps.common.LAYOUT_ALIGNMENT;
import org.wbemservices.wbem.apps.common.Util;

class ReferenceEditDialog
extends CIMEditDialog
implements ListSelectionListener,
WindowListener {
    protected InstancePanel instancePanel = null;
    protected CIMKeyPropertiesPanel keyTable = null;
    JList instanceList = null;
    CIMInstance cimInstance;
    CIMObjectPath objectPath;
    protected Frame parentFrame;
    protected Vector cimValues;
    protected CIMTypes cimTypes;
    protected CIMClient cimClient;

    public ReferenceEditDialog(Frame frame, String name, CIMDataType cdt, CIMObjectPath op) {
        this(frame, name, cdt, op, true);
    }

    public ReferenceEditDialog(Frame frame, String name, CIMDataType cdt, CIMObjectPath op, boolean editable) {
        super(frame, name, cdt.toString(), editable);
        this.parentFrame = frame;
        this.cimClient = CIMClientObject.getClient();
        CIMClass cimClass = null;
        String className = cdt.getRefClassName();
        try {
            cimClass = this.cimClient.getClass(new CIMObjectPath(className), false, true, true, null);
        }
        catch (CIMException e) {
            CIMErrorDialog.display(this, e);
            this.dispose();
        }
        this.objectPath = new CIMObjectPath(className);
        this.objectPath.setNameSpace(CIMClientObject.getNameSpace());
        this.cimInstance = cimClass.newInstance();
        this.keyTable = new CIMKeyPropertiesPanel(this.cimClient, this.cimInstance, editable);
        this.keyTable.setPreferredSize(new Dimension(500, 100));
        JPanel topPanel = new JPanel();
        topPanel.setLayout(new ColumnLayout(LAYOUT_ALIGNMENT.EXPAND));
        topPanel.setBorder(BorderFactory.createEmptyBorder(10, 0, 5, 0));
        String sKeys = I18N.loadStringFormat("LBL_INSTANCE_KEYS", className);
        ActionString asKeys = new ActionString(sKeys, true);
        JLabel lKeys = new JLabel(asKeys.getString());
        lKeys.setDisplayedMnemonic(asKeys.getMnemonic());
        lKeys.setLabelFor(this.keyTable);
        topPanel.add(lKeys);
        topPanel.add(this.keyTable);
        JPanel mainPanel = this.getMainPanel();
        mainPanel.add(topPanel);
        String defaultHelp = "ShowValue_000.htm";
        if (this.isEditable) {
            this.instancePanel = new InstancePanel(cimClass);
            this.instancePanel.setPreferredSize(new Dimension(500, 100));
            this.instancePanel.refreshInstanceList();
            this.instanceList = this.instancePanel.getInstanceList();
            this.instanceList.addListSelectionListener(this);
            JPanel bottomPanel = new JPanel();
            bottomPanel.setLayout(new ColumnLayout(LAYOUT_ALIGNMENT.EXPAND));
            bottomPanel.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 0));
            String sInstances = I18N.loadStringFormat("LBL_INSTANCES_OF", className);
            ActionString asInstances = new ActionString(sInstances, true);
            JLabel lInstances = new JLabel(asInstances.getString());
            lInstances.setDisplayedMnemonic(asInstances.getMnemonic());
            lInstances.setLabelFor(this.instancePanel);
            bottomPanel.add(lInstances);
            bottomPanel.add(this.instancePanel);
            mainPanel.add(bottomPanel);
            defaultHelp = "ReferenceEdit_000.htm";
        } else {
            this.keyTable.setEnabled(false);
        }
        this.setDefaultHelp(defaultHelp);
        this.addWindowListener(this);
        this.pack();
        this.setLocation(Util.getCenterPoint(frame, this));
        this.setVisible(true);
    }

    public void valueChanged(ListSelectionEvent evt) {
        if (evt.getValueIsAdjusting()) {
            return;
        }
        int i = this.instanceList.getSelectedIndex();
        Util.setWaitCursor(this);
        DefaultListModel listModel = (DefaultListModel)this.instanceList.getModel();
        if (!listModel.isEmpty() && i >= 0 && i < listModel.size()) {
            try {
                CIMInstance ci = this.cimClient.getInstance((CIMObjectPath)listModel.elementAt(i), false, true, true, null);
                this.keyTable.setInstance(ci);
                this.objectPath.setObjectName(ci.getClassName());
            }
            catch (CIMException exc) {
                CIMErrorDialog.display(this, exc);
            }
        }
        Util.setDefaultCursor(this);
    }

    public void okClicked() {
        Vector newProperties = this.keyTable.getProperties();
        Enumeration e = newProperties.elements();
        while (e.hasMoreElements()) {
            CIMProperty cp = (CIMProperty)e.nextElement();
            CIMValue cv = cp.getValue();
            if (!cp.isKey()) continue;
            if (cv == null || cv.getValue() == null) {
                JOptionPane.showMessageDialog(this, I18N.loadStringFormat("ERR_NO_PROPERTY_VALUE", cp.getName()), I18N.loadString("TTL_CIM_ERROR"), 0);
                return;
            }
            this.objectPath.addKey(cp.getName(), cp.getValue());
        }
        this.returnObject = this.objectPath;
        this.returnString = this.objectPath.toString();
        this.dispose();
    }

    public void windowActivated(WindowEvent evt) {
    }

    public void windowClosed(WindowEvent evt) {
    }

    public void windowClosing(WindowEvent evt) {
    }

    public void windowDeactivated(WindowEvent evt) {
    }

    public void windowDeiconified(WindowEvent evt) {
    }

    public void windowIconified(WindowEvent evt) {
    }

    public void windowOpened(WindowEvent evt) {
        if (!((DefaultListModel)this.instanceList.getModel()).isEmpty() && this.isEditable) {
            this.instanceList.clearSelection();
            this.instanceList.setSelectedIndex(0);
        }
        if (this.isEditable) {
            this.getOKBtn().requestFocus();
        } else {
            this.getCancelBtn().requestFocus();
        }
    }
}

