/*
 * Decompiled with CFR 0.152.
 */
package org.wbemservices.wbem.apps.common;

import java.awt.BorderLayout;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import org.wbemservices.wbem.apps.common.ColumnLayout;
import org.wbemservices.wbem.apps.common.I18N;
import org.wbemservices.wbem.apps.common.LAYOUT_ALIGNMENT;
import org.wbemservices.wbem.apps.common.Util;

public class AboutDialog
extends JDialog
implements ActionListener {
    JButton ok;

    public AboutDialog(Frame frame, String productName, String productVersion, String copyright, String iconName) {
        super(frame, true);
        this.setTitle(I18N.loadStringFormat("LBL_ABOUT", productName));
        JPanel pane = (JPanel)this.getContentPane();
        pane.setLayout(new BorderLayout());
        DlgTextArea productNameArea = new DlgTextArea(this, productName);
        DlgTextArea productVersionArea = new DlgTextArea(this, productVersion);
        DlgTextArea copyrightArea = new DlgTextArea(this, copyright);
        JPanel infoPanel = new JPanel(new ColumnLayout(LAYOUT_ALIGNMENT.LEFT));
        infoPanel.add(productNameArea);
        infoPanel.add(copyrightArea);
        infoPanel.add(productVersionArea);
        JPanel buttonPanel = new JPanel();
        this.ok = new JButton(I18N.loadString("LBL_OK", "org.wbemservices.wbem.apps.common.common"));
        this.ok.setActionCommand("ok");
        this.ok.addActionListener(this);
        buttonPanel.add(this.ok);
        pane.add("Center", infoPanel);
        pane.add("South", buttonPanel);
        if (iconName != null && iconName.trim().length() > 0) {
            try {
                ImageIcon productIcon = Util.loadImageIcon(iconName);
                pane.add("West", new JLabel(productIcon));
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        DisposeListener OKListener = new DisposeListener();
        pane.registerKeyboardAction(OKListener, KeyStroke.getKeyStroke(27, 0, true), 2);
        pane.registerKeyboardAction(OKListener, KeyStroke.getKeyStroke(10, 0, true), 2);
        this.pack();
        Util.positionWindow(this, frame);
        this.setVisible(true);
    }

    public void actionPerformed(ActionEvent e) {
        String actionCmd = e.getActionCommand();
        if (actionCmd.equals("ok")) {
            this.dispose();
        }
    }

    public class DlgTextArea
    extends JTextArea {
        public DlgTextArea(JDialog dlg, String text) {
            super(text);
            this.setEditable(false);
            this.setBackground(dlg.getBackground());
        }

        public Insets getInsets() {
            return new Insets(5, 5, 5, 5);
        }
    }

    protected class DisposeListener
    implements ActionListener {
        protected DisposeListener() {
        }

        public void actionPerformed(ActionEvent e) {
            AboutDialog.this.dispose();
        }
    }
}

