/*
 * Decompiled with CFR 0.152.
 */
package org.wbemservices.wbem.apps.common;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import org.wbemservices.wbem.apps.common.LAYOUT_ALIGNMENT;

public class ColumnLayout
implements LayoutManager {
    LAYOUT_ALIGNMENT align;
    int hgap;
    int vgap;

    public ColumnLayout() {
        this(LAYOUT_ALIGNMENT.EXPAND, 5, 5);
    }

    public ColumnLayout(LAYOUT_ALIGNMENT alignment) {
        this(alignment, 5, 5);
    }

    public ColumnLayout(LAYOUT_ALIGNMENT alignment, int hGap, int vGap) {
        this.align = alignment;
        this.hgap = hGap;
        this.vgap = vGap;
    }

    public void addLayoutComponent(String name, Component comp) {
    }

    public void removeLayoutComponent(Component comp) {
    }

    public int getHorizontalGap() {
        return this.hgap;
    }

    public int getVerticalGap() {
        return this.hgap;
    }

    public LAYOUT_ALIGNMENT getAlignment() {
        return this.align;
    }

    public Dimension preferredLayoutSize(Container target) {
        Dimension dim = new Dimension(0, 0);
        int nmembers = target.getComponentCount();
        for (int i = 0; i < nmembers; ++i) {
            Component m = target.getComponent(i);
            if (!m.isVisible()) continue;
            Dimension d = m.getPreferredSize();
            dim.width = Math.max(dim.width, d.width);
            dim.height += d.height;
        }
        Insets insets = target.getInsets();
        dim.width += insets.left + insets.right;
        dim.height += insets.top + insets.bottom + (nmembers - 1) * this.vgap;
        return dim;
    }

    public Dimension minimumLayoutSize(Container target) {
        Dimension dim = new Dimension(0, 0);
        int nmembers = target.getComponentCount();
        for (int i = 0; i < nmembers; ++i) {
            Component m = target.getComponent(i);
            if (!m.isVisible()) continue;
            Dimension d = m.getMinimumSize();
            dim.width = Math.max(dim.width, d.width);
            dim.height += d.height;
        }
        Insets insets = target.getInsets();
        dim.width += insets.left + insets.right;
        dim.height += insets.top + insets.bottom + (nmembers - 1) * this.vgap;
        return dim;
    }

    public void layoutContainer(Container target) {
        Dimension d;
        Component m;
        int i;
        Insets insets = target.getInsets();
        Dimension dim = target.getSize();
        int nmembers = target.getComponentCount();
        int x = insets.left;
        int y = insets.top;
        int xoff = 0;
        int widest = 0;
        for (i = 0; i < nmembers; ++i) {
            m = target.getComponent(i);
            if (!m.isVisible()) continue;
            d = m.getPreferredSize();
            widest = Math.max(widest, d.width);
        }
        for (i = 0; i < nmembers; ++i) {
            m = target.getComponent(i);
            d = m.getPreferredSize();
            int targetWidth = dim.width - insets.left - insets.right;
            int compWidth = d.width;
            int compHeight = d.height;
            if (!m.isVisible()) continue;
            if (this.align == LAYOUT_ALIGNMENT.LEFT) {
                xoff = 0;
            } else if (this.align == LAYOUT_ALIGNMENT.CENTER) {
                xoff = (targetWidth - compWidth) / 2;
            } else if (this.align == LAYOUT_ALIGNMENT.RIGHT) {
                xoff = targetWidth - compWidth;
            } else if (this.align == LAYOUT_ALIGNMENT.EXPAND) {
                xoff = 0;
                compWidth = widest;
            } else if (this.align == LAYOUT_ALIGNMENT.FIT) {
                xoff = 0;
                compWidth = targetWidth;
            }
            m.setBounds(x + xoff, y, compWidth, compHeight);
            y += this.vgap + compHeight;
        }
    }

    public String toString() {
        String str = "";
        if (this.align == LAYOUT_ALIGNMENT.LEFT) {
            str = ",align=left";
        } else if (this.align == LAYOUT_ALIGNMENT.CENTER) {
            str = ",align=center";
        } else if (this.align == LAYOUT_ALIGNMENT.RIGHT) {
            str = ",align=right";
        } else if (this.align == LAYOUT_ALIGNMENT.EXPAND) {
            str = ",align=expand";
        } else if (this.align == LAYOUT_ALIGNMENT.FIT) {
            str = ",align=fit";
        }
        return this.getClass().getName() + "[hgap=" + this.hgap + ",vgap=" + this.vgap + str + "]";
    }
}

