/*
 * Decompiled with CFR 0.152.
 */
package org.wbemservices.wbem.apps.common;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Polygon;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.event.DocumentListener;
import org.wbemservices.wbem.apps.common.Constraints;

public class JSpinBox
extends JPanel
implements KeyListener {
    private JPanel spinBox;
    private static final Border emptyBorder = new EmptyBorder(0, 0, 0, 0);
    private static final Border lineBorder = new LineBorder(Color.black);
    public Toolkit toolkit = Toolkit.getDefaultToolkit();
    public JTextField textField;
    public JButton upButton;
    public JButton downButton;
    public boolean wrapping = true;
    public boolean editable = true;

    public JSpinBox(int cols) {
        this.spinBox = this;
        this.createJSpinBox();
        this.textField.setColumns(cols);
    }

    public void createJSpinBox() {
        this.spinBox.setLayout(new GridBagLayout());
        this.spinBox.setBorder(lineBorder);
        this.textField = new JTextField();
        this.textField.setDoubleBuffered(true);
        this.textField.addKeyListener(this);
        this.textField.setBorder(emptyBorder);
        Constraints.constrain(this.spinBox, this.textField, 0, 0, 1, 1, 1, 17, 1.0, 1.0, 0, 0, 0, 0);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new GridBagLayout());
        this.upButton = new JButton();
        this.upButton.addKeyListener(this);
        this.upButton.setMargin(new Insets(0, 0, 0, 0));
        this.upButton.setContentAreaFilled(false);
        Constraints.constrain(buttonPanel, this.upButton, 0, 0, 1, 1, 0, 17, 0.0, 0.0, 0, 0, 0, 0);
        this.downButton = new JButton();
        this.downButton.addKeyListener(this);
        this.downButton.setContentAreaFilled(false);
        this.downButton.setMargin(new Insets(0, 0, 0, 0));
        Constraints.constrain(buttonPanel, this.downButton, 0, 1, 1, 1, 0, 17, 0.0, 0.0, 0, 0, 0, 0);
        Constraints.constrain(this.spinBox, buttonPanel, 1, 0, 1, 1, 0, 17, 0.0, 0.0, 0, 0, 0, 0);
    }

    public void setEnabled(boolean enabled) {
        this.textField.setEnabled(enabled);
        this.upButton.setEnabled(enabled);
        this.downButton.setEnabled(enabled);
    }

    public void addNotify() {
        super.addNotify();
        Image upImage = this.createImage(8, 3);
        Graphics bg = upImage.getGraphics();
        Polygon polygon = new Polygon();
        polygon.addPoint(4, 0);
        polygon.addPoint(0, 3);
        polygon.addPoint(8, 3);
        bg.setColor(Color.black);
        bg.fillPolygon(polygon);
        ImageIcon upIcon = new ImageIcon(upImage);
        this.upButton.setIcon(upIcon);
        Image downImage = this.createImage(8, 3);
        bg = downImage.getGraphics();
        polygon = new Polygon();
        polygon.addPoint(0, 0);
        polygon.addPoint(8, 0);
        polygon.addPoint(4, 3);
        bg.setColor(Color.black);
        bg.fillPolygon(polygon);
        ImageIcon downIcon = new ImageIcon(downImage);
        this.downButton.setIcon(downIcon);
    }

    public JTextField getTextField() {
        return this.textField;
    }

    public void setTextField(JTextField txtField) {
        this.textField = txtField;
    }

    public JButton getUpButton() {
        return this.upButton;
    }

    public void setUpButton(JButton upBtn) {
        this.upButton = upBtn;
    }

    public JButton getDownButton() {
        return this.downButton;
    }

    public void setDownButton(JButton downBtn) {
        this.downButton = downBtn;
    }

    public boolean isWrapping() {
        return this.wrapping;
    }

    public void setWrapping(boolean w) {
        this.wrapping = w;
    }

    public boolean isEditable() {
        return this.textField.isEditable();
    }

    public void setEditable(boolean e) {
        this.textField.setEditable(e);
    }

    public void keyTyped(KeyEvent e) {
    }

    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 38) {
            if (this.upButton.isEnabled()) {
                this.upButton.doClick();
            } else {
                this.toolkit.beep();
            }
        } else if (e.getKeyCode() == 40) {
            if (this.downButton.isEnabled()) {
                this.downButton.doClick();
            } else {
                this.toolkit.beep();
            }
        }
    }

    public void keyReleased(KeyEvent e) {
    }

    public void addDocumentListener(DocumentListener listener) {
        this.textField.getDocument().addDocumentListener(listener);
    }
}

