/*
 * Decompiled with CFR 0.152.
 */
package org.wbemservices.wbem.apps.common;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.wbemservices.wbem.apps.common.ActionString;
import org.wbemservices.wbem.apps.common.AdminDialog;
import org.wbemservices.wbem.apps.common.ColumnLayout;
import org.wbemservices.wbem.apps.common.DefaultProperties;
import org.wbemservices.wbem.apps.common.GenInfoPanel;
import org.wbemservices.wbem.apps.common.I18N;
import org.wbemservices.wbem.apps.common.LAYOUT_ALIGNMENT;
import org.wbemservices.wbem.apps.common.TextFieldFocusListener;
import org.wbemservices.wbem.apps.common.Util;

public class LoginDialog
extends AdminDialog
implements DocumentListener {
    protected JButton btnOK;
    protected JButton btnCancel;
    protected JTextField uname;
    protected JTextField hname;
    protected JPasswordField pass;
    protected JTextField nspace;
    protected JTextField interop;
    protected GenInfoPanel infoPanel;
    protected boolean loggedIn = false;
    protected int reqMask;
    protected int inputMask;
    public static final int HOSTNAME = 1;
    public static final int NAMESPACE = 2;
    public static final int USERNAME = 4;
    public static final int PASSWORD = 8;
    public static final int INTEROP = 16;
    public static final int NONE = 0;
    public static final int ALL = 31;

    public LoginDialog(Frame parent, int iMask, int rMask) {
        super(parent, I18N.loadString("TTL_LOGIN", "org.wbemservices.wbem.apps.common.common"), false);
        this.inputMask = iMask;
        this.reqMask = rMask & iMask;
        this.infoPanel = this.getInfoPanel();
        this.btnOK = this.getOKBtn();
        this.btnOK.addActionListener(new OKCancelButtonListener());
        this.btnCancel = this.getCancelBtn();
        this.btnCancel.addActionListener(new OKCancelButtonListener());
        JPanel mainPanel = this.getRightPanel();
        mainPanel.setBorder(BorderFactory.createEmptyBorder(15, 15, 15, 15));
        mainPanel.setLayout(new ColumnLayout(LAYOUT_ALIGNMENT.EXPAND));
        JPanel inputs = new JPanel();
        inputs.setLayout(new ColumnLayout(LAYOUT_ALIGNMENT.RIGHT));
        TextFieldFocusListener tfListener = new TextFieldFocusListener();
        if ((this.inputMask & 1) > 0) {
            JPanel hnamep = new JPanel();
            ActionString asHost = new ActionString("LBL_HOSTURL", "org.wbemservices.wbem.apps.common.common");
            JLabel hnamel = new JLabel(asHost.getString() + ":", 4);
            hnamel.setDisplayedMnemonic(asHost.getMnemonic());
            hnamep.add(hnamel);
            this.hname = new JTextField(12);
            hnamel.setLabelFor(this.hname);
            this.hname.addFocusListener(tfListener);
            this.hname.getDocument().addDocumentListener(this);
            hnamep.add(this.hname);
            inputs.add(hnamep);
        }
        if ((this.inputMask & 2) > 0) {
            JPanel nspacep = new JPanel();
            ActionString asNSpace = new ActionString("LBL_NAMESPACE");
            JLabel nspacel = new JLabel(asNSpace.getString() + ":", 4);
            nspacel.setDisplayedMnemonic(asNSpace.getMnemonic());
            nspacep.add(nspacel);
            this.nspace = new JTextField(12);
            nspacel.setLabelFor(this.nspace);
            this.nspace.addFocusListener(tfListener);
            this.nspace.getDocument().addDocumentListener(this);
            nspacep.add(this.nspace);
            inputs.add(nspacep);
        }
        if ((this.inputMask & 4) > 0) {
            JPanel login = new JPanel();
            ActionString asUser = new ActionString("LBL_USERNAME", "org.wbemservices.wbem.apps.common.common");
            JLabel userl = new JLabel(asUser.getString() + ":", 4);
            userl.setDisplayedMnemonic(asUser.getMnemonic());
            login.add(userl);
            this.uname = new JTextField(12);
            userl.setLabelFor(this.uname);
            this.uname.addFocusListener(tfListener);
            this.uname.getDocument().addDocumentListener(this);
            login.add(this.uname);
            inputs.add(login);
        }
        if ((this.inputMask & 8) > 0) {
            JPanel passwd = new JPanel();
            ActionString asPasswd = new ActionString("LBL_PASSWORD", "org.wbemservices.wbem.apps.common.common");
            JLabel passwdl = new JLabel(asPasswd.getString() + ":", 4);
            passwdl.setDisplayedMnemonic(asPasswd.getMnemonic());
            passwd.add(passwdl);
            this.pass = new JPasswordField(12);
            passwdl.setLabelFor(this.pass);
            this.pass.addFocusListener(tfListener);
            this.pass.getDocument().addDocumentListener(this);
            passwd.add(this.pass);
            inputs.add(passwd);
        }
        if ((this.inputMask & 0x10) > 0) {
            JPanel interopp = new JPanel();
            ActionString asInterop = new ActionString("LBL_INTEROP_NS");
            JLabel lInterop = new JLabel(asInterop.getString() + ":", 4);
            lInterop.setDisplayedMnemonic(asInterop.getMnemonic());
            interopp.add(lInterop);
            this.interop = new JTextField(12);
            lInterop.setLabelFor(this.interop);
            this.interop.addFocusListener(tfListener);
            this.interop.getDocument().addDocumentListener(this);
            interopp.add(this.interop);
            inputs.add(interopp);
        }
        mainPanel.add(inputs);
        this.setSize(DefaultProperties.loginWindowSize);
        this.setOKEnabled();
        Util.positionWindow(this, parent);
    }

    public boolean getLoggedIn() {
        return this.loggedIn;
    }

    public void setLoggedIn(boolean b) {
        this.loggedIn = b;
    }

    public String getUserName() {
        String ret = "";
        if (this.uname != null) {
            ret = this.uname.getText().trim();
        }
        return ret;
    }

    public String getInteropNameSpace() {
        String ret = "";
        if (this.interop != null) {
            ret = this.interop.getText().trim();
        }
        return ret;
    }

    public String getPassword() {
        String ret = "";
        if (this.pass != null) {
            ret = new String(this.pass.getPassword());
        }
        return ret.trim();
    }

    public String getHostName() {
        String ret = "";
        if (this.hname != null) {
            ret = this.hname.getText().trim();
        }
        return ret;
    }

    public String getNameSpace() {
        String ret = "";
        if (this.nspace != null) {
            ret = this.nspace.getText().trim();
        }
        return ret;
    }

    public void setHostName(String s) {
        if (this.hname != null) {
            this.hname.setText(s);
        }
    }

    public void setInteropNameSpace(String s) {
        if (this.interop != null) {
            this.interop.setText(s);
        }
    }

    public void setNameSpace(String s) {
        if (this.nspace != null) {
            this.nspace.setText(s);
        }
    }

    public void setUserName(String s) {
        if (this.uname != null) {
            this.uname.setText(s);
        }
    }

    public void setPassword(String s) {
        if (this.pass != null) {
            this.pass.setText(s);
        }
    }

    public void changedUpdate(DocumentEvent evt) {
        this.documentEvent(evt);
    }

    public void insertUpdate(DocumentEvent evt) {
        this.documentEvent(evt);
    }

    public void removeUpdate(DocumentEvent evt) {
        this.documentEvent(evt);
    }

    public void documentEvent(DocumentEvent evt) {
        if (this.btnOK != null) {
            this.setOKEnabled();
        }
    }

    protected void setOKEnabled() {
        boolean b = true;
        if ((this.reqMask & 1) > 0) {
            boolean bl = b = b && this.hname.getText().trim().length() != 0;
        }
        if ((this.reqMask & 2) > 0) {
            boolean bl = b = b && this.nspace.getText().trim().length() != 0;
        }
        if ((this.reqMask & 4) > 0) {
            boolean bl = b = b && this.uname.getText().trim().length() != 0;
        }
        if ((this.reqMask & 8) > 0) {
            boolean bl = b = b && this.getPassword().trim().length() != 0;
        }
        if ((this.reqMask & 0x10) > 0) {
            b = b && this.interop.getText().trim().length() != 0;
        }
        this.btnOK.setEnabled(b);
    }

    public void okClicked() {
    }

    public void cancelClicked() {
    }

    class OKCancelButtonListener
    implements ActionListener {
        OKCancelButtonListener() {
        }

        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == LoginDialog.this.btnCancel) {
                LoginDialog.this.cancelClicked();
            } else if (e.getSource() == LoginDialog.this.btnOK) {
                LoginDialog.this.okClicked();
            }
        }
    }
}

