/*
 * Decompiled with CFR 0.152.
 */
package org.wbemservices.wbem.apps.common;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import org.wbemservices.wbem.apps.common.LAYOUT_ALIGNMENT;

public class RowLayout
implements LayoutManager {
    LAYOUT_ALIGNMENT align;
    int hgap;
    int vgap;

    public RowLayout() {
        this(LAYOUT_ALIGNMENT.EXPAND, 5, 5);
    }

    public RowLayout(LAYOUT_ALIGNMENT alignment) {
        this(alignment, 5, 5);
    }

    public RowLayout(LAYOUT_ALIGNMENT alignment, int hzgap, int vrtgap) {
        this.align = alignment;
        this.hgap = hzgap;
        this.vgap = vrtgap;
    }

    public void addLayoutComponent(String name, Component comp) {
    }

    public void removeLayoutComponent(Component comp) {
    }

    public int getHorizontalGap() {
        return this.hgap;
    }

    public int getVerticalGap() {
        return this.hgap;
    }

    public LAYOUT_ALIGNMENT getAlignment() {
        return this.align;
    }

    public Dimension preferredLayoutSize(Container target) {
        Dimension dim = new Dimension(0, 0);
        int nmembers = target.getComponentCount();
        for (int i = 0; i < nmembers; ++i) {
            Component m = target.getComponent(i);
            if (!m.isVisible()) continue;
            Dimension d = m.getPreferredSize();
            dim.height = Math.max(dim.height, d.height);
            dim.width += d.width;
        }
        Insets insets = target.getInsets();
        dim.width += insets.left + insets.right + (nmembers - 1) * this.hgap;
        dim.height += insets.top + insets.bottom;
        return dim;
    }

    public Dimension minimumLayoutSize(Container target) {
        Dimension dim = new Dimension(0, 0);
        int nmembers = target.getComponentCount();
        for (int i = 0; i < nmembers; ++i) {
            Component m = target.getComponent(i);
            if (!m.isVisible()) continue;
            Dimension d = m.getMinimumSize();
            dim.height = Math.max(dim.height, d.height);
            dim.width += d.width;
        }
        Insets insets = target.getInsets();
        dim.width += insets.left + insets.right + (nmembers - 1) * this.hgap;
        dim.height += insets.top + insets.bottom;
        return dim;
    }

    public void layoutContainer(Container target) {
        Dimension d;
        Component m;
        int i;
        Insets insets = target.getInsets();
        Dimension dim = target.getSize();
        int nmembers = target.getComponentCount();
        int x = insets.left;
        int y = insets.top;
        int yoff = 0;
        int tallest = 0;
        for (i = 0; i < nmembers; ++i) {
            m = target.getComponent(i);
            if (!m.isVisible()) continue;
            d = m.getPreferredSize();
            tallest = Math.max(tallest, d.height);
        }
        for (i = 0; i < nmembers; ++i) {
            m = target.getComponent(i);
            d = m.getPreferredSize();
            int targetHeight = dim.height - insets.top - insets.bottom;
            int compHeight = d.height;
            int compWidth = d.width;
            if (!m.isVisible()) continue;
            if (this.align == LAYOUT_ALIGNMENT.LEFT) {
                yoff = 0;
            } else if (this.align == LAYOUT_ALIGNMENT.CENTER) {
                yoff = (targetHeight - compHeight) / 2;
            } else if (this.align == LAYOUT_ALIGNMENT.RIGHT) {
                yoff = targetHeight - compHeight;
            } else if (this.align == LAYOUT_ALIGNMENT.EXPAND) {
                yoff = 0;
                compHeight = tallest;
            } else if (this.align == LAYOUT_ALIGNMENT.FIT) {
                yoff = 0;
                compHeight = targetHeight;
            }
            m.setBounds(x, y + yoff, compWidth, compHeight);
            x += this.hgap + d.width;
        }
    }

    public String toString() {
        String str = "";
        if (this.align == LAYOUT_ALIGNMENT.LEFT) {
            str = ",align=left";
        } else if (this.align == LAYOUT_ALIGNMENT.CENTER) {
            str = ",align=center";
        } else if (this.align == LAYOUT_ALIGNMENT.RIGHT) {
            str = ",align=right";
        } else if (this.align == LAYOUT_ALIGNMENT.EXPAND) {
            str = ",align=expand";
        }
        return this.getClass().getName() + "[hgap=" + this.hgap + ",vgap=" + this.vgap + str + "]";
    }
}

