/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.simulator.cimom.common;

import java.io.InputStream;
import java.io.ObjectInputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMProperty;
import org.eclipse.aperi.simulator.cimom.common.ConnectionPool;
import org.eclipse.aperi.simulator.cimom.common.SimulatorUtility;
import org.eclipse.aperi.simulator.cimom.common.generator.SimClass;
import org.eclipse.aperi.simulator.cimom.sunwbem.util.CIMDataBLOB;

public final class DatabaseManager {
    private static final String CIMOM_INFO_INSERT = "INSERT INTO SIM.CIMOM_INFO (CIMOM_TYPE, DETAILS, URL, INTOP_NS, USERID, PWDID) VALUES(?, ?, ?, ?, ?, ?)";
    private static final String NS_INFO_INSERT = "INSERT INTO SIM.NS_INFO(CIMOM_INFO_ID, NAMESPACE) VALUES (?, ?)";
    private static final String CIM_CLASS_INSERT = "INSERT INTO SIM.CIM_CLASS(NS_INFO_ID, CLASS_NAME) VALUES (?, ?)";
    private static final String CIM_DATA_INSERT = "INSERT INTO SIM.CIM_DATA (CIM_CLASS_ID, CIM_OP, CIM_INST) VALUES (?, ?, ?)";
    private static final String CIM_DATA_UPDATE = "UPDATE SIM.CIM_DATA DATA SET CIM_OP = ? , CIM_INST = ? WHERE DATA.ID = ?";
    private static final String CIM_GET_CLASS_ID = "SELECT CIM_CLASS.ID FROM SIM.CIM_CLASS AS CIM_CLASS, SIM.NS_INFO AS NS_INFO WHERE NS_INFO.NAMESPACE = ? AND CIM_CLASS.CLASS_NAME = ? AND CIM_CLASS.NS_INFO_ID = NS_INFO.ID";
    private static final String IS_ASSOCIATION_INDEX_QUERY = "SELECT ID FROM SIM.CIM_ASC";
    private static boolean isAssociationTableExistsFlag;
    private PreparedStatement psEnumInstanceNamesWithString;
    private PreparedStatement psEnumInstanceNamesWithID;
    PreparedStatement psGetInstanceQuery;

    private DatabaseManager() {
        try {
            Class.forName("COM.ibm.db2.jdbc.app.DB2Driver");
            this.init();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void init() throws SQLException {
        Connection connection = ConnectionPool.getConnection();
        this.psEnumInstanceNamesWithString = connection.prepareStatement("SELECT DATA.CIM_OP, DATA.ID FROM SIM.CIM_DATA DATA, SIM.CIM_CLASS CLS, SIM.NS_INFO NS WHERE DATA.CIM_CLASS_ID=CLS.ID AND CLS.NS_INFO_ID=NS.ID AND CLS.CLASS_NAME = ? AND NS.NAMESPACE=?");
        this.psEnumInstanceNamesWithID = connection.prepareStatement("SELECT DATA.CIM_OP, DATA.ID FROM SIM.CIM_DATA DATA, SIM.CIM_CLASS CLS WHERE DATA.CIM_CLASS_ID=CLS.ID AND CLS.CLASS_NAME=? AND CLS.NS_INFO_ID=?");
        this.psGetInstanceQuery = connection.prepareStatement("SELECT DATA.ID, DATA.CIM_OP, DATA.CIM_INST  FROM SIM.CIM_DATA DATA, SIM.CIM_CLASS CLS, SIM.NS_INFO NS WHERE DATA.CIM_CLASS_ID=CLS.ID AND CLS.NS_INFO_ID=NS.ID AND CLS.CLASS_NAME = ? AND NS.NAMESPACE=?");
        isAssociationTableExistsFlag = this.isAssociationTableExists();
        ConnectionPool.closeConnection(connection);
    }

    public static DatabaseManager getDbManager() {
        return DatabaseManagerHandler.instance;
    }

    public synchronized void insert_CIMOM_INFO(int n, String string, String string2, String string3, String string4, String string5) throws Exception {
        Connection connection = ConnectionPool.getConnection();
        PreparedStatement preparedStatement = connection.prepareStatement(CIMOM_INFO_INSERT);
        preparedStatement.setInt(1, n);
        preparedStatement.setString(2, string);
        preparedStatement.setString(3, string2);
        preparedStatement.setString(4, string3);
        if (string4 != null) {
            preparedStatement.setString(5, string4);
        } else {
            preparedStatement.setNull(5, 12);
        }
        if (string5 != null) {
            preparedStatement.setString(6, string5);
        } else {
            preparedStatement.setNull(6, 12);
        }
        preparedStatement.executeUpdate();
        connection.commit();
        preparedStatement.close();
        ConnectionPool.closeConnection(connection);
    }

    public synchronized void insert_NS_INFO(int n, String string) throws Exception {
        Connection connection = ConnectionPool.getConnection();
        PreparedStatement preparedStatement = connection.prepareStatement(NS_INFO_INSERT);
        preparedStatement.setInt(1, n);
        preparedStatement.setString(2, string);
        preparedStatement.executeUpdate();
        connection.commit();
        preparedStatement.close();
        ConnectionPool.closeConnection(connection);
    }

    public synchronized void insert_CIM_CLASS(int n, String string) throws Exception {
        Connection connection = ConnectionPool.getConnection();
        PreparedStatement preparedStatement = connection.prepareStatement(CIM_CLASS_INSERT);
        preparedStatement.setInt(1, n);
        preparedStatement.setString(2, string);
        preparedStatement.executeUpdate();
        connection.commit();
        preparedStatement.close();
        ConnectionPool.closeConnection(connection);
    }

    public synchronized void insert_CIM_DATA(int n, CIMInstance cIMInstance) throws Exception {
        Connection connection = ConnectionPool.getConnection();
        CIMDataBLOB cIMDataBLOB = new CIMDataBLOB(cIMInstance);
        int n2 = (int)cIMDataBLOB.length();
        CIMDataBLOB cIMDataBLOB2 = new CIMDataBLOB(cIMInstance.getObjectPath());
        int n3 = (int)cIMDataBLOB2.length();
        PreparedStatement preparedStatement = connection.prepareStatement(CIM_DATA_INSERT);
        preparedStatement.setInt(1, n);
        preparedStatement.setBinaryStream(2, cIMDataBLOB2.getBinaryStream(), n3);
        preparedStatement.setBinaryStream(3, cIMDataBLOB.getBinaryStream(), n2);
        preparedStatement.executeUpdate();
        connection.commit();
        preparedStatement.close();
        ConnectionPool.closeConnection(connection);
    }

    public int getMaxID(String string) throws Exception {
        Connection connection = ConnectionPool.getConnection();
        int n = -1;
        String string2 = "SELECT MAX(ID) FROM " + string;
        PreparedStatement preparedStatement = connection.prepareStatement(string2);
        ResultSet resultSet = preparedStatement.executeQuery();
        if (resultSet.next()) {
            n = resultSet.getInt(1);
        }
        resultSet.close();
        preparedStatement.close();
        ConnectionPool.closeConnection(connection);
        return n;
    }

    public void persistInstances(int n, Map map, Map map2) throws Exception {
        Set set = map.keySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            String string2 = string.substring(string.indexOf(58) + 1);
            this.insert_CIM_CLASS(n, string2);
            int n2 = this.getMaxID("SIM.CIM_CLASS");
            Object v = map.get(string);
            if (null == v) continue;
            if (v instanceof List) {
                Iterator iterator2 = ((List)v).iterator();
                while (iterator2.hasNext()) {
                    CIMInstance cIMInstance = (CIMInstance)iterator2.next();
                    System.out.println(cIMInstance);
                    this.insert_CIM_DATA(n2, cIMInstance);
                }
                continue;
            }
            this.insert_CIM_DATA(n2, (CIMInstance)v);
            System.out.println(v.toString());
        }
        if (isAssociationTableExistsFlag) {
            this.buildAssociationIndexes(n, this.createAssociationClassList(map2));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAssociationTableExists() {
        boolean bl = false;
        Connection connection = ConnectionPool.getConnection();
        try {
            PreparedStatement preparedStatement = connection.prepareStatement("SELECT TABLES.TABSCHEMA, TABLES.TABNAME FROM SYSCAT.TABLES AS TABLES  WHERE TABLES.TABNAME = 'CIM_ASC' AND TABLES.TABSCHEMA = 'SIM'");
            ResultSet resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                bl = true;
            }
            resultSet.close();
            preparedStatement.close();
        }
        catch (Exception exception) {
            System.out.println(" Exception description : " + exception.toString());
        }
        finally {
            ConnectionPool.closeConnection(connection);
        }
        return bl;
    }

    private Set createAssociationClassList(Map map) {
        HashSet<String> hashSet = new HashSet<String>();
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            SimClass simClass = (SimClass)map.get(string);
            if (!simClass.isAssociation()) continue;
            hashSet.add(simClass.getName());
        }
        return hashSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAssociationIndex() {
        boolean bl = false;
        if (isAssociationTableExistsFlag) {
            Connection connection = ConnectionPool.getConnection();
            try {
                PreparedStatement preparedStatement = connection.prepareStatement(IS_ASSOCIATION_INDEX_QUERY);
                ResultSet resultSet = preparedStatement.executeQuery();
                if (resultSet.next()) {
                    bl = true;
                }
                resultSet.close();
                preparedStatement.close();
            }
            catch (Exception exception) {
                System.out.println(" Exception description : " + exception.toString());
            }
            finally {
                ConnectionPool.closeConnection(connection);
            }
        }
        return bl;
    }

    private void buildAssociationIndexes(int n, Set set) {
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            try {
                this.psEnumInstanceNamesWithID.setString(1, string);
                this.psEnumInstanceNamesWithID.setInt(2, n);
                ResultSet resultSet = this.psEnumInstanceNamesWithID.executeQuery();
                while (resultSet.next()) {
                    int n2 = resultSet.getInt(2);
                    InputStream inputStream = resultSet.getBinaryStream(1);
                    ObjectInputStream objectInputStream = new ObjectInputStream(inputStream);
                    Object object = objectInputStream.readObject();
                    CIMObjectPath cIMObjectPath = (CIMObjectPath)object;
                    this.insertAssociationIndexData(n2, cIMObjectPath);
                }
                resultSet.close();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private void insertAssociationIndexData(int n, CIMObjectPath cIMObjectPath) throws Exception {
        int n2;
        Vector vector = cIMObjectPath.getKeys();
        CIMObjectPath cIMObjectPath2 = null;
        CIMObjectPath cIMObjectPath3 = null;
        int n3 = vector.size();
        for (n2 = 0; n2 < n3; ++n2) {
            CIMProperty cIMProperty = (CIMProperty)vector.elementAt(n2);
            if (cIMProperty.getType().getType() != 28) continue;
            if (cIMObjectPath2 == null) {
                cIMObjectPath2 = (CIMObjectPath)cIMProperty.getValue().getValue();
                continue;
            }
            if (cIMObjectPath3 != null) continue;
            cIMObjectPath3 = (CIMObjectPath)cIMProperty.getValue().getValue();
            break;
        }
        if (null != cIMObjectPath2 && null != cIMObjectPath3) {
            n2 = this.getInstanceID(cIMObjectPath2);
            int n4 = this.getInstanceID(cIMObjectPath3);
            if (n2 != -1 && n4 != -1) {
                this.insert_CIM_ASSOC(n, n2, n4);
            }
        }
    }

    protected synchronized void insert_CIM_ASSOC(int n, int n2, int n3) throws Exception {
        Connection connection = ConnectionPool.getConnection();
        String string = "INSERT INTO SIM.CIM_ASC(CIM_DATA_ASC_ID, CIM_DATA_FRM_ID, CIM_DATA_TO_ID) VALUES (?, ?, ?)";
        PreparedStatement preparedStatement = connection.prepareStatement(string);
        preparedStatement.setInt(1, n);
        preparedStatement.setInt(2, n2);
        preparedStatement.setInt(3, n3);
        preparedStatement.executeUpdate();
        connection.commit();
        preparedStatement.close();
        ConnectionPool.closeConnection(connection);
    }

    public int getInstanceID(CIMObjectPath cIMObjectPath) {
        int n = -1;
        try {
            String string = cIMObjectPath.getObjectName();
            String string2 = SimulatorUtility.fixNamespaceSlashIssue(cIMObjectPath.getNameSpace());
            this.psEnumInstanceNamesWithString.setString(1, string);
            this.psEnumInstanceNamesWithString.setString(2, string2);
            ResultSet resultSet = this.psEnumInstanceNamesWithString.executeQuery();
            while (resultSet.next()) {
                ObjectInputStream objectInputStream;
                Object object;
                CIMObjectPath cIMObjectPath2;
                InputStream inputStream = resultSet.getBinaryStream(1);
                if (inputStream == null || !SimulatorUtility.equalsCIMObjectPath(cIMObjectPath2 = (CIMObjectPath)(object = (objectInputStream = new ObjectInputStream(inputStream)).readObject()), cIMObjectPath)) continue;
                n = resultSet.getInt(2);
                break;
            }
            resultSet.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return n;
    }

    public CIMInstance getInstance(CIMObjectPath cIMObjectPath) throws Exception {
        String string = cIMObjectPath.getObjectName();
        String string2 = SimulatorUtility.fixNamespaceSlashIssue(cIMObjectPath.getNameSpace());
        CIMInstance cIMInstance = null;
        this.psGetInstanceQuery.setString(1, string);
        this.psGetInstanceQuery.setString(2, string2);
        ResultSet resultSet = this.psGetInstanceQuery.executeQuery();
        while (resultSet.next()) {
            ObjectInputStream objectInputStream = new ObjectInputStream(resultSet.getBinaryStream(2));
            CIMObjectPath cIMObjectPath2 = (CIMObjectPath)objectInputStream.readObject();
            if (!SimulatorUtility.equalsCIMObjectPath(cIMObjectPath2, cIMObjectPath)) continue;
            InputStream inputStream = resultSet.getBinaryStream(3);
            ObjectInputStream objectInputStream2 = new ObjectInputStream(inputStream);
            cIMInstance = (CIMInstance)objectInputStream2.readObject();
            break;
        }
        resultSet.close();
        return cIMInstance;
    }

    public boolean createInstance(CIMInstance cIMInstance) throws Exception {
        Connection connection = ConnectionPool.getConnection();
        CIMObjectPath cIMObjectPath = cIMInstance.getObjectPath();
        String string = cIMObjectPath.getObjectName();
        String string2 = SimulatorUtility.fixNamespaceSlashIssue(cIMObjectPath.getNameSpace());
        int n = -1;
        PreparedStatement preparedStatement = connection.prepareStatement(CIM_GET_CLASS_ID);
        preparedStatement.setString(1, string2);
        preparedStatement.setString(2, string);
        ResultSet resultSet = preparedStatement.executeQuery();
        if (resultSet.next()) {
            n = resultSet.getInt(1);
        }
        if (n == -1) {
            n = this.createClassEntry(string2, string);
        }
        resultSet.close();
        preparedStatement.close();
        this.insert_CIM_DATA(n, cIMInstance);
        if (isAssociationTableExistsFlag) {
            this.insertAssociationIndexData(this.getMaxID("SIM.CIM_DATA"), cIMInstance.getObjectPath());
        }
        ConnectionPool.closeConnection(connection);
        return false;
    }

    private int createClassEntry(String string, String string2) throws Exception {
        Connection connection = ConnectionPool.getConnection();
        Statement statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery("SELECT NS_INFO.ID FROM SIM.NS_INFO AS NS_INFO WHERE NS_INFO.NAMESPACE = '" + string + "'");
        int n = -1;
        if (resultSet.next()) {
            n = resultSet.getInt(1);
        }
        statement.close();
        resultSet.close();
        if (-1 == n) {
            this.insert_NS_INFO(this.getMaxID("SIM.CIMOM_INFO"), string);
            resultSet = statement.executeQuery("SELECT NS_INFO.ID FROM SIM.NS_INFO AS NS_INFO WHERE NS_INFO.NAMESPACE = '" + string + "'");
            if (resultSet.next()) {
                n = resultSet.getInt(1);
            }
        }
        this.insert_CIM_CLASS(n, string2);
        ConnectionPool.closeConnection(connection);
        return this.getMaxID("SIM.CIM_CLASS");
    }

    public boolean updateInstance(CIMObjectPath cIMObjectPath, CIMInstance cIMInstance) throws Exception {
        Connection connection = ConnectionPool.getConnection();
        boolean bl = false;
        int n = this.getInstanceID(cIMObjectPath);
        CIMDataBLOB cIMDataBLOB = new CIMDataBLOB(cIMInstance);
        int n2 = (int)cIMDataBLOB.length();
        CIMDataBLOB cIMDataBLOB2 = new CIMDataBLOB(cIMInstance.getObjectPath());
        int n3 = (int)cIMDataBLOB2.length();
        PreparedStatement preparedStatement = connection.prepareStatement(CIM_DATA_UPDATE);
        preparedStatement.setBinaryStream(1, cIMDataBLOB2.getBinaryStream(), n3);
        preparedStatement.setBinaryStream(2, cIMDataBLOB.getBinaryStream(), n2);
        preparedStatement.setInt(3, n);
        preparedStatement.executeUpdate();
        preparedStatement.close();
        bl = true;
        ConnectionPool.closeConnection(connection);
        return bl;
    }

    public boolean deleteInstance(CIMObjectPath cIMObjectPath) throws Exception {
        Connection connection = ConnectionPool.getConnection();
        boolean bl = false;
        int n = this.getInstanceID(cIMObjectPath);
        Statement statement = connection.createStatement();
        statement.execute("DELETE FROM SIM.CIM_DATA DATA WHERE DATA.ID = " + n);
        statement.close();
        bl = true;
        ConnectionPool.closeConnection(connection);
        return bl;
    }

    public List enumerateInstances(String string, String string2) throws Exception {
        Connection connection = ConnectionPool.getConnection();
        ArrayList<CIMInstance> arrayList = new ArrayList<CIMInstance>();
        PreparedStatement preparedStatement = connection.prepareStatement("SELECT DATA.ID, DATA.CIM_OP, DATA.CIM_INST  FROM SIM.CIM_DATA DATA, SIM.CIM_CLASS CLS, SIM.NS_INFO NS WHERE DATA.CIM_CLASS_ID=CLS.ID AND CLS.NS_INFO_ID=NS.ID AND CLS.CLASS_NAME = ? AND NS.NAMESPACE=?");
        preparedStatement.setString(1, string2);
        preparedStatement.setString(2, string);
        ResultSet resultSet = preparedStatement.executeQuery();
        while (resultSet.next()) {
            InputStream inputStream = resultSet.getBinaryStream(3);
            ObjectInputStream objectInputStream = new ObjectInputStream(inputStream);
            Object object = objectInputStream.readObject();
            CIMInstance cIMInstance = (CIMInstance)object;
            arrayList.add(cIMInstance);
        }
        resultSet.close();
        preparedStatement.close();
        ConnectionPool.closeConnection(connection);
        return arrayList;
    }

    public List enumerateInstanceNames(CIMObjectPath cIMObjectPath) {
        String string = cIMObjectPath.getObjectName();
        String string2 = cIMObjectPath.getNameSpace();
        return this.enumerateInstanceNames(string2, string);
    }

    public List enumerateInstanceNames(String string, String string2) {
        Vector<CIMObjectPath> vector = new Vector<CIMObjectPath>();
        Connection connection = ConnectionPool.getConnection();
        try {
            PreparedStatement preparedStatement = connection.prepareStatement("SELECT DATA.CIM_OP, DATA.ID FROM SIM.CIM_DATA DATA, SIM.CIM_CLASS CLS, SIM.NS_INFO NS WHERE DATA.CIM_CLASS_ID=CLS.ID AND CLS.NS_INFO_ID=NS.ID AND CLS.CLASS_NAME = ? AND NS.NAMESPACE=?");
            preparedStatement.setString(1, string2);
            preparedStatement.setString(2, string);
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                InputStream inputStream = resultSet.getBinaryStream(1);
                ObjectInputStream objectInputStream = new ObjectInputStream(inputStream);
                Object object = objectInputStream.readObject();
                CIMObjectPath cIMObjectPath = (CIMObjectPath)object;
                vector.add(cIMObjectPath);
            }
            resultSet.close();
            preparedStatement.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        ConnectionPool.closeConnection(connection);
        return vector;
    }

    public int getClassID(String string, String string2) throws SQLException {
        Connection connection = ConnectionPool.getConnection();
        PreparedStatement preparedStatement = connection.prepareStatement("SELECT CIM_CLASS.ID, CIM_CLASS.CLASS_NAME FROM SIM.CIM_CLASS AS CIM_CLASS, SIM.NS_INFO AS NS_INFO WHERE CIM_CLASS.NS_INFO_ID = NS_INFO.ID AND NS_INFO.NAMESPACE = ? AND CIM_CLASS.CLASS_NAME = ?");
        preparedStatement.setString(1, string);
        preparedStatement.setString(2, string2);
        ResultSet resultSet = preparedStatement.executeQuery();
        int n = -1;
        if (resultSet.next()) {
            n = resultSet.getInt(1);
        }
        preparedStatement.close();
        resultSet.close();
        ConnectionPool.closeConnection(connection);
        return n;
    }

    public List getReferencedInstances(int n, int n2) throws Exception {
        Connection connection = ConnectionPool.getConnection();
        PreparedStatement preparedStatement = connection.prepareStatement("SELECT CIM_DATA.ID, CIM_DATA.CIM_OP, CIM_DATA.CIM_INST FROM SIM.CIM_DATA AS CIM_DATA, SIM.CIM_ASC AS CIM_ASC WHERE CIM_DATA.CIM_CLASS_ID = ? AND CIM_ASC.CIM_DATA_ASC_ID = CIM_DATA.ID AND (CIM_ASC.CIM_DATA_FRM_ID = ? OR CIM_ASC.CIM_DATA_TO_ID = ?)");
        preparedStatement.setInt(1, n2);
        preparedStatement.setInt(2, n);
        preparedStatement.setInt(3, n);
        ResultSet resultSet = preparedStatement.executeQuery();
        ArrayList<CIMInstance> arrayList = new ArrayList<CIMInstance>();
        while (resultSet.next()) {
            InputStream inputStream = resultSet.getBinaryStream(3);
            ObjectInputStream objectInputStream = new ObjectInputStream(inputStream);
            Object object = objectInputStream.readObject();
            CIMInstance cIMInstance = (CIMInstance)object;
            arrayList.add(cIMInstance);
        }
        resultSet.close();
        preparedStatement.close();
        ConnectionPool.closeConnection(connection);
        return arrayList;
    }

    public List getTargetInstances(int n, int n2) throws Exception {
        Integer n3;
        Connection connection = ConnectionPool.getConnection();
        Vector<Integer> vector = new Vector<Integer>();
        ArrayList<CIMInstance> arrayList = new ArrayList<CIMInstance>();
        PreparedStatement preparedStatement = connection.prepareStatement("SELECT CIM_ASC.CIM_DATA_FRM_ID FROM SIM.CIM_DATA AS CIM_DATA, SIM.CIM_ASC AS CIM_ASC WHERE CIM_DATA.CIM_CLASS_ID = ? AND CIM_ASC.CIM_DATA_TO_ID = ? AND CIM_ASC.CIM_DATA_ASC_ID = CIM_DATA.ID");
        preparedStatement.setInt(1, n2);
        preparedStatement.setInt(2, n);
        ResultSet resultSet = preparedStatement.executeQuery();
        while (resultSet.next()) {
            n3 = new Integer(resultSet.getInt(1));
            if (vector.contains(n3)) continue;
            vector.add(n3);
        }
        resultSet.close();
        preparedStatement.close();
        preparedStatement = connection.prepareStatement("SELECT CIM_ASC.CIM_DATA_TO_ID FROM SIM.CIM_DATA AS CIM_DATA, SIM.CIM_ASC AS CIM_ASC WHERE CIM_DATA.CIM_CLASS_ID = ? AND CIM_ASC.CIM_DATA_FRM_ID = ? AND CIM_ASC.CIM_DATA_ASC_ID = CIM_DATA.ID");
        preparedStatement.setInt(1, n2);
        preparedStatement.setInt(2, n);
        resultSet = preparedStatement.executeQuery();
        while (resultSet.next()) {
            n3 = new Integer(resultSet.getInt(1));
            if (vector.contains(n3)) continue;
            vector.add(n3);
        }
        resultSet.close();
        preparedStatement.close();
        ConnectionPool.closeConnection(connection);
        int n4 = vector.size();
        for (int i = 0; i < n4; ++i) {
            arrayList.add(this.getInstanceFromId((Integer)vector.elementAt(i)));
        }
        return arrayList;
    }

    public CIMInstance getInstanceFromId(int n) throws Exception {
        Connection connection = ConnectionPool.getConnection();
        CIMInstance cIMInstance = null;
        PreparedStatement preparedStatement = connection.prepareStatement("SELECT CIM_DATA.CIM_INST FROM SIM.CIM_DATA AS CIM_DATA WHERE CIM_DATA.ID = ?");
        preparedStatement.setInt(1, n);
        ResultSet resultSet = preparedStatement.executeQuery();
        while (resultSet.next()) {
            InputStream inputStream = resultSet.getBinaryStream(1);
            ObjectInputStream objectInputStream = new ObjectInputStream(inputStream);
            Object object = objectInputStream.readObject();
            cIMInstance = (CIMInstance)object;
        }
        resultSet.close();
        preparedStatement.close();
        ConnectionPool.closeConnection(connection);
        return cIMInstance;
    }

    public List references(CIMObjectPath cIMObjectPath, CIMObjectPath cIMObjectPath2) throws CIMException {
        ArrayList<CIMInstance> arrayList = new ArrayList<CIMInstance>();
        try {
            boolean bl = DatabaseManager.getDbManager().isAssociationIndex();
            String string = cIMObjectPath.getNameSpace();
            if (bl) {
                int n = DatabaseManager.getDbManager().getInstanceID(cIMObjectPath2);
                if (-1 != n) {
                    String string2 = cIMObjectPath.getObjectName();
                    int n2 = DatabaseManager.getDbManager().getClassID(string, string2);
                    if (-1 != n2) {
                        arrayList.addAll(DatabaseManager.getDbManager().getReferencedInstances(n, n2));
                    }
                }
            } else {
                List list = DatabaseManager.getDbManager().enumerateInstances(string, cIMObjectPath.getObjectName());
                Iterator iterator = list.iterator();
                block2: while (iterator.hasNext()) {
                    CIMInstance cIMInstance = (CIMInstance)iterator.next();
                    Vector vector = cIMInstance.getKeys();
                    Iterator iterator2 = vector.iterator();
                    boolean bl2 = false;
                    while (iterator2.hasNext()) {
                        CIMProperty cIMProperty = (CIMProperty)iterator2.next();
                        if (cIMProperty.isReference()) {
                            CIMObjectPath cIMObjectPath3 = (CIMObjectPath)cIMProperty.getValue().getValue();
                            bl2 = SimulatorUtility.equalsCIMObjectPath(cIMObjectPath3, cIMObjectPath2);
                        }
                        if (!bl2) continue;
                        arrayList.add(cIMInstance);
                        continue block2;
                    }
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return arrayList;
    }

    private static class DatabaseManagerHandler {
        private static DatabaseManager instance = new DatabaseManager();

        private DatabaseManagerHandler() {
        }
    }
}

