/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.simulator.cimom.common.base;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import org.eclipse.aperi.simulator.cimom.common.CIMOM;

public abstract class BaseMOFGenerator {
    protected static final String PROVIDER_QUALIFIER_STRING = "Provider";
    protected static final String PROVIDER_NAME_QUALIFIER_STRING = "ProviderName";
    protected static final String SIMULATOR_PROVIDER = "java:org.eclipse.aperi.simulator.cimom.sunwbem.provider.Provider";
    protected static final String ASSOCIATION_QUALIFIER_NAME = "Association";
    protected static final String DATETIME_DATATYPE_STRING = "datetime";
    protected CIMOM cimom;
    private BufferedWriter writer;
    protected boolean isOnlyLeaf = false;

    public BaseMOFGenerator(CIMOM cIMOM) {
        this.cimom = cIMOM;
        this.initialize();
    }

    protected void initialize() {
        String string = this.cimom.getServiceURL();
        String string2 = this.cimom.getUserID();
        String string3 = this.cimom.getPassword();
        String string4 = this.cimom.getNamespace();
        this.createCIMClient(string, string2, string3, string4);
    }

    protected abstract void createCIMClient(String var1, String var2, String var3, String var4);

    public void generateMOFData(String string) throws Exception {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(this.cimom.getNamespace());
        this.generateData(string, arrayList);
    }

    public abstract void generateDataForNameSpace(String var1, String var2) throws Exception;

    protected abstract void generateData(String var1, ArrayList var2) throws Exception;

    public boolean isOnlyLeaf() {
        return this.isOnlyLeaf;
    }

    public void setOnlyLeaf(boolean bl) {
        this.isOnlyLeaf = bl;
    }

    protected String createNewWriter(String string, String string2) throws IOException {
        String string3 = this.getFileName(string);
        this.writer = new BufferedWriter(new FileWriter(string2 + File.separator + string3));
        return string3;
    }

    protected void writeDataToFile(String string) throws IOException {
        this.writer.newLine();
        this.writer.write(string);
        this.writer.newLine();
        this.writer.flush();
    }

    protected void closeFile() throws IOException {
        if (null != this.writer) {
            this.writer.flush();
            this.writer.close();
        }
        this.writer = null;
    }

    private String getFileName(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        String[] stringArray = string.split("/");
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].trim().length() <= 0) continue;
            if (stringBuffer.length() > 0) {
                stringBuffer.append("_");
            }
            stringBuffer.append(stringArray[i]);
        }
        return stringBuffer.toString() + ".mof";
    }
}

