/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.simulator.cimom.common.generator;

import java.io.IOException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import javax.wbem.cim.CIMClass;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMNameSpace;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMProperty;
import javax.wbem.client.CIMClient;
import javax.wbem.client.PasswordCredential;
import javax.wbem.client.UserPrincipal;
import javax.xml.transform.TransformerException;
import org.eclipse.aperi.simulator.cimom.common.CIMOM;
import org.eclipse.aperi.simulator.cimom.common.base.BaseClassXMLBuilder;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class ClassXMLBuilder
extends BaseClassXMLBuilder {
    private CIMClient cimClient;

    public void parse(InputSource inputSource) throws SAXException {
        if (null == this.handler) {
            System.out.println("The handler is null");
            System.exit(1);
        } else if (null == this.cimom) {
            System.out.println("The cimom object is null");
            System.exit(1);
        }
        this.initCimClient();
        this.handler.startDocument();
        this.addIndent(INDENT0);
        this.handler.startElement("", "SAN_Simulator", "SAN_Simulator", null);
        try {
            this.generateForNamespace(this.cimom.getNamespace());
        }
        catch (CIMException cIMException) {
            cIMException.printStackTrace();
        }
        this.addIndent(INDENT0);
        this.handler.endElement("", "SAN_Simulator", "SAN_Simulator");
        this.handler.endDocument();
    }

    private void generateForNamespace(String string) throws CIMException {
        CIMObjectPath cIMObjectPath = new CIMObjectPath();
        Enumeration enumeration = this.cimClient.enumerateClasses(cIMObjectPath, true, false, false, true);
        block2: while (enumeration.hasMoreElements()) {
            CIMClass cIMClass = (CIMClass)enumeration.nextElement();
            String string2 = cIMClass.getName();
            Iterator iterator = this.cimom.getLeafClassNamePrefixes().iterator();
            while (iterator.hasNext()) {
                if (!string2.startsWith((String)iterator.next())) continue;
                try {
                    this.generateForClass(cIMClass, string);
                    continue block2;
                }
                catch (Exception exception) {
                    System.err.println("Error in class : " + string2);
                    exception.printStackTrace();
                }
            }
        }
        this.cimClient.close();
    }

    private void generateForClass(CIMClass cIMClass, String string) throws SAXException, CIMException {
        AttributesImpl attributesImpl = new AttributesImpl();
        attributesImpl.addAttribute("", "Name", "Name", "", cIMClass.getName());
        attributesImpl.addAttribute("", "Namespace", "Namespace", "", string);
        attributesImpl.addAttribute("", "NOI", "NOI", "", "");
        if (this.isAssociation(cIMClass)) {
            attributesImpl.addAttribute("", "Association", "Association", "", "true");
            this.addIndent(INDENT1);
            this.handler.startElement("", "Class", "Class", attributesImpl);
            this.generateAssociationClassData(cIMClass.getName(), string);
        } else {
            this.addIndent(INDENT1);
            this.handler.startElement("", "Class", "Class", attributesImpl);
            this.generateClassData(cIMClass.getName());
        }
        this.addIndent(INDENT1);
        this.handler.endElement("", "Class", "Class");
    }

    private void generateClassData(String string) throws CIMException, SAXException {
        CIMObjectPath cIMObjectPath = new CIMObjectPath(string);
        Enumeration enumeration = this.cimClient.enumerateInstances(cIMObjectPath, true, false, false, true, null);
        System.out.println("Generated data for : " + string);
        if (enumeration.hasMoreElements()) {
            CIMInstance cIMInstance = (CIMInstance)enumeration.nextElement();
            Vector vector = cIMInstance.getProperties();
            Iterator iterator = vector.iterator();
            while (iterator.hasNext()) {
                CIMProperty cIMProperty = (CIMProperty)iterator.next();
                this.generatePropertyData(cIMProperty);
            }
        }
    }

    private void generateAssociationClassData(String string, String string2) throws SAXException, CIMException {
        CIMObjectPath cIMObjectPath = new CIMObjectPath(string);
        Enumeration enumeration = this.cimClient.enumerateInstances(cIMObjectPath, true, false, false, true, null);
        System.out.println("Generated data for : " + string);
        if (enumeration.hasMoreElements()) {
            CIMInstance cIMInstance = (CIMInstance)enumeration.nextElement();
            Vector vector = cIMInstance.getProperties();
            CIMProperty cIMProperty = (CIMProperty)vector.get(0);
            CIMProperty cIMProperty2 = (CIMProperty)vector.get(1);
            AttributesImpl attributesImpl = new AttributesImpl();
            attributesImpl.addAttribute("", "Name", "Name", "", cIMProperty.getName());
            attributesImpl.addAttribute("", "ClassName", "ClassName", "", cIMProperty.getType().getRefClassName());
            attributesImpl.addAttribute("", "Namespace", "Namespace", "", string2);
            if (cIMProperty.isKey()) {
                attributesImpl.addAttribute("", "Key", "Key", "", "true");
            }
            this.addIndent(INDENT2);
            this.handler.startElement("", "Antecedent", "Antecedent", attributesImpl);
            this.addIndent(INDENT2);
            this.handler.endElement("", "Antecedent", "Antecedent");
            attributesImpl.clear();
            attributesImpl.addAttribute("", "Name", "Name", "", cIMProperty2.getName());
            attributesImpl.addAttribute("", "ClassName", "ClassName", "", cIMProperty2.getType().getRefClassName());
            attributesImpl.addAttribute("", "Namespace", "Namespace", "", string2);
            if (cIMProperty2.isKey()) {
                attributesImpl.addAttribute("", "Key", "Key", "", "true");
            }
            this.addIndent(INDENT2);
            this.handler.startElement("", "Dependent", "Dependent", attributesImpl);
            this.addIndent(INDENT2);
            this.handler.endElement("", "Dependent", "Dependent");
            for (int i = 2; i < vector.size(); ++i) {
                CIMProperty cIMProperty3 = (CIMProperty)vector.get(i);
                this.generatePropertyData(cIMProperty3);
            }
        }
    }

    private void generatePropertyData(CIMProperty cIMProperty) throws SAXException {
        AttributesImpl attributesImpl = new AttributesImpl();
        attributesImpl.addAttribute("", "Name", "Name", "", cIMProperty.getName());
        String string = cIMProperty.getType().isArrayType() ? cIMProperty.getType().toString() + "[]" : cIMProperty.getType().toString();
        attributesImpl.addAttribute("", "Type", "Type", "", string);
        attributesImpl.addAttribute("", "Random", "Random", "", "false");
        if (cIMProperty.isKey()) {
            attributesImpl.addAttribute("", "Key", "Key", "", "true");
        }
        this.addIndent(INDENT2);
        this.handler.startElement("", "Property", "Property", attributesImpl);
        if (null != cIMProperty.getValue()) {
            this.addIndent(INDENT3);
            this.handler.startElement("", "Value", "Value", null);
            char[] cArray = cIMProperty.getValue().getValue().toString().toCharArray();
            this.handler.characters(cArray, 0, cArray.length);
            this.addIndent(INDENT3);
            this.handler.endElement("", "Value", "Value");
        }
        this.addIndent(INDENT2);
        this.handler.endElement("", "Property", "Property");
    }

    private boolean isAssociation(CIMClass cIMClass) {
        Iterator iterator = cIMClass.getAllProperties().iterator();
        while (iterator.hasNext()) {
            CIMProperty cIMProperty = (CIMProperty)iterator.next();
            if (!cIMProperty.isReference()) continue;
            return true;
        }
        return false;
    }

    private void initCimClient() {
        try {
            String string = this.cimom.getServiceURL();
            String string2 = this.cimom.getUserID();
            String string3 = this.cimom.getPassword();
            String string4 = this.cimom.getNamespace();
            UserPrincipal userPrincipal = null;
            PasswordCredential passwordCredential = null;
            if (string != null && string4 != null) {
                try {
                    CIMNameSpace cIMNameSpace = new CIMNameSpace(string, string4);
                    if (string2 != null) {
                        userPrincipal = new UserPrincipal(string2);
                    }
                    if (string3 != null) {
                        passwordCredential = new PasswordCredential(string3);
                    }
                    this.cimClient = new CIMClient(cIMNameSpace, (Principal)userPrincipal, (Object)passwordCredential);
                }
                catch (Exception exception) {
                    System.out.println("Unable To Connect to CIMOM [" + string + "]" + exception.getMessage());
                }
            } else {
                System.out.println("Given CIMOM URL AND/OR Namespace is NULL");
            }
            if (this.cimClient == null) {
                System.exit(-1);
            }
        }
        catch (Exception exception) {
            System.out.println("Some error occured while creating cimom object");
            exception.printStackTrace();
        }
    }

    public static void main(String[] stringArray) throws IOException, TransformerException {
        ClassXMLBuilder classXMLBuilder = new ClassXMLBuilder();
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("Brocade");
        CIMOM cIMOM = new CIMOM("9.182.193.140", "administrator", "san26pass", "/interop", "Switch", "Sun Java WBEM CIMOM", arrayList);
        classXMLBuilder.generateXML(cIMOM, "Abc.xml");
    }
}

