/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.simulator.cimom.common.mofparser;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.StringTokenizer;
import org.eclipse.aperi.simulator.cimom.common.mofparser.MOFDefaultHandler;
import org.eclipse.aperi.simulator.cimom.common.mofparser.MOFParseException;

public class MOFParser {
    public static final int STEP_NOTHING = 0;
    public static final int STEP_CLASS = 1;
    public static final int STEP_PROPERTY = 2;
    public static final int STEP_METHOD = 3;
    public static final int STEP_QUALIFIER = 4;
    private static final String BLANK_LINE = "";
    private static final String START_OF_COMMENT = "//";
    private static final String START_OF_CLASS = "class";
    private static final String END_OF_CLASS = "};";
    private static final String START_OF_METHOD = "(";
    private static final String END_OF_METHOD = ");";
    private static final String START_OF_QUALIFIER = "[";
    private static final String END_OF_QUALIFIER = "]";
    private static final String START_OF_CONSTANT = "#CONST";
    private static final String EQUAL_SYMBOL = "=";
    private static final String PROPERTY_DELIM = ",";
    private int currentState;
    private MOFDefaultHandler handler;
    private int previousState;

    public void parse(String string, MOFDefaultHandler mOFDefaultHandler) throws IOException, MOFParseException {
        BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
        this.parse(bufferedReader, mOFDefaultHandler);
    }

    public void parse(BufferedReader bufferedReader, MOFDefaultHandler mOFDefaultHandler) throws IOException, MOFParseException {
        if (null == mOFDefaultHandler) {
            throw new MOFParseException("Default handler is null");
        }
        this.handler = mOFDefaultHandler;
        this.currentState = 0;
        String string = null;
        while (null != (string = bufferedReader.readLine())) {
            System.out.println(string);
            if ((string = string.trim()).equals(BLANK_LINE) || string.startsWith(START_OF_COMMENT)) continue;
            if (string.startsWith(START_OF_CLASS)) {
                this.startClass(string);
                continue;
            }
            if (string.endsWith(END_OF_CLASS)) {
                this.endCurrentClass();
                continue;
            }
            if (string.startsWith(START_OF_CONSTANT)) {
                this.startConstant(string);
                continue;
            }
            if (string.startsWith(START_OF_QUALIFIER)) {
                this.startQualifier(string);
                continue;
            }
            if (string.endsWith(END_OF_QUALIFIER)) {
                this.endQualifier();
                continue;
            }
            if (this.currentState == 1 && string.indexOf(START_OF_METHOD) != -1) {
                this.startMethod(string);
                continue;
            }
            if (string.endsWith(END_OF_METHOD)) {
                this.endMethod();
                continue;
            }
            if (4 == this.currentState) {
                this.qualifier(string);
                continue;
            }
            this.previousState = this.currentState;
            this.currentState = 2;
            this.startProperty(string);
            this.currentState = this.previousState;
        }
    }

    private void startClass(String string) throws MOFParseException {
        if (0 != this.currentState) {
            throw new MOFParseException("Illegal start of class");
        }
        this.currentState = 1;
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        stringTokenizer.nextToken();
        String string2 = stringTokenizer.nextToken();
        String string3 = null;
        String string4 = stringTokenizer.nextToken();
        if (string4.equals(":")) {
            string3 = stringTokenizer.nextToken();
        } else if (string4.equals("{")) {
            // empty if block
        }
        this.handler.startClass(string2, string3);
    }

    private void endCurrentClass() {
        this.handler.endClass();
        this.currentState = 0;
    }

    private void startConstant(String string) throws MOFParseException {
        if (1 != this.currentState) {
            throw new MOFParseException("Illegal constant");
        }
        this.handler.constant(string.substring(string.indexOf(START_OF_CONSTANT) + START_OF_CONSTANT.length()));
    }

    private void startQualifier(String string) {
        this.previousState = this.currentState;
        this.currentState = 4;
        this.qualifier(string.substring(1, string.length()));
        if (string.endsWith(END_OF_QUALIFIER)) {
            this.endQualifier();
        }
    }

    private void qualifier(String string) {
        String string2 = null;
        String string3 = null;
        if (string.indexOf(40) != -1) {
            string3 = string.substring(0, string.indexOf(40));
            string2 = string.substring(string.indexOf(40) + 1, string.lastIndexOf(41));
        } else if (string.indexOf(123) != -1) {
            string3 = string.substring(0, string.indexOf(123));
            string2 = string.substring(string.indexOf(123), string.lastIndexOf(125) + 1);
        }
        System.out.println("Qualifier Data is : " + string2);
        this.handler.qualifier(string3);
    }

    private void endQualifier() {
        this.currentState = this.previousState;
    }

    private void startMethod(String string) throws MOFParseException {
        if (1 != this.currentState) {
            throw new MOFParseException("Illegal method start");
        }
        this.currentState = 3;
        String string2 = string.substring(0, string.indexOf(" "));
        String string3 = string.substring(string2.length(), string.indexOf(40));
        this.handler.startMethod(string3, string2);
        String string4 = string.endsWith(END_OF_METHOD) ? string.substring(string.indexOf(START_OF_METHOD) + 1, string.length() - 2).trim() : string.substring(string.indexOf(START_OF_METHOD) + 1, string.length() - 1).trim();
        while (!string4.equals(BLANK_LINE)) {
            int n;
            if (string4.startsWith(START_OF_QUALIFIER)) {
                n = string4.indexOf(END_OF_QUALIFIER);
                this.startQualifier(string4.substring(1, n + 1));
            } else {
                n = string4.indexOf(PROPERTY_DELIM) != -1 ? string4.indexOf(44) : string4.length();
                this.startProperty(string4.substring(0, n));
            }
            if (n == string4.length()) {
                string4 = BLANK_LINE;
                continue;
            }
            string4 = string4.substring(n + 1).trim();
        }
        if (string.endsWith(END_OF_METHOD)) {
            this.endMethod();
        }
    }

    private void endMethod() {
        this.handler.endMethod();
        this.currentState = 1;
    }

    private void startProperty(String string) {
        String string2;
        String string3 = null;
        String string4 = null;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "; \t\n\r\f");
        if (string.indexOf(" REF ") != -1) {
            string3 = stringTokenizer.nextToken();
            string2 = stringTokenizer.nextToken();
        } else {
            string2 = stringTokenizer.nextToken();
        }
        String string5 = stringTokenizer.nextToken();
        if (string5.indexOf("[]") != -1) {
            string2 = string2 + "[]";
            string5 = string5.substring(0, string5.indexOf(91));
        }
        if (string5.endsWith(PROPERTY_DELIM)) {
            string5 = string5.substring(0, string5.length() - 1);
        }
        if (stringTokenizer.hasMoreTokens() && stringTokenizer.nextToken().equals(EQUAL_SYMBOL)) {
            string4 = stringTokenizer.nextToken();
        }
        boolean bl = true;
        if (3 == this.previousState) {
            bl = false;
        }
        this.handler.property(string5, string2, string3, string4, bl);
    }
}

