/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.simulator.cimom.common.mofparser;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.aperi.simulator.cimom.common.mofparser.MOFDefaultHandler;
import org.eclipse.aperi.simulator.cimom.common.mofparser.MOFParseException;
import org.eclipse.aperi.simulator.cimom.common.mofparser.MOFParser;
import org.eclipse.aperi.simulator.cimom.common.mofparser.SIMClass;
import org.eclipse.aperi.simulator.cimom.common.mofparser.SIMMethod;
import org.eclipse.aperi.simulator.cimom.common.mofparser.SIMProperty;

public class MOFParserImpl
implements MOFDefaultHandler {
    private SIMClass currentSimClass;
    private SIMMethod currentSimMethod;
    private SIMProperty currentSimProperty;
    private Map classMap = new HashMap();
    private List currentQualifiersList = new ArrayList();

    public void startClass(String string, String string2) {
        this.currentSimClass = new SIMClass(string);
        this.currentSimClass.setParentClassName(string2);
        if (this.currentQualifiersList.contains("Association")) {
            this.currentSimClass.setAssociation(true);
        }
        this.currentQualifiersList.clear();
    }

    public void endClass() {
        this.classMap.put(this.currentSimClass.getClassName(), this.currentSimClass);
    }

    public void constant(String string) {
        System.out.println("Constant is :  " + string);
    }

    public void qualifier(String string) {
        this.currentQualifiersList.add(string);
    }

    public void property(String string, String string2, String string3, String string4, boolean bl) {
        this.currentSimProperty = new SIMProperty();
        this.currentSimProperty.setPropertyName(string);
        this.currentSimProperty.setPropertyType(string2);
        this.currentSimProperty.setPropertyRefName(string3);
        this.currentSimProperty.setDefaultValue(string4);
        if (this.currentQualifiersList.contains("Key")) {
            this.currentSimProperty.setKey(true);
        }
        if (bl) {
            this.currentSimClass.addProperty(this.currentSimProperty);
        } else {
            this.currentSimMethod.addProperty(this.currentSimProperty);
        }
        this.currentQualifiersList.clear();
    }

    public void startMethod(String string, String string2) {
        this.currentSimMethod = new SIMMethod(string);
        this.currentSimMethod.setReturnType(string2);
        this.currentQualifiersList.clear();
    }

    public void endMethod() {
        this.currentSimClass.addLocalMethod(this.currentSimMethod);
    }

    public Map parse(String string) throws IOException, MOFParseException {
        MOFParser mOFParser = new MOFParser();
        mOFParser.parse(string, (MOFDefaultHandler)this);
        return this.classMap;
    }

    public static void main(String[] stringArray) throws IOException, MOFParseException {
        System.out.println("Jai Baberi");
        MOFParserImpl mOFParserImpl = new MOFParserImpl();
        Map map = mOFParserImpl.parse("test.mof");
        Set set = map.keySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            System.out.println(map.get(string));
        }
    }
}

