/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.simulator.cimom.sunwbem.init;

import java.io.InputStream;
import java.io.ObjectInputStream;
import java.security.Principal;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import javax.wbem.cim.CIMClass;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMNameSpace;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.client.CIMClient;
import javax.wbem.client.PasswordCredential;
import javax.wbem.client.UserPrincipal;
import org.eclipse.aperi.simulator.cimom.common.CIMOM;

public class CIMOMInitializer {
    private CIMClient cimClient;

    public CIMOMInitializer(CIMOM cIMOM) throws Exception {
        CIMNameSpace cIMNameSpace = new CIMNameSpace(cIMOM.getServiceURL(), cIMOM.getNamespace());
        UserPrincipal userPrincipal = new UserPrincipal(cIMOM.getUserID());
        PasswordCredential passwordCredential = new PasswordCredential(cIMOM.getPassword());
        this.cimClient = new CIMClient(cIMNameSpace, (Principal)userPrincipal, (Object)passwordCredential);
        CIMObjectPath cIMObjectPath = new CIMObjectPath("CIM_RegisteredProfile");
        CIMClass cIMClass = this.cimClient.getClass(cIMObjectPath, false, false, true, null);
        System.out.println("cls = " + cIMClass);
    }

    public void initialize() throws Exception {
        Connection connection = DriverManager.getConnection("jdbc:db2:SIMDB");
        String string = "SELECT DATA.CIM_INST, DATA.ID FROM SIM.CIM_DATA DATA, SIM.CIM_CLASS CLS, SIM.NS_INFO NS WHERE DATA.CIM_CLASS_ID=CLS.ID AND CLS.NS_INFO_ID=NS.ID AND CLS.CLASS_NAME=? AND NS.NAMESPACE=?";
        PreparedStatement preparedStatement = connection.prepareStatement(string);
        preparedStatement.setString(1, "CIM_RegisteredProfile");
        preparedStatement.setString(2, "/interop");
        ResultSet resultSet = preparedStatement.executeQuery();
        while (resultSet.next()) {
            System.out.println("SIMULATOR : From DB DATA ID = " + resultSet.getInt(2));
            InputStream inputStream = resultSet.getBinaryStream(1);
            ObjectInputStream objectInputStream = new ObjectInputStream(inputStream);
            Object object = objectInputStream.readObject();
            CIMInstance cIMInstance = (CIMInstance)object;
            System.out.println("SIMULATOR : Set Instance for = " + cIMInstance.getClassName());
            this.cimClient.createInstance(new CIMObjectPath(cIMInstance.getClassName()), cIMInstance);
        }
        preparedStatement.close();
        connection.close();
        connection = null;
    }

    public static void main(String[] stringArray) {
        try {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add("LSISSI");
            CIMOM cIMOM = new CIMOM("http://9.1.73.43:5988", "x", "x", "/interop", "Array", "Sun Java WBEM CIMOM", arrayList);
            CIMOMInitializer cIMOMInitializer = new CIMOMInitializer(cIMOM);
            cIMOMInitializer.initialize();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    static {
        try {
            Class.forName("COM.ibm.db2.jdbc.app.DB2Driver");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

