/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.simulator.cimom.sunwbem.util;

import java.io.IOException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.wbem.cim.CIMClass;
import javax.wbem.cim.CIMDataType;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMMethod;
import javax.wbem.cim.CIMNameSpace;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMParameter;
import javax.wbem.cim.CIMProperty;
import javax.wbem.cim.CIMQualifier;
import javax.wbem.cim.CIMQualifierType;
import javax.wbem.cim.CIMValue;
import javax.wbem.client.CIMClient;
import javax.wbem.client.PasswordCredential;
import javax.wbem.client.UserPrincipal;
import org.eclipse.aperi.simulator.cimom.common.CIMOM;
import org.eclipse.aperi.simulator.cimom.common.base.BaseMOFGenerator;
import org.eclipse.aperi.simulator.cimom.sunwbem.util.DiscoveryUtil;

public class MOFGenerator
extends BaseMOFGenerator {
    private UserPrincipal principal;
    private PasswordCredential credential;
    private CIMClient cimClient;

    public MOFGenerator(CIMOM cIMOM) {
        super(cIMOM);
    }

    public void generateDataForNameSpace(String string, String string2) throws Exception {
        this.cimClient = null;
        CIMNameSpace cIMNameSpace = new CIMNameSpace(this.cimom.getServiceURL(), string);
        this.cimClient = new CIMClient(cIMNameSpace, (Principal)this.principal, (Object)this.credential);
        CIMObjectPath cIMObjectPath = new CIMObjectPath();
        Enumeration enumeration = this.cimClient.enumerateClasses(cIMObjectPath, true, false, false, true);
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        block0: while (enumeration.hasMoreElements()) {
            CIMClass cIMClass = (CIMClass)enumeration.nextElement();
            String string3 = cIMClass.getName();
            if (arrayList.contains(string3)) continue;
            if (this.isOnlyLeaf) {
                Iterator iterator = this.cimom.getLeafClassNamePrefixes().iterator();
                while (iterator.hasNext()) {
                    if (!string3.startsWith((String)iterator.next())) continue;
                    this.addClassWithReferences(arrayList, cIMClass, arrayList2);
                    continue block0;
                }
                continue;
            }
            this.addClassWithReferences(arrayList, cIMClass, arrayList2);
        }
        this.printData(string, string2, arrayList, arrayList2);
        this.cimClient.close();
        this.cimClient = null;
    }

    private void printData(String string, String string2, List list, List list2) throws IOException {
        String string3 = this.createNewWriter(string, string2);
        System.out.println("File created for namespace : " + string + " is : " + string3);
        this.writeDataToFile("#pragma namespace (\"" + string + "\")");
        this.writeDataToFile("#pragma Locale (\"en-US\")");
        this.printQualifierData(list2);
        CIMObjectPath cIMObjectPath = null;
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            try {
                cIMObjectPath = new CIMObjectPath((String)list.get(i));
                CIMClass cIMClass = this.cimClient.getClass(cIMObjectPath);
                this.doAdditionalChanges(cIMClass);
                this.writeDataToFile("// " + cIMClass.getName());
                this.writeDataToFile(cIMClass.toString());
                continue;
            }
            catch (Exception exception) {
                System.out.println("Error for class " + cIMObjectPath);
                this.writeDataToFile("class " + cIMObjectPath.getObjectName() + " {");
                this.writeDataToFile("};");
                System.out.println(exception.getMessage());
                exception.printStackTrace();
            }
        }
        this.closeFile();
    }

    private void doAdditionalChanges(CIMClass cIMClass) {
        CIMProperty cIMProperty;
        Object object;
        String string = cIMClass.getName();
        Vector vector = cIMClass.getQualifiers();
        Vector<Object> vector2 = new Vector<Object>();
        Iterator iterator = vector.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            object = (CIMQualifier)iterator.next();
            if (object.getName().equalsIgnoreCase("Provider") || object.getName().equalsIgnoreCase("ProviderName")) {
                cIMProperty = this.cimom.getLeafClassNamePrefixes().iterator();
                boolean bl = false;
                while (cIMProperty.hasNext()) {
                    if (!string.startsWith((String)cIMProperty.next())) continue;
                    object.setValue(new CIMValue((Object)"java:org.eclipse.aperi.simulator.cimom.sunwbem.provider.Provider", new CIMDataType(8)));
                    vector2.add(n++, object);
                    bl = true;
                    break;
                }
                if (bl) continue;
                vector2.add(n++, object);
                continue;
            }
            if (object.getName().equalsIgnoreCase("Association")) {
                vector2.add(0, object);
                continue;
            }
            vector2.add(n++, object);
        }
        cIMClass.setQualifiers(vector2);
        object = cIMClass.getAllProperties();
        iterator = ((Vector)object).iterator();
        while (iterator.hasNext()) {
            cIMProperty = (CIMProperty)iterator.next();
            if (cIMProperty.getType().getType() == 12) {
                cIMProperty.setValue(null);
                continue;
            }
            if (!cIMProperty.isReference()) continue;
            cIMProperty.setValue(null);
        }
    }

    private void printQualifierData(List list) {
        Collections.sort(list);
        String string = null;
        StringBuffer stringBuffer = new StringBuffer();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            stringBuffer.setLength(0);
            try {
                string = (String)list.get(i);
                CIMObjectPath cIMObjectPath = new CIMObjectPath(string);
                CIMQualifierType cIMQualifierType = this.cimClient.getQualifierType(cIMObjectPath);
                String string2 = cIMQualifierType.toString();
                if (string2.indexOf(91, string2.indexOf("Scope(")) != -1) {
                    stringBuffer.append(string2.substring(0, string2.indexOf("Scope(") + "Scope(".length()));
                    string2 = string2.substring(string2.indexOf("Scope(") + "Scope(".length() + 1);
                    string2 = string2.replace('[', ' ');
                    string2 = string2.replace(']', ' ');
                    if (string2.indexOf(91, string2.indexOf("Flavor(")) != -1) {
                        stringBuffer.append(string2.substring(0, string2.indexOf("Flavor(") + "Flavor(".length()));
                        string2 = string2.substring(string2.indexOf("Flavor(") + "Flavor(".length() + 1);
                        string2 = string2.replace('[', ' ');
                        string2 = string2.replace(']', ' ');
                    }
                    stringBuffer.append(string2);
                } else {
                    stringBuffer.append(string2);
                }
                this.writeDataToFile("// " + string);
                this.writeDataToFile(stringBuffer.toString());
                continue;
            }
            catch (Exception exception) {
                System.out.println("Error for qualifier " + string);
                System.out.println(exception.getMessage());
            }
        }
    }

    private void addClassWithReferences(List list, CIMClass cIMClass, List list2) throws CIMException {
        String string;
        Object object;
        Vector vector;
        String string2 = cIMClass.getSuperClass();
        if (string2 != null && !string2.trim().equals("") && !list.contains(string2)) {
            vector = new CIMObjectPath(string2);
            this.addClassWithReferences(list, this.cimClient.getClass((CIMObjectPath)vector), list2);
        }
        vector = cIMClass.getAllProperties();
        Iterator iterator = vector.iterator();
        while (iterator.hasNext()) {
            object = (CIMProperty)iterator.next();
            this.addQualifiersToList(list2, object.getQualifiers());
            if (!object.isReference() || list.contains(string = object.getType().getRefClassName())) continue;
            try {
                this.addClassWithReferences(list, this.cimClient.getClass(new CIMObjectPath(string)), list2);
            }
            catch (Exception exception) {
                list.add(cIMClass.getName());
            }
        }
        this.addClassQualifier(cIMClass, list2);
        if (this.isOnlyLeaf) {
            object = this.cimom.getLeafClassNamePrefixes().iterator();
            string = cIMClass.getName();
            while (object.hasNext()) {
                if (!string.startsWith((String)object.next())) continue;
                list.add(string);
                break;
            }
        } else {
            list.add(cIMClass.getName());
        }
    }

    private void addClassQualifier(CIMClass cIMClass, List list) {
        this.addQualifiersToList(list, cIMClass.getQualifiers());
        Vector vector = cIMClass.getAllMethods();
        Iterator iterator = vector.iterator();
        while (iterator.hasNext()) {
            CIMMethod cIMMethod = (CIMMethod)iterator.next();
            this.addMethodQualifier(cIMMethod, list);
        }
    }

    private void addMethodQualifier(CIMMethod cIMMethod, List list) {
        this.addQualifiersToList(list, cIMMethod.getQualifiers());
        Vector vector = cIMMethod.getParameters();
        Iterator iterator = vector.iterator();
        while (iterator.hasNext()) {
            CIMParameter cIMParameter = (CIMParameter)iterator.next();
            this.addQualifiersToList(list, cIMParameter.getQualifiers());
        }
    }

    private void addQualifiersToList(List list, Vector vector) {
        Iterator iterator = vector.iterator();
        while (iterator.hasNext()) {
            CIMQualifier cIMQualifier = (CIMQualifier)iterator.next();
            if (list.contains(cIMQualifier.getName())) continue;
            list.add(cIMQualifier.getName());
        }
    }

    protected void createCIMClient(String string, String string2, String string3, String string4) {
        try {
            if (string != null && string4 != null) {
                CIMNameSpace cIMNameSpace = new CIMNameSpace(string, string4);
                if (string2 != null) {
                    this.principal = new UserPrincipal(string2);
                }
                if (string3 != null) {
                    this.credential = new PasswordCredential(string3);
                }
                this.cimClient = new CIMClient(cIMNameSpace, (Principal)this.principal, (Object)this.credential);
            } else {
                System.err.println("Given CIMOM URL AND/OR Namespace is NULL");
            }
        }
        catch (CIMException cIMException) {
            cIMException.printStackTrace();
        }
    }

    protected void generateData(String string, ArrayList arrayList) throws Exception {
        DiscoveryUtil.getNamespaces(this.cimClient, arrayList, this.cimom.getCimomType());
        for (int i = 0; i < arrayList.size(); ++i) {
            this.generateDataForNameSpace((String)arrayList.get(i), string);
        }
        if (this.cimClient != null) {
            try {
                this.cimClient.close();
            }
            catch (CIMException cIMException) {
                cIMException.printStackTrace();
            }
        }
        this.cimClient = null;
    }
}

