/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.simulator.cimom.common.base;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import org.eclipse.aperi.simulator.cimom.common.CIMOM;

public abstract class BaseMOFGenerator {
    protected static final String PROVIDER_QUALIFIER_STRING = "Provider";
    protected static final String PROVIDER_NAME_QUALIFIER_STRING = "ProviderName";
    protected static final String SIMULATOR_PROVIDER = "java:org.eclipse.aperi.simulator.cimom.sunwbem.provider.Provider";
    protected static final String ASSOCIATION_QUALIFIER_NAME = "Association";
    protected static final String DATETIME_DATATYPE_STRING = "datetime";
    protected CIMOM cimom;
    private BufferedWriter writer;
    protected boolean isOnlyLeaf = false;

    public BaseMOFGenerator(CIMOM cimom) {
        this.cimom = cimom;
        this.initialize();
    }

    protected void initialize() {
        String url = this.cimom.getServiceURL();
        String user = this.cimom.getUserID();
        String password = this.cimom.getPassword();
        String namespace = this.cimom.getNamespace();
        this.createCIMClient(url, user, password, namespace);
    }

    protected abstract void createCIMClient(String var1, String var2, String var3, String var4);

    public void generateMOFData(String filePath) throws Exception {
        ArrayList<String> namespaces = new ArrayList<String>();
        namespaces.add(this.cimom.getNamespace());
        this.generateData(filePath, namespaces);
    }

    public abstract void generateDataForNameSpace(String var1, String var2) throws Exception;

    protected abstract void generateData(String var1, ArrayList var2) throws Exception;

    public boolean isOnlyLeaf() {
        return this.isOnlyLeaf;
    }

    public void setOnlyLeaf(boolean isOnlyLeaf) {
        this.isOnlyLeaf = isOnlyLeaf;
    }

    protected String createNewWriter(String namespace, String filePath) throws IOException {
        String fileName = this.getFileName(namespace);
        this.writer = new BufferedWriter(new FileWriter(String.valueOf(filePath) + File.separator + fileName));
        return fileName;
    }

    protected void writeDataToFile(String data) throws IOException {
        this.writer.newLine();
        this.writer.write(data);
        this.writer.newLine();
        this.writer.flush();
    }

    protected void closeFile() throws IOException {
        if (this.writer != null) {
            this.writer.flush();
            this.writer.close();
        }
        this.writer = null;
    }

    private String getFileName(String namespace) {
        StringBuffer fileName = new StringBuffer();
        String[] array = namespace.split("/");
        int i = 0;
        while (i < array.length) {
            if (array[i].trim().length() > 0) {
                if (fileName.length() > 0) {
                    fileName.append("_");
                }
                fileName.append(array[i]);
            }
            ++i;
        }
        return String.valueOf(fileName.toString()) + ".mof";
    }
}

