/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.simulator.cimom.common.mofparser;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.StringTokenizer;
import org.eclipse.aperi.simulator.cimom.common.mofparser.MOFDefaultHandler;
import org.eclipse.aperi.simulator.cimom.common.mofparser.MOFParseException;

public class MOFParser {
    public static final int STEP_NOTHING = 0;
    public static final int STEP_CLASS = 1;
    public static final int STEP_PROPERTY = 2;
    public static final int STEP_METHOD = 3;
    public static final int STEP_QUALIFIER = 4;
    private static final String BLANK_LINE = "";
    private static final String START_OF_COMMENT = "//";
    private static final String START_OF_CLASS = "class";
    private static final String END_OF_CLASS = "};";
    private static final String START_OF_METHOD = "(";
    private static final String END_OF_METHOD = ");";
    private static final String START_OF_QUALIFIER = "[";
    private static final String END_OF_QUALIFIER = "]";
    private static final String START_OF_CONSTANT = "#CONST";
    private static final String EQUAL_SYMBOL = "=";
    private static final String PROPERTY_DELIM = ",";
    private int currentState;
    private MOFDefaultHandler handler;
    private int previousState;

    public void parse(String fileName, MOFDefaultHandler defaultHandler) throws IOException, MOFParseException {
        BufferedReader reader = new BufferedReader(new FileReader(fileName));
        this.parse(reader, defaultHandler);
    }

    public void parse(BufferedReader reader, MOFDefaultHandler defaultHandler) throws IOException, MOFParseException {
        if (defaultHandler == null) {
            throw new MOFParseException("Default handler is null");
        }
        this.handler = defaultHandler;
        this.currentState = 0;
        String data = null;
        while ((data = reader.readLine()) != null) {
            System.out.println(data);
            data = data.trim();
            if (data.equals(BLANK_LINE) || data.startsWith(START_OF_COMMENT)) continue;
            if (data.startsWith(START_OF_CLASS)) {
                this.startClass(data);
                continue;
            }
            if (data.endsWith(END_OF_CLASS)) {
                this.endCurrentClass();
                continue;
            }
            if (data.startsWith(START_OF_CONSTANT)) {
                this.startConstant(data);
                continue;
            }
            if (data.startsWith(START_OF_QUALIFIER)) {
                this.startQualifier(data);
                continue;
            }
            if (data.endsWith(END_OF_QUALIFIER)) {
                this.endQualifier();
                continue;
            }
            if (this.currentState == 1 && data.indexOf(START_OF_METHOD) != -1) {
                this.startMethod(data);
                continue;
            }
            if (data.endsWith(END_OF_METHOD)) {
                this.endMethod();
                continue;
            }
            if (4 == this.currentState) {
                this.qualifier(data);
                continue;
            }
            this.previousState = this.currentState;
            this.currentState = 2;
            this.startProperty(data);
            this.currentState = this.previousState;
        }
    }

    private void startClass(String data) throws MOFParseException {
        if (this.currentState != 0) {
            throw new MOFParseException("Illegal start of class");
        }
        this.currentState = 1;
        StringTokenizer st = new StringTokenizer(data);
        st.nextToken();
        String className = st.nextToken();
        String parentName = null;
        String token = st.nextToken();
        if (token.equals(":")) {
            parentName = st.nextToken();
        } else {
            token.equals("{");
        }
        this.handler.startClass(className, parentName);
    }

    private void endCurrentClass() {
        this.handler.endClass();
        this.currentState = 0;
    }

    private void startConstant(String data) throws MOFParseException {
        if (1 != this.currentState) {
            throw new MOFParseException("Illegal constant");
        }
        this.handler.constant(data.substring(data.indexOf(START_OF_CONSTANT) + START_OF_CONSTANT.length()));
    }

    private void startQualifier(String data) {
        this.previousState = this.currentState;
        this.currentState = 4;
        this.qualifier(data.substring(1, data.length()));
        if (data.endsWith(END_OF_QUALIFIER)) {
            this.endQualifier();
        }
    }

    private void qualifier(String data) {
        String qualifierData = null;
        String qualifierName = null;
        if (data.indexOf(40) != -1) {
            qualifierName = data.substring(0, data.indexOf(40));
            qualifierData = data.substring(data.indexOf(40) + 1, data.lastIndexOf(41));
        } else if (data.indexOf(123) != -1) {
            qualifierName = data.substring(0, data.indexOf(123));
            qualifierData = data.substring(data.indexOf(123), data.lastIndexOf(125) + 1);
        }
        System.out.println("Qualifier Data is : " + qualifierData);
        this.handler.qualifier(qualifierName);
    }

    private void endQualifier() {
        this.currentState = this.previousState;
    }

    private void startMethod(String data) throws MOFParseException {
        if (1 != this.currentState) {
            throw new MOFParseException("Illegal method start");
        }
        this.currentState = 3;
        String methodType = data.substring(0, data.indexOf(" "));
        String methodName = data.substring(methodType.length(), data.indexOf(40));
        this.handler.startMethod(methodName, methodType);
        String propertiesData = data.endsWith(END_OF_METHOD) ? data.substring(data.indexOf(START_OF_METHOD) + 1, data.length() - 2).trim() : data.substring(data.indexOf(START_OF_METHOD) + 1, data.length() - 1).trim();
        while (!propertiesData.equals(BLANK_LINE)) {
            int endIndex;
            if (propertiesData.startsWith(START_OF_QUALIFIER)) {
                endIndex = propertiesData.indexOf(END_OF_QUALIFIER);
                this.startQualifier(propertiesData.substring(1, endIndex + 1));
            } else {
                endIndex = propertiesData.indexOf(PROPERTY_DELIM) != -1 ? propertiesData.indexOf(44) : propertiesData.length();
                this.startProperty(propertiesData.substring(0, endIndex));
            }
            propertiesData = endIndex == propertiesData.length() ? BLANK_LINE : propertiesData.substring(endIndex + 1).trim();
        }
        if (data.endsWith(END_OF_METHOD)) {
            this.endMethod();
        }
    }

    private void endMethod() {
        this.handler.endMethod();
        this.currentState = 1;
    }

    private void startProperty(String data) {
        String propertyType;
        String propertyRefName = null;
        String defaultValue = null;
        StringTokenizer st = new StringTokenizer(data, "; \t\n\r\f");
        if (data.indexOf(" REF ") != -1) {
            propertyRefName = st.nextToken();
            propertyType = st.nextToken();
        } else {
            propertyType = st.nextToken();
        }
        String propertyName = st.nextToken();
        if (propertyName.indexOf("[]") != -1) {
            propertyType = String.valueOf(propertyType) + "[]";
            propertyName = propertyName.substring(0, propertyName.indexOf(91));
        }
        if (propertyName.endsWith(PROPERTY_DELIM)) {
            propertyName = propertyName.substring(0, propertyName.length() - 1);
        }
        if (st.hasMoreTokens() && st.nextToken().equals(EQUAL_SYMBOL)) {
            defaultValue = st.nextToken();
        }
        boolean isClassProperty = true;
        if (3 == this.previousState) {
            isClassProperty = false;
        }
        this.handler.property(propertyName, propertyType, propertyRefName, defaultValue, isClassProperty);
    }
}

