/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.simulator.cimom.common.mofparser;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.aperi.simulator.cimom.common.mofparser.MOFDefaultHandler;
import org.eclipse.aperi.simulator.cimom.common.mofparser.MOFParseException;
import org.eclipse.aperi.simulator.cimom.common.mofparser.MOFParser;
import org.eclipse.aperi.simulator.cimom.common.mofparser.SIMClass;
import org.eclipse.aperi.simulator.cimom.common.mofparser.SIMMethod;
import org.eclipse.aperi.simulator.cimom.common.mofparser.SIMProperty;

public class MOFParserImpl
implements MOFDefaultHandler {
    private SIMClass currentSimClass;
    private SIMMethod currentSimMethod;
    private SIMProperty currentSimProperty;
    private Map classMap = new HashMap();
    private List currentQualifiersList = new ArrayList();

    public void startClass(String className, String parentName) {
        this.currentSimClass = new SIMClass(className);
        this.currentSimClass.setParentClassName(parentName);
        if (this.currentQualifiersList.contains("Association")) {
            this.currentSimClass.setAssociation(true);
        }
        this.currentQualifiersList.clear();
    }

    public void endClass() {
        this.classMap.put(this.currentSimClass.getClassName(), this.currentSimClass);
    }

    public void constant(String constant) {
        System.out.println("Constant is :  " + constant);
    }

    public void qualifier(String data) {
        this.currentQualifiersList.add(data);
    }

    public void property(String propertyName, String propertyType, String propertyRefName, String defaultValue, boolean isClassProperty) {
        this.currentSimProperty = new SIMProperty();
        this.currentSimProperty.setPropertyName(propertyName);
        this.currentSimProperty.setPropertyType(propertyType);
        this.currentSimProperty.setPropertyRefName(propertyRefName);
        this.currentSimProperty.setDefaultValue(defaultValue);
        if (this.currentQualifiersList.contains("Key")) {
            this.currentSimProperty.setKey(true);
        }
        if (isClassProperty) {
            this.currentSimClass.addProperty(this.currentSimProperty);
        } else {
            this.currentSimMethod.addProperty(this.currentSimProperty);
        }
        this.currentQualifiersList.clear();
    }

    public void startMethod(String methodName, String returnType) {
        this.currentSimMethod = new SIMMethod(methodName);
        this.currentSimMethod.setReturnType(returnType);
        this.currentQualifiersList.clear();
    }

    public void endMethod() {
        this.currentSimClass.addLocalMethod(this.currentSimMethod);
    }

    public Map parse(String fileName) throws IOException, MOFParseException {
        MOFParser parse = new MOFParser();
        parse.parse(fileName, (MOFDefaultHandler)this);
        return this.classMap;
    }

    public static void main(String[] args) throws IOException, MOFParseException {
        System.out.println("Jai Baberi");
        MOFParserImpl test = new MOFParserImpl();
        Map classMap = test.parse("test.mof");
        Set keySet = classMap.keySet();
        Iterator iter = keySet.iterator();
        while (iter.hasNext()) {
            String className = (String)iter.next();
            System.out.println(classMap.get(className));
        }
    }
}

