/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.simulator.cimom.connection;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMValue;
import org.eclipse.aperi.simulator.cimom.common.DatabaseManager;
import org.eclipse.aperi.simulator.cimom.connection.ConnectionConfig;
import org.eclipse.aperi.simulator.cimom.connection.SwitchConnection;

public class SwitchDBClient
implements SwitchConnection {
    public void configSwitchDB() {
        Properties properties = new Properties();
        properties.setProperty("DATABASE", "db2");
        properties.setProperty("DB_NAME", ConnectionConfig.getProperty("SWITCH_DB_NAME"));
        properties.setProperty("DB_LOCATION", ConnectionConfig.getProperty("SWITCH_DB_URL"));
        properties.setProperty("DB_USERNAME", ConnectionConfig.getProperty("SWITCH_DB_USERNAME"));
        properties.setProperty("DB_PASSWORD", ConnectionConfig.getProperty("SWITCH_DB_PASSWORD"));
        try {
            File temp = File.createTempFile("setupwizard", ".config");
            temp.deleteOnExit();
            properties.store(new FileOutputStream(temp), "SETUP WIZARD PROPERTIES");
            System.setProperty("SETUP_WIZARD_CONFIG_FILEPATH", temp.getAbsolutePath());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void init() {
        this.configSwitchDB();
    }

    public CIMValue getPortWWN(int srcPort, String systemName) throws Exception {
        CIMInstance instance = null;
        boolean flag = false;
        List classList = DatabaseManager.getDbManager().enumerateInstances("/root/brocade1", "Brocade_SwitchFCPort");
        Iterator iter = classList.iterator();
        while (iter.hasNext()) {
            CIMValue portNo;
            instance = (CIMInstance)iter.next();
            CIMValue systemname = instance.getProperty("ElementName").getValue();
            if (!systemname.getValue().equals(systemName) || Integer.parseInt((portNo = instance.getProperty("PortNumber").getValue()).toString()) != srcPort) continue;
            flag = true;
            break;
        }
        if (flag) {
            CIMValue PortWWN = instance.getProperty("DeviceID").getValue();
            return PortWWN;
        }
        return null;
    }

    public CIMInstance getInstance(String className, String propName, CIMValue propValue) throws Exception {
        CIMInstance resultInst = null;
        List classList = DatabaseManager.getDbManager().enumerateInstances("/root/brocade1", className);
        Iterator iterator = classList.iterator();
        while (iterator.hasNext()) {
            resultInst = (CIMInstance)iterator.next();
            CIMValue resValue = resultInst.getProperty(propName).getValue();
            if (resValue.equals((Object)propValue)) break;
        }
        return resultInst;
    }

    public CIMValue getFabricId(String switchName) throws Exception {
        List switchList = DatabaseManager.getDbManager().enumerateInstances("/root/brocade1", "Brocade_Switch");
        Iterator iterator = switchList.iterator();
        CIMValue fabricId = null;
        while (iterator.hasNext()) {
            CIMInstance switchInst = (CIMInstance)iterator.next();
            if (!switchInst.getProperty("ElementName").getValue().getValue().equals(switchName)) continue;
            fabricId = switchInst.getProperty("Name").getValue();
            break;
        }
        return fabricId;
    }
}

