/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.simulator.cimom.sunwbem.init;

import java.io.InputStream;
import java.io.ObjectInputStream;
import java.security.Principal;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import javax.wbem.cim.CIMClass;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMNameSpace;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.client.CIMClient;
import javax.wbem.client.PasswordCredential;
import javax.wbem.client.UserPrincipal;
import org.eclipse.aperi.simulator.SimulatorConfig;
import org.eclipse.aperi.simulator.cimom.common.CIMOM;

public class CIMOMInitializer {
    private CIMClient cimClient;

    static {
        try {
            Class.forName(SimulatorConfig.dbDriverName);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public CIMOMInitializer(CIMOM cimom) throws Exception {
        CIMNameSpace cimNS = new CIMNameSpace(cimom.getServiceURL(), cimom.getNamespace());
        UserPrincipal principal = new UserPrincipal(cimom.getUserID());
        PasswordCredential credential = new PasswordCredential(cimom.getPassword());
        this.cimClient = new CIMClient(cimNS, (Principal)principal, (Object)credential);
        CIMObjectPath cimOP = new CIMObjectPath("CIM_RegisteredProfile");
        CIMClass cc = this.cimClient.getClass(cimOP, false, false, true, null);
        System.out.println("cls = " + cc);
    }

    public void initialize() throws Exception {
        Connection con = DriverManager.getConnection(SimulatorConfig.dbUrl);
        String query = "SELECT DATA.CIM_INST, DATA.ID FROM SIM.CIM_DATA DATA, SIM.CIM_CLASS CLS, SIM.NS_INFO NS WHERE DATA.CIM_CLASS_ID=CLS.ID AND CLS.NS_INFO_ID=NS.ID AND CLS.CLASS_NAME=? AND NS.NAMESPACE=?";
        PreparedStatement ps = con.prepareStatement(query);
        ps.setString(1, "CIM_RegisteredProfile");
        ps.setString(2, "/interop");
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            System.out.println("SIMULATOR : From DB DATA ID = " + rs.getInt(2));
            InputStream is = rs.getBinaryStream(1);
            ObjectInputStream ois = new ObjectInputStream(is);
            Object rawObj = ois.readObject();
            CIMInstance instance = (CIMInstance)rawObj;
            System.out.println("SIMULATOR : Set Instance for = " + instance.getClassName());
            this.cimClient.createInstance(new CIMObjectPath(instance.getClassName()), instance);
        }
        ps.close();
        con.close();
        con = null;
    }

    public static void main(String[] argv) {
        try {
            ArrayList<String> leafClassPrefix = new ArrayList<String>();
            leafClassPrefix.add("LSISSI");
            CIMOM cimom = new CIMOM("http://9.1.73.43:5988", "x", "x", "/interop", "Array", "Sun Java WBEM CIMOM", leafClassPrefix);
            CIMOMInitializer initializer = new CIMOMInitializer(cimom);
            initializer.initialize();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

