/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.simulator.cimom.sunwbem.provider.methods;

import java.util.Iterator;
import java.util.List;
import javax.wbem.cim.CIMArgument;
import javax.wbem.cim.CIMDataType;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMValue;
import org.eclipse.aperi.simulator.cimom.common.DatabaseManager;
import org.eclipse.aperi.simulator.cimom.common.generator.ClassXMLParser;
import org.eclipse.aperi.simulator.cimom.common.generator.InstanceCreator;
import org.eclipse.aperi.simulator.cimom.common.generator.ParserRespose;
import org.eclipse.aperi.simulator.cimom.common.generator.SimAssociationClass;
import org.eclipse.aperi.simulator.cimom.common.generator.SimClass;

public class StoragePoolMethods {
    private static final String NAMESPACE_ROOT_LSISSI = "/root/lsissi11";
    private static final String NAMESPACE_ROOT_IBM = "/root/ibm";
    private static final String DS4K_XML_FILE_PATH = "XML\\Storage\\IBM\\DS4K\\DS4K_LSISSI_11.xml";
    private static final String DS6K_XML_FILE_PATH = "XML\\Storage\\IBM\\DS6K\\DS6K_Root_IBM.xml";
    private static final String CLASS_LSISSI_STORAGE_SYSTEM = "LSISSI_StorageSystem";
    private static final String CLASS_LSISSI_ALLOCATED_FROM_STORAGE_POOL = "LSISSI_AllocatedFromStoragePool";
    private static final String CLASS_LSISSI_STORAGE_VOLUME = "LSISSI_StorageVolume";
    private static final String CLASS_LSISSI_STORAGE_POOL = "LSISSI_StoragePool";
    private static final String CLASS_LSISSI_STORAGE_SYSTEM_DEVICE = "LSISSI_StorageSystemDevice";
    private static final String CLASS_IBMTSESS_STORAGE_SYSTEM = "IBMTSESS_StorageSystem";
    private static final String CLASS_IBMTSESS_ALLOCATED_FROM_STORAGE_POOL = "IBMTSESS_AllocatedFromStoragePool";
    private static final String CLASS_IBMTSESS_STORAGE_VOLUME = "IBMTSESS_Volume";
    private static final String CLASS_IBMTSESS_STORAGE_POOL = "IBMTSESS_VolumeSpace";

    public void createModifyElement(CIMObjectPath storageConfigurationServiceOP, CIMArgument[] inArray) throws Exception {
        DatabaseManager dbManager = DatabaseManager.getDbManager();
        List storageSystemsOPs = dbManager.enumerateInstanceNames(NAMESPACE_ROOT_LSISSI, CLASS_LSISSI_STORAGE_SYSTEM);
        Iterator iter = storageSystemsOPs.iterator();
        String requiredSystemID = (String)storageConfigurationServiceOP.getKey("SystemName").getValue().getValue();
        CIMObjectPath storageSystemOP = null;
        while (iter.hasNext()) {
            CIMObjectPath op = (CIMObjectPath)iter.next();
            String systemName = (String)op.getKey("Name").getValue().getValue();
            if (!systemName.equalsIgnoreCase(requiredSystemID)) continue;
            storageSystemOP = op;
            break;
        }
        CIMObjectPath storagePoolOP = (CIMObjectPath)inArray[4].getValue().getValue();
        if (storageSystemOP != null) {
            ClassXMLParser parser = new ClassXMLParser();
            ParserRespose response = parser.parse(DS4K_XML_FILE_PATH);
            InstanceCreator instanceCreator = new InstanceCreator(NAMESPACE_ROOT_LSISSI);
            SimClass simClass = (SimClass)response.getClassMap().get(CLASS_LSISSI_STORAGE_VOLUME);
            CIMInstance volumeInst = instanceCreator.createDefaultInstance(simClass);
            volumeInst.setProperty("ElementName", inArray[0].getValue());
            volumeInst.setProperty("DeviceID", volumeInst.getProperty("Name").getValue());
            volumeInst.setProperty("SystemName", new CIMValue((Object)requiredSystemID));
            volumeInst.getObjectPath().getKey("DeviceID").setValue(volumeInst.getProperty("DeviceID").getValue());
            volumeInst.getObjectPath().getKey("SystemName").setValue(volumeInst.getProperty("SystemName").getValue());
            System.out.println("Volume Instance: " + volumeInst.toString());
            System.out.println("Volume instance object path: " + volumeInst.getObjectPath());
            simClass = (SimClass)response.getClassMap().get(CLASS_LSISSI_STORAGE_SYSTEM_DEVICE);
            ((SimAssociationClass)simClass).setAntecedentClassName(CLASS_LSISSI_STORAGE_SYSTEM);
            ((SimAssociationClass)simClass).setDependentClassName(CLASS_LSISSI_STORAGE_VOLUME);
            CIMInstance associationInstance = instanceCreator.createAssociationInstance(simClass, storageSystemOP, volumeInst.getObjectPath());
            System.out.println("Association Instance: " + associationInstance.toString());
            System.out.println("Association Instance object path: " + associationInstance.getObjectPath());
            simClass = (SimClass)response.getClassMap().get(CLASS_LSISSI_ALLOCATED_FROM_STORAGE_POOL);
            ((SimAssociationClass)simClass).setAntecedentClassName(CLASS_LSISSI_STORAGE_POOL);
            ((SimAssociationClass)simClass).setDependentClassName(CLASS_LSISSI_STORAGE_VOLUME);
            CIMInstance allocatedInstance = instanceCreator.createAssociationInstance(simClass, storagePoolOP, volumeInst.getObjectPath());
            System.out.println("Allocated Instance: " + allocatedInstance.toString());
            System.out.println("Allocated Instance object path: " + allocatedInstance.getObjectPath());
            dbManager.createInstance(volumeInst);
            dbManager.createInstance(associationInstance);
            dbManager.createInstance(allocatedInstance);
        }
    }

    public void createModifyDS6KElement(CIMObjectPath storageConfigurationServiceOP, CIMArgument[] inArray) throws Exception {
        DatabaseManager dbManager = DatabaseManager.getDbManager();
        List storageSystemsOPs = dbManager.enumerateInstanceNames(NAMESPACE_ROOT_IBM, CLASS_IBMTSESS_STORAGE_SYSTEM);
        Iterator iter = storageSystemsOPs.iterator();
        String requiredSystemID = (String)storageConfigurationServiceOP.getKey("SystemName").getValue().getValue();
        CIMObjectPath storageSystemOP = null;
        while (iter.hasNext()) {
            CIMObjectPath op = (CIMObjectPath)iter.next();
            String systemName = (String)op.getKey("Name").getValue().getValue();
            if (!systemName.equalsIgnoreCase(requiredSystemID)) continue;
            storageSystemOP = op;
            break;
        }
        CIMObjectPath storagePoolOP = (CIMObjectPath)inArray[4].getValue().getValue();
        if (storageSystemOP != null) {
            ClassXMLParser parser = new ClassXMLParser();
            ParserRespose response = parser.parse(DS6K_XML_FILE_PATH);
            InstanceCreator instanceCreator = new InstanceCreator(NAMESPACE_ROOT_IBM);
            SimClass simClass = (SimClass)response.getClassMap().get(CLASS_IBMTSESS_STORAGE_VOLUME);
            CIMInstance volumeInst = instanceCreator.createDefaultInstance(simClass);
            System.out.println("Name of new volume is : " + inArray[0].getValue().getValue());
            volumeInst.setProperty("ElementName", inArray[0].getValue());
            volumeInst.setProperty("Name", new CIMValue((Object)("0000000000000000000000000000" + volumeInst.getProperty("DeviceID").getValue().getValue()), CIMDataType.getPredefinedType((int)8)));
            volumeInst.setProperty("SystemName", new CIMValue((Object)requiredSystemID));
            volumeInst.getObjectPath().getKey("DeviceID").setValue(volumeInst.getProperty("DeviceID").getValue());
            volumeInst.getObjectPath().getKey("SystemName").setValue(volumeInst.getProperty("SystemName").getValue());
            System.out.println("Volume Instance: " + volumeInst.toString());
            System.out.println("Volume instance object path: " + volumeInst.getObjectPath());
            simClass = (SimClass)response.getClassMap().get(CLASS_IBMTSESS_ALLOCATED_FROM_STORAGE_POOL);
            ((SimAssociationClass)simClass).setAntecedentClassName(CLASS_IBMTSESS_STORAGE_POOL);
            ((SimAssociationClass)simClass).setDependentClassName(CLASS_IBMTSESS_STORAGE_VOLUME);
            CIMInstance allocatedInstance = instanceCreator.createAssociationInstance(simClass, storagePoolOP, volumeInst.getObjectPath());
            System.out.println("Allocated Instance: " + allocatedInstance.toString());
            System.out.println("Allocated Instance object path: " + allocatedInstance.getObjectPath());
            dbManager.createInstance(volumeInst);
            dbManager.createInstance(allocatedInstance);
        }
    }
}

