/*
 * Decompiled with CFR 0.152.
 */
package javax.wbem.cimxml;

import java.io.ByteArrayInputStream;
import java.math.BigInteger;
import java.util.Enumeration;
import java.util.Vector;
import javax.wbem.cim.CIMClass;
import javax.wbem.cim.CIMDataType;
import javax.wbem.cim.CIMDateTime;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMFlavor;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMMethod;
import javax.wbem.cim.CIMObject;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMParameter;
import javax.wbem.cim.CIMProperty;
import javax.wbem.cim.CIMQualifier;
import javax.wbem.cim.CIMQualifierType;
import javax.wbem.cim.CIMScope;
import javax.wbem.cim.CIMValue;
import javax.wbem.cim.UnsignedInt16;
import javax.wbem.cim.UnsignedInt32;
import javax.wbem.cim.UnsignedInt64;
import javax.wbem.cim.UnsignedInt8;
import javax.wbem.cimxml.NodeTreeWalker;
import javax.wbem.client.Debug;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

class XMLParser {
    XMLParser() {
    }

    static CIMClass getCIMClass(Node node, CIMObjectPath op) {
        CIMClass cc = XMLParser.getCIMClass(node);
        if (op != null) {
            cc.setObjectPath(op);
        }
        return cc;
    }

    static CIMClass getCIMClass(Node node) {
        CIMClass cc = new CIMClass();
        Vector<CIMQualifier> q = new Vector<CIMQualifier>();
        Vector<CIMProperty> p = new Vector<CIMProperty>();
        Vector<CIMMethod> m = new Vector<CIMMethod>();
        NodeTreeWalker walker = new NodeTreeWalker(node);
        node = walker.getCurrentNode();
        while (node != null) {
            String nodename = node.getNodeName();
            if (nodename.equals("CLASS")) {
                NamedNodeMap attrs = node.getAttributes();
                for (int i = 0; i < attrs.getLength(); ++i) {
                    Node item = attrs.item(i);
                    String itemname = item.getNodeName();
                    if (itemname.equals("NAME")) {
                        cc.setName(item.getNodeValue());
                        continue;
                    }
                    if (!itemname.equals("SUPERCLASS")) continue;
                    cc.setSuperClass(item.getNodeValue());
                }
                node = walker.nextNode();
                continue;
            }
            if (nodename.equals("QUALIFIER")) {
                if (node.getParentNode().getNodeName().equals("CLASS")) {
                    CIMQualifier cq = XMLParser.getCIMQualifier(node);
                    q.addElement(cq);
                    if (cq.getName().equalsIgnoreCase("ASSOCIATION")) {
                        cc.setIsAssociation(true);
                    } else if (cq.getName().equalsIgnoreCase("INDICATION")) {
                        cc.setIsAssociation(true);
                    }
                }
                node = node.getNextSibling();
                continue;
            }
            if (nodename.startsWith("PROPERTY")) {
                CIMProperty prop = XMLParser.getCIMProperty(node);
                p.addElement(prop);
                if (prop.isKey()) {
                    cc.setIsKeyed(true);
                }
                node = node.getNextSibling();
                continue;
            }
            if (nodename.equals("METHOD")) {
                m.addElement(XMLParser.getCIMMethod(node));
                node = node.getNextSibling();
                continue;
            }
            node = node.getNextSibling();
        }
        if (m.size() > 0) {
            cc.setMethods(m);
        }
        if (q.size() > 0) {
            cc.setQualifiers(q);
        }
        if (p.size() > 0) {
            cc.setProperties(p);
        }
        return cc;
    }

    static CIMInstance getCIMInstance(Node node, CIMObjectPath path) {
        Vector keys = new Vector();
        CIMInstance ci = new CIMInstance();
        Vector<CIMQualifier> q = new Vector<CIMQualifier>();
        Vector<CIMProperty> p = new Vector<CIMProperty>();
        NodeTreeWalker walker = new NodeTreeWalker(node);
        if ((node = walker.getCurrentNode()).getNodeName().equals("VALUE.NAMEDINSTANCE") || node.getNodeName().equals("VALUE.OBJECTWITHPATH")) {
            keys = XMLParser.getCIMObjectPath(node).getKeys();
        }
        while (node != null && !node.getNodeName().equals("INSTANCE")) {
            node = walker.nextNode();
        }
        node = walker.getCurrentNode();
        while (node != null) {
            String nodename = node.getNodeName();
            if (nodename.equals("INSTANCE")) {
                ((Element)node).normalize();
                ci.setClassName(((Element)node).getAttribute("CLASSNAME"));
                node = node.getFirstChild();
                continue;
            }
            if (nodename.equals("QUALIFIER")) {
                q.addElement(XMLParser.getCIMQualifier(node));
                node = node.getNextSibling();
                continue;
            }
            if (nodename.startsWith("PROPERTY")) {
                CIMProperty cpKey;
                CIMProperty cp = XMLParser.getCIMProperty(node);
                Enumeration eKeys = keys.elements();
                while (eKeys.hasMoreElements()) {
                    cpKey = (CIMProperty)eKeys.nextElement();
                    if (!cp.getName().equalsIgnoreCase(cpKey.getName())) continue;
                    cp.setKey(true);
                    cp.setValue(cpKey.getValue());
                }
                if (path != null) {
                    eKeys = path.getKeys().elements();
                    while (eKeys.hasMoreElements()) {
                        cpKey = (CIMProperty)eKeys.nextElement();
                        if (!cp.getName().equalsIgnoreCase(cpKey.getName())) continue;
                        cp.setKey(true);
                        cp.setValue(cpKey.getValue());
                    }
                }
                p.addElement(cp);
                node = node.getNextSibling();
                continue;
            }
            node = node.getNextSibling();
        }
        if (p.size() > 0) {
            ci.setProperties(p);
        }
        if (path != null) {
            ci.setObjectPath(path);
        }
        return ci;
    }

    static CIMMethod getCIMMethod(Node node) {
        CIMMethod cm = new CIMMethod();
        Vector<CIMQualifier> q = new Vector<CIMQualifier>();
        Vector<CIMParameter> p = new Vector<CIMParameter>();
        NodeTreeWalker walker = new NodeTreeWalker(node);
        node = walker.getCurrentNode();
        while (node != null) {
            String nodename = node.getNodeName();
            if (nodename.equals("METHOD")) {
                NamedNodeMap attrs = node.getAttributes();
                for (int i = 0; i < attrs.getLength(); ++i) {
                    Node item = attrs.item(i);
                    String itemname = item.getNodeName();
                    if (itemname.equals("NAME")) {
                        cm.setName(item.getNodeValue());
                        continue;
                    }
                    if (itemname.equals("TYPE")) {
                        String cimtype = item.getNodeValue();
                        try {
                            CIMDataType cdt = CIMDataType.getDataType(cimtype);
                            cm.setType(cdt);
                        }
                        catch (CIMException e) {
                            Debug.trace1("Got exception", e);
                        }
                        continue;
                    }
                    if (itemname.equals("PROPAGATED") || !itemname.equals("CLASSORIGIN")) continue;
                    cm.setOriginClass(item.getNodeValue());
                }
            } else if (nodename.equals("QUALIFIER")) {
                if (node.getParentNode().getNodeName().equals("METHOD")) {
                    q.addElement(XMLParser.getCIMQualifier(node));
                }
            } else if (nodename.startsWith("PARAMETER")) {
                p.addElement(XMLParser.getCIMParameter(node));
            }
            node = walker.nextNode();
        }
        if (q.size() > 0) {
            cm.setQualifiers(q);
        }
        if (p.size() > 0) {
            cm.setParameters(p);
        }
        return cm;
    }

    static CIMObjectPath getCIMObjectPath(Node node) {
        String className = "";
        String nameSpace = "";
        CIMObjectPath cop = new CIMObjectPath();
        NodeTreeWalker walker = new NodeTreeWalker(node);
        node = walker.getCurrentNode();
        while (node != null) {
            String nodename = node.getNodeName();
            if (!(nodename.equals("NAMESPACEPATH") || nodename.equals("LOCALNAMESPACEPATH") || nodename.equals("CLASSPATH") || nodename.equals("LOCALCLASSPATH") || nodename.equals("INSTANCEPATH") || nodename.equals("LOCALINSTANCEPATH") || nodename.equals("OBJECTPATH"))) {
                if (nodename.equals("VALUE.REFERENCE")) {
                    node = walker.removeCurrent();
                    continue;
                }
                if (nodename.equals("HOST")) {
                    String host = XMLParser.getTextNode(node);
                    if (host == null || host.length() == 0) continue;
                    cop.setHost(host);
                } else if (nodename.equals("NAMESPACE")) {
                    nameSpace = nameSpace + "/" + ((Element)node).getAttribute("NAME");
                    cop.setNameSpace(nameSpace);
                    node = node.getNextSibling();
                } else if (nodename.equals("CLASSNAME")) {
                    cop.setObjectName(((Element)node).getAttribute("NAME"));
                } else if (nodename.equals("INSTANCENAME")) {
                    className = ((Element)node).getAttribute("CLASSNAME");
                    cop.setObjectName(className);
                } else if (node.getNodeName() == "KEYBINDING") {
                    CIMProperty cp = XMLParser.getCIMProperty(node);
                    cop.addKey(cp);
                    if (className.equals("__Namespace") && cp.getName().startsWith("Name")) {
                        nameSpace = cp.getValue().getValue().toString();
                    }
                    node = walker.removeCurrent();
                    continue;
                }
            }
            node = walker.nextNode();
        }
        if (className.equals("__Namespace")) {
            return new CIMObjectPath("", nameSpace);
        }
        return cop;
    }

    static CIMParameter getCIMParameter(Node node) {
        CIMParameter cp = new CIMParameter();
        Vector<CIMQualifier> q = new Vector<CIMQualifier>();
        NodeTreeWalker walker = new NodeTreeWalker(node);
        String refclassname = null;
        node = walker.getCurrentNode();
        while (node != null) {
            String nodename = node.getNodeName();
            if (nodename.startsWith("PARAMETER")) {
                NamedNodeMap attrs = node.getAttributes();
                for (int i = 0; i < attrs.getLength(); ++i) {
                    Node item = attrs.item(i);
                    String itemname = item.getNodeName();
                    if (itemname.equals("NAME")) {
                        cp.setName(item.getNodeValue());
                        continue;
                    }
                    if (itemname.equals("TYPE")) {
                        String cimtype = item.getNodeValue();
                        try {
                            cp.setType(CIMDataType.getDataType(cimtype, nodename.endsWith(".ARRAY")));
                        }
                        catch (CIMException e) {
                            Debug.trace1("Got exception", e);
                        }
                        continue;
                    }
                    if (itemname.equals("ARRAYSIZE")) {
                        cp.setSize(Integer.parseInt(item.getNodeValue()));
                        continue;
                    }
                    if (!itemname.equals("REFERENCECLASS")) continue;
                    refclassname = XMLParser.xml2string(item.getNodeValue());
                }
                if (nodename.endsWith(".REFERENCE")) {
                    cp.setType(new CIMDataType(refclassname != null ? refclassname : ""));
                }
                if (nodename.endsWith(".REFARRAY")) {
                    int refSize = cp.getSize();
                    if (refSize <= 0) {
                        refSize = -2;
                    }
                    cp.setType(new CIMDataType(42, refSize));
                }
            } else if (nodename.equals("QUALIFIER")) {
                node = walker.getCurrentNode();
                while (node != null) {
                    q.addElement(XMLParser.getCIMQualifier(node));
                    node = walker.getNextElement(nodename);
                }
            }
            node = walker.nextNode();
        }
        if (q.size() > 0) {
            cp.setQualifiers(q);
        }
        return cp;
    }

    static CIMProperty getCIMProperty(Node node) {
        CIMProperty cp = new CIMProperty();
        String cimtype = null;
        boolean isEmbeddedObj = false;
        boolean isValueNode = false;
        Object obj = null;
        NodeTreeWalker walker = new NodeTreeWalker(node);
        node = walker.getCurrentNode();
        while (node != null) {
            String nodename = node.getNodeName();
            if (nodename.startsWith("PROPERTY")) {
                NamedNodeMap attrs = node.getAttributes();
                String name = null;
                String origin = null;
                String size = null;
                String propagated = "false";
                String reference = null;
                for (int i = 0; i < attrs.getLength(); ++i) {
                    Node item = attrs.item(i);
                    String itemname = item.getNodeName();
                    if (itemname.equals("NAME")) {
                        name = item.getNodeValue();
                        continue;
                    }
                    if (itemname.equals("TYPE")) {
                        cimtype = item.getNodeValue();
                        try {
                            cp.setType(CIMDataType.getDataType(cimtype, nodename.endsWith(".ARRAY")));
                        }
                        catch (CIMException e) {
                            Debug.trace1("Got exception", e);
                        }
                        continue;
                    }
                    if (itemname.equals("CLASSORIGIN")) {
                        origin = item.getNodeValue();
                        continue;
                    }
                    if (itemname.equals("ARRAYSIZE")) {
                        size = item.getNodeValue();
                        continue;
                    }
                    if (itemname.equals("PROPAGATED")) {
                        propagated = item.getNodeValue();
                        continue;
                    }
                    if (!itemname.equals("REFERENCECLASS")) continue;
                    reference = item.getNodeValue();
                }
                cp.setPropagated(propagated.equalsIgnoreCase("true"));
                if (name != null) {
                    cp.setName(name);
                }
                if (origin != null) {
                    cp.setOriginClass(origin);
                }
                if (size != null) {
                    // empty if block
                }
                if (reference != null) {
                    cp.setType(new CIMDataType(reference));
                }
                node = walker.nextNode();
                continue;
            }
            if (nodename.equals("QUALIFIER")) {
                try {
                    String q = ((Element)node).getAttribute("NAME");
                    if (q.equals("EmbeddedObject")) {
                        isEmbeddedObj = true;
                    }
                    cp.addQualifier(XMLParser.getCIMQualifier(node));
                }
                catch (CIMException e) {
                    Debug.trace1("Got exception", e);
                }
                node = node.getNextSibling();
                continue;
            }
            if (nodename.equals("KEYBINDING")) {
                if (cp.getName().length() == 0) {
                    cp.setName(((Element)node).getAttribute("NAME"));
                }
                node = walker.nextNode();
                continue;
            }
            if (nodename.equals("KEYVALUE")) {
                cimtype = ((Element)node).getAttribute("TYPE");
                if (!cimtype.equals("")) {
                    Object obj2 = XMLParser.valueObject(node, cimtype);
                    CIMDataType cdt = null;
                    try {
                        cdt = CIMDataType.getDataType(cimtype);
                    }
                    catch (Exception e) {
                        cp.setType(new CIMDataType(-1));
                        cdt = new CIMDataType(8);
                    }
                    cp.setValue(new CIMValue(obj2, cdt));
                } else {
                    String value = XMLParser.getStringValue(node);
                    cp.setValue(new CIMValue(value));
                    cp.setType(new CIMDataType(-1));
                }
                cp.setKey(true);
                break;
            }
            if (nodename.equals("VALUE.REFERENCE")) {
                cp.setValue(XMLParser.getCIMValue(node, ""));
                cp.setType(new CIMDataType(((CIMObjectPath)cp.getValue().getValue()).getObjectName()));
                break;
            }
            if (nodename.equals("VALUE.ARRAY")) {
                cp.setValue(XMLParser.getCIMValue(node, cimtype));
                break;
            }
            if (nodename.equals("VALUE")) {
                isValueNode = true;
                obj = XMLParser.valueObject(node, cimtype);
                break;
            }
            node = node.getNextSibling();
        }
        if (isValueNode) {
            if (isEmbeddedObj) {
                try {
                    obj = XMLParser.getEmbeddedObject((String)obj);
                }
                catch (CIMException e) {
                    Debug.trace1("Got exception", e);
                }
            }
            cp.setValue(new CIMValue(obj));
        }
        return cp;
    }

    static Object getEmbeddedObject(String xml) throws CIMException {
        CIMObject o = null;
        Document d = null;
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        try {
            DocumentBuilder builder = dbf.newDocumentBuilder();
            InputSource in = new InputSource();
            byte[] buffer = XMLParser.stripQuote(xml).getBytes();
            in.setByteStream(new ByteArrayInputStream(buffer));
            d = builder.parse(in);
        }
        catch (Exception e) {
            throw new CIMException("XMLERROR", (Object)e);
        }
        NodeTreeWalker walker = new NodeTreeWalker(d);
        Node node = walker.getCurrentNode();
        while (node != null) {
            String nodename = node.getNodeName();
            if (nodename.equals("CLASS")) {
                o = XMLParser.getCIMClass(node, null);
                node = node.getNextSibling();
                continue;
            }
            if (nodename.equals("INSTANCE")) {
                o = XMLParser.getCIMInstance(node, null);
                node = node.getNextSibling();
                continue;
            }
            node = walker.nextNode();
        }
        return o;
    }

    static String stripQuote(String pcdata) {
        StringBuffer buf = new StringBuffer(pcdata.length());
        for (int i = 0; i < pcdata.length(); ++i) {
            if (pcdata.charAt(i) == '\\' && (pcdata.charAt(i + 1) == '\\' || pcdata.charAt(i + 1) == '\"')) {
                buf.append(pcdata.charAt(++i));
                continue;
            }
            buf.append(pcdata.charAt(i));
        }
        return buf.toString();
    }

    static CIMQualifier getCIMQualifier(Node node) {
        CIMQualifier cq = new CIMQualifier();
        String type = null;
        NodeTreeWalker walker = new NodeTreeWalker(node);
        node = walker.getCurrentNode();
        while (node != null) {
            String nodename = node.getNodeName();
            if (nodename.equals("QUALIFIER")) {
                NamedNodeMap attrs = node.getAttributes();
                for (int i = 0; i < attrs.getLength(); ++i) {
                    Node item = attrs.item(i);
                    if (item.getNodeName().equals("NAME")) {
                        cq.setName(item.getNodeValue());
                        continue;
                    }
                    if (item.getNodeName().equals("TYPE")) {
                        type = item.getNodeValue();
                        continue;
                    }
                    if (item.getNodeName().equals("OVERRIDABLE")) {
                        if (item.getNodeValue().equalsIgnoreCase("true")) {
                            cq.addFlavor(new CIMFlavor(0));
                            continue;
                        }
                        cq.addFlavor(new CIMFlavor(1));
                        continue;
                    }
                    if (item.getNodeName().equals("TOSUBCLASS")) {
                        if (item.getNodeValue().equalsIgnoreCase("true")) {
                            cq.addFlavor(new CIMFlavor(3));
                            continue;
                        }
                        cq.addFlavor(new CIMFlavor(2));
                        continue;
                    }
                    if (!item.getNodeName().equals("TRANSLATABLE") || !item.getNodeValue().equalsIgnoreCase("true")) continue;
                    cq.addFlavor(new CIMFlavor(4));
                }
                node = walker.nextNode();
                continue;
            }
            if (nodename.startsWith("VALUE")) {
                cq.setValue(XMLParser.getCIMValue(node, type));
                break;
            }
            node = walker.nextNode();
        }
        return cq;
    }

    static CIMQualifierType getCIMQualifierType(Node node) {
        CIMQualifierType cqt = new CIMQualifierType();
        String cimtype = null;
        boolean isarray = false;
        int qSize = -2;
        NodeTreeWalker walker = new NodeTreeWalker(node);
        node = walker.getCurrentNode();
        while (node != null) {
            Node item;
            NamedNodeMap attrs;
            String nodename = node.getNodeName();
            if (nodename.equals("QUALIFIER.DECLARATION")) {
                attrs = node.getAttributes();
                for (int i = 0; i < attrs.getLength(); ++i) {
                    item = attrs.item(i);
                    if (item.getNodeName().equals("NAME")) {
                        cqt.setName(item.getNodeValue());
                        continue;
                    }
                    if (item.getNodeName().equals("TYPE")) {
                        cimtype = item.getNodeValue();
                        continue;
                    }
                    if (item.getNodeName().equals("ISARRAY")) {
                        isarray = item.getNodeValue().equalsIgnoreCase("true");
                        continue;
                    }
                    if (item.getNodeName().equals("ARRAYSIZE")) {
                        isarray = true;
                        qSize = Integer.parseInt(item.getNodeValue());
                        continue;
                    }
                    if (item.getNodeName().equals("OVERRIDABLE")) {
                        if (item.getNodeValue().equalsIgnoreCase("true")) {
                            cqt.addFlavor(new CIMFlavor(0));
                            continue;
                        }
                        cqt.addFlavor(new CIMFlavor(1));
                        continue;
                    }
                    if (item.getNodeName().equals("TOSUBCLASS")) {
                        if (item.getNodeValue().equalsIgnoreCase("true")) {
                            cqt.addFlavor(new CIMFlavor(3));
                            continue;
                        }
                        cqt.addFlavor(new CIMFlavor(2));
                        continue;
                    }
                    if (!item.getNodeName().equals("TRANSLATABLE") || !item.getNodeValue().equalsIgnoreCase("true")) continue;
                    cqt.addFlavor(new CIMFlavor(4));
                }
                try {
                    CIMDataType cdt = CIMDataType.getDataType(cimtype, isarray);
                    if (isarray) {
                        cdt = new CIMDataType(cdt.getType(), qSize);
                    }
                    cqt.setType(cdt);
                }
                catch (CIMException e) {
                    Debug.trace1("Got exception", e);
                }
                node = walker.nextNode();
                continue;
            }
            if (nodename.startsWith("SCOPE")) {
                attrs = node.getAttributes();
                for (int i = 0; i < attrs.getLength(); ++i) {
                    item = attrs.item(i);
                    if (item.getNodeName().equals("CLASS") && item.getNodeValue().equalsIgnoreCase("true")) {
                        cqt.addScope(new CIMScope(1));
                        continue;
                    }
                    if (item.getNodeName().equals("ASSOCIATION") && item.getNodeValue().equalsIgnoreCase("true")) {
                        cqt.addScope(new CIMScope(2));
                        continue;
                    }
                    if (item.getNodeName().equals("REFERENCE") && item.getNodeValue().equalsIgnoreCase("true")) {
                        cqt.addScope(new CIMScope(5));
                        continue;
                    }
                    if (item.getNodeName().equals("PROPERTY") && item.getNodeValue().equalsIgnoreCase("true")) {
                        cqt.addScope(new CIMScope(4));
                        continue;
                    }
                    if (item.getNodeName().equals("METHOD") && item.getNodeValue().equalsIgnoreCase("true")) {
                        cqt.addScope(new CIMScope(6));
                        continue;
                    }
                    if (item.getNodeName().equals("PARAMETER") && item.getNodeValue().equalsIgnoreCase("true")) {
                        cqt.addScope(new CIMScope(7));
                        continue;
                    }
                    if (!item.getNodeName().equals("INDICATION") || !item.getNodeValue().equalsIgnoreCase("true")) continue;
                    cqt.addScope(new CIMScope(3));
                }
                node = walker.nextNode();
                continue;
            }
            if (nodename.startsWith("VALUE")) {
                cqt.setDefaultValue(XMLParser.getCIMValue(node, cimtype));
                break;
            }
            node = walker.nextNode();
        }
        return cqt;
    }

    static CIMValue getCIMValue(Node node, String type) {
        Vector<Object> o = null;
        NodeTreeWalker walker = new NodeTreeWalker(node);
        node = walker.getCurrentNode();
        while (node != null) {
            String nodename = node.getNodeName();
            if (nodename.equals("KEYVALUE")) {
                o = XMLParser.valueObject(node, ((Element)node).getAttribute("VALUETYPE"));
                break;
            }
            if (nodename.equals("VALUE")) {
                o = XMLParser.valueObject(node, type);
                break;
            }
            if (nodename.equals("VALUE.ARRAY")) {
                Vector<Object> v = new Vector<Object>();
                node = walker.getNextElement("VALUE");
                while (node != null) {
                    v.addElement(XMLParser.valueObject(node, type));
                    node = walker.getNextElement("VALUE");
                }
                o = v;
                break;
            }
            if (nodename.equals("VALUE.REFERENCE")) {
                o = XMLParser.getCIMObjectPath(XMLParser.getFirstChildElement(node));
                break;
            }
            node = walker.nextNode();
        }
        return new CIMValue(o);
    }

    private static Object valueObject(Node node, String type) {
        Object o = null;
        String value = XMLParser.getStringValue(node);
        if (value == null || type == null) {
            return value;
        }
        type = type.length() > 0 ? type : "string";
        int radix = 10;
        if (type.startsWith("sint") && (value.startsWith("0x") || value.startsWith("+0x") || value.startsWith("-0x") || value.startsWith("0X") || value.startsWith("+0X") || value.startsWith("-0X")) || type.startsWith("uint") && (value.startsWith("0x") || value.startsWith("0X"))) {
            radix = 16;
            int dot = (value.indexOf("x") > 0 ? value.indexOf("x") : value.indexOf("X")) + 1;
            String string = value = value.startsWith("-") ? "-" + value.substring(dot) : value.substring(dot);
        }
        if (type.equals("boolean")) {
            o = Boolean.valueOf(value);
        } else if (type.equals("char16")) {
            o = new Character(value.charAt(0));
        } else if (type.equals("datetime")) {
            o = new CIMDateTime(value);
        } else if (type.equals("real32")) {
            o = new Float(value);
        } else if (type.equals("real64")) {
            o = new Double(value);
        } else if (type.equals("sint16")) {
            o = Short.valueOf(value, radix);
        } else if (type.equals("sint32")) {
            o = Integer.valueOf(value, radix);
        } else if (type.equals("sint64")) {
            o = Long.valueOf(value, radix);
        } else if (type.equals("sint8")) {
            o = Byte.valueOf(value, radix);
        } else if (type.equals("string")) {
            o = value;
        } else if (type.equals("reference")) {
            o = new CIMObjectPath(value);
        } else if (type.equals("uint16")) {
            o = new UnsignedInt16(Integer.valueOf(value, radix));
        } else if (type.equals("uint32")) {
            o = new UnsignedInt32(Long.valueOf(value, radix));
        } else if (type.equals("uint64")) {
            o = new UnsignedInt64(new BigInteger(value, radix));
        } else if (type.equals("uint8")) {
            o = new UnsignedInt8(Short.valueOf(value, radix));
        } else if (value.indexOf("e") > 0 || value.indexOf("E") > 0) {
            o = new Double(value);
        } else if (value.startsWith("+") || value.startsWith("-")) {
            o = new Long(value);
        }
        return o;
    }

    static boolean getBooleanValue(Node node) {
        NodeTreeWalker walker = new NodeTreeWalker(node);
        node = walker.getNextElement("VALUE");
        return XMLParser.getTextNode(node).equalsIgnoreCase("true");
    }

    private static Node getFirstChildElement(Node node) {
        if (node.hasChildNodes()) {
            NodeList nl = node.getChildNodes();
            for (int i = 0; i < nl.getLength(); ++i) {
                Node item = nl.item(i);
                if (item.getNodeType() != 1) continue;
                return item;
            }
        }
        return null;
    }

    static String getStringValue(Node node) {
        String nodename = node.getNodeName();
        if (nodename.endsWith("PARAMVALUE")) {
            node = XMLParser.getFirstChildElement(node);
        }
        return XMLParser.getTextNode(node);
    }

    private static String getTextNode(Node node) {
        NodeTreeWalker walker = new NodeTreeWalker(node);
        node = walker.getCurrentNode();
        while (node != null) {
            if (node != null && (node.getNodeType() == 3 || node.getNodeType() == 4)) {
                return XMLParser.xml2string(node.getNodeValue());
            }
            node = walker.nextNode();
        }
        return "";
    }

    static String xml2string(String pcdata) {
        pcdata.replaceAll("&lt;", "<");
        pcdata.replaceAll("&amp;", "&");
        pcdata.replaceAll("&quot;", "\"");
        pcdata.replaceAll("&gt;", ">");
        pcdata.replaceAll("&apos;", "'");
        return pcdata;
    }
}

