/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.jcc;

import com.ibm.db2.jcc.DB2BaseDataSource;
import com.ibm.db2.jcc.DB2PooledConnection;
import com.ibm.db2.jcc.DB2XADataSource;
import com.ibm.db2.jcc.a.c;
import com.ibm.db2.jcc.a.g;
import com.ibm.db2.jcc.a.xb;
import com.ibm.db2.jcc.a.yb;
import com.ibm.db2.jcc.b.SqlException;
import com.ibm.db2.jcc.b.SqlWarning;
import com.ibm.db2.jcc.t2.T2Configuration;
import com.ibm.db2.jcc.uw.UWXAResource;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.XAConnection;
import javax.transaction.xa.XAResource;

public class DB2XAConnection
extends DB2PooledConnection
implements XAConnection {
    private static int rmIdSeed_ = 95688932;
    private DB2XADataSource db2ds_ = null;
    private XAResource xares_ = null;
    private UWXAResource uwXares_ = null;
    private xb t4Xares_ = null;
    private boolean fFirstGetConnection_ = true;
    private Connection logicalCon_;
    private c controlCon_ = null;

    public DB2XAConnection(DB2XADataSource dB2XADataSource, g g2, String string, String string2) throws SqlException {
        super(dB2XADataSource, g2, string, string2, DB2XAConnection.getUnigueRmId());
        this.db2ds_ = dB2XADataSource;
        this.logicalCon_ = super.getConnection();
        switch (dB2XADataSource.getDriverType()) {
            case 2: {
                if (2 == T2Configuration.a()) {
                    this.uwXares_ = new UWXAResource(this, this.rmId_, this.uwPhysicalConnection_);
                    this.xares_ = this.uwXares_;
                    break;
                }
                throw new SqlException((com.ibm.db2.jcc.b.xb)g2, "Driver type 2 z/OS not enabled for XA connections");
            }
            case 4: {
                if (this.isRunningV7390()) {
                    this.t4Xares_ = new yb(this, this.rmId_, string, string2, this.t4XAPhysicalConnection_);
                    this.xares_ = this.t4Xares_;
                    break;
                }
                this.t4Xares_ = new xb(this, this.rmId_, string, string2, this.t4XAPhysicalConnection_);
                this.xares_ = this.t4Xares_;
            }
        }
    }

    public Connection getConnection() throws SqlException {
        if (this.fFirstGetConnection_) {
            this.fFirstGetConnection_ = false;
        } else {
            this.logicalCon_ = super.getConnection();
            if (this.physicalConnection_ != null && this.t4XAPhysicalConnection_ != null) {
                this.t4Xares_.j();
            }
        }
        return this.logicalCon_;
    }

    private static synchronized int getUnigueRmId() {
        return ++rmIdSeed_;
    }

    public int getRmId() {
        return this.rmId_;
    }

    public XAResource getXAResource() throws SqlException {
        return this.xares_;
    }

    public DB2XADataSource getDataSource() throws SqlException {
        return this.db2ds_;
    }

    public c createControlConnection(g g2, SqlWarning sqlWarning, String string, String string2, DB2BaseDataSource dB2BaseDataSource, int n2, boolean bl) throws SqlException {
        this.controlCon_ = new c(g2, string, string2, dB2BaseDataSource, n2, bl);
        this.controlCon_.setTransactionIsolation(1);
        return this.controlCon_;
    }

    public boolean isRunningV7390() {
        return this.physicalConnection_.Hb && this.physicalConnection_.Ib == 7;
    }

    public synchronized void close() throws SqlException {
        if (this.physicalConnection_ != null && this.isRunningV7390()) {
            try {
                super.close();
                this.db2ds_.adjustControlConnectionUsage(-1);
            }
            catch (SQLException sQLException) {
                throw new SqlException(null, sQLException.getMessage());
            }
        } else {
            super.close();
        }
    }
}

