/*
 * Decompiled with CFR 0.152.
 */
package org.wbemservices.wbem.cimom;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Vector;
import javax.wbem.cim.CIMClass;
import javax.wbem.cim.CIMClassException;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMProperty;
import javax.wbem.cim.CIMPropertyException;
import javax.wbem.cim.CIMQualifier;
import javax.wbem.cim.CIMScope;
import javax.wbem.cim.CIMValue;
import org.wbemservices.wbem.cimom.CIMOMUtils;
import org.wbemservices.wbem.cimom.MethodChecker;
import org.wbemservices.wbem.cimom.PropertyChecker;

class ClassChecker {
    CIMOMUtils cu;
    PropertyChecker propCheck;
    MethodChecker methCheck;
    static final String INDICATIONQUALIFIER = "indication";

    public ClassChecker(CIMOMUtils cu) {
        this.cu = cu;
        this.propCheck = new PropertyChecker(cu);
        this.methCheck = new MethodChecker(cu);
    }

    void compareKeys(Vector oldKeys, Vector newKeys) throws CIMException {
        String key;
        CIMProperty cp;
        HashMap<String, CIMProperty> keyMap = new HashMap<String, CIMProperty>();
        Enumeration e = oldKeys.elements();
        if (oldKeys.size() != newKeys.size()) {
            throw new CIMPropertyException("NEW_KEY", (Object)"", (Object)"");
        }
        while (e.hasMoreElements()) {
            cp = (CIMProperty)e.nextElement();
            key = cp.getOriginClass().toLowerCase() + ":" + cp.getName();
            keyMap.put(key, cp);
        }
        e = newKeys.elements();
        while (e.hasMoreElements()) {
            cp = (CIMProperty)e.nextElement();
            key = cp.getOriginClass().toLowerCase() + ":" + cp.getName();
            CIMProperty oldcp = (CIMProperty)keyMap.get(key);
            if (oldcp == null) {
                throw new CIMPropertyException("NEW_KEY", (Object)key, (Object)"");
            }
            if (oldcp.getType().equals((Object)cp.getType())) continue;
            throw new CIMPropertyException("NEW_KEY", (Object)key, (Object)"");
        }
    }

    void checkClassSanity(String namespace, CIMClass cc, CIMClass parentClass) throws CIMException {
        CIMQualifier qe;
        if (cc.getName().indexOf("_") < 0) {
            throw new CIMClassException("CIM_ERR_INVALID_PARAMETER", (Object)cc.getName());
        }
        int keysRequired = 0;
        int refsRequired = 0;
        CIMScope curLevel = new CIMScope(1);
        CIMClass superclass = parentClass;
        if (superclass == null && cc.getSuperClass().length() != 0) {
            superclass = this.cu.getPS().getClass(namespace, cc.getSuperClass().toLowerCase());
        }
        if (superclass == null && cc.getSuperClass().length() != 0) {
            throw new CIMClassException("CIM_ERR_INVALID_SUPERCLASS", (Object)cc.getName(), (Object)cc.getSuperClass());
        }
        Vector qualifiers = cc.getQualifiers();
        if (superclass != null) {
            this.cu.assignInheritedQualifiers(qualifiers, superclass.getQualifiers());
        }
        if ((qe = cc.getQualifier("association")) == null) {
            qe = this.cu.createDefaultQualifier(namespace, "association");
        } else {
            this.cu.checkQualifier(namespace, qe);
        }
        CIMValue Tmp = qe.getValue();
        if (Tmp != null && Tmp.equals((Object)CIMValue.TRUE)) {
            cc.setIsAssociation(true);
            curLevel = new CIMScope(2);
            if (superclass == null || !superclass.isAssociation()) {
                refsRequired = 2;
            }
        }
        this.cu.doCommonQualifierChecks(namespace, cc.getName(), qualifiers, curLevel);
        if (superclass != null) {
            cc.setIsKeyed(superclass.isKeyed());
        } else {
            cc.setIsKeyed(false);
        }
        qe = cc.getQualifier("abstract");
        if (qe == null) {
            qe = this.cu.createDefaultQualifier(namespace, "abstract");
        }
        if (qe.getValue().equals((Object)CIMValue.TRUE)) {
            if (superclass != null) {
                qe = superclass.getQualifier("abstract");
            }
        } else {
            keysRequired = cc.isKeyed() ? -1 : 1;
        }
        boolean isIndication = false;
        try {
            qe = cc.getQualifier(INDICATIONQUALIFIER);
            if (qe == null) {
                qe = this.cu.createDefaultQualifier(namespace, INDICATIONQUALIFIER);
            } else {
                this.cu.checkQualifier(namespace, qe);
            }
            Tmp = qe.getValue();
            if (Tmp != null && Tmp.equals((Object)CIMValue.TRUE)) {
                keysRequired = -1;
                isIndication = true;
            }
        }
        catch (CIMException indException) {
            // empty catch block
        }
        this.propCheck.checkPropertiesSanity(namespace, cc, keysRequired, refsRequired, superclass, isIndication);
        this.methCheck.checkMethodsSanity(namespace, cc, superclass);
    }
}

