/*
 * Decompiled with CFR 0.152.
 */
package org.wbemservices.wbem.cimom;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMProperty;
import javax.wbem.cim.CIMValue;
import javax.wbem.client.Debug;
import javax.wbem.client.ProviderCIMOMHandle;
import javax.wbem.query.SelectExp;
import org.wbemservices.wbem.cimom.EventService;
import org.wbemservices.wbem.cimom.FilterActivation;
import org.wbemservices.wbem.cimom.LogFile;

class IndicationPoller {
    private static final int ADDTRIGGERFLAG = 1;
    private static final int MODIFYTRIGGERFLAG = 2;
    private static final int DELETETRIGGERFLAG = 4;
    private ProviderCIMOMHandle pch = null;
    Map classMap = new TreeMap();

    IndicationPoller(ProviderCIMOMHandle pch) {
        this.pch = pch;
    }

    private void doActivation(FilterActivation.SubActivation sa, int flag) throws CIMException {
        String tns = sa.getParentActivation().getTargetNameSpace().getNameSpace();
        String fullClassName = tns + ":" + sa.getClassName();
        PollerThread pt = (PollerThread)this.classMap.get(fullClassName);
        if (pt == null) {
            pt = new PollerThread(flag, tns, sa.getClassName());
            this.classMap.put(fullClassName, pt);
            pt.start();
        } else {
            pt.setFlag(pt.getFlag() | flag);
        }
    }

    private void doDeActivation(FilterActivation.SubActivation sa, int flag) throws CIMException {
        String tns = sa.getParentActivation().getTargetNameSpace().getNameSpace();
        String fullClassName = tns + ":" + sa.getClassName();
        PollerThread pt = (PollerThread)this.classMap.get(fullClassName);
        if (pt == null) {
            return;
        }
        int currFlag = pt.getFlag();
        if ((currFlag & flag) != 0) {
            pt.setFlag(currFlag - flag);
            if (pt.getFlag() == 0) {
                this.classMap.remove(fullClassName);
            }
        }
    }

    void additionTriggerActivate(FilterActivation.SubActivation sa) throws CIMException {
        this.doActivation(sa, 1);
    }

    void modificationTriggerActivate(FilterActivation.SubActivation sa) throws CIMException {
        this.doActivation(sa, 2);
    }

    void deletionTriggerActivate(FilterActivation.SubActivation sa) throws CIMException {
        this.doActivation(sa, 4);
    }

    void additionTriggerDeActivate(FilterActivation.SubActivation sa) throws CIMException {
        this.doDeActivation(sa, 1);
    }

    void modificationTriggerDeActivate(FilterActivation.SubActivation sa) throws CIMException {
        this.doDeActivation(sa, 2);
    }

    void deletionTriggerDeActivate(FilterActivation.SubActivation sa) throws CIMException {
        this.doDeActivation(sa, 4);
    }

    public void authorizeFilter(SelectExp filter, String eventType, CIMObjectPath classPath, String owner) throws CIMException {
        this.pch.enumerateInstances(classPath, false, false, true, true, null);
    }

    static /* synthetic */ ProviderCIMOMHandle access$000(IndicationPoller x0) {
        return x0.pch;
    }

    private class PollerThread
    extends Thread {
        private int flag = 0;
        private CIMObjectPath classPath;
        private Enumeration pve;
        private Map instanceMap;

        synchronized void setFlag(int flag) {
            this.flag = flag;
        }

        synchronized int getFlag() {
            return this.flag;
        }

        PollerThread(int flag, String tns, String className) {
            try {
                LogFile.add(4, "DEBUG_VALUE", "New poller thread flag for class", className);
            }
            catch (CIMException e) {
                // empty catch block
            }
            this.flag = flag;
            this.classPath = new CIMObjectPath(className);
            this.classPath.setNameSpace(tns);
        }

        private boolean instanceEqual(CIMInstance inst1, CIMInstance inst2) {
            if (inst1 == null) {
                return inst2 == null;
            }
            if (inst2 == null) {
                return false;
            }
            Enumeration enumeration = inst1.getProperties().elements();
            while (enumeration.hasMoreElements()) {
                CIMProperty cp = (CIMProperty)enumeration.nextElement();
                CIMValue v1 = cp.getValue();
                CIMValue v2 = null;
                try {
                    v2 = inst2.getProperty(cp.getName()).getValue();
                    if (v1 == null) {
                        if (v2 == null) continue;
                        return false;
                    }
                    if (v2 == null) {
                        return false;
                    }
                    if (v1.equals((Object)v2)) continue;
                    return false;
                }
                catch (Exception e) {
                    Debug.trace2((String)"Caught Exception in IndicationPoller.instanceEqual", (Throwable)e);
                    return false;
                }
            }
            return true;
        }

        /*
         * Unable to fully structure code
         */
        public void run() {
            try {
                this.pve = IndicationPoller.access$000(IndicationPoller.this).enumerateInstances(this.classPath, false, false, true, true, null);
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    LogFile.add(4, "DEBUG_VALUE", "Exception in poll", e);
                }
                catch (CIMException e1) {
                    // empty catch block
                }
            }
            block12: while (true) {
                try {
                    Thread.sleep(EventService.pollInterval);
                }
                catch (InterruptedException ie) {
                    // empty catch block
                }
                tflag = this.getFlag();
                if (tflag == 0) {
                    try {
                        LogFile.add(4, "DEBUG_VALUE", "Stopping poll for", this.classPath);
                    }
                    catch (CIMException e) {
                        // empty catch block
                    }
                    return;
                }
                addPoll = (tflag & 1) != 0;
                deletePoll = (tflag & 4) != 0;
                modifyPoll = (tflag & 2) != 0;
                tns = this.classPath.getNameSpace();
                cve = null;
                try {
                    cve = IndicationPoller.access$000(IndicationPoller.this).enumerateInstances(this.classPath, false, false, true, true, null);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    try {
                        LogFile.add(4, "DEBUG_VALUE", "Exception in poll", e);
                    }
                    catch (CIMException e1) {}
                    continue;
                }
                this.instanceMap = new HashMap<K, V>();
                while (this.pve.hasMoreElements()) {
                    ci = (CIMInstance)this.pve.nextElement();
                    this.instanceMap.put(ci.getObjectPath(), ci);
                }
                previousVector = new Vector<CIMInstance>();
                while (cve.hasMoreElements()) {
                    ci = (CIMInstance)cve.nextElement();
                    previousVector.addElement(ci);
                    pci = (CIMInstance)this.instanceMap.remove(ci.getObjectPath());
                    if (addPoll && pci == null) {
                        indication = new CIMInstance();
                        indication.setClassName("cim_instcreation");
                        cp = new CIMProperty();
                        cp.setName("SourceInstance");
                        cp.setValue(new CIMValue((Object)ci));
                        v = new Vector<CIMProperty>();
                        v.addElement(cp);
                        indication.setProperties(v);
                        EventService.eventService.deliverEvent(tns, indication, true);
                    }
                    if (!modifyPoll || pci == null || this.instanceEqual(pci, ci)) continue;
                    indication = new CIMInstance();
                    indication.setClassName("cim_instmodification");
                    cp = new CIMProperty();
                    cp.setName("SourceInstance");
                    cp.setValue(new CIMValue((Object)ci));
                    v = new Vector<E>();
                    v.addElement(cp);
                    cp = new CIMProperty();
                    cp.setName("PreviousInstance");
                    cp.setValue(new CIMValue((Object)pci));
                    v.addElement(cp);
                    indication.setProperties(v);
                    EventService.eventService.deliverEvent(tns, indication, true);
                }
                this.pve = previousVector.elements();
                if (!deletePoll) continue;
                values = this.instanceMap.values();
                i = values.iterator();
                while (true) {
                    if (i.hasNext()) ** break;
                    continue block12;
                    ci = (CIMInstance)i.next();
                    indication = new CIMInstance();
                    indication.setClassName("cim_instdeletion");
                    cp = new CIMProperty();
                    cp.setName("SourceInstance");
                    cp.setValue(new CIMValue((Object)ci));
                    v = new Vector<CIMProperty>();
                    v.addElement(cp);
                    indication.setProperties(v);
                    EventService.eventService.deliverEvent(tns, indication, true);
                }
                break;
            }
        }
    }
}

