/*
 * Decompiled with CFR 0.152.
 */
package org.wbemservices.wbem.cimom;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.wbem.cim.CIMClass;
import javax.wbem.cim.CIMClassException;
import javax.wbem.cim.CIMDataType;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMProperty;
import javax.wbem.cim.CIMPropertyException;
import javax.wbem.cim.CIMQualifier;
import javax.wbem.cim.CIMScope;
import javax.wbem.cim.CIMSemanticException;
import javax.wbem.cim.CIMValue;
import org.wbemservices.wbem.cimom.CIMOMUtils;

class PropertyChecker {
    CIMOMUtils cu;
    private Hashtable reservedSQL;

    public PropertyChecker(CIMOMUtils cu) {
        this.cu = cu;
        this.reservedSQL = new Hashtable();
        this.reservedSQL.put("select", "");
        this.reservedSQL.put("from", "");
        this.reservedSQL.put("where", "");
        this.reservedSQL.put("or", "");
        this.reservedSQL.put("and", "");
        this.reservedSQL.put("not", "");
    }

    void checkPropertiesSanity(String namespace, CIMClass cc, int keysRequired, int refsRequired, CIMClass superclass, boolean isIndication) throws CIMException {
        Vector prt = cc.getProperties();
        Hashtable overrideMap = new Hashtable();
        Hashtable<String, String> propNames = new Hashtable<String, String>();
        Enumeration proprefs = prt.elements();
        while (proprefs.hasMoreElements()) {
            CIMProperty pe = (CIMProperty)proprefs.nextElement();
            if (pe.getName() == null) {
                throw new CIMPropertyException("CIM_ERR_INVALID_PARAMETER");
            }
            CIMDataType cdt = pe.getType();
            if (cdt == null) {
                throw new CIMPropertyException("CIM_ERR_INVALID_PARAMETER", (Object)pe.getName());
            }
            int cdtt = cdt.getType();
            if (cdtt >= 30 || cdtt <= -1) {
                throw new CIMPropertyException("CIM_ERR_INVALID_PARAMETER", (Object)pe.getName());
            }
            if (this.reservedSQL.get(pe.getName().toLowerCase()) != null) {
                throw new CIMPropertyException("CIM_ERR_INVALID_PARAMETER", (Object)pe.getName());
            }
            if (propNames.get(pe.getName().toLowerCase()) != null) {
                throw new CIMPropertyException("CIM_ERR_INVALID_PARAMETER", (Object)pe.getName());
            }
            propNames.put(pe.getName().toLowerCase(), "");
            pe.setOriginClass(cc.getName());
            Vector qt = pe.getQualifiers();
            if (pe.isReference()) {
                if (!cc.isAssociation()) {
                    throw new CIMPropertyException("CLASS_REFERENCE", (Object)(pe.getOriginClass() + "." + pe.getName()), (Object)cc.getName());
                }
                this.cu.doCommonQualifierChecks(namespace, pe.getOriginClass() + "." + pe.getName(), qt, CIMScope.getScope((int)5));
                --refsRequired;
            } else {
                this.cu.doCommonQualifierChecks(namespace, pe.getOriginClass() + "." + pe.getName(), qt, CIMScope.getScope((int)4));
            }
            try {
                pe.setValue(this.cu.typeConvert(pe.getType(), pe.getValue()));
            }
            catch (Exception e) {
                throw new CIMPropertyException("TYPE_ERROR", new Object[]{pe.getOriginClass() + "." + pe.getName(), cc.getName(), pe.getType(), pe.getValue().getType(), pe.getValue()});
            }
            boolean isKey = pe.isKey();
            if (isKey && pe.getType().isArrayType()) {
                throw new CIMPropertyException("CIM_ERR_INVALID_PARAMETER", (Object)pe);
            }
            boolean newKey = this.handlePropertyOverride(namespace, cc, pe, overrideMap, superclass);
            CIMQualifier qe = pe.getQualifier("override");
            if ((qe != null || !isKey) && (qe == null || !newKey)) continue;
            if (cc.isKeyed() || isIndication) {
                throw new CIMPropertyException("NEW_KEY", (Object)(pe.getOriginClass() + "." + pe.getName()), (Object)cc.getName());
            }
            keysRequired = -1;
        }
        if (keysRequired == -1 && !isIndication) {
            cc.setIsKeyed(true);
        }
        if (keysRequired > 0) {
            throw new CIMClassException("KEY_REQUIRED", (Object)cc.getName());
        }
        if (refsRequired > 0) {
            throw new CIMClassException("REF_REQUIRED", (Object)cc.getName());
        }
        this.assignInheritedProperties(namespace, cc, overrideMap, superclass);
    }

    private boolean handlePropertyOverride(String namespace, CIMClass cc, CIMProperty pe, Hashtable overrideMap, CIMClass superclass) throws CIMException {
        String PropertyName;
        boolean newKey = false;
        CIMQualifier qe = pe.getQualifier("override");
        if (qe == null) {
            return false;
        }
        CIMValue ValueTable = qe.getValue();
        String Value = null;
        if (ValueTable != null) {
            Value = (String)ValueTable.getValue();
        }
        if (ValueTable == null || Value == null || Value.equals("")) {
            throw new CIMSemanticException("NO_QUALIFIER_VALUE", (Object)(pe.getOriginClass() + "." + pe.getName()), (Object)qe.getName());
        }
        String ClassName = null;
        int trenner = Value.indexOf(".");
        String fullName = PropertyName = Value.substring(trenner + 1, Value.length());
        if (trenner > 0) {
            ClassName = Value.substring(0, trenner);
            fullName = ClassName + "." + PropertyName;
        }
        CIMProperty ope = null;
        if (superclass == null) {
            throw new CIMPropertyException("NO_OVERRIDDEN_PROPERTY", (Object)fullName, (Object)(pe.getOriginClass() + "." + pe.getName()));
        }
        ope = superclass.getProperty(PropertyName, ClassName);
        if (ope == null) {
            throw new CIMPropertyException("NO_OVERRIDDEN_PROPERTY", (Object)(pe.getOriginClass() + "." + pe.getName()), (Object)fullName);
        }
        if (ClassName != null && !ope.getOriginClass().equalsIgnoreCase(ClassName) || !ope.getName().equalsIgnoreCase(PropertyName)) {
            throw new CIMPropertyException("PROPERTY_OVERRIDDEN", (Object)(pe.getOriginClass() + "." + pe.getName()), (Object)fullName, (Object)(ope.getOriginClass() + "." + ope.getName()));
        }
        String tempop = (String)overrideMap.get(ope.getOriginClass() + "." + ope.getName());
        if (tempop != null) {
            throw new CIMPropertyException("PROPERTY_OVERRIDDEN", (Object)(pe.getOriginClass() + "." + pe.getName()), (Object)(ope.getOriginClass() + "." + ope.getName()), (Object)tempop);
        }
        this.cu.assignInheritedQualifiers(pe.getQualifiers(), ope.getQualifiers());
        if (pe.getQualifier("key") != null) {
            pe.setKey(true);
        }
        boolean isKeyOpe = ope.isKey();
        boolean isKeyPe = pe.isKey();
        if (isKeyOpe && !isKeyPe) {
            throw new CIMPropertyException("KEY_OVERRIDE", (Object)(pe.getOriginClass() + "." + pe.getName()), (Object)(ope.getOriginClass() + "." + ope.getName()));
        }
        if (isKeyPe && !isKeyOpe) {
            newKey = true;
        }
        overrideMap.put(ope.getOriginClass() + "." + ope.getName(), pe.getOriginClass() + "." + pe.getName());
        return newKey;
    }

    private void assignInheritedProperties(String namespace, CIMClass cc, Hashtable overrideMap, CIMClass superclass) {
        if (superclass != null) {
            Vector PropTable = superclass.getAllProperties();
            Enumeration proprefs = PropTable.elements();
            while (proprefs.hasMoreElements()) {
                CIMProperty pe = (CIMProperty)proprefs.nextElement();
                CIMProperty pec = (CIMProperty)pe.clone();
                String op = (String)overrideMap.get(pe.getOriginClass() + "." + pe.getName());
                if (op != null) {
                    pec.setOverridingProperty(op);
                }
                cc.addProperty(pec);
            }
        }
    }
}

