/*
 * Decompiled with CFR 0.152.
 */
package org.wbemservices.wbem.cimom;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.wbem.cim.CIMArgument;
import javax.wbem.cim.CIMClass;
import javax.wbem.cim.CIMClassException;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMMethod;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMProperty;
import javax.wbem.cim.CIMPropertyException;
import javax.wbem.cim.CIMQualifier;
import javax.wbem.cim.CIMValue;
import javax.wbem.client.CIMOMHandle;
import javax.wbem.client.CIMProviderException;
import javax.wbem.client.Debug;
import javax.wbem.client.ProviderCIMOMHandle;
import javax.wbem.provider.Authorizable;
import javax.wbem.provider.CIMAssociatorProvider;
import javax.wbem.provider.CIMIndicationProvider;
import javax.wbem.provider.CIMInstanceProvider;
import javax.wbem.provider.CIMMethodProvider;
import javax.wbem.provider.CIMProvider;
import javax.wbem.provider.EventProvider;
import org.wbemservices.wbem.cimom.CIMOMProvider;
import org.wbemservices.wbem.cimom.InternalProviderAdapter;
import org.wbemservices.wbem.cimom.OneToManyAssocProvider;
import org.wbemservices.wbem.cimom.adapter.provider.ProviderAdapterIF;
import org.wbemservices.wbem.cimom.adapter.provider.ProviderProtocolAdapterIF;
import org.wbemservices.wbem.cimom.util.DynClassLoader;

public class ProviderAdapterFactory
implements InternalProviderAdapter.InternalServiceProvider {
    private Map mAdapters = null;
    private Map mProviders = null;
    private List serviceProviders = new ArrayList();
    private ProviderCIMOMHandle mCimom = null;
    private boolean mShouldReturnNull = false;
    private static final String PPACIMCLASS = "WBEMServices_ObjectManagerProviderProtocolAdapter";
    private static final String PPA_ASSOC_CLASS = "WBEMServices_ProviderProtocolAdapterForManager";
    private static final String STARTSERVICE = "StartService";
    private static final String STOPSERVICE = "StopService";
    private static final String PROTOCOLTYPE = "Name";
    private static final String IMPLCLASS = "ImplClass";
    private static final String CLASSPATH = "classPath";
    AdapterProvider adapterProvider;
    AdapterAssocProvider assocProvider;

    public String[] getProviderNames() {
        this.serviceProviders.add(PPACIMCLASS);
        this.serviceProviders.add(PPA_ASSOC_CLASS);
        String[] tArray = new String[this.serviceProviders.size()];
        return this.serviceProviders.toArray(tArray);
    }

    public CIMProvider getProvider(String pName) throws CIMException {
        if (pName.equals(PPACIMCLASS)) {
            return this.adapterProvider;
        }
        if (pName.equals(PPA_ASSOC_CLASS)) {
            return this.assocProvider;
        }
        return (CIMProvider)this.mAdapters.get(pName);
    }

    public ProviderAdapterFactory(ProviderCIMOMHandle pch) throws CIMException {
        this.mCimom = pch;
        String passAllProvCheck = System.getProperty("passAllProviderCheck", "false");
        if ("true".equalsIgnoreCase(passAllProvCheck)) {
            this.mShouldReturnNull = true;
            Debug.trace3((String)"'passAllProviderCheck' was true");
        } else {
            this.mShouldReturnNull = false;
            this.mAdapters = Collections.synchronizedMap(new HashMap(5));
            this.mProviders = Collections.synchronizedMap(new HashMap(100));
            this.adapterProvider = new AdapterProvider();
            this.assocProvider = new AdapterAssocProvider();
            Debug.trace3((String)"Provider factory created and ready");
        }
    }

    void RegisterProtocolProvider(String pAdapterType, ProviderProtocolAdapterIF pAdapter, boolean isAuto) {
        this.UnRegisterProtocolProvider(pAdapterType);
        pAdapter.initialize(this.mCimom);
        if (isAuto) {
            pAdapter.start();
        }
        if (pAdapter.isValid()) {
            Debug.trace3((String)("adding an adapter for protocol: " + pAdapterType));
            this.mAdapters.put(pAdapterType, pAdapter);
            if (pAdapter instanceof CIMProvider) {
                Debug.trace3((String)("The " + pAdapterType + " is a CIMProvider"));
                this.serviceProviders.add(pAdapterType);
            }
        } else {
            Debug.trace3((String)("The " + pAdapterType + " says it is not valid"));
        }
    }

    void UnRegisterProtocolProvider(String pAdapterType) {
        ProviderProtocolAdapterIF adapter = (ProviderProtocolAdapterIF)this.mAdapters.get(pAdapterType);
        if (adapter != null) {
            Debug.trace3((String)("Removing protocol adapter:" + pAdapterType));
            this.mAdapters.remove(pAdapterType);
            adapter.stop();
        }
    }

    public CIMInstanceProvider getInstanceProvider(String pNamespace, CIMClass pCIMClass) throws CIMException {
        CIMInstanceProvider realProv;
        block8: {
            if (this.mShouldReturnNull) {
                return null;
            }
            realProv = null;
            CIMQualifier qual = pCIMClass.getQualifier("provider");
            if (qual == null) {
                Debug.trace3((String)("No 'provider' qualifier found for class: " + pCIMClass));
                return null;
            }
            String provider = this.getProviderString(qual);
            ProviderAdapterIF prov = null;
            try {
                prov = this.getProviderAdapter(pNamespace, provider, pCIMClass);
            }
            catch (ClassNotFoundException cnfe) {
                Debug.trace3((String)"getProviderAdapter threw ClassNotFoundException", (Throwable)cnfe);
                throw new CIMProviderException("NO_INSTANCE_PROVIDER", (Object)pCIMClass.getName(), (Object)provider);
            }
            if (prov.isInstanceProvider()) {
                try {
                    realProv = (CIMInstanceProvider)prov.getProvider();
                    if (realProv == null) {
                        Debug.trace3((String)"getProvider returned NULL");
                        throw new CIMProviderException("NO_INSTANCE_PROVIDER", (Object)pCIMClass.getName(), (Object)provider);
                    }
                    break block8;
                }
                catch (ClassCastException cce) {
                    Debug.trace3((String)"Class Cast Exception", (Throwable)cce);
                    throw new CIMProviderException("NOT_INSTANCE_PROVIDER", (Object)pCIMClass.getName(), (Object)provider);
                }
            }
            Debug.trace3((String)"isInstanceProvider returned false");
            throw new CIMProviderException("NOT_INSTANCE_PROVIDER", (Object)pCIMClass.getName(), (Object)provider);
        }
        return realProv;
    }

    public CIMAssociatorProvider getAssociatorProvider(String pNamespace, CIMClass pCIMClass) throws CIMException {
        CIMAssociatorProvider realProv;
        block8: {
            if (this.mShouldReturnNull) {
                return null;
            }
            realProv = null;
            CIMQualifier qual = pCIMClass.getQualifier("provider");
            if (qual == null) {
                Debug.trace3((String)("No 'provider' qualifier found for class: " + pCIMClass));
                return null;
            }
            String provider = this.getProviderString(qual);
            ProviderAdapterIF prov = null;
            try {
                prov = this.getProviderAdapter(pNamespace, provider, pCIMClass);
            }
            catch (ClassNotFoundException cnfe) {
                Debug.trace3((String)"getProviderAdapter threw ClassNotFoundException");
                throw new CIMProviderException("NOe_ASSOCIATOR_PROVIDER", (Object)pCIMClass.getName(), (Object)provider);
            }
            if (prov.isAssociatorProvider()) {
                try {
                    realProv = (CIMAssociatorProvider)prov.getProvider();
                    if (realProv == null) {
                        Debug.trace3((String)"getProvider returned NULL");
                        throw new CIMProviderException("NOe_ASSOCIATOR_PROVIDER", (Object)pCIMClass.getName(), (Object)provider);
                    }
                    break block8;
                }
                catch (ClassCastException cce) {
                    Debug.trace3((String)"Class Cast Exception", (Throwable)cce);
                    throw new CIMProviderException("NOT_ASSOCIATOR_PROVIDER", (Object)pCIMClass.getName(), (Object)provider);
                }
            }
            Debug.trace3((String)"isAssociatorProvider returned false");
            throw new CIMProviderException("NOT_ASSOCIATOR_PROVIDER", (Object)pCIMClass.getName(), (Object)provider);
        }
        return realProv;
    }

    public Authorizable getAuthorizableProvider(String pNamespace, CIMClass pCIMClass) throws CIMException {
        Authorizable realProv;
        block8: {
            if (this.mShouldReturnNull) {
                return null;
            }
            realProv = null;
            CIMQualifier qual = pCIMClass.getQualifier("provider");
            if (qual == null) {
                Debug.trace3((String)("No 'provider' qualifier found for class: " + pCIMClass));
                return null;
            }
            String provider = this.getProviderString(qual);
            ProviderAdapterIF prov = null;
            try {
                prov = this.getProviderAdapter(pNamespace, provider, pCIMClass);
            }
            catch (ClassNotFoundException cnfe) {
                Debug.trace3((String)"getProviderAdapter threw ClassNotFoundException");
                throw new CIMProviderException("NO_AUTHORIZABLE_PROVIDER", (Object)pCIMClass.getName(), (Object)provider);
            }
            if (prov.isAuthorizable()) {
                try {
                    realProv = (Authorizable)prov.getProvider();
                    if (realProv == null) {
                        Debug.trace3((String)"getProvider returned NULL");
                        throw new CIMProviderException("NO_AUTHORIZABLE_PROVIDER", (Object)pCIMClass.getName(), (Object)provider);
                    }
                    break block8;
                }
                catch (ClassCastException cce) {
                    Debug.trace3((String)"Class Cast Exception", (Throwable)cce);
                    throw new CIMProviderException("NOT_AUTHORIZABLE_PROVIDER", (Object)pCIMClass.getName(), (Object)provider);
                }
            }
            Debug.trace3((String)"isAuthorizable returned false");
            throw new CIMProviderException("NOT_AUTHORIZABLE_PROVIDER", (Object)pCIMClass.getName(), (Object)provider);
        }
        return realProv;
    }

    public Authorizable getAuthorizableProvider(String pNamespace, CIMMethod pMethod) throws CIMException {
        Authorizable realProv;
        block8: {
            if (this.mShouldReturnNull) {
                return null;
            }
            realProv = null;
            CIMQualifier qual = pMethod.getQualifier("provider");
            if (qual == null) {
                Debug.trace3((String)("No 'provider' qualifier found for Method: " + pMethod));
                return null;
            }
            String provider = this.getProviderString(qual);
            ProviderAdapterIF prov = null;
            try {
                prov = this.getProviderAdapter(pNamespace, provider, null);
            }
            catch (ClassNotFoundException cnfe) {
                Debug.trace3((String)"getProviderAdapter threw ClassNotFoundException", (Throwable)cnfe);
                throw new CIMProviderException("NO_AUTHORIZABLE_PROVIDER", (Object)pMethod.getName(), (Object)provider);
            }
            if (prov.isAuthorizable()) {
                try {
                    realProv = (Authorizable)prov.getProvider();
                    if (realProv == null) {
                        Debug.trace3((String)"getProvider returned NULL");
                        throw new CIMProviderException("NO_AUTHORIZABLE_PROVIDER", (Object)pMethod.getName(), (Object)provider);
                    }
                    break block8;
                }
                catch (ClassCastException cce) {
                    Debug.trace3((String)"Class Cast Exception", (Throwable)cce);
                    throw new CIMProviderException("NOT_AUTHORIZABLE_PROVIDER", (Object)pMethod.getName(), (Object)provider);
                }
            }
            Debug.trace3((String)"isAuthorizable returned false");
            throw new CIMProviderException("NOT_AUTHORIZABLE_PROVIDER", (Object)pMethod.getName(), (Object)provider);
        }
        return realProv;
    }

    public Authorizable getAuthorizableProvider(String pNamespace, CIMProperty pProp) throws CIMException {
        Authorizable realProv;
        block8: {
            if (this.mShouldReturnNull) {
                return null;
            }
            realProv = null;
            CIMQualifier qual = pProp.getQualifier("provider");
            if (qual == null) {
                Debug.trace3((String)("No 'provider' qualifier found for Property: " + pProp));
                return null;
            }
            String provider = this.getProviderString(qual);
            ProviderAdapterIF prov = null;
            try {
                prov = this.getProviderAdapter(pNamespace, provider, null);
            }
            catch (ClassNotFoundException cnfe) {
                Debug.trace3((String)"getProviderAdapter threw ClassNotFoundException", (Throwable)cnfe);
                throw new CIMProviderException("NO_AUTHORIZABLE_PROVIDER", (Object)pProp.getName(), (Object)provider);
            }
            if (prov.isAuthorizable()) {
                try {
                    realProv = (Authorizable)prov.getProvider();
                    if (realProv == null) {
                        Debug.trace3((String)"getProvider returned NULL");
                        throw new CIMProviderException("NO_AUTHORIZABLE_PROVIDER", (Object)pProp.getName(), (Object)provider);
                    }
                    break block8;
                }
                catch (ClassCastException cce) {
                    Debug.trace3((String)"Class Cast Exception", (Throwable)cce);
                    throw new CIMProviderException("NOT_AUTHORIZABLE_PROVIDER", (Object)pProp.getName(), (Object)provider);
                }
            }
            Debug.trace3((String)"isAuthorizable returned false");
            throw new CIMProviderException("NOT_AUTHORIZABLE_PROVIDER", (Object)pProp.getName(), (Object)provider);
        }
        return realProv;
    }

    public CIMMethodProvider getMethodProvider(String pNamespace, CIMClass pCIMClass) throws CIMException {
        CIMMethodProvider realProv;
        block8: {
            if (this.mShouldReturnNull) {
                return null;
            }
            realProv = null;
            CIMQualifier qual = pCIMClass.getQualifier("provider");
            if (qual == null) {
                Debug.trace3((String)("No 'provider' qualifier found for class: " + pCIMClass));
                return null;
            }
            String provider = this.getProviderString(qual);
            ProviderAdapterIF prov = null;
            try {
                prov = this.getProviderAdapter(pNamespace, provider, pCIMClass);
            }
            catch (ClassNotFoundException cnfe) {
                Debug.trace3((String)"getProviderAdapter threw ClassNotFoundException", (Throwable)cnfe);
                throw new CIMProviderException("NO_METHOD_PROVIDER", (Object)pCIMClass.getName(), (Object)provider);
            }
            if (prov.isMethodProvider()) {
                try {
                    realProv = (CIMMethodProvider)prov.getProvider();
                    if (realProv == null) {
                        Debug.trace3((String)"getProvider returned NULL");
                        throw new CIMProviderException("NO_METHOD_PROVIDER", (Object)pCIMClass.getName(), (Object)provider);
                    }
                    break block8;
                }
                catch (ClassCastException cce) {
                    Debug.trace3((String)"Class Cast Exception", (Throwable)cce);
                    throw new CIMProviderException("NOT_METHOD_PROVIDER", (Object)pCIMClass.getName(), (Object)provider);
                }
            }
            Debug.trace3((String)"isMethodProvider returned false");
            throw new CIMProviderException("NOT_METHOD_PROVIDER", (Object)pCIMClass.getName(), (Object)provider);
        }
        return realProv;
    }

    public CIMMethodProvider getMethodProvider(String pNamespace, CIMMethod pMethod, CIMClass pCIMClass) throws CIMException {
        CIMMethodProvider realProv;
        block8: {
            if (this.mShouldReturnNull) {
                return null;
            }
            realProv = null;
            CIMQualifier qual = pMethod.getQualifier("provider");
            if (qual == null) {
                Debug.trace3((String)("No 'provider' qualifier found for Method: " + pMethod));
                return null;
            }
            String provider = this.getProviderString(qual);
            ProviderAdapterIF prov = null;
            try {
                prov = this.getProviderAdapter(pNamespace, provider, pCIMClass);
            }
            catch (ClassNotFoundException cnfe) {
                Debug.trace3((String)"getProviderAdapter threw ClassNotFoundException", (Throwable)cnfe);
                throw new CIMProviderException("NO_METHOD_PROVIDER", (Object)pMethod.getName(), (Object)provider);
            }
            if (prov.isMethodProvider()) {
                try {
                    realProv = (CIMMethodProvider)prov.getProvider();
                    if (realProv == null) {
                        Debug.trace3((String)"getProvider returned NULL");
                        throw new CIMProviderException("NO_METHOD_PROVIDER", (Object)pMethod.getName(), (Object)provider);
                    }
                    break block8;
                }
                catch (ClassCastException cce) {
                    Debug.trace3((String)"Class Cast Exception", (Throwable)cce);
                    throw new CIMProviderException("NOT_METHOD_PROVIDER", (Object)pMethod.getName(), (Object)provider);
                }
            }
            Debug.trace3((String)"isMethodProvider returned false");
            throw new CIMProviderException("NOT_METHOD_PROVIDER", (Object)pMethod.getName(), (Object)provider);
        }
        return realProv;
    }

    public EventProvider getEventProvider(String pNamespace, CIMClass pCIMClass) throws CIMException {
        EventProvider realProv;
        block8: {
            if (this.mShouldReturnNull) {
                return null;
            }
            realProv = null;
            CIMQualifier qual = pCIMClass.getQualifier("provider");
            if (qual == null) {
                Debug.trace3((String)("No 'provider' qualifier found for class: " + pCIMClass));
                return null;
            }
            String provider = this.getProviderString(qual);
            ProviderAdapterIF prov = null;
            try {
                prov = this.getProviderAdapter(pNamespace, provider, pCIMClass);
            }
            catch (ClassNotFoundException cnfe) {
                Debug.trace3((String)"getProviderAdapter threw ClassNotFoundException", (Throwable)cnfe);
                throw new CIMProviderException("NO_EVENT_PROVIDER", (Object)pCIMClass.getName(), (Object)provider);
            }
            if (prov.isEventProvider()) {
                try {
                    realProv = (EventProvider)prov.getProvider();
                    if (realProv == null) {
                        Debug.trace3((String)"getProvider returned NULL");
                        throw new CIMProviderException("NO_EVENT_PROVIDER", (Object)pCIMClass.getName(), (Object)provider);
                    }
                    break block8;
                }
                catch (ClassCastException cce) {
                    Debug.trace3((String)"Class Cast Exception", (Throwable)cce);
                    throw new CIMProviderException("NOT_EVENT_PROVIDER", (Object)pCIMClass.getName(), (Object)provider);
                }
            }
            Debug.trace3((String)"isEventProvider returned false");
            throw new CIMProviderException("NOT_EVENT_PROVIDER", (Object)pCIMClass.getName(), (Object)provider);
        }
        return realProv;
    }

    public CIMIndicationProvider getCIMIndicationProvider(String pNamespace, CIMClass pCIMClass) throws CIMException {
        CIMIndicationProvider realProv;
        block8: {
            if (this.mShouldReturnNull) {
                return null;
            }
            realProv = null;
            CIMQualifier qual = pCIMClass.getQualifier("provider");
            if (qual == null) {
                Debug.trace3((String)("No 'provider' qualifier found for class: " + pCIMClass));
                return null;
            }
            String provider = this.getProviderString(qual);
            ProviderAdapterIF prov = null;
            try {
                prov = this.getProviderAdapter(pNamespace, provider, pCIMClass);
            }
            catch (ClassNotFoundException cnfe) {
                Debug.trace3((String)"getProviderAdapter threw ClassNotFoundException", (Throwable)cnfe);
                throw new CIMProviderException("NO_INDICATION_PROVIDER", (Object)pCIMClass.getName(), (Object)provider);
            }
            if (prov.isCIMIndicationProvider()) {
                try {
                    realProv = (CIMIndicationProvider)prov.getProvider();
                    if (realProv == null) {
                        Debug.trace3((String)"getProvider returned NULL");
                        throw new CIMProviderException("NO_INDICATION_PROVIDER", (Object)pCIMClass.getName(), (Object)provider);
                    }
                    break block8;
                }
                catch (ClassCastException cce) {
                    Debug.trace3((String)"Class Cast Exception", (Throwable)cce);
                    throw new CIMProviderException("NOT_INDICATION_PROVIDER", (Object)pCIMClass.getName(), (Object)provider);
                }
            }
            Debug.trace3((String)"isCIMIndicationProvider returned false");
            throw new CIMProviderException("NOT_INDICATION_PROVIDER", (Object)pCIMClass.getName(), (Object)provider);
        }
        return realProv;
    }

    private ProviderAdapterIF getProviderAdapter(String pNamespace, String pQualString, CIMClass pCimClass) throws CIMClassException, CIMException, ClassNotFoundException {
        String providerName = this.getProviderName(pQualString);
        Debug.trace3((String)("Need to get provider named " + providerName));
        Object providerKey = this.mProviders.get(providerName);
        ProviderProtocolAdapterIF adapter = null;
        try {
            String providerProtocol = this.getProtocol(pQualString);
            Debug.trace3((String)("Need to get provider protocol adapter " + providerProtocol));
            adapter = (ProviderProtocolAdapterIF)this.mAdapters.get(providerProtocol);
            if (adapter == null) {
                Debug.trace3((String)("Did not find provider protocol adapter for: " + providerProtocol));
                throw new CIMProviderException("UNKNOWN_PROVIDER_ADAPTER", (Object)providerProtocol);
            }
        }
        catch (Exception e) {
            Debug.trace2((String)"Caught Exception at ProviderAdapterIF.getProviderAdapter", (Throwable)e);
            throw new CIMClassException(e.toString());
        }
        if (providerKey == null) {
            Debug.trace3((String)"Loading provider from adapter");
            providerKey = adapter.loadProvider(pNamespace, providerName, this.getProviderParams(pQualString), pCimClass);
            this.mProviders.put(providerName, providerKey);
        }
        Debug.trace3((String)"Getting provider adapter interface");
        ProviderAdapterIF ret = adapter.getProviderAdapter(providerKey);
        Debug.trace3((String)("Got adapter interface " + ret));
        return ret;
    }

    private String getProtocol(String providerQual) {
        int index = providerQual.indexOf(58);
        Debug.trace3((String)"getting protocol");
        if (index < 0) {
            Debug.trace3((String)"No provider qualifier, defaulting to 'sunjava'");
            return "sunjava";
        }
        String protocol = providerQual.substring(0, index);
        Debug.trace3((String)("Protocol: " + protocol));
        return protocol;
    }

    private String getProviderName(String providerQual) throws CIMException {
        int index2;
        int index = providerQual.indexOf(58);
        int length = providerQual.length();
        if (index < 0) {
            return providerQual;
        }
        if (index == length - 1) {
            Debug.trace3((String)("Invalid provider qualifier: " + providerQual));
            throw new CIMException("CIM_ERR_INVALID_PARAMETER", providerQual);
        }
        if ((index2 = providerQual.indexOf(58, ++index)) < 0) {
            index2 = length;
        }
        String providerString = providerQual.substring(index, index2);
        Debug.trace3((String)("Provider: " + providerString));
        return providerString;
    }

    private String[] getProviderParams(String providerQual) {
        int index2;
        int index = providerQual.indexOf(58);
        int length = providerQual.length();
        if (index < 0 || index == length - 1) {
            return new String[0];
        }
        if ((index2 = providerQual.indexOf(58, ++index)) < 0) {
            return new String[0];
        }
        index = 0;
        String params = providerQual.substring(++index2);
        StringTokenizer tok = new StringTokenizer(params, ",");
        String[] paramsArray = new String[tok.countTokens()];
        while (tok.hasMoreTokens()) {
            paramsArray[index] = tok.nextToken();
            ++index;
        }
        return paramsArray;
    }

    private String getProviderString(CIMQualifier pQual) throws CIMClassException, CIMException {
        if (pQual == null) {
            throw new CIMClassException("CIM_ERR_NOT_FOUND", (Object)"Invalid qualifier, can not be null!");
        }
        String qual = (String)pQual.getValue().getValue();
        if (pQual == null) {
            throw new CIMClassException("CIM_ERR_NOT_FOUND", (Object)"Invalid provider qualifier, no value found!");
        }
        return qual;
    }

    void startAdapters() throws CIMException {
        CIMInstance ci = null;
        try {
            CIMObjectPath cop = new CIMObjectPath(PPACIMCLASS);
            cop.setNameSpace("/interop");
            CIMInstance[] protocols = this.adapterProvider.enumerateInstances(cop, false, true, true, null, null);
            for (int i = 0; i < protocols.length; ++i) {
                ci = protocols[i];
                this.handleAdapterInstance(ci);
                ci = null;
            }
        }
        catch (Exception e) {
            Debug.trace1((String)("Provider registration failed: " + (ci == null ? "no provider" : ci.getObjectPath().toString())), (Throwable)e);
        }
    }

    private void handleAdapterInstance(CIMInstance ci) throws CIMException {
        Debug.trace3((String)("Handling provider protocol " + ci));
        try {
            String protocolType;
            CIMProperty pathProp = ci.getProperty(CLASSPATH);
            CIMValue pathVal = pathProp.getValue();
            String[] path = new String[]{};
            if (pathVal != null && !pathVal.isNull() && pathVal.getType().getType() == 22) {
                Vector vec = (Vector)pathVal.getValue();
                path = vec.toArray(new String[vec.size()]);
            }
            DynClassLoader dcl = new DynClassLoader(path, this.getClass().getClassLoader());
            CIMProperty cp = ci.getProperty(IMPLCLASS);
            CIMValue cv = cp.getValue();
            String className = (String)cv.getValue();
            Class<?> cl = dcl.loadClass(className);
            String automatic = "";
            try {
                automatic = (String)ci.getProperty("StartMode").getValue().getValue();
            }
            catch (Exception ex) {
                // empty catch block
            }
            try {
                protocolType = (String)ci.getProperty(PROTOCOLTYPE).getValue().getValue();
            }
            catch (NullPointerException ex) {
                throw new CIMPropertyException("CIM_ERR_INVALID_PARAMETER", (Object)PROTOCOLTYPE);
            }
            if (protocolType.trim().length() == 0) {
                throw new CIMPropertyException("CIM_ERR_INVALID_PARAMETER", (Object)PROTOCOLTYPE);
            }
            if (protocolType.equals("internal")) {
                throw new CIMPropertyException("CIM_ERR_INVALID_PARAMETER", (Object)"internal");
            }
            ProviderProtocolAdapterIF adapter = (ProviderProtocolAdapterIF)cl.newInstance();
            boolean isAuto = false;
            if (automatic.equalsIgnoreCase("Automatic")) {
                isAuto = true;
            }
            this.RegisterProtocolProvider(protocolType, adapter, isAuto);
        }
        catch (CIMException e) {
            throw e;
        }
        catch (Exception e) {
            Debug.trace2((String)"Adapter exception", (Throwable)e);
            throw new CIMException("CIM_ERR_FAILED", e.toString());
        }
    }

    private static class AdapterAssocProvider
    extends OneToManyAssocProvider {
        private static final CIMObjectPath PPA_CLASS_OP = new CIMObjectPath("WBEMServices_ObjectManagerProviderProtocolAdapter", "/interop");

        private AdapterAssocProvider() {
        }

        protected String getOneRole(CIMObjectPath assocName) {
            return "Antecedent";
        }

        protected String getManyRole(CIMObjectPath assocName) {
            return "Dependent";
        }

        protected CIMObjectPath getManyClass(CIMObjectPath assocName) {
            return PPA_CLASS_OP;
        }

        protected CIMObjectPath getOneClass(CIMObjectPath assocName) {
            return CIMOMProvider.CLASSOP;
        }
    }

    private class AdapterProvider
    implements CIMInstanceProvider,
    CIMMethodProvider {
        CIMInstanceProvider internalProvider;

        public AdapterProvider() {
            this.internalProvider = ProviderAdapterFactory.this.mCimom.getInternalCIMInstanceProvider();
        }

        public CIMObjectPath[] enumerateInstanceNames(CIMObjectPath op, CIMClass cc) throws CIMException {
            return this.internalProvider.enumerateInstanceNames(op, cc);
        }

        public CIMInstance[] enumerateInstances(CIMObjectPath op, boolean localOnly, boolean includeQualifiers, boolean includeClassOrigin, String[] propList, CIMClass cc) throws CIMException {
            return this.internalProvider.enumerateInstances(op, localOnly, includeQualifiers, includeClassOrigin, propList, cc);
        }

        public CIMInstance getInstance(CIMObjectPath op, boolean localOnly, boolean includeQualifiers, boolean includeClassOrigin, String[] propList, CIMClass cc) throws CIMException {
            return this.internalProvider.getInstance(op, localOnly, includeQualifiers, includeClassOrigin, propList, cc);
        }

        public synchronized CIMObjectPath createInstance(CIMObjectPath op, CIMInstance ci) throws CIMException {
            CIMObjectPath retVal = this.internalProvider.createInstance(op, ci);
            try {
                ProviderAdapterFactory.this.handleAdapterInstance(ci);
            }
            catch (CIMException e) {
                CIMObjectPath lop = new CIMObjectPath();
                lop.setNameSpace(op.getNameSpace());
                lop.setObjectName(op.getObjectName());
                lop.setKeys(ci.getKeys());
                this.internalProvider.deleteInstance(lop);
                throw e;
            }
            return retVal;
        }

        public synchronized void setInstance(CIMObjectPath op, CIMInstance ci, boolean includeQualifier, String[] propertyList) throws CIMException {
            throw new CIMException("CIM_ERR_NOT_SUPPORTED");
        }

        public synchronized void deleteInstance(CIMObjectPath op) throws CIMException {
            String protocolType;
            CIMInstance ci = this.getInstance(op, false, false, false, null, null);
            try {
                protocolType = (String)ci.getProperty(ProviderAdapterFactory.PROTOCOLTYPE).getValue().getValue();
            }
            catch (NullPointerException ex) {
                throw new CIMPropertyException("CIM_ERR_INVALID_PARAMETER", (Object)ProviderAdapterFactory.PROTOCOLTYPE);
            }
            ProviderAdapterFactory.this.UnRegisterProtocolProvider(protocolType);
            this.internalProvider.deleteInstance(op);
        }

        public void initialize(CIMOMHandle ch) {
        }

        public void cleanup() {
        }

        public CIMInstance[] execQuery(CIMObjectPath op, String query, String ql, CIMClass cc) throws CIMException {
            return this.internalProvider.execQuery(op, query, ql, cc);
        }

        public CIMValue invokeMethod(CIMObjectPath op, String methodName, CIMArgument[] inArgs, CIMArgument[] outArgs) throws CIMException {
            String protocolType;
            CIMInstance ci = this.getInstance(op, false, false, false, null, null);
            try {
                protocolType = (String)ci.getProperty(ProviderAdapterFactory.PROTOCOLTYPE).getValue().getValue();
            }
            catch (NullPointerException e) {
                Debug.trace1((String)"Caught NullPointerException at AdapterProvider.invokeMethod", (Throwable)e);
                return new CIMValue((Object)new Integer(2));
            }
            ProviderProtocolAdapterIF adapter = (ProviderProtocolAdapterIF)ProviderAdapterFactory.this.mAdapters.get(protocolType);
            if (adapter == null) {
                return new CIMValue((Object)new Integer(3));
            }
            if (methodName.equalsIgnoreCase(ProviderAdapterFactory.STARTSERVICE)) {
                adapter.start();
            } else {
                adapter.stop();
            }
            return new CIMValue((Object)new Integer(0));
        }
    }
}

