/*
 * Decompiled with CFR 0.152.
 */
package org.wbemservices.wbem.cimom;

import java.io.File;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.MessageDigest;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.util.Arrays;
import javax.wbem.cim.CIMException;
import javax.wbem.client.CIMSecurityException;
import javax.wbem.client.Debug;
import javax.wbem.security.SecurityMessage;
import javax.wbem.security.SecurityToken;
import javax.wbem.security.SecurityUtil;
import org.wbemservices.wbem.cimom.CommonServerSecurityContext;
import org.wbemservices.wbem.cimom.security.UserPasswordProvider;
import org.wbemservices.wbem.client.adapter.rmi.RemoteCIMListener;

public final class ServerSecurity
implements CommonServerSecurityContext {
    public static final long AUDIT_NO_SUCH_USER = -1L;
    public static final long AUDIT_BAD_PASSWD = -2L;
    public static final long AUDIT_SUCCESS = 1L;
    private static final String WBEM_LOCAL_TYPE = "__LOCAL";
    private static final String WBEM_LOCAL_DIR = "/var/sadm/wbem/security";
    private static final int WBEM_LOCAL_NONCE_SIZE = 16;
    private static ThreadLocal requestSession = new ThreadLocal();
    protected static byte[] adminCred = null;
    private static boolean initialized = false;
    private static KeyPairGenerator keygen;
    private static KeyPair keypair;
    private static Signature signer;
    private static PrivateKey sprivkey;
    private static PublicKey spubkey;
    private MessageDigest md = null;
    private PublicKey cpubkey;
    private String userName = null;
    private String roleName = null;
    private String authName = null;
    private String localFile = null;
    private String clientHost = null;
    private String initialKey = "InitialKey";
    private byte[] schallenge1;
    private byte[] sessionId = null;
    private byte[] sessionKey = null;
    private byte[] decryptKey = null;
    private byte[] auditKey = null;
    private byte[] sf;
    private byte[] nameSpace;
    private String cp = null;
    private String cversion;
    private String cap = "none";
    private String capNameSpace = "__junk__";
    private boolean bLocalMode = false;
    private static UserPasswordProvider upp;
    private RemoteCIMListener rl = null;
    private static final int MAX_DATA_SIZE = 15;

    static UserPasswordProvider getUserPasswordProvider() throws Exception {
        if (upp == null) {
            try {
                Class<?> c = Class.forName(System.getProperty("org.wbemservices.wbem.cimom.pswdprov"));
                upp = (UserPasswordProvider)c.newInstance();
            }
            catch (Exception e) {
                Debug.trace1((String)"Sundigest: Error getting password provider", (Throwable)e);
                throw e;
            }
        }
        return upp;
    }

    public ServerSecurity() throws Exception {
        if (!initialized) {
            signer = Signature.getInstance("DSA");
            keygen = KeyPairGenerator.getInstance("DSA");
            keygen.initialize(1024, SecurityUtil.secrand);
            keypair = keygen.generateKeyPair();
            sprivkey = keypair.getPrivate();
            spubkey = keypair.getPublic();
            initialized = true;
        }
        upp = ServerSecurity.getUserPasswordProvider();
        this.md = MessageDigest.getInstance("MD5");
    }

    public ServerSecurity(String userName, String roleName, String hostname, byte[] auditKey) {
        this.userName = userName;
        this.roleName = roleName;
        this.setClientHostName(hostname);
        ServerSecurity.setRequestSession(this);
        this.auditKey = auditKey;
    }

    public String getClientVersion() {
        return this.cversion;
    }

    public String getCapability() {
        return this.cap;
    }

    public String getCapabilityNS() {
        return this.capNameSpace;
    }

    public byte[] getSessionId() {
        return this.sessionId;
    }

    public byte[] getChallenge() {
        return this.schallenge1;
    }

    public String getPasswd() {
        return this.cp;
    }

    public byte[] getNameSpace() {
        return this.nameSpace;
    }

    public byte[] getShadow() {
        return this.sf;
    }

    public byte[] getSessionKey() {
        return this.sessionKey;
    }

    public PublicKey getPublicKey() {
        return spubkey;
    }

    public PublicKey getClientPublicKey() {
        return this.cpubkey;
    }

    public PrivateKey getPrivateKey() {
        return sprivkey;
    }

    public MessageDigest getMD() {
        return this.md;
    }

    public Signature getSigner() {
        return signer;
    }

    public RemoteCIMListener getListener() {
        return this.rl;
    }

    public void setCapability(String cap) {
        this.cap = cap;
    }

    public void setCapabilityNS(String ns) {
        this.capNameSpace = ns;
    }

    public void setClientHostName(String hostName) {
        this.clientHost = hostName;
    }

    public void setListener(RemoteCIMListener rl) {
        this.rl = rl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SecurityMessage generateChallenge(String version, SecurityMessage cm, byte[] sessionId) throws CIMException {
        int i;
        byte[] cchallenge1;
        block15: {
            if (!cm.isHello()) {
                throw new CIMSecurityException("NOT_HELLO");
            }
            this.cversion = version;
            this.sessionId = sessionId;
            cchallenge1 = cm.getChallenge();
            this.md.reset();
            this.md.update(cchallenge1);
            byte[] userHash = this.md.digest(this.initialKey.getBytes());
            this.md.reset();
            this.md.update(cchallenge1);
            this.md.update(this.initialKey.getBytes());
            this.md.update(cm.getUserDigest());
            this.md.update(cm.getNameSpace());
            if (!MessageDigest.isEqual(this.md.digest(), cm.getChecksum())) {
                Debug.trace1((String)"Sundigest: user authentication; request checksum error");
                throw new CIMSecurityException("CHECKSUM_ERROR");
            }
            byte[] unb = SecurityUtil.extractHashedData((byte[])cm.getUserDigest(), (byte[])userHash);
            this.nameSpace = SecurityUtil.extractHashedData((byte[])cm.getNameSpace(), (byte[])userHash);
            this.userName = new String(unb);
            if (unb == null) {
                Debug.trace1((String)"Sundigest: user authentication; no user name");
                upp.auditLogin(this.clientHost, this.userName, -1L);
                throw new CIMSecurityException("NO_SUCH_PRINCIPAL", null);
            }
            this.authName = new String(unb);
            Debug.trace3((String)("Sundigest: user = " + this.authName));
            i = this.authName.indexOf(58);
            if (i > 0) {
                this.userName = this.authName.substring(0, i);
                if (this.authName.length() > i && this.authName.substring(i + 1).equals(WBEM_LOCAL_TYPE)) {
                    this.bLocalMode = true;
                    break block15;
                } else {
                    Debug.trace1((String)("Sundigest: invalid user type: " + this.authName));
                    throw new CIMSecurityException("NO_SUCH_PRINCIPAL", (Object)"INVALID_TYPE");
                }
            }
            this.userName = this.authName;
            this.bLocalMode = false;
        }
        String shadow = upp.getEncryptedPassword(this.userName, 1);
        if (shadow == null || shadow.length() == 0) {
            Debug.trace1((String)("Sundigest: user authentication; bad user name: " + this.userName));
            upp.auditLogin(this.clientHost, this.userName, -1L);
            throw new CIMSecurityException("NO_SUCH_PRINCIPAL", (Object)this.userName);
        }
        byte[] salt = null;
        if (this.bLocalMode) {
            this.sf = new byte[16];
            SecurityUtil.secrand.nextBytes(this.sf);
            Debug.trace3((String)("Sundigest: shared secret: " + SecurityUtil.toHex((byte[])this.sf)));
            byte[] hnb = SecurityUtil.hashData((byte[])this.sf, (byte[])cchallenge1);
            String hnx = SecurityUtil.toHex((byte[])hnb);
            this.localFile = null;
            try {
                this.localFile = upp.writeLocalAuthenticator(this.userName, WBEM_LOCAL_DIR, hnx);
                i = this.localFile.lastIndexOf(File.separatorChar);
                if (i > 0) {
                    this.localFile = this.localFile.substring(i + 1);
                }
                String sSalt = "$__LOCAL$" + this.localFile;
                salt = sSalt.getBytes("UTF-8");
            }
            catch (Exception ex) {
                Debug.trace1((String)("Sundigest: error writing local auth file: " + ex.getMessage()));
                throw new CIMSecurityException("CIM_ERR_FAILED", (Object)"WRITE_LOCAL_AUTHENTICATOR");
            }
        }
        if (shadow.charAt(0) != '$') {
            this.sf = shadow.getBytes();
            salt = new byte[]{this.sf[0], this.sf[1]};
        } else {
            i = shadow.lastIndexOf(36);
            try {
                this.sf = shadow.substring(i + 1).getBytes();
                salt = shadow.substring(0, i).getBytes();
            }
            catch (Exception ex) {
                Debug.trace1((String)("Sundigest: bad password encryption: " + shadow));
                throw new CIMSecurityException("INVALID_CREDENTIAL");
            }
        }
        Debug.trace3((String)("Sundigest: shared secret: " + new String(this.sf)));
        Debug.trace3((String)("Sundigest: salt = " + new String(salt)));
        Debug.trace3((String)("Sundigest: request valid: " + this.userName));
        this.schallenge1 = new byte[16];
        SecurityUtil.secrand.nextBytes(this.schallenge1);
        this.md.reset();
        this.md.update(this.schallenge1);
        this.md.update(this.initialKey.getBytes());
        byte[] digest = this.md.digest();
        byte[] hashedSalt = SecurityUtil.hashData((byte[])salt, (byte[])digest);
        this.md.reset();
        this.md.update(this.schallenge1);
        this.md.update(this.initialKey.getBytes());
        this.md.update(hashedSalt);
        return SecurityMessage.challenge((byte[])this.schallenge1, (byte[])hashedSalt, (byte[])sessionId, (byte[])this.md.digest(sessionId));
    }

    public SecurityMessage validateResponse(byte[] challenge, byte[] f, PublicKey pubkey, byte[] sessionKey, SecurityMessage cm) throws CIMException {
        if (this.bLocalMode) {
            this.removeLocalFile();
        }
        if (!cm.isResponse()) {
            throw new CIMSecurityException("NOT_RESPONSE");
        }
        this.sessionKey = sessionKey;
        this.cpubkey = cm.getPublicKey();
        this.md.reset();
        this.md.update(challenge);
        this.md.update(this.initialKey.getBytes());
        byte[] digest = this.md.digest(f);
        this.md.reset();
        this.md.update(challenge);
        this.md.update(this.initialKey.getBytes());
        this.md.update(f);
        this.md.update(cm.getResponse());
        this.md.update(cm.getPublicKey().getEncoded());
        this.md.update(cm.getSessionId());
        if (!MessageDigest.isEqual(this.md.digest(), cm.getChecksum())) {
            Debug.trace1((String)("Sundigest: invalid credentials: " + this.userName));
            upp.auditLogin(this.clientHost, this.userName, -2L);
            throw new CIMSecurityException("INVALID_CREDENTIAL");
        }
        byte[] response = SecurityUtil.extractHashedData((byte[])cm.getResponse(), (byte[])digest);
        if (response == null) {
            upp.auditLogin(this.clientHost, this.userName, -2L);
            throw new CIMSecurityException("INVALID_CREDENTIAL");
        }
        boolean bOk = false;
        if (this.bLocalMode) {
            if (Arrays.equals(response, f)) {
                bOk = true;
            }
        } else {
            try {
                bOk = upp.authenticateUser(this.userName, new String(response, "UTF-8"));
            }
            catch (Exception utfexc) {
                Debug.trace1((String)("Sundigest: error creating password string with UTF-8 converter: " + utfexc.getMessage()));
            }
        }
        if (!bOk) {
            Debug.trace1((String)("Sundigest: invalid credentials: " + this.userName));
            upp.auditLogin(this.clientHost, this.userName, -2L);
            throw new CIMSecurityException("INVALID_CREDENTIAL");
        }
        Debug.trace1((String)("Sundigest: client authenticated: " + this.userName));
        this.decryptKey = new byte[sessionKey.length];
        System.arraycopy(sessionKey, 0, this.decryptKey, 0, this.decryptKey.length);
        this.auditKey = new byte[4];
        System.arraycopy(sessionKey, 0, this.auditKey, 0, 4);
        this.md.reset();
        this.md.update(challenge);
        digest = this.md.digest(response);
        byte[] hashedKey = SecurityUtil.hashData((byte[])sessionKey, (byte[])digest);
        this.md.reset();
        this.md.update(challenge);
        this.md.update(response);
        this.md.update(cm.getSessionId());
        this.md.update(pubkey.getEncoded());
        upp.auditLogin(this.clientHost, this.userName, 1L);
        return SecurityMessage.result((byte[])cm.getSessionId(), (PublicKey)pubkey, (byte[])hashedKey, (byte[])this.md.digest(hashedKey));
    }

    public void assumeRole(String role_name, String encr_pswd) throws CIMException {
        String role_pswd = this.trans51Unformat(encr_pswd);
        if (!upp.authenticateRole(role_name, role_pswd, this.userName)) {
            Debug.trace1((String)("Solarisdigest: role assumption; : Could not assume role " + role_name + " for user " + this.userName));
            upp.auditLogin(this.clientHost, role_name, -2L);
            throw new CIMSecurityException("CANNOT_ASSUME_ROLE", (Object)this.userName, (Object)role_name);
        }
        this.roleName = role_name;
        Debug.trace1((String)("Solarisdigest: role assumed: " + this.roleName));
        upp.auditLogin(this.clientHost, role_name, 1L);
    }

    public void authenticateRequest(String[] sarray, SecurityToken st) throws CIMException {
        ServerSecurity.setRequestSession(this);
        MessageDigest digester = this.getMD();
        String s = "";
        for (int i = 0; i < sarray.length; ++i) {
            s = s + sarray[i];
        }
        byte[] ser = s.getBytes();
        digester.reset();
        digester.update(this.getSessionKey());
        digester.update(ser);
        byte[] digest = digester.digest();
        if (!MessageDigest.isEqual(digest, st.getChecksum())) {
            Debug.trace1((String)"Sundigest: method authentication; invalid digest");
            throw new CIMSecurityException("CHECKSUM_ERROR");
        }
    }

    public void incSessionKey() {
        SecurityUtil.incByteArray((byte[])this.sessionKey);
    }

    public String trans51Unformat(String inData) {
        byte[] pwb = SecurityUtil.fromHex((String)inData);
        if (pwb == null) {
            return null;
        }
        if (this.decryptKey == null) {
            return null;
        }
        int len = this.decryptKey.length;
        byte[] rb = new byte[len];
        System.arraycopy(this.decryptKey, 0, rb, 0, len);
        boolean sw = true;
        int j = 0;
        int k = len;
        for (int i = 0; i < k; ++i) {
            int n = i;
            rb[n] = (byte)(rb[n] ^ pwb[i]);
            if (!sw || rb[i] != 0) continue;
            sw = false;
            j = i;
        }
        if (j < 1 || j > 15) {
            return null;
        }
        String sval = new String(rb, 0, j);
        return sval;
    }

    public static void setRequestSession(CommonServerSecurityContext newCtx) {
        requestSession.set(newCtx);
    }

    static CommonServerSecurityContext getRequestSession() {
        return (CommonServerSecurityContext)requestSession.get();
    }

    public String getUserName() {
        return this.userName;
    }

    public String getRoleName() {
        return this.roleName;
    }

    public String getClientHostName() {
        return this.clientHost;
    }

    public int getAuditId() {
        int i = 0;
        if (this.auditKey != null) {
            i = (this.auditKey[0] & 0xFF) << 24;
            i |= (this.auditKey[1] & 0xFF) << 16;
            i |= (this.auditKey[2] & 0xFF) << 8;
            i |= this.auditKey[3] & 0xFF;
        }
        return i;
    }

    private void removeLocalFile() {
        if (this.localFile != null && this.localFile.length() > 0) {
            try {
                File fd = new File(WBEM_LOCAL_DIR + File.separator + this.localFile);
                fd.delete();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    static {
        upp = null;
    }
}

