/*
 * Decompiled with CFR 0.152.
 */
package org.wbemservices.wbem.cimom.adapters.client.http;

import java.io.DataOutputStream;
import java.io.IOException;
import java.net.PasswordAuthentication;
import java.util.StringTokenizer;
import javax.wbem.client.Debug;
import javax.wbem.client.adapter.http.transport.HttpServerRequestHandler;
import javax.wbem.client.adapter.http.transport.InboundRequest;
import org.w3c.dom.Document;
import org.wbemservices.wbem.cimom.CIMOMServer;
import org.wbemservices.wbem.cimom.adapters.client.http.BASE64Decoder;
import org.wbemservices.wbem.cimom.adapters.client.http.XmlResponder;
import org.wbemservices.wbem.cimom.security.UserPasswordProvider;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

class CIMRequestHandler
extends HttpServerRequestHandler {
    private String servername;
    private CIMOMServer cimom = null;
    private PasswordAuthentication auth;
    private UserPasswordProvider upp = null;

    CIMRequestHandler(CIMOMServer cimom, String serverName) throws Exception {
        this.cimom = cimom;
        this.upp = this.getUserPasswordProvider();
    }

    public boolean checkAuthentication(InboundRequest request) {
        String str = request.getHeaderField("Authorization");
        if (str == null) {
            request.setRespondHeaderField("WWW-Authenticate", "Basic realm=\"" + this.getRealm() + "\"");
            try {
                Document xmlDoc = this.getXmlDocument(request);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return false;
        }
        this.auth = this.verifyAuthentication(str);
        return this.auth != null;
    }

    public void addResponseHeaderFields(InboundRequest request) {
        request.setRespondHeaderField("CIMOperation", "MethodResponse");
    }

    public void handleRequest(InboundRequest request) {
        try {
            Document xmlDoc = this.getXmlDocument(request);
            DataOutputStream out = new DataOutputStream(request.getResponseOutputStream());
            this.rpc(xmlDoc, this.auth, out);
        }
        catch (SAXException e) {
            DataOutputStream out = new DataOutputStream(request.getResponseOutputStream());
            Exception x = e.getException();
            String message = "Parse Error with Request:\n";
            if (x == null) {
                x = e;
            }
            if (e instanceof SAXParseException) {
                SAXParseException spe = (SAXParseException)e;
                message = message + "** URI: " + spe.getSystemId() + "\n";
                message = message + "** Line: " + spe.getLineNumber() + "\n";
            }
            this.do500Error(out, "XML Parsing error: <b>" + message + "</b>");
            Debug.trace1((String)("HTTP: CIMRequestHandler.handleRequest: " + message));
            Debug.trace1((String)"HTTP: CIMRequestHandler.handleRequest", (Throwable)e);
        }
        catch (IOException e) {
            Debug.trace1((String)"HTTP: CIMRequestHandler.handleRequest", (Throwable)e);
        }
        catch (Exception e) {
            Debug.trace1((String)"HTTP: CIMRequestHandler.handleRequest", (Throwable)e);
        }
    }

    private UserPasswordProvider getUserPasswordProvider() throws Exception {
        UserPasswordProvider tupp = null;
        try {
            Class<?> c = Class.forName(System.getProperty("org.wbemservices.wbem.cimom.pswdprov"));
            tupp = (UserPasswordProvider)c.newInstance();
        }
        catch (Exception e) {
            Debug.trace1((String)"Http: error getting password provider", (Throwable)e);
            throw e;
        }
        return tupp;
    }

    private PasswordAuthentication verifyAuthentication(String authenticator) {
        PasswordAuthentication auth = null;
        String auth_type = null;
        String auth_value = null;
        if (authenticator != null) {
            StringTokenizer st = new StringTokenizer(authenticator);
            try {
                auth_type = st.nextToken();
                auth_value = st.nextToken();
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        if (auth_type != null && auth_value != null && auth_type.equalsIgnoreCase("Basic")) {
            byte[] ba;
            BASE64Decoder decoder = new BASE64Decoder();
            try {
                ba = decoder.decodeBuffer(auth_value);
            }
            catch (Exception ex) {
                ba = new byte[]{};
            }
            int j = ba.length;
            char[] ca = new char[j];
            int k = 0;
            for (int i = 0; i < j; ++i) {
                ca[i] = (char)ba[i];
                if (ca[i] != ':') continue;
                k = i;
            }
            if (k > 0) {
                String username = new String(ca, 0, k);
                int len = j - k - 1;
                char[] password = new char[len];
                for (int i = 0; i < len; ++i) {
                    password[i] = ca[++k];
                }
                String userpswd = new String(password);
                if (this.upp != null) {
                    try {
                        if (this.upp.authenticateUser(username, userpswd)) {
                            auth = new PasswordAuthentication(username, password);
                            Debug.trace1((String)("Http: client authenticated: " + username));
                        }
                    }
                    catch (Exception ex) {
                        auth = null;
                    }
                    if (auth == null) {
                        Debug.trace1((String)("Http: invalid credentials: " + username));
                    }
                }
            }
        }
        if (auth == null) {
            Debug.trace1((String)"Http: invalid authentication");
        }
        return auth;
    }

    private String getRealm() {
        String realm = "wbem@" + this.servername;
        return realm;
    }

    private void rpc(Document request, PasswordAuthentication auth, DataOutputStream out) {
        try {
            XmlResponder rsp = new XmlResponder(this.cimom);
            rsp.getResponse(request, auth, out);
        }
        catch (IOException e) {
            Debug.trace1((String)"CIMRequstHandler: rpc", (Throwable)e);
        }
        catch (SAXException e) {
            Debug.trace1((String)"CIMRequstHandler: rpc", (Throwable)e);
        }
    }
}

