/*
 * Decompiled with CFR 0.152.
 */
package org.wbemservices.wbem.cimom.adapters.client.http;

import java.net.InetAddress;
import java.util.Vector;
import javax.wbem.cim.CIMClass;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMValue;
import javax.wbem.cim.UnsignedInt16;
import javax.wbem.cim.UnsignedInt32;
import javax.wbem.client.CIMOMHandle;
import javax.wbem.client.Debug;
import javax.wbem.client.adapter.http.transport.HttpServerEndpoint;
import javax.wbem.client.adapter.http.transport.RequestHandler;
import org.wbemservices.wbem.cimom.CIMOMServer;
import org.wbemservices.wbem.cimom.DeliveryHandler;
import org.wbemservices.wbem.cimom.adapter.client.ClientProtocolAdapterIF;
import org.wbemservices.wbem.cimom.adapters.client.http.CIMRequestHandler;
import org.wbemservices.wbem.cimom.adapters.client.http.HttpIndicationHandler;

public class HttpService
implements ClientProtocolAdapterIF {
    private static final String PORT = "PortNumber";
    private final String XMLHTTPDELIVERYCLASS = "CIM_IndicationHandlerCIMXML";
    private final String XMLHTTLISTENERDESTINATIONCLASS = "CIM_ListenerDestinationCIMXML";
    private final String CIMXMLCOMMUNICATIONMECHANISM = "CIM_CIMXMLCommunicationMechanism";
    private final String DEFAULTNS = "/interop";
    private final String SYSCREATIONCLASSNAME = "SystemCreationClassName";
    private final String SYSNAME = "SystemName";
    private final String CREATIONCLASSNAME = "CreationClassName";
    private final String COMMUNICATIONMECHANISM = "CommunicationMechanism";
    private final String NAME = "Name";
    private final String WBEMSERVICES_OBJECTMANAGER = "WBEMServices_ObjectManager";
    private final String PROFILESSUPPORTED = "FunctionalProfilesSupported";
    private final String MULTIPLEOPERATIONSSUPPORTED = "MultipleOperationsSupported";
    private final String QUERYLANGUAGESSUPPORTED = "QueryLanguagesSupported";
    private final String AUTHMECHANISMSSUPPORTED = "AuthenticationMechanismsSupported";
    private final String XMLPROTOCOLVERSION = "CIMXMLProtocolVersion";
    private final String VALIDATED = "CIMValidated";
    private final String WQL1 = "WBEMSQL1";
    protected String communicationMechanismName = "cim-xml";
    private String servername;
    private CIMOMServer cimom = null;
    private CIMOMHandle ch = null;
    private int port;
    private HttpServerEndpoint serverEndPoint;
    private CIMObjectPath commMechOp;
    boolean useSSL = false;

    public HttpService() throws Exception {
        try {
            this.servername = InetAddress.getLocalHost().getHostName();
        }
        catch (Exception ex) {
            this.servername = "??";
        }
    }

    public HttpService(CIMOMServer cimomHandle) throws Exception {
        this();
        this.cimom = cimomHandle;
    }

    public void initialize(CIMOMServer cimomHandle, CIMOMHandle ch) {
        this.cimom = cimomHandle;
        this.ch = ch;
        DeliveryHandler.registerIndicationHandler("CIM_IndicationHandlerCIMXML", new HttpIndicationHandler());
        DeliveryHandler.registerIndicationHandler("CIM_ListenerDestinationCIMXML", new HttpIndicationHandler());
    }

    public int startService(CIMInstance cpa) {
        Debug.trace1((String)"CIM-XML StartService Called");
        try {
            CIMObjectPath cimomClassOp = new CIMObjectPath("WBEMServices_ObjectManager", "/interop");
            CIMInstance cimomInstance = (CIMInstance)this.ch.enumerateInstances(cimomClassOp, true, false, true, true, null).nextElement();
            CIMObjectPath classOp = new CIMObjectPath("CIM_CIMXMLCommunicationMechanism", "/interop");
            CIMClass cc = this.ch.getClass(classOp, false, true, true, null);
            CIMInstance ci = cc.newInstance();
            ci.setProperty("SystemCreationClassName", cimomInstance.getProperty("SystemCreationClassName").getValue());
            ci.setProperty("SystemName", cimomInstance.getProperty("SystemName").getValue());
            ci.setProperty("CreationClassName", new CIMValue((Object)classOp.getObjectName()));
            ci.setProperty("Name", new CIMValue((Object)"cim-xml"));
            ci.setProperty("CommunicationMechanism", new CIMValue((Object)new UnsignedInt16(2)));
            Vector<UnsignedInt16> profilesSupported = new Vector<UnsignedInt16>(8);
            profilesSupported.addElement(new UnsignedInt16(2));
            profilesSupported.addElement(new UnsignedInt16(3));
            profilesSupported.addElement(new UnsignedInt16(4));
            profilesSupported.addElement(new UnsignedInt16(5));
            profilesSupported.addElement(new UnsignedInt16(6));
            profilesSupported.addElement(new UnsignedInt16(7));
            profilesSupported.addElement(new UnsignedInt16(8));
            profilesSupported.addElement(new UnsignedInt16(9));
            CIMValue profileVal = new CIMValue(profilesSupported);
            ci.setProperty("FunctionalProfilesSupported", profileVal);
            ci.setProperty("MultipleOperationsSupported", CIMValue.TRUE);
            Debug.trace2((String)"Set AuthMech");
            Vector<UnsignedInt16> authMechs = new Vector<UnsignedInt16>(1);
            authMechs.addElement(new UnsignedInt16(3));
            CIMValue authMechsVal = new CIMValue(authMechs);
            ci.setProperty("AuthenticationMechanismsSupported", authMechsVal);
            ci.setProperty("CIMXMLProtocolVersion", new CIMValue((Object)new UnsignedInt16(1)));
            ci.setProperty("CIMValidated", CIMValue.FALSE);
            Debug.trace2((String)"createInstance called");
            this.ch.createInstance(classOp, ci);
            Debug.trace2((String)"After createInstance called");
            this.commMechOp = ci.getObjectPath();
            Debug.trace2((String)"commMechOp");
            this.commMechOp.setNameSpace(classOp.getNameSpace());
            Debug.trace2((String)"commMechOp 2 ");
        }
        catch (CIMException ce) {
            Debug.trace2((String)"Ignore Error: Exception creating CIMXML_CommunicationMechanism", (Throwable)ce);
        }
        try {
            CIMValue cv = cpa.getProperty(PORT).getValue();
            this.port = ((UnsignedInt32)cv.getValue()).intValue();
        }
        catch (NullPointerException ex) {
            Debug.trace2((String)"Got exception getting the HTTP port number", (Throwable)ex);
        }
        try {
            CIMRequestHandler handler = new CIMRequestHandler(this.cimom, this.servername);
            this.serverEndPoint = new HttpServerEndpoint(this.servername, this.port, this.useSSL);
            this.serverEndPoint.listen((RequestHandler)handler);
        }
        catch (Exception ex) {
            Debug.trace2((String)"Got exception when starting Http service", (Throwable)ex);
            return -1;
        }
        return 0;
    }

    public int stopService() {
        try {
            this.ch.deleteInstance(this.commMechOp);
        }
        catch (CIMException e) {
            Debug.trace2((String)"Got exception deleting comm mech instance", (Throwable)e);
        }
        return 0;
    }
}

