/*
 * Decompiled with CFR 0.152.
 */
package org.wbemservices.wbem.cimom.security;

import javax.wbem.cim.CIMException;
import javax.wbem.security.UserPasswordEncryptionProvider;
import org.wbemservices.wbem.cimom.CIMOMLibrary;
import org.wbemservices.wbem.cimom.security.UserPasswordProvider;
import org.wbemservices.wbem.client.SolarisPswdEncryptionProvider;

public final class SolarisUserPasswordProvider
implements UserPasswordProvider {
    private static final String DFLT_SALT = "AA";
    private UserPasswordEncryptionProvider pep = new SolarisPswdEncryptionProvider();

    public String getEncryptedPassword(String username, int type) throws CIMException {
        String hash = CIMOMLibrary.getEncryptedPassword(username, type);
        if (hash != null && hash.length() < 3) {
            hash = this.pep.encryptPassword(username, DFLT_SALT, "");
        }
        return hash;
    }

    public String writeLocalAuthenticator(String username, String dir, String value) throws CIMException {
        return CIMOMLibrary.writeLocalAuthenticator(username, dir, value);
    }

    public boolean authenticateUser(String username, String password) throws CIMException {
        if (password == null || password.trim().length() == 0) {
            return false;
        }
        return CIMOMLibrary.authenticateUser(username, password);
    }

    public boolean authenticateRole(String rolename, String password, String roleuser) throws CIMException {
        if (password == null || password.trim().length() == 0 || roleuser == null || roleuser.trim().length() == 0) {
            return false;
        }
        return CIMOMLibrary.authenticateRole(rolename, password, roleuser);
    }

    public void auditLogin(String hostName, String userName, long success) throws CIMException {
        CIMOMLibrary.auditLogin(hostName, userName, success);
    }
}

