/*
 * Decompiled with CFR 0.152.
 */
package org.wbemservices.wbem.cimom.util;

import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.text.MessageFormat;

public class DynClassLoader
extends URLClassLoader {
    public static final String BASEDIR = System.getProperty("BaseDir", "");
    static final String FILEURL = "file:";

    public DynClassLoader(String pPath, ClassLoader pParent) {
        super(new URL[0], pParent);
        this.addToClassPath(pPath);
    }

    public DynClassLoader(String[] pPaths, ClassLoader pParent) {
        super(new URL[0], pParent);
        for (int count = 0; count < pPaths.length; ++count) {
            this.addToClassPath(pPaths[count]);
        }
    }

    public DynClassLoader(URL[] urls, ClassLoader parent) {
        super(urls, parent);
    }

    public DynClassLoader(ClassLoader pParent) {
        super(new URL[0], pParent);
    }

    public void addToClassPath(URL url) {
        try {
            this.addURL(url);
        }
        catch (Exception e) {
            System.out.println("Error adding URL: " + url);
            e.printStackTrace();
        }
    }

    public void addToClassPath(String path) {
        if (path == null) {
            return;
        }
        try {
            String spec = path;
            if (path.regionMatches(true, 0, FILEURL, 0, FILEURL.length())) {
                Object[] argument = new Object[]{BASEDIR};
                spec = MessageFormat.format(path, argument);
            }
            this.addToClassPath(new URL(spec));
        }
        catch (MalformedURLException e) {
            System.out.println("Malformed URL: " + path);
            e.printStackTrace();
        }
    }

    protected PermissionCollection getPermissions(CodeSource cs) {
        PermissionCollection pc = new AllPermission().newPermissionCollection();
        pc.add(new AllPermission());
        return pc;
    }
}

