/*
 * Decompiled with CFR 0.152.
 */
package org.wbemservices.wbem.repository;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.wbem.cim.CIMClass;
import javax.wbem.cim.CIMClassException;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMProperty;
import org.wbemservices.wbem.repository.CIMClassRlogEntry;
import org.wbemservices.wbem.repository.CIMNameSpaceRlogEntry;

public class CIMAssocClassRlogEntry
extends CIMClassRlogEntry {
    private static final long serialVersionUID = -5517300490476497950L;
    private AssocRole[] roles = new AssocRole[0];

    public CIMAssocClassRlogEntry(CIMNameSpaceRlogEntry nsentry, String name, String supercc) {
        super(nsentry, name, supercc);
    }

    public void createAssciations(CIMClass cc) throws CIMException {
        this.roles = this.createAssociationClassPropList(cc);
        this.addClassAssociations();
    }

    public void addSubClass(CIMClassRlogEntry cs) throws CIMException {
        if (!(cs instanceof CIMAssocClassRlogEntry)) {
            throw new CIMClassException("CIM_ERR_INVALID_CLASS", (Object)cs.getName());
        }
        super.addSubClass(cs);
    }

    private AssocRole[] createAssociationClassPropList(CIMClass cc) {
        ArrayList<AssocRole> al = new ArrayList<AssocRole>();
        Enumeration e = cc.getProperties().elements();
        while (e.hasMoreElements()) {
            CIMProperty pe = (CIMProperty)e.nextElement();
            if (!pe.isReference()) continue;
            al.add(new AssocRole(pe.getType().getRefClassName(), pe.getName()));
        }
        AssocRole[] arr = new AssocRole[al.size()];
        al.toArray(arr);
        return arr;
    }

    public void validateClassAsociations() throws CIMException {
        for (int i = 0; i < this.roles.length; ++i) {
            CIMClassRlogEntry cctemp = this.nsentry.getClass(this.roles[i].cc);
            if (cctemp != null) continue;
            throw new CIMClassException("CIM_ERR_NOT_FOUND", (Object)this.roles[i].cc);
        }
    }

    private void addClassAssociations() throws CIMException {
        this.validateClassAsociations();
        for (int i = 0; i < this.roles.length; ++i) {
            CIMClassRlogEntry cctemp = this.nsentry.getClass(this.roles[i].cc);
            cctemp.addAssociation(this);
        }
    }

    public void removeClassAssociations() throws CIMException {
        this.validateClassAsociations();
        for (int i = 0; i < this.roles.length; ++i) {
            CIMClassRlogEntry cctemp = this.nsentry.getClass(this.roles[i].cc);
            cctemp.removeAssociation(this.getName());
        }
    }

    public ArrayList matchRole(String cname, String role, String resultRole) {
        ArrayList<String> v = new ArrayList<String>();
        boolean match = false;
        boolean rolematch = false;
        boolean isReflective = false;
        for (int k = 0; k < this.roles.length; ++k) {
            if (!this.roles[k].cc.equalsIgnoreCase(cname)) continue;
            if (role != null && role.length() != 0) {
                if (this.roles[k].role.equalsIgnoreCase(role)) {
                    rolematch = true;
                }
            } else {
                rolematch = true;
            }
            if (match) {
                isReflective = true;
            }
            match = true;
        }
        if (!match || !rolematch) {
            return v;
        }
        for (int i = 0; i < this.roles.length; ++i) {
            if (!isReflective && this.roles[i].cc.equalsIgnoreCase(cname) || resultRole != null && resultRole.length() != 0 && !this.roles[i].role.equalsIgnoreCase(resultRole)) continue;
            boolean exist = false;
            for (int k = 0; k < v.size(); ++k) {
                if (!this.roles[i].cc.equalsIgnoreCase((String)v.get(k))) continue;
                exist = true;
            }
            if (exist) continue;
            v.add(this.roles[i].cc);
        }
        return v;
    }

    private static class AssocRole
    implements Serializable {
        public String cc;
        public String role;

        public AssocRole(String cc, String role) {
            this.cc = cc;
            this.role = role;
        }
    }
}

