/*
 * Decompiled with CFR 0.152.
 */
package org.wbemservices.wbem.repository;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;
import javax.wbem.cim.CIMClass;
import javax.wbem.cim.CIMClassException;
import javax.wbem.cim.CIMElement;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMInstanceException;
import javax.wbem.cim.CIMNameSpaceException;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMQualifierType;
import javax.wbem.cim.CIMQualifierTypeException;
import javax.wbem.client.CIMOMHandle;
import javax.wbem.provider.EventProvider;
import javax.wbem.query.QueryExp;
import javax.wbem.query.SelectExp;
import javax.wbem.query.SelectList;
import javax.wbem.query.WQLParser;
import org.wbemservices.wbem.cimom.ReadersWriter;
import org.wbemservices.wbem.cimom.repository.RepositoryIF;
import org.wbemservices.wbem.repository.CIMAssocClassRlogEntry;
import org.wbemservices.wbem.repository.CIMAssocInstanceRlogEntry;
import org.wbemservices.wbem.repository.CIMClassRlogEntry;
import org.wbemservices.wbem.repository.CIMInstanceRlogEntry;
import org.wbemservices.wbem.repository.CIMNameSpaceRlogEntry;
import org.wbemservices.wbem.repository.CIMQualifierTypeRlogEntry;
import org.wbemservices.wbem.repository.CIMRlogEntry;
import org.wbemservices.wbem.repository.EventHelper;
import org.wbemservices.wbem.repository.InstanceNameUtils;
import org.wbemservices.wbem.repository.LogException;
import org.wbemservices.wbem.repository.LogHandler;
import org.wbemservices.wbem.repository.PersistentStore;
import org.wbemservices.wbem.repository.ReliableLog;

public class PSRlogImpl
implements RepositoryIF,
EventProvider {
    private static final int CIMQYALIFY = 0;
    private static final int CIMCLASS = 1;
    private static final int CIMINSTANCE = 2;
    private EventHelper eventHelper;
    public static final String CIMROOT = "/";
    public static final String TOP = "top";
    public static final String CIMBASE = "root/cimv2";
    private static final int LOG_VERSION = 1;
    public static boolean verbose = false;
    private static HashMap nameSpacesMap = null;
    private ReliableLog log;
    private boolean inRecovery;
    private ReadersWriter concurrentObj;
    private final Object snapshotNotifier = new Object();
    private int logToSnapshotThresh = 200;
    private int logFileSize = 0;
    private final Thread snapshotter = new SnapshotThread();
    private PersistentStore store = null;
    private String logpath = null;
    static /* synthetic */ Class class$org$wbemservices$wbem$repository$PSRlogImpl;

    public PSRlogImpl(String hostname, ReadersWriter concurrentObj) throws CIMException {
        try {
            this.concurrentObj = concurrentObj;
            this.eventHelper = new EventHelper(concurrentObj);
            this.init();
        }
        catch (Exception e) {
            if (verbose) {
                e.printStackTrace();
            }
            throw new CIMException("CIM_ERR_FAILED", e.toString());
        }
    }

    public PSRlogImpl(String hostname, ReadersWriter concurrentObj, String logpath) throws CIMException {
        try {
            this.concurrentObj = concurrentObj;
            this.logpath = logpath;
            this.init();
        }
        catch (Exception e) {
            if (verbose) {
                e.printStackTrace();
            }
            throw new CIMException("CIM_ERR_FAILED", e.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createNameSpace(String namespace) throws CIMException {
        try {
            this.concurrentObj.writeLock();
            this.createNameSpaceDo(namespace);
        }
        finally {
            this.concurrentObj.writeUnlock();
        }
    }

    private void createNameSpaceDo(String namespace) throws CIMException {
        String ns = namespace.replace('\\', '/');
        try {
            CIMNameSpaceRlogEntry nsentry;
            if (ns == null || ns.length() == 0 || ns.equals(CIMROOT)) {
                throw new CIMNameSpaceException("CIM_ERR_ALREADY_EXISTS", (Object)namespace);
            }
            if (namespace.length() == 0) {
                namespace = CIMROOT;
            }
            if ((nsentry = (CIMNameSpaceRlogEntry)nameSpacesMap.get(ns)) != null) {
                throw new CIMNameSpaceException("CIM_ERR_ALREADY_EXISTS", (Object)namespace);
            }
            nsentry = new CIMNameSpaceRlogEntry(ns);
            nsentry.addClass(new CIMClassRlogEntry(nsentry, TOP, ""));
            this.putNameSpaceEntryToMap(nsentry);
            this.addLogRecord(new CreateNameSpaceLogObj(namespace));
        }
        catch (CIMException e) {
            if (verbose) {
                e.printStackTrace();
            }
            throw e;
        }
        catch (Exception e) {
            if (verbose) {
                e.printStackTrace();
            }
            throw new CIMException("CIM_ERR_FAILED", e.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCIMElement(String namespace, CIMQualifierType qt) throws CIMException {
        try {
            this.concurrentObj.writeLock();
            this.addCIMElementDO(namespace, qt);
        }
        finally {
            this.concurrentObj.writeUnlock();
        }
    }

    private void addCIMElementDO(String namespace, CIMQualifierType qt) throws CIMException {
        String qtName = qt.getName();
        CIMRlogEntry qtentry = this.addCIMQualifierTypeDo(namespace, qtName);
        this.createAddElementLogRecord(namespace, qtentry, (CIMElement)qt);
    }

    private CIMRlogEntry addCIMQualifierTypeDo(String namespace, String qtName) throws CIMException {
        try {
            CIMNameSpaceRlogEntry nsentry = PSRlogImpl.getNameSpaceEntryFromMap(namespace);
            CIMQualifierTypeRlogEntry qtentry = nsentry.getQualifierType(qtName);
            if (qtentry != null) {
                throw new CIMQualifierTypeException("CIM_ERR_ALREADY_EXISTS", (Object)qtName);
            }
            qtentry = new CIMQualifierTypeRlogEntry(namespace, qtName);
            nsentry.addQualifierType(qtentry);
            return qtentry;
        }
        catch (CIMException e) {
            if (verbose) {
                e.printStackTrace();
            }
            throw e;
        }
        catch (Exception e) {
            if (verbose) {
                e.printStackTrace();
            }
            throw new CIMException("CIM_ERR_FAILED", e.toString());
        }
    }

    private void createAddElementLogRecord(String namespace, CIMRlogEntry entry, CIMElement element) throws CIMException {
        this.createLogRecord(namespace, entry, element, true);
    }

    private void createSetElementLogRecord(String namespace, CIMRlogEntry entry, CIMElement element) throws CIMException {
        this.createLogRecord(namespace, entry, element, false);
    }

    private void createLogRecord(String namespace, CIMRlogEntry entry, CIMElement element, boolean add) throws CIMException {
        String otherName = null;
        String name = InstanceNameUtils.getNameForElement(element);
        int type = 0;
        boolean assoc = false;
        AddCIMQualifierLogObj rec = null;
        entry.createPersistObject(PSRlogImpl.serialize(element));
        PersistentStore.PersistObject po = entry.getPersistObject();
        if (element instanceof CIMQualifierType) {
            type = 0;
            rec = add ? new AddCIMQualifierLogObj(namespace, name, po) : new SetCIMQualifierLogObj(namespace, name, po);
        } else if (element instanceof CIMClass) {
            type = 1;
            assoc = ((CIMClass)element).isAssociation();
            otherName = ((CIMClass)element).getSuperClass();
            rec = add ? new AddCIMClassLogObj(namespace, name, otherName, assoc, po) : new SetCIMClassLogObj(namespace, name, otherName, po);
        } else if (element instanceof CIMInstance) {
            type = 2;
            otherName = ((CIMInstance)element).getClassName();
            if (add) {
                assoc = entry instanceof CIMAssocInstanceRlogEntry;
                rec = new AddCIMInstanceLogObj(namespace, name, otherName, assoc, po);
            } else {
                rec = new SetCIMInstanceLogObj(namespace, name, otherName, po);
            }
        }
        this.addLogRecord(rec);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCIMElement(String namespace, CIMClass cc) throws CIMException {
        try {
            this.concurrentObj.writeLock();
            this.addCIMElementDO(namespace, cc);
        }
        finally {
            this.concurrentObj.writeUnlock();
        }
    }

    private void addCIMElementDO(String namespace, CIMClass cc) throws CIMException {
        String cname = cc.getName();
        String supercc = cc.getSuperClass();
        boolean assoc = cc.isAssociation();
        CIMRlogEntry ccentry = this.addCIMClassDo(namespace, cname, supercc, assoc, cc);
        this.createAddElementLogRecord(namespace, ccentry, (CIMElement)cc);
        this.eventHelper.classCreation(namespace, cc);
    }

    private CIMRlogEntry addCIMClassDo(String namespace, String cname, String supercc, boolean assoc, CIMClass cc) throws CIMException {
        if (supercc.length() == 0) {
            supercc = TOP;
        }
        try {
            CIMNameSpaceRlogEntry nsentry = PSRlogImpl.getNameSpaceEntryFromMap(namespace);
            CIMClassRlogEntry ccentry = nsentry.getClass(cname);
            if (ccentry != null) {
                throw new CIMClassException("CIM_ERR_ALREADY_EXISTS", (Object)cname);
            }
            CIMClassRlogEntry supccentry = nsentry.getClass(supercc);
            if (supccentry == null) {
                throw new CIMClassException("CIM_ERR_NOT_FOUND", (Object)supercc);
            }
            if (assoc) {
                ccentry = new CIMAssocClassRlogEntry(nsentry, cname, supercc);
                ((CIMAssocClassRlogEntry)ccentry).createAssciations(cc);
            } else {
                ccentry = new CIMClassRlogEntry(nsentry, cname, supercc);
            }
            supccentry.addSubClass(ccentry);
            nsentry.addClass(ccentry);
            return ccentry;
        }
        catch (CIMException e) {
            if (verbose) {
                e.printStackTrace();
            }
            throw e;
        }
        catch (Exception e) {
            if (verbose) {
                e.printStackTrace();
            }
            throw new CIMException("CIM_ERR_FAILED", e.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCIMElement(String namespace, CIMInstance ci) throws CIMException {
        try {
            this.concurrentObj.writeLock();
            this.addCIMElementDo(namespace, ci);
        }
        finally {
            this.concurrentObj.writeUnlock();
        }
    }

    private void addCIMElementDo(String namespace, CIMInstance ci) throws CIMException {
        String cname = ci.getClassName();
        String iname = InstanceNameUtils.getInstanceNameKey(ci);
        CIMRlogEntry entry = this.addCIMInstanceDo(namespace, iname, cname, ci);
        this.createAddElementLogRecord(namespace, entry, (CIMElement)ci);
        this.eventHelper.instanceAddition(namespace.toLowerCase(), ci);
    }

    private CIMRlogEntry addCIMInstanceDo(String namespace, String iname, String cname, CIMInstance ci) throws CIMException {
        try {
            CIMNameSpaceRlogEntry nsentry = PSRlogImpl.getNameSpaceEntryFromMap(namespace);
            CIMClassRlogEntry ccentry = nsentry.getClass(cname);
            if (ccentry == null) {
                throw new CIMClassException("CIM_ERR_NOT_FOUND", (Object)cname);
            }
            CIMInstanceRlogEntry cientry = ccentry.getInstance(iname);
            if (cientry != null) {
                throw new CIMInstanceException("CIM_ERR_ALREADY_EXISTS", (Object)iname);
            }
            if (ccentry instanceof CIMAssocClassRlogEntry) {
                cientry = new CIMAssocInstanceRlogEntry(nsentry, iname);
                CIMAssocInstanceRlogEntry associentry = (CIMAssocInstanceRlogEntry)cientry;
                associentry.validateInstanceAssociations();
                associentry.createAssciations(ci);
                associentry.addInstanceAssociations(cname, associentry);
            } else {
                cientry = new CIMInstanceRlogEntry(nsentry, iname);
            }
            ccentry.addInstance(cientry);
            return cientry;
        }
        catch (CIMException e) {
            if (verbose) {
                e.printStackTrace();
            }
            throw e;
        }
        catch (Exception e) {
            if (verbose) {
                e.printStackTrace();
            }
            throw new CIMException("CIM_ERR_FAILED", e.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setQualifierType(String namespace, CIMQualifierType qt) throws CIMException {
        try {
            this.concurrentObj.writeLock();
            this.setQualifierTypeDo(namespace, qt);
        }
        finally {
            this.concurrentObj.writeUnlock();
        }
    }

    private void setQualifierTypeDo(String namespace, CIMQualifierType qt) throws CIMException {
        String qtName = qt.getName();
        CIMRlogEntry entry = this.setQualifierTypeDo(namespace, qtName);
        this.createSetElementLogRecord(namespace, entry, (CIMElement)qt);
    }

    private CIMRlogEntry setQualifierTypeDo(String namespace, String qtName) throws CIMException {
        try {
            CIMNameSpaceRlogEntry nsentry = PSRlogImpl.getNameSpaceEntryFromMap(namespace);
            CIMQualifierTypeRlogEntry qtentry = nsentry.getQualifierType(qtName);
            if (qtentry == null) {
                qtentry = new CIMQualifierTypeRlogEntry(namespace, qtName);
                nsentry.addQualifierType(qtentry);
            }
            return qtentry;
        }
        catch (CIMException e) {
            if (verbose) {
                e.printStackTrace();
            }
            throw e;
        }
        catch (Exception e) {
            if (verbose) {
                e.printStackTrace();
            }
            throw new CIMException("CIM_ERR_FAILED", e.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setClass(String namespace, CIMClass cc) throws CIMException {
        try {
            this.concurrentObj.writeLock();
            this.setClassDo(namespace, cc);
        }
        finally {
            this.concurrentObj.writeUnlock();
        }
    }

    private void setClassDo(String namespace, CIMClass cc) throws CIMException {
        CIMObjectPath classop = new CIMObjectPath(cc.getName(), namespace);
        CIMClass oldcc = this.getClassDo(classop.getNameSpace(), classop.getObjectName());
        String name = cc.getName();
        String supercc = cc.getSuperClass();
        CIMRlogEntry entry = this.setClassDo(namespace, name, supercc);
        this.createSetElementLogRecord(namespace, entry, (CIMElement)cc);
        this.eventHelper.classModification(namespace, oldcc, cc);
    }

    private CIMRlogEntry setClassDo(String namespace, String cname, String supercc) throws CIMException {
        if (supercc.length() == 0) {
            supercc = TOP;
        }
        try {
            CIMNameSpaceRlogEntry nsentry = PSRlogImpl.getNameSpaceEntryFromMap(namespace);
            CIMClassRlogEntry ccentry = nsentry.getClass(cname);
            if (ccentry == null) {
                ccentry = new CIMClassRlogEntry(nsentry, cname, supercc);
                nsentry.addClass(ccentry);
            }
            return ccentry;
        }
        catch (CIMException e) {
            e.printStackTrace();
            if (verbose) {
                e.printStackTrace();
            }
            throw e;
        }
        catch (Exception e) {
            if (!verbose) {
                // empty if block
            }
            e.printStackTrace();
            throw new CIMException("CIM_ERR_FAILED", e.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setInstance(String namespace, CIMInstance ci) throws CIMException {
        try {
            this.concurrentObj.writeLock();
            this.setInstanceDo(namespace, ci);
        }
        finally {
            this.concurrentObj.writeUnlock();
        }
    }

    private void setInstanceDo(String namespace, CIMInstance ci) throws CIMException {
        String cname = ci.getClassName();
        String iname = InstanceNameUtils.getInstanceNameKey(ci);
        CIMRlogEntry entry = this.setInstanceDo(namespace, iname, cname);
        CIMInstance oldci = (CIMInstance)PSRlogImpl.deserialize(entry.getValue());
        this.createSetElementLogRecord(namespace, entry, (CIMElement)ci);
        this.eventHelper.instanceModification(namespace.toLowerCase(), oldci, ci);
    }

    private CIMRlogEntry setInstanceDo(String namespace, String iname, String cname) throws CIMException {
        try {
            CIMNameSpaceRlogEntry nsentry = PSRlogImpl.getNameSpaceEntryFromMap(namespace);
            CIMClassRlogEntry ccentry = nsentry.getClass(cname);
            if (ccentry == null) {
                throw new CIMClassException("CIM_ERR_NOT_FOUND", (Object)cname);
            }
            CIMInstanceRlogEntry cientry = ccentry.getInstance(iname);
            if (cientry == null) {
                cientry = new CIMInstanceRlogEntry(nsentry, iname);
                ccentry.addInstance(cientry);
            }
            return cientry;
        }
        catch (CIMException e) {
            if (verbose) {
                e.printStackTrace();
            }
            throw e;
        }
        catch (Exception e) {
            if (verbose) {
                e.printStackTrace();
            }
            throw new CIMException("CIM_ERR_FAILED", e.toString());
        }
    }

    public CIMQualifierType getQualifierType(CIMObjectPath op) throws CIMException {
        return this.getQualifierType(op.getNameSpace(), op.getObjectName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CIMQualifierType getQualifierType(String namespace, String qtName) throws CIMException {
        try {
            this.concurrentObj.readLock();
            CIMQualifierType cIMQualifierType = this.getQualifierTypeDo(namespace, qtName);
            return cIMQualifierType;
        }
        finally {
            this.concurrentObj.readUnlock();
        }
    }

    private CIMQualifierType getQualifierTypeDo(String namespace, String qtName) throws CIMException {
        CIMQualifierType qt = null;
        CIMQualifierTypeRlogEntry qtentry = null;
        try {
            CIMNameSpaceRlogEntry nsentry = PSRlogImpl.getNameSpaceEntryFromMap(namespace);
            qtentry = nsentry.getQualifierType(qtName);
            if (qtentry != null) {
                qt = (CIMQualifierType)PSRlogImpl.deserialize(qtentry.getValue());
            }
        }
        catch (CIMException e) {
            if (verbose) {
                e.printStackTrace();
            }
            throw e;
        }
        catch (Exception e) {
            if (verbose) {
                e.printStackTrace();
            }
            throw new CIMException("CIM_ERR_FAILED", e.toString());
        }
        return qt;
    }

    public CIMClass getClass(CIMObjectPath op) throws CIMException {
        return this.getClass(op.getNameSpace(), op.getObjectName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CIMClass getClass(String namespace, String className) throws CIMException {
        try {
            this.concurrentObj.readLock();
            CIMClass cIMClass = this.getClassDo(namespace, className);
            return cIMClass;
        }
        finally {
            this.concurrentObj.readUnlock();
        }
    }

    private CIMClass getClassDo(String namespace, String className) throws CIMException {
        CIMClass cc = null;
        CIMClassRlogEntry ccentry = null;
        try {
            CIMNameSpaceRlogEntry nsentry = PSRlogImpl.getNameSpaceEntryFromMap(namespace);
            ccentry = nsentry.getClass(className);
            if (ccentry != null) {
                cc = (CIMClass)PSRlogImpl.deserialize(ccentry.getValue());
            }
        }
        catch (CIMException e) {
            return null;
        }
        catch (Exception e) {
            if (verbose) {
                e.printStackTrace();
            }
            throw new CIMException("CIM_ERR_FAILED", e.toString());
        }
        return cc;
    }

    public CIMInstance getInstance(CIMObjectPath op) throws CIMException {
        String namespace = op.getNameSpace();
        String className = op.getObjectName();
        CIMClass cc = this.getClass(namespace, className);
        CIMInstance nci = cc.newInstance();
        nci.updatePropertyValues(op.getKeys());
        CIMInstance ci = this.getInstance(namespace, InstanceNameUtils.getInstanceNameKey(nci));
        this.eventHelper.instanceRead(namespace.toLowerCase(), ci);
        return ci;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CIMInstance getInstance(String namespace, String iname) throws CIMException {
        try {
            this.concurrentObj.readLock();
            CIMInstance cIMInstance = this.getInstanceDo(namespace, iname);
            return cIMInstance;
        }
        finally {
            this.concurrentObj.readUnlock();
        }
    }

    private CIMInstance getInstanceDo(String namespace, String iname) throws CIMException {
        String cname = iname.substring(0, iname.indexOf(58));
        CIMInstance ci = null;
        CIMInstanceRlogEntry cientry = null;
        try {
            CIMNameSpaceRlogEntry nsentry = PSRlogImpl.getNameSpaceEntryFromMap(namespace);
            CIMClassRlogEntry ccentry = nsentry.getClass(cname);
            if (ccentry == null) {
                throw new CIMClassException("CIM_ERR_NOT_FOUND", (Object)cname);
            }
            cientry = ccentry.getInstance(iname);
            if (cientry != null) {
                ci = (CIMInstance)PSRlogImpl.deserialize(cientry.getValue());
            }
        }
        catch (CIMException e) {
            if (verbose) {
                e.printStackTrace();
            }
            throw e;
        }
        catch (Exception e) {
            if (verbose) {
                e.printStackTrace();
            }
            throw new CIMException("CIM_ERR_FAILED", e.toString());
        }
        return ci;
    }

    public void deleteQualifier(CIMObjectPath op) throws CIMException {
        this.deleteQualifier(op.getNameSpace(), op.getObjectName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteQualifier(String namespace, String qtName) throws CIMException {
        try {
            this.concurrentObj.writeLock();
            this.deleteQualifierDo(namespace, qtName);
        }
        finally {
            this.concurrentObj.writeUnlock();
        }
    }

    private void deleteQualifierDo(String namespace, String qtName) throws CIMException {
        try {
            CIMNameSpaceRlogEntry nsentry = PSRlogImpl.getNameSpaceEntryFromMap(namespace);
            nsentry.removeQualifierType(qtName);
            this.addLogRecord(new DeleteQualifierLogObj(namespace, qtName));
        }
        catch (CIMException e) {
            if (verbose) {
                e.printStackTrace();
            }
            throw e;
        }
        catch (Exception e) {
            if (verbose) {
                e.printStackTrace();
            }
            throw new CIMException("CIM_ERR_FAILED", e.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteNameSpace(String namespace) throws CIMException {
        try {
            this.concurrentObj.writeLock();
            this.deleteNameSpaceDo(namespace);
        }
        finally {
            this.concurrentObj.writeUnlock();
        }
    }

    private void deleteNameSpaceDo(String namespace) throws CIMException {
        if (namespace == null || namespace.length() == 0) {
            throw new CIMNameSpaceException("CIM_ERR_INVALID_NAMESPACE", (Object)" ");
        }
        String ns = namespace.replace('\\', '/');
        try {
            CIMNameSpaceRlogEntry nsentry = (CIMNameSpaceRlogEntry)nameSpacesMap.get(ns);
            if (nsentry == null) {
                throw new CIMNameSpaceException("CIM_ERR_NOT_FOUND", (Object)namespace);
            }
            nameSpacesMap.remove(ns);
            this.addLogRecord(new DeleteNameSpaceLogObj(namespace));
        }
        catch (CIMException e) {
            if (verbose) {
                e.printStackTrace();
            }
            throw e;
        }
        catch (Exception e) {
            if (verbose) {
                e.printStackTrace();
            }
            throw new CIMException("CIM_ERR_FAILED", e.toString());
        }
    }

    public void deleteClass(CIMObjectPath op) throws CIMException {
        CIMClass cc = this.getClass(op);
        String namespace = op.getNameSpace();
        this.deleteClass(namespace, op.getObjectName());
        this.eventHelper.classDeletion(namespace, cc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteClass(String namespace, String className) throws CIMException {
        try {
            this.concurrentObj.writeLock();
            this.deleteClassDo(namespace, className);
        }
        finally {
            this.concurrentObj.writeUnlock();
        }
    }

    private void deleteClassDo(String namespace, String className) throws CIMException {
        try {
            CIMNameSpaceRlogEntry nsentry = PSRlogImpl.getNameSpaceEntryFromMap(namespace);
            CIMClassRlogEntry ccentry = nsentry.getClass(className);
            if (ccentry == null) {
                throw new CIMClassException("CIM_ERR_NOT_FOUND", (Object)className);
            }
            if (ccentry.hasClassAssociation()) {
                throw new CIMException("CIM_ERR_FAILED", className);
            }
            String supercc = ccentry.getSuperClassName();
            CIMClassRlogEntry superentry = nsentry.getClass(supercc.length() == 0 ? TOP : supercc);
            if (superentry == null) {
                throw new CIMClassException("CIM_ERR_NOT_FOUND", (Object)supercc);
            }
            this.validateAssociationClass(ccentry);
            superentry.removeSubClass(className);
            nsentry.removeClass(className);
            if (ccentry instanceof CIMAssocClassRlogEntry) {
                ((CIMAssocClassRlogEntry)ccentry).removeClassAssociations();
            }
            ArrayList arrayList = new ArrayList(ccentry.getSubClassCollection());
            for (int i = 0; i < arrayList.size(); ++i) {
                ccentry = (CIMClassRlogEntry)arrayList.get(i);
                ArrayList v = new ArrayList(ccentry.getSubClassCollection());
                for (int j = 0; j < v.size(); ++j) {
                    arrayList.add(v.get(j));
                }
                nsentry.removeClass(ccentry.getNameKey());
                if (!(ccentry instanceof CIMAssocClassRlogEntry)) continue;
                ((CIMAssocClassRlogEntry)ccentry).removeClassAssociations();
            }
            this.addLogRecord(new DeleteClassLogObj(namespace, className));
        }
        catch (CIMException e) {
            if (verbose) {
                e.printStackTrace();
            }
            throw e;
        }
        catch (Exception e) {
            if (verbose) {
                e.printStackTrace();
            }
            throw new CIMException("CIM_ERR_FAILED", e.toString());
        }
    }

    void validateAssociationClass(CIMClassRlogEntry entry) throws CIMException {
        if (entry instanceof CIMAssocClassRlogEntry) {
            ((CIMAssocClassRlogEntry)entry).validateClassAsociations();
        }
        ArrayList arrayList = new ArrayList(entry.getSubClassCollection());
        for (int i = 0; i < arrayList.size(); ++i) {
            CIMClassRlogEntry ccentry = (CIMClassRlogEntry)arrayList.get(i);
            ArrayList v = new ArrayList(ccentry.getSubClassCollection());
            for (int j = 0; j < v.size(); ++j) {
                arrayList.add(v.get(j));
            }
            if (!(ccentry instanceof CIMAssocClassRlogEntry)) continue;
            ((CIMAssocClassRlogEntry)ccentry).validateClassAsociations();
        }
    }

    public void deleteInstance(CIMObjectPath op) throws CIMException {
        String namespace = op.getNameSpace();
        String className = op.getObjectName();
        CIMClass cc = this.getClass(namespace, className);
        CIMInstance nci = cc.newInstance();
        nci.updatePropertyValues(op.getKeys());
        CIMInstance ci = this.getInstance(namespace, InstanceNameUtils.getInstanceNameKey(nci));
        if (ci == null) {
            throw new CIMInstanceException("CIM_ERR_NOT_FOUND", (Object)nci.getObjectPath());
        }
        this.deleteInstance(namespace, InstanceNameUtils.getInstanceNameKey(ci));
        this.eventHelper.instanceDeletion(namespace.toLowerCase(), ci);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteInstance(String namespace, String iname) throws CIMException {
        try {
            this.concurrentObj.writeLock();
            this.deleteInstanceDo(namespace, iname);
        }
        finally {
            this.concurrentObj.writeUnlock();
        }
    }

    private void deleteInstanceDo(String namespace, String iname) throws CIMException {
        String cname = iname.substring(0, iname.indexOf(58));
        try {
            CIMNameSpaceRlogEntry nsentry = PSRlogImpl.getNameSpaceEntryFromMap(namespace);
            CIMClassRlogEntry ccentry = nsentry.getClass(cname);
            if (ccentry == null) {
                throw new CIMClassException("CIM_ERR_NOT_FOUND", (Object)cname);
            }
            CIMInstanceRlogEntry cientry = ccentry.getInstance(iname);
            if (cientry.hasAssociation()) {
                throw new CIMException("CIM_ERR_FAILED", iname);
            }
            if (cientry instanceof CIMAssocInstanceRlogEntry) {
                ((CIMAssocInstanceRlogEntry)cientry).removeInstanceAssociations(cname, iname);
            }
            ccentry.removeInstance(iname);
            this.addLogRecord(new DeleteInstanceLogObj(namespace, iname));
        }
        catch (CIMException e) {
            if (verbose) {
                e.printStackTrace();
            }
            throw e;
        }
        catch (Exception e) {
            if (verbose) {
                e.printStackTrace();
            }
            throw new CIMException("CIM_ERR_FAILED", e.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector enumerateNameSpace(String namespace, boolean deep) throws CIMException {
        try {
            this.concurrentObj.readLock();
            Vector ns = new Vector();
            this.enumNameSpaceDo(ns);
            Vector vector = ns;
            return vector;
        }
        finally {
            this.concurrentObj.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector enumerateNameSpace() throws CIMException {
        try {
            this.concurrentObj.readLock();
            Vector ns = new Vector();
            this.enumNameSpaceDo(ns);
            Vector vector = ns;
            return vector;
        }
        finally {
            this.concurrentObj.readUnlock();
        }
    }

    private void enumNameSpaceDo(Vector nslist) throws CIMException {
        ArrayList arrayList = new ArrayList(nameSpacesMap.values());
        for (int i = 0; i < arrayList.size(); ++i) {
            CIMNameSpaceRlogEntry ns = (CIMNameSpaceRlogEntry)arrayList.get(i);
            nslist.add(ns.getName());
        }
    }

    public Vector enumerateQualifierTypes(CIMObjectPath op) throws CIMException {
        return this.enumerateQualifierTypes(op.getNameSpace());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector enumerateQualifierTypes(String namespace) throws CIMException {
        try {
            this.concurrentObj.readLock();
            Vector vector = this.enumerateQualifierTypesDo(namespace);
            return vector;
        }
        finally {
            this.concurrentObj.readUnlock();
        }
    }

    private Vector enumerateQualifierTypesDo(String namespace) throws CIMException {
        Vector<CIMQualifierType> qualifiers = new Vector<CIMQualifierType>();
        try {
            CIMNameSpaceRlogEntry nsentry = PSRlogImpl.getNameSpaceEntryFromMap(namespace);
            ArrayList a = new ArrayList(nsentry.getQualifierCollection());
            CIMQualifierType qt = null;
            for (int i = 0; i < a.size(); ++i) {
                CIMQualifierTypeRlogEntry qtentry = (CIMQualifierTypeRlogEntry)a.get(i);
                if (qtentry != null) {
                    qt = (CIMQualifierType)PSRlogImpl.deserialize(qtentry.getValue());
                }
                qualifiers.addElement(qt);
            }
        }
        catch (CIMException e) {
            if (verbose) {
                e.printStackTrace();
            }
            throw e;
        }
        catch (Exception e) {
            if (verbose) {
                e.printStackTrace();
            }
            throw new CIMException("CIM_ERR_FAILED", e.toString());
        }
        return qualifiers;
    }

    public Vector enumerateClasses(CIMObjectPath op, boolean deep) throws CIMException {
        return this.enumerateClasses(op.getNameSpace(), op.getObjectName(), deep);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector enumerateClasses(String namespace, String className, boolean deep) throws CIMException {
        try {
            this.concurrentObj.readLock();
            Vector vector = this.enumClassesDo(namespace, className, deep, true, false);
            return vector;
        }
        finally {
            this.concurrentObj.readUnlock();
        }
    }

    public Vector enumerateClasses(CIMObjectPath op, boolean deep, boolean localonly) throws CIMException {
        return this.enumerateClasses(op.getNameSpace(), op.getObjectName(), deep, localonly);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector enumerateClasses(String namespace, String className, boolean deep, boolean localonly) throws CIMException {
        try {
            this.concurrentObj.readLock();
            Vector vector = this.enumClassesDo(namespace, className, deep, false, localonly);
            return vector;
        }
        finally {
            this.concurrentObj.readUnlock();
        }
    }

    private Vector enumClassesDo(String namespace, String className, boolean deep, boolean needop, boolean localonly) throws CIMException {
        Vector<Object> classList = new Vector<Object>();
        if (className == null || className.length() == 0 || className.equalsIgnoreCase(TOP)) {
            className = TOP;
        }
        try {
            CIMNameSpaceRlogEntry nsentry = PSRlogImpl.getNameSpaceEntryFromMap(namespace);
            CIMClassRlogEntry ccentry = nsentry.getClass(className);
            if (ccentry == null) {
                throw new CIMClassException("CIM_ERR_NOT_FOUND", (Object)className);
            }
            ArrayList arrayList = new ArrayList(ccentry.getSubClassCollection());
            for (int i = 0; i < arrayList.size(); ++i) {
                ccentry = (CIMClassRlogEntry)arrayList.get(i);
                if (deep) {
                    ArrayList v = new ArrayList(ccentry.getSubClassCollection());
                    for (int j = 0; j < v.size(); ++j) {
                        arrayList.add(v.get(j));
                    }
                }
                if (needop) {
                    classList.addElement(new CIMObjectPath(ccentry.getName(), namespace));
                    continue;
                }
                CIMClass cc = (CIMClass)PSRlogImpl.deserialize(ccentry.getValue());
                classList.addElement(localonly ? cc.localElements() : cc);
            }
        }
        catch (CIMException e) {
            if (verbose) {
                e.printStackTrace();
            }
            throw e;
        }
        catch (Exception e) {
            if (verbose) {
                e.printStackTrace();
            }
            throw new CIMException("CIM_ERR_FAILED", e.toString());
        }
        return classList;
    }

    public Vector enumerateInstances(CIMObjectPath op, boolean deep) throws CIMException {
        return this.enumerateInstances(op.getNameSpace(), op.getObjectName(), deep);
    }

    public Vector enumerateInstances(String namespace, String className, boolean deep) throws CIMException {
        return this.enumInstances(namespace, className, deep, true, false);
    }

    public Vector enumerateInstances(CIMObjectPath op, boolean deep, boolean localonly) throws CIMException {
        Vector instanceList = this.enumerateInstances(op.getNameSpace(), op.getObjectName(), deep, localonly);
        this.eventHelper.instanceEnumerate(op, instanceList);
        return instanceList;
    }

    public Vector enumerateInstances(String namespace, String className, boolean deep, boolean localonly) throws CIMException {
        return this.enumInstances(namespace, className, deep, false, localonly);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Vector enumInstances(String namespace, String className, boolean deep, boolean needop, boolean localonly) throws CIMException {
        try {
            this.concurrentObj.readLock();
            Vector vector = this.enumInstancesDo(namespace, className, deep, needop, localonly);
            return vector;
        }
        finally {
            this.concurrentObj.readUnlock();
        }
    }

    private Vector enumInstancesDo(String namespace, String className, boolean deep, boolean needop, boolean localonly) throws CIMException {
        Vector instanceList = new Vector();
        if (className == null || className.equalsIgnoreCase(TOP)) {
            className = TOP;
        }
        try {
            CIMNameSpaceRlogEntry nsentry = PSRlogImpl.getNameSpaceEntryFromMap(namespace);
            CIMClassRlogEntry ccentry = nsentry.getClass(className);
            if (ccentry == null) {
                throw new CIMClassException("CIM_ERR_NOT_FOUND", (Object)className);
            }
            this.getInstanceList(namespace, ccentry, needop, instanceList);
            if (deep) {
                ArrayList arrayList = new ArrayList(ccentry.getSubClassCollection());
                for (int i = 0; i < arrayList.size(); ++i) {
                    ccentry = (CIMClassRlogEntry)arrayList.get(i);
                    ArrayList v = new ArrayList(ccentry.getSubClassCollection());
                    for (int j = 0; j < v.size(); ++j) {
                        arrayList.add(v.get(j));
                    }
                    this.getInstanceList(namespace, (CIMClassRlogEntry)arrayList.get(i), needop, instanceList);
                }
            }
        }
        catch (CIMException e) {
            if (verbose) {
                e.printStackTrace();
            }
            throw e;
        }
        catch (Exception e) {
            if (verbose) {
                e.printStackTrace();
            }
            throw new CIMException("CIM_ERR_FAILED", e.toString());
        }
        return instanceList;
    }

    private void getInstanceList(String namespace, CIMClassRlogEntry ccentry, boolean needop, Vector list) throws CIMException {
        try {
            Iterator iter = ccentry.getInstanceCollection().iterator();
            while (iter.hasNext()) {
                CIMInstanceRlogEntry cientry = (CIMInstanceRlogEntry)iter.next();
                CIMInstance ci = (CIMInstance)PSRlogImpl.deserialize(cientry.getValue());
                if (needop) {
                    CIMObjectPath op = new CIMObjectPath(ci.getClassName(), ci.getKeys());
                    op.setNameSpace(namespace);
                    list.addElement(op);
                    continue;
                }
                list.addElement(ci);
            }
        }
        catch (Exception e) {
            throw new CIMException("CIM_ERR_FAILED", e.toString());
        }
    }

    static CIMNameSpaceRlogEntry getNameSpaceEntryFromMap(String namespace) throws CIMException {
        String ns = namespace.replace('\\', '/');
        CIMNameSpaceRlogEntry nsentry = (CIMNameSpaceRlogEntry)nameSpacesMap.get(ns);
        if (nsentry == null) {
            throw new CIMNameSpaceException("CIM_ERR_INVALID_NAMESPACE", (Object)namespace);
        }
        return nsentry;
    }

    private void putNameSpaceEntryToMap(CIMNameSpaceRlogEntry nsentry) {
        nameSpacesMap.put(nsentry.getName(), nsentry);
    }

    public Vector execQuery(CIMObjectPath op, String stmt, String queryType, CIMClass cc) throws CIMException {
        String namespace = op.getNameSpace();
        ByteArrayInputStream in = new ByteArrayInputStream(stmt.getBytes());
        WQLParser parser = new WQLParser((InputStream)in);
        Vector<CIMElement> result = new Vector<CIMElement>();
        try {
            SelectExp q = (SelectExp)parser.querySpecification();
            SelectList attrs = q.getSelectList();
            QueryExp where = q.getWhereClause();
            Vector v = this.enumerateInstances(namespace, cc.getName().toLowerCase(), false, false);
            for (int i = 0; i < v.size(); ++i) {
                if (where != null && !where.apply((CIMElement)((CIMInstance)v.elementAt(i)))) continue;
                result.addElement(attrs.apply((CIMElement)((CIMInstance)v.elementAt(i))));
            }
        }
        catch (CIMException e) {
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CIMException("CIM_ERR_FAILED", e.toString());
        }
        return result;
    }

    private void init() throws IOException {
        if (this.logpath == null) {
            this.logpath = System.getProperty("logdir", System.getProperty("logparent", "/var/sadm/wbem") + File.separator + "logr");
        }
        this.log = new ReliableLog(this.logpath, new LocalLogHandler());
        this.store = new PersistentStore(this.logpath + "/store");
        CIMRlogEntry.setPersistentStore(this.store);
        this.inRecovery = true;
        this.log.recover();
        this.inRecovery = false;
        if (nameSpacesMap == null) {
            nameSpacesMap = new HashMap();
        }
        this.log.snapshot();
        this.snapshotter.start();
    }

    private void takeSnapshot(OutputStream out) throws IOException {
        ObjectOutputStream stream = new ObjectOutputStream(out);
        stream.writeUTF((class$org$wbemservices$wbem$repository$PSRlogImpl == null ? (class$org$wbemservices$wbem$repository$PSRlogImpl = PSRlogImpl.class$("org.wbemservices.wbem.repository.PSRlogImpl")) : class$org$wbemservices$wbem$repository$PSRlogImpl).getName());
        stream.writeInt(1);
        stream.writeObject(nameSpacesMap);
        this.store.addToSnapshot(stream);
        stream.writeObject(null);
        stream.flush();
    }

    private void recoverSnapshot(InputStream in) throws IOException, ClassNotFoundException {
        ObjectInputStream stream = new ObjectInputStream(in);
        if (!(class$org$wbemservices$wbem$repository$PSRlogImpl == null ? (class$org$wbemservices$wbem$repository$PSRlogImpl = PSRlogImpl.class$("org.wbemservices.wbem.repository.PSRlogImpl")) : class$org$wbemservices$wbem$repository$PSRlogImpl).getName().equals(stream.readUTF())) {
            throw new IOException("log from wrong implementation");
        }
        if (stream.readInt() != 1) {
            throw new IOException("wrong log format version");
        }
        nameSpacesMap = (HashMap)stream.readObject();
        this.store.recoverFromSnapshot(stream);
    }

    private void addLogRecord(LogRecord rec) {
        try {
            if (!this.inRecovery) {
                this.log.update(rec, true);
                if (++this.logFileSize >= this.logToSnapshotThresh) {
                    this.concurrentObj.waiterNotify(this.snapshotNotifier);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Vector associatorClassNames(CIMObjectPath op, String assocClass, String resultClass, String role, String resultRole) throws CIMException {
        return this.classAssociators(op, assocClass, resultClass, role, resultRole, false, false, null, true, true);
    }

    public Vector associatorsClass(CIMObjectPath op, String assocClass, String resultClass, String role, String resultRole, boolean includeQualifiers, boolean includeClassOrigin, String[] propertyList) throws CIMException {
        return this.classAssociators(op, assocClass, resultClass, role, resultRole, includeQualifiers, includeClassOrigin, propertyList, false, true);
    }

    public Vector reference(CIMObjectPath op, String resultClass, String role, boolean includeQualifiers, boolean includeClassOrigin, String[] propertyList) throws CIMException {
        return this.classAssociators(op, resultClass, null, role, null, includeQualifiers, includeClassOrigin, propertyList, false, false);
    }

    public Vector referenceNames(CIMObjectPath op, String resultClass, String role) throws CIMException {
        return this.classAssociators(op, resultClass, null, role, null, false, false, null, true, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Vector classAssociators(CIMObjectPath op, String assocClass, String resultClass, String role, String resultRole, boolean includeQualifiers, boolean includeClassOrigin, String[] propertyList, boolean needop, boolean includeAssociatedClass) throws CIMException {
        try {
            this.concurrentObj.readLock();
            Vector vector = this.classAssociatorsDo(op, assocClass, resultClass, role, resultRole, includeQualifiers, includeClassOrigin, propertyList, needop, includeAssociatedClass);
            return vector;
        }
        finally {
            this.concurrentObj.readUnlock();
        }
    }

    private Vector classAssociatorsDo(CIMObjectPath op, String assocClass, String resultClass, String role, String resultRole, boolean includeQualifiers, boolean includeClassOrigin, String[] propertyList, boolean needop, boolean includeAssociatedClass) throws CIMException {
        Vector v = new Vector();
        if (role != null && role.length() != 0 && resultRole != null && resultRole.length() != 0 && role.equalsIgnoreCase(resultRole)) {
            return v;
        }
        String ns = op.getNameSpace();
        String cname = op.getObjectName();
        ns = ns.replace('\\', '/');
        CIMNameSpaceRlogEntry nsentry = PSRlogImpl.getNameSpaceEntryFromMap(ns);
        this.ccAssociators(nsentry, cname, assocClass, resultClass, role, resultRole, includeQualifiers, includeClassOrigin, propertyList, v, needop, includeAssociatedClass);
        return v;
    }

    private void ccAssociators(CIMNameSpaceRlogEntry nsentry, String cname, String assocClass, String resultClass, String role, String resultRole, boolean includeQualifiers, boolean includeClassOrigin, String[] propertyList, Vector v, boolean needop, boolean includeAssociatedClass) throws CIMException {
        ArrayList assoclist = new ArrayList();
        ArrayList resultclist = new ArrayList();
        try {
            CIMClassRlogEntry ccentry = nsentry.getClass(cname);
            if (ccentry == null) {
                throw new CIMClassException("CIM_ERR_NOT_FOUND", (Object)cname);
            }
            if (assocClass != null && assocClass.length() != 0) {
                assoclist = this.deepEnum(nsentry, assocClass);
            }
            if (resultClass != null && resultClass.length() != 0) {
                resultclist = this.deepEnum(nsentry, resultClass);
                String sc = nsentry.getClass(resultClass).getSuperClassName();
                while (sc.length() != 0 && !sc.equals(TOP)) {
                    resultclist.add(sc);
                    sc = nsentry.getClass(sc).getSuperClassName();
                }
            }
            CIMAssocClassRlogEntry[] list = ccentry.getAssocications();
            HashMap<String, String> dups = new HashMap<String, String>();
            for (int i = 0; list != null && i < list.length; ++i) {
                if (dups.get(list[i].getName()) != null) continue;
                boolean match = true;
                if (assocClass != null && assocClass.length() != 0) {
                    match = this.matchClassList(list[i].getName(), assoclist);
                }
                ArrayList al = null;
                if (match) {
                    al = list[i].matchRole(cname, role, resultRole);
                }
                if (al == null || al.isEmpty()) continue;
                boolean didit = false;
                boolean addnull = false;
                for (int k = 0; k < al.size(); ++k) {
                    if (!this.matchClassList((String)al.get(k), resultclist)) continue;
                    addnull = true;
                    if (!didit) {
                        didit = true;
                        this.addToResultList(nsentry, list[i].getName(), true, true, null, v, false);
                        dups.put(list[i].getName(), "");
                    }
                    if (!includeAssociatedClass) continue;
                    this.addToResultList(nsentry, (String)al.get(k), includeQualifiers, includeClassOrigin, propertyList, v, needop);
                }
                if (!addnull) continue;
                v.addElement(null);
            }
            String supercc = ccentry.getSuperClassName();
            if (supercc == null || supercc.length() == 0) {
                return;
            }
            this.ccAssociators(nsentry, supercc, assocClass, resultClass, role, resultRole, includeQualifiers, includeClassOrigin, propertyList, v, needop, includeAssociatedClass);
        }
        catch (CIMException e) {
            e.printStackTrace();
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CIMException("CIM_ERR_FAILED", e.toString());
        }
    }

    private boolean matchClassList(String cname, ArrayList list) {
        if (list.isEmpty()) {
            return true;
        }
        for (int j = 0; j < list.size(); ++j) {
            if (!cname.equalsIgnoreCase((String)list.get(j))) continue;
            return true;
        }
        return false;
    }

    private void addToResultList(CIMNameSpaceRlogEntry nsentry, String cname, boolean includeQualifiers, boolean includeClassOrigin, String[] propertyList, Vector v, boolean needop) throws CIMException {
        try {
            if (needop) {
                v.addElement(new CIMObjectPath(cname, nsentry.getName()));
                return;
            }
            CIMClassRlogEntry ccentry = nsentry.getClass(cname);
            if (ccentry == null) {
                throw new CIMClassException("CIM_ERR_NOT_FOUND", (Object)cname);
            }
            CIMClass cc = (CIMClass)PSRlogImpl.deserialize(ccentry.getValue());
            v.addElement(cc.filterProperties(propertyList, includeQualifiers, includeClassOrigin));
        }
        catch (CIMException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CIMException("CIM_ERR_FAILED", e.toString());
        }
    }

    private ArrayList deepEnum(CIMNameSpaceRlogEntry nsentry, String cname) throws CIMException {
        CIMClassRlogEntry ccentry = nsentry.getClass(cname);
        if (ccentry == null) {
            throw new CIMClassException("CIM_ERR_NOT_FOUND", (Object)cname);
        }
        ArrayList<String> list = new ArrayList<String>();
        list.add(cname);
        for (int i = 0; i < list.size(); ++i) {
            ccentry = nsentry.getClass((String)list.get(i));
            if (ccentry == null) {
                throw new CIMClassException("CIM_ERR_NOT_FOUND", (Object)cname);
            }
            ArrayList arrayList = new ArrayList(ccentry.getSubClassKeys());
            for (int j = 0; j < arrayList.size(); ++j) {
                list.add((String)arrayList.get(j));
            }
        }
        return list;
    }

    private String getInstanceName(CIMNameSpaceRlogEntry nsentry, CIMObjectPath op) throws CIMException {
        CIMClassRlogEntry ccentry = nsentry.getClass(op.getObjectName());
        CIMClass cc = (CIMClass)PSRlogImpl.deserialize(ccentry.getValue());
        CIMInstance nci = cc.newInstance();
        nci.updatePropertyValues(op.getKeys());
        return InstanceNameUtils.getInstanceNameKey(nci);
    }

    public Vector associatorNames(CIMObjectPath op, CIMObjectPath objectName, String resultClass, String role, String resultRole) throws CIMException {
        return this.instanceAssociators(op, objectName, resultClass, role, resultRole, false, false, null, true, false);
    }

    public Vector associators(CIMObjectPath op, CIMObjectPath objectName, String resultClass, String role, String resultRole, boolean includeQualifiers, boolean includeClassOrigin, String[] propertyList) throws CIMException {
        return this.instanceAssociators(op, objectName, resultClass, role, resultRole, includeQualifiers, includeClassOrigin, propertyList, true, false);
    }

    public Vector reference(CIMObjectPath op, CIMObjectPath objectName, String role, boolean includeQualifiers, boolean includeClassOrigin, String[] propertyList) throws CIMException {
        return this.instanceAssociators(op, objectName, role, null, includeQualifiers, includeClassOrigin, propertyList, false, true);
    }

    public Vector referenceNames(CIMObjectPath op, CIMObjectPath objectName, String role) throws CIMException {
        return this.instanceAssociators(op, objectName, role, null, false, false, null, true, true);
    }

    private Vector instanceAssociators(CIMObjectPath assocName, CIMObjectPath objectName, String role, String resultRole, boolean includeQualifiers, boolean includeClassOrigin, String[] propertyList, boolean needop, boolean isRef) throws CIMException {
        return this.instanceAssociators(assocName, objectName, null, role, resultRole, includeQualifiers, includeClassOrigin, propertyList, needop, isRef);
    }

    private Vector instanceAssociators(CIMObjectPath assocName, CIMObjectPath objectName, String resultClass, String role, String resultRole, boolean includeQualifiers, boolean includeClassOrigin, String[] propertyList, boolean needop, boolean isRef) throws CIMException {
        Vector<Object> v = new Vector<Object>();
        if (role != null && role.length() != 0 && resultRole != null && resultRole.length() != 0 && role.equalsIgnoreCase(resultRole)) {
            return v;
        }
        String ns = objectName.getNameSpace();
        String cname = objectName.getObjectName();
        String asname = assocName.getObjectName();
        ns = ns.replace('\\', '/');
        try {
            this.concurrentObj.readLock();
            CIMNameSpaceRlogEntry nsentry = PSRlogImpl.getNameSpaceEntryFromMap(ns);
            CIMClassRlogEntry ccentry = nsentry.getClass(cname);
            if (ccentry == null) {
                throw new CIMClassException("CIM_ERR_NOT_FOUND", (Object)cname);
            }
            String iname = this.getInstanceName(nsentry, objectName);
            CIMInstanceRlogEntry cientry = ccentry.getInstance(iname);
            if (cientry == null) {
                throw new CIMInstanceException("CIM_ERR_NOT_FOUND", (Object)iname);
            }
            CIMAssocInstanceRlogEntry[] cimap = cientry.getAssociations(asname);
            if (cimap == null) {
                Vector<Object> vector = v;
                return vector;
            }
            HashMap<String, String> dups = new HashMap<String, String>();
            for (int i = 0; i < cimap.length; ++i) {
                CIMObjectPath op;
                if (dups.get(cimap[i].getName()) != null) continue;
                dups.put(cimap[i].getName(), "");
                if (isRef) {
                    CIMObjectPath asop = cimap[i].matchAssociator(iname, role, resultRole);
                    if (asop == null) continue;
                    if (needop) {
                        v.addElement(asop);
                        continue;
                    }
                    CIMInstance ci = this.getInstance(asop);
                    v.addElement(ci.filterProperties(propertyList, includeQualifiers, includeClassOrigin));
                    continue;
                }
                ArrayList rv = cimap[i].matchRole(iname, role, resultRole);
                HashSet<String> resultClassSet = null;
                if (resultClass != null && resultClass.length() != 0) {
                    resultClassSet = new HashSet<String>();
                    resultClassSet.add(resultClass.toLowerCase());
                    Vector resultV = this.enumClassesDo(ns, resultClass, true, true, false);
                    Iterator resultE = resultV.iterator();
                    while (resultE.hasNext()) {
                        op = (CIMObjectPath)resultE.next();
                        resultClassSet.add(op.getObjectName().toLowerCase());
                    }
                }
                int size = rv.size();
                for (int k = 0; k < size; ++k) {
                    op = (CIMObjectPath)rv.get(k);
                    if (resultClassSet != null && !resultClassSet.contains(op.getObjectName().toLowerCase())) continue;
                    v.addElement(op);
                }
            }
        }
        catch (CIMException e) {
            if (verbose) {
                e.printStackTrace();
            }
            throw e;
        }
        catch (Exception e) {
            if (verbose) {
                e.printStackTrace();
            }
            throw new CIMException("CIM_ERR_FAILED", e.toString());
        }
        finally {
            this.concurrentObj.readUnlock();
        }
        return v;
    }

    static byte[] serialize(Object obj) throws CIMException {
        byte[] bytes;
        try {
            ByteArrayOutputStream bas = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(bas);
            oos.writeObject(obj);
            oos.flush();
            bytes = bas.toByteArray();
            oos.close();
            bas.close();
        }
        catch (Exception e) {
            throw new CIMException("CIM_ERR_FAILED", e.toString());
        }
        return bytes;
    }

    static Object deserialize(byte[] bytes) throws CIMException {
        Object obj;
        try {
            ByteArrayInputStream bas = new ByteArrayInputStream(bytes);
            ObjectInputStream ois = new ObjectInputStream(bas);
            obj = ois.readObject();
            ois.close();
            bas.close();
        }
        catch (Exception e) {
            throw new CIMException("CIM_ERR_FAILED", e.toString());
        }
        return obj;
    }

    public void additionTriggerActivate(String namespace, String className) {
        this.eventHelper.additionTriggerActivate(namespace, className);
    }

    public void deletionTriggerActivate(String namespace, String className) {
        this.eventHelper.deletionTriggerActivate(namespace, className);
    }

    public void modificationTriggerActivate(String namespace, String className) {
        this.eventHelper.modificationTriggerActivate(namespace, className);
    }

    public void additionTriggerDeActivate(String namespace, String className) {
        this.eventHelper.additionTriggerDeActivate(namespace, className);
    }

    public void deletionTriggerDeActivate(String namespace, String className) {
        this.eventHelper.deletionTriggerDeActivate(namespace, className);
    }

    public void modificationTriggerDeActivate(String namespace, String className) {
        this.eventHelper.modificationTriggerDeActivate(namespace, className);
    }

    public void authorizeFilter(SelectExp filter, String eventType, CIMObjectPath classPath, String owner) throws CIMException {
        this.eventHelper.authorizeFilter(filter, eventType, classPath, owner);
    }

    public boolean mustPoll(SelectExp filter, String eventType, CIMObjectPath classPath) throws CIMException {
        return this.eventHelper.mustPoll(filter, eventType, classPath);
    }

    public void activateFilter(SelectExp filter, String eventType, CIMObjectPath classPath, boolean firstActivation) throws CIMException {
        this.eventHelper.activateFilter(filter, eventType, classPath, firstActivation);
    }

    public void deActivateFilter(SelectExp filter, String eventType, CIMObjectPath classPath, boolean lastActivation) throws CIMException {
        this.eventHelper.deActivateFilter(filter, eventType, classPath, lastActivation);
    }

    public void initialize(CIMOMHandle ch) {
    }

    public void cleanup() {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class SnapshotThread
    extends Thread {
        public SnapshotThread() {
            super("snapshot thread");
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            block14: {
                try {
                    PSRlogImpl.this.concurrentObj.readLock();
                }
                catch (ReadersWriter.ConcurrentLockException e) {
                    return;
                }
                while (true) {
                    if (this.isInterrupted()) break block14;
                    PSRlogImpl.this.concurrentObj.readerWait(PSRlogImpl.this.snapshotNotifier, Long.MAX_VALUE);
                    try {
                        PSRlogImpl.this.log.snapshot();
                        PSRlogImpl.this.logFileSize = 0;
                        continue;
                    }
                    catch (InterruptedIOException e) {
                        PSRlogImpl.this.concurrentObj.readUnlock();
                        return;
                    }
                    catch (Exception e) {
                        block15: {
                            if (!(e instanceof LogException) || !(((LogException)e).detail instanceof InterruptedIOException)) break block15;
                            PSRlogImpl.this.concurrentObj.readUnlock();
                            return;
                        }
                        try {
                            e.printStackTrace();
                            continue;
                        }
                        catch (ReadersWriter.ConcurrentLockException e2) {
                            PSRlogImpl.this.concurrentObj.readUnlock();
                            return;
                        }
                    }
                    break;
                }
                finally {
                    PSRlogImpl.this.concurrentObj.readUnlock();
                }
            }
        }
    }

    private class LocalLogHandler
    extends LogHandler {
        public void snapshot(OutputStream out) throws IOException {
            PSRlogImpl.this.takeSnapshot(out);
        }

        public void recover(InputStream in) throws IOException, ClassNotFoundException {
            PSRlogImpl.this.recoverSnapshot(in);
        }

        public void applyUpdate(Object logRecObj) {
            ((LogRecord)logRecObj).apply(PSRlogImpl.this);
        }
    }

    private static class DeleteInstanceLogObj
    implements LogRecord {
        private static final long serialVersionUID = -244838496512419329L;
        private String namespace;
        private String iname;

        public DeleteInstanceLogObj(String namespace, String iname) {
            this.namespace = namespace;
            this.iname = iname;
        }

        public void apply(PSRlogImpl psImpl) {
            try {
                psImpl.deleteInstance(this.namespace, this.iname);
            }
            catch (CIMException cIMException) {
                // empty catch block
            }
        }
    }

    private static class DeleteClassLogObj
    implements LogRecord {
        private static final long serialVersionUID = -6444092897893756582L;
        private String namespace;
        private String className;

        public DeleteClassLogObj(String namespace, String className) {
            this.namespace = namespace;
            this.className = className;
        }

        public void apply(PSRlogImpl psImpl) {
            try {
                psImpl.deleteClass(this.namespace, this.className);
            }
            catch (CIMException cIMException) {
                // empty catch block
            }
        }
    }

    private static class DeleteQualifierLogObj
    implements LogRecord {
        private static final long serialVersionUID = -4910178553526207227L;
        private String namespace;
        private String qtName;

        public DeleteQualifierLogObj(String namespace, String qtName) {
            this.namespace = namespace;
            this.qtName = qtName;
        }

        public void apply(PSRlogImpl psImpl) {
            try {
                psImpl.deleteQualifier(this.namespace, this.qtName);
            }
            catch (CIMException cIMException) {
                // empty catch block
            }
        }
    }

    private static class AddCIMInstanceLogObj
    extends AddCIMClassLogObj {
        private static final long serialVersionUID = -3727326644253863113L;

        public AddCIMInstanceLogObj(String namespace, String name, String otherName, boolean assoc, PersistentStore.PersistObject po) {
            super(namespace, name, otherName, assoc, po);
        }

        protected void applyDo(PSRlogImpl psImpl) throws CIMException {
            CIMInstance ci = this.assoc ? (CIMInstance)this.getCIMElement(psImpl) : null;
            this.entry = psImpl.addCIMInstanceDo(this.namespace, this.name, this.otherName, ci);
        }
    }

    private static class AddCIMClassLogObj
    extends AddCIMQualifierLogObj {
        private static final long serialVersionUID = -7848952153471853442L;
        protected String otherName;
        protected boolean assoc;

        public AddCIMClassLogObj(String namespace, String name, String otherName, boolean assoc, PersistentStore.PersistObject po) {
            super(namespace, name, po);
            this.assoc = assoc;
            this.otherName = otherName;
        }

        protected void applyDo(PSRlogImpl psImpl) throws CIMException {
            CIMClass cc = this.assoc ? (CIMClass)this.getCIMElement(psImpl) : null;
            this.entry = psImpl.addCIMClassDo(this.namespace, this.name, this.otherName, this.assoc, cc);
        }
    }

    private static class SetCIMInstanceLogObj
    extends SetCIMClassLogObj {
        private static final long serialVersionUID = 8152734320755230951L;

        public SetCIMInstanceLogObj(String namespace, String name, String otherName, PersistentStore.PersistObject po) {
            super(namespace, name, otherName, po);
        }

        protected void applyDo(PSRlogImpl psImpl) throws CIMException {
            this.entry = psImpl.setInstanceDo(this.namespace, this.name, this.otherName);
        }
    }

    private static class SetCIMClassLogObj
    extends AddCIMQualifierLogObj {
        private static final long serialVersionUID = 4842199887990665842L;
        protected String otherName;

        public SetCIMClassLogObj(String namespace, String name, String otherName, PersistentStore.PersistObject po) {
            super(namespace, name, po);
            this.otherName = otherName;
        }

        protected void applyDo(PSRlogImpl psImpl) throws CIMException {
            this.entry = psImpl.setClassDo(this.namespace, this.name, this.otherName);
        }
    }

    private static class SetCIMQualifierLogObj
    extends AddCIMQualifierLogObj {
        private static final long serialVersionUID = 6509220164924254555L;

        public SetCIMQualifierLogObj(String namespace, String name, PersistentStore.PersistObject po) {
            super(namespace, name, po);
        }

        protected void applyDo(PSRlogImpl psImpl) throws CIMException {
            this.entry = psImpl.setQualifierTypeDo(this.namespace, this.name);
        }
    }

    private static class AddCIMQualifierLogObj
    implements LogRecord {
        private static final long serialVersionUID = 9136358929100936537L;
        protected String namespace;
        protected String name;
        protected PersistentStore.PersistObject po;
        protected transient CIMRlogEntry entry = null;

        public AddCIMQualifierLogObj(String namespace, String name, PersistentStore.PersistObject po) {
            this.namespace = namespace;
            this.name = name;
            this.po = po;
        }

        public void apply(PSRlogImpl psImpl) {
            try {
                psImpl.store.addPersistObject(this.po);
                this.applyDo(psImpl);
                this.entry.setID(this.po.getID());
            }
            catch (CIMException cIMException) {
                // empty catch block
            }
        }

        protected void applyDo(PSRlogImpl psImpl) throws CIMException {
            this.entry = psImpl.addCIMQualifierTypeDo(this.namespace, this.name);
        }

        protected CIMElement getCIMElement(PSRlogImpl psImpl) throws CIMException {
            try {
                byte[] bytes = psImpl.store.readObjectBytes(this.po.getID());
                return (CIMElement)PSRlogImpl.deserialize(bytes);
            }
            catch (IOException e) {
                System.out.println("exception:" + e);
                e.printStackTrace();
                throw new RuntimeException("object id = " + this.po.getID() + " does not exist");
            }
        }
    }

    private static class DeleteNameSpaceLogObj
    implements LogRecord {
        private static final long serialVersionUID = 6349423596857633706L;
        private String namespace;

        public DeleteNameSpaceLogObj(String namespace) {
            this.namespace = namespace;
        }

        public void apply(PSRlogImpl psImpl) {
            try {
                psImpl.deleteNameSpaceDo(this.namespace);
            }
            catch (CIMException cIMException) {
                // empty catch block
            }
        }
    }

    private static class CreateNameSpaceLogObj
    implements LogRecord {
        private static final long serialVersionUID = -3217549711344318384L;
        private String namespace;

        public CreateNameSpaceLogObj(String namespace) {
            this.namespace = namespace;
        }

        public void apply(PSRlogImpl psImpl) {
            try {
                psImpl.createNameSpaceDo(this.namespace);
            }
            catch (CIMException cIMException) {
                // empty catch block
            }
        }
    }

    private static interface LogRecord
    extends Serializable {
        public void apply(PSRlogImpl var1);
    }
}

