/*
 * Decompiled with CFR 0.152.
 */
package org.wbemservices.wbem.repository;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.TreeMap;

class PersistentStore {
    private String fileName;
    private long fileLength;
    private Object[] maps = new Object[4];
    private TreeMap deletedObjectsBySize = new TreeMap();
    private HashMap deletedObjectsByOffset = new HashMap();
    private HashMap deletedObjectsByEnd = new HashMap();
    private HashMap objectIdMap = new HashMap();

    public PersistentStore(String fileName) throws IOException {
        this.fileName = fileName;
        this.fileLength = 0L;
        this.maps[0] = this.deletedObjectsBySize;
        this.maps[1] = this.deletedObjectsByOffset;
        this.maps[2] = this.deletedObjectsByEnd;
        this.maps[3] = this.objectIdMap;
        RandomAccessFile raf = new RandomAccessFile(fileName, "rw");
        this.fileLength = raf.length();
        raf.close();
    }

    public byte[] readObjectBytes(long objId) throws IOException {
        PersistObject po = this.getObjectFromId(objId);
        byte[] bytes = new byte[po.length];
        this.read(bytes, po.offset);
        return bytes;
    }

    public long writeObjectBytes(byte[] bytes) throws IOException {
        int length = bytes.length;
        PersistObject po = this.createPersistObject(length);
        this.write(po.offset, bytes);
        this.putObjectToIdMap(po);
        return po.id;
    }

    public void deleteObject(long id) {
        PersistObject po = this.getObjectFromId(id);
        if (po == null) {
            System.out.println("invaid object id: " + id);
            return;
        }
        this.removeObjectFromIdMap(id);
        this.addDeletedObject(po, false);
    }

    private void joinDeleteObject() {
        HashMap tmp = (HashMap)this.deletedObjectsByOffset.clone();
        Iterator iter = tmp.values().iterator();
        while (iter.hasNext()) {
            PersistObject po = (PersistObject)iter.next();
            if (this.deletedObjectsByOffset.get(new Long(po.offset)) == null) continue;
            this.removeDeleteObject(po);
            PersistObject poJoin = (PersistObject)this.deletedObjectsByOffset.get(new Long(po.offset + (long)po.length));
            if (poJoin != null) {
                this.removeDeleteObject(poJoin);
                po.length += poJoin.length;
            }
            this.addDeletedObject(po, false);
            poJoin = (PersistObject)this.deletedObjectsByEnd.get(new Long(po.offset));
            if (poJoin == null) continue;
            this.removeDeleteObject(po);
            this.removeDeleteObject(poJoin);
            poJoin.length += po.length;
            this.addDeletedObject(poJoin, false);
        }
    }

    public void addToSnapshot(ObjectOutputStream stream) throws IOException {
        this.joinDeleteObject();
        Iterator iter = this.deletedObjectsByOffset.values().iterator();
        while (iter.hasNext()) {
            PersistObject po = (PersistObject)iter.next();
            this.deletedObjectsBySize.remove(po);
            po.bReadyToUse = true;
            this.deletedObjectsBySize.put(po, po);
        }
        PersistObject poTemp = (PersistObject)this.deletedObjectsByEnd.get(new Long(this.fileLength));
        if (poTemp != null && poTemp.bReadyToUse) {
            RandomAccessFile raf = new RandomAccessFile(this.fileName, "rw");
            raf.setLength(poTemp.offset);
            this.fileLength = poTemp.offset;
            raf.close();
            this.removeDeleteObject(poTemp);
        }
        stream.writeLong(PersistObject.currentID);
        stream.writeObject(this.maps);
    }

    public void recoverFromSnapshot(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        PersistObject.currentID = stream.readLong();
        this.maps = (Object[])stream.readObject();
        this.deletedObjectsBySize = (TreeMap)this.maps[0];
        this.deletedObjectsByOffset = (HashMap)this.maps[1];
        this.deletedObjectsByEnd = (HashMap)this.maps[2];
        this.objectIdMap = (HashMap)this.maps[3];
    }

    public PersistObject getPersistObject(long id) {
        return this.getObjectFromId(id);
    }

    public void addPersistObject(PersistObject po) {
        this.putObjectToIdMap(po);
        this.createPersistObject(po.length);
    }

    private PersistObject createPersistObject(int length) {
        PersistObject po = new PersistObject(this.fileLength, length);
        if (this.deletedObjectsBySize.isEmpty()) {
            return po;
        }
        PersistObject poDeleted = (PersistObject)this.deletedObjectsBySize.lastKey();
        if (!poDeleted.bReadyToUse || poDeleted.length < po.length) {
            return po;
        }
        this.removeDeleteObject(poDeleted);
        po.offset = poDeleted.offset;
        poDeleted.offset = po.offset + (long)length;
        poDeleted.length -= po.length;
        this.addDeletedObject(poDeleted, true);
        return po;
    }

    private void addDeletedObject(PersistObject po, boolean ready) {
        if (po.length == 0) {
            return;
        }
        po.bReadyToUse = ready;
        Long endObj = new Long(po.offset + (long)po.length);
        this.deletedObjectsBySize.put(po, po);
        this.deletedObjectsByOffset.put(new Long(po.offset), po);
        this.deletedObjectsByEnd.put(endObj, po);
    }

    private void removeDeleteObject(PersistObject po) {
        this.deletedObjectsBySize.remove(po);
        this.deletedObjectsByOffset.remove(new Long(po.offset));
        this.deletedObjectsByEnd.remove(new Long(po.offset + (long)po.length));
    }

    private PersistObject getObjectFromId(long id) {
        return (PersistObject)this.objectIdMap.get(new Long(id));
    }

    private void putObjectToIdMap(PersistObject po) {
        this.objectIdMap.put(new Long(po.id), po);
    }

    private void removeObjectFromIdMap(long id) {
        this.objectIdMap.remove(new Long(id));
    }

    private void write(long pos, byte[] bytes) throws IOException {
        RandomAccessFile raf = new RandomAccessFile(this.fileName, "rw");
        raf.seek(pos);
        raf.write(bytes);
        this.fileLength = raf.length();
        raf.close();
    }

    private void read(byte[] rb, long pos) throws IOException {
        RandomAccessFile raf = new RandomAccessFile(this.fileName, "r");
        raf.seek(pos);
        raf.read(rb);
        raf.close();
    }

    static class PersistObject
    implements Comparable,
    Serializable {
        private static final long serialVersionUID = -8265199713085209820L;
        static long currentID = 0L;
        private long id = currentID++;
        private long offset;
        private int length;
        private boolean bReadyToUse = true;

        public PersistObject(long offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        public int compareTo(Object o) {
            PersistObject po = (PersistObject)o;
            if (this == po) {
                return 0;
            }
            if (this.bReadyToUse && !po.bReadyToUse) {
                return 1;
            }
            if (!this.bReadyToUse && po.bReadyToUse) {
                return -1;
            }
            if (this.length == po.length) {
                return this.id > po.id ? 1 : -1;
            }
            return this.length > po.length ? 1 : -1;
        }

        public long getID() {
            return this.id;
        }
    }
}

