/*
 * Decompiled with CFR 0.152.
 */
package org.sblim.wbem.cim;

import java.util.Iterator;
import java.util.Vector;
import org.sblim.wbem.cim.CIMObjectPath;
import org.sblim.wbem.cim.CIMProperty;
import org.sblim.wbem.cim.CIMQualifiableElement;
import org.sblim.wbem.cim.CIMValue;
import org.sblim.wbem.util.Utils;

public abstract class CIMObject
extends CIMQualifiableElement {
    protected CIMObjectPath objectpath;
    protected Vector allProperties = new Vector(0);

    protected CIMObject() {
    }

    protected CIMObject(String name) {
        super(name);
    }

    public CIMProperty getProperty(String propertyName) {
        if (propertyName == null) {
            throw new IllegalArgumentException("null property name argument");
        }
        int delimiter = propertyName.indexOf(46);
        if (delimiter > -1) {
            return this.getProperty(propertyName.substring(delimiter + 1), propertyName.substring(0, delimiter));
        }
        Iterator iter = this.allProperties.iterator();
        while (iter.hasNext()) {
            CIMProperty property = (CIMProperty)iter.next();
            if (!property.getName().equalsIgnoreCase(propertyName)) continue;
            String overridingProperty = property.getOverridingProperty();
            if (overridingProperty != null) {
                int delimeter = overridingProperty.indexOf(46);
                if (delimeter > -1) {
                    return this.getProperty(overridingProperty.substring(delimeter + 1), overridingProperty.substring(0, delimeter));
                }
                return this.getProperty(overridingProperty);
            }
            return property;
        }
        return null;
    }

    public CIMProperty getProperty(String name, String originClass) {
        if (name == null) {
            return null;
        }
        if (originClass == null || originClass.length() == 0) {
            return this.getProperty(name);
        }
        Iterator iter = this.allProperties.iterator();
        while (iter.hasNext()) {
            CIMProperty property = (CIMProperty)iter.next();
            if (!property.getName().equalsIgnoreCase(name) || !property.getOriginClass().equalsIgnoreCase(originClass)) continue;
            String overridingProperty = property.getOverridingProperty();
            if (overridingProperty != null) {
                int delimeter = overridingProperty.indexOf(46);
                if (delimeter > -1) {
                    return this.getProperty(overridingProperty.substring(delimeter + 1), overridingProperty.substring(0, delimeter));
                }
                return this.getProperty(overridingProperty);
            }
            return property;
        }
        return null;
    }

    protected CIMProperty getProperty(CIMProperty propperty) {
        Iterator iter = this.allProperties.iterator();
        while (iter.hasNext()) {
            CIMProperty property = (CIMProperty)iter.next();
            if (!property.getName().equalsIgnoreCase(propperty.getName())) continue;
            return property;
        }
        return null;
    }

    protected CIMProperty getAllProperty(CIMProperty prop) {
        Iterator iter = this.allProperties.iterator();
        while (iter.hasNext()) {
            CIMProperty property = (CIMProperty)iter.next();
            if (!property.getName().equalsIgnoreCase(prop.getName())) continue;
            return property;
        }
        return null;
    }

    public Vector getProperties() {
        Vector<CIMProperty> properties = new Vector<CIMProperty>();
        Iterator iter = this.allProperties.iterator();
        while (iter.hasNext()) {
            CIMProperty property = (CIMProperty)iter.next();
            if (property.getOriginClass() != null) continue;
            properties.add(property);
        }
        return properties;
    }

    public Vector getAllProperties() {
        return this.allProperties;
    }

    public void addProperty(CIMProperty property) {
        if (property == null) {
            throw new IllegalArgumentException("null property argument");
        }
        Utils.addSorted(this.allProperties, property);
    }

    public void setProperties(Vector v) {
        if (v == null) {
            this.allProperties.setSize(0);
        } else {
            this.allProperties.setSize(0);
            Utils.addSorted(this.allProperties, v);
        }
    }

    public CIMProperty setProperty(String propertyName, CIMValue value) {
        if (propertyName == null) {
            throw new IllegalArgumentException("null property name argument");
        }
        CIMProperty property = this.getProperty(propertyName);
        if (property == null) {
            property = new CIMProperty(propertyName, value);
            this.addProperty(property);
        } else {
            property.setValue(value);
        }
        return property;
    }

    public CIMProperty removeProperty(String propertyName) {
        if (propertyName == null) {
            throw new IllegalArgumentException("null property name argument");
        }
        Iterator iter = this.allProperties.iterator();
        while (iter.hasNext()) {
            CIMProperty prop = (CIMProperty)iter.next();
            if (!prop.getName().equalsIgnoreCase(propertyName)) continue;
            iter.remove();
            return prop;
        }
        return null;
    }

    public Vector getKeys() {
        Vector keys = new Vector();
        Iterator iter = this.allProperties.iterator();
        while (iter.hasNext()) {
            CIMProperty property = (CIMProperty)iter.next();
            if (!property.isKey()) continue;
            Utils.addSorted(keys, (CIMProperty)property.clone());
        }
        return keys;
    }

    abstract CIMObjectPath getObjectPath();

    public abstract void setObjectPath(CIMObjectPath var1);
}

