/*
 * Decompiled with CFR 0.152.
 */
package org.sblim.wbem.cim;

import java.io.Serializable;
import org.sblim.wbem.cim.UnsignedInt8;

public class UnsignedInt16
extends Number
implements Serializable,
Cloneable {
    private int value;
    public static int MIN_VALUE = 0;
    public static int MAX_VALUE = 65535;

    public UnsignedInt16(byte value) {
        if (value < MIN_VALUE || value > MAX_VALUE) {
            throw new IllegalArgumentException("Invalid value range. Value must be in a " + MIN_VALUE + ".." + MAX_VALUE + " range");
        }
        this.value = value;
    }

    public UnsignedInt16(short value) {
        if (value < MIN_VALUE || value > MAX_VALUE) {
            throw new IllegalArgumentException("Invalid value range. Value must be in a " + MIN_VALUE + ".." + MAX_VALUE + " range");
        }
        this.value = value;
    }

    public UnsignedInt16(int value) {
        if (value < MIN_VALUE || value > MAX_VALUE) {
            throw new IllegalArgumentException("Invalid value range. Value must be in a " + MIN_VALUE + ".." + MAX_VALUE + " range");
        }
        this.value = value;
    }

    public UnsignedInt16(String value) {
        if (value == null) {
            throw new IllegalArgumentException("null string argument");
        }
        if (value.trim().length() == 0) {
            throw new IllegalArgumentException("empty string argument");
        }
        this.value = Integer.parseInt(value);
        if (this.value < MIN_VALUE || this.value > MAX_VALUE) {
            throw new IllegalArgumentException("Invalid value range. Value must be in a " + MIN_VALUE + ".." + MAX_VALUE + " range");
        }
    }

    public UnsignedInt16(UnsignedInt8 value) {
        this.value = value.intValue();
    }

    public UnsignedInt16(UnsignedInt16 value) {
        this.value = value.intValue();
    }

    public String toString() {
        return Integer.toString(this.value);
    }

    public boolean equals(Object o) {
        if (o instanceof UnsignedInt16) {
            return this.value == ((UnsignedInt16)o).value;
        }
        return false;
    }

    public byte byteValue() {
        if (this.value < -128 || this.value > 127) {
            throw new NumberFormatException("Value range exceeded. The value " + this.value + " is not in the range of a Byte value which is inbetween " + -128 + " .. " + 127);
        }
        return (byte)this.value;
    }

    public short shortValue() {
        if (this.value < Short.MIN_VALUE || this.value > Short.MAX_VALUE) {
            throw new NumberFormatException("Value range exceeded. The value " + this.value + " is not in the range of a Short value which is inbetween " + Short.MIN_VALUE + " .. " + Short.MAX_VALUE);
        }
        return (short)this.value;
    }

    public int intValue() {
        return this.value;
    }

    public long longValue() {
        return this.value;
    }

    public float floatValue() {
        return this.value;
    }

    public double doubleValue() {
        return this.value;
    }

    public int hashCode() {
        return new Integer(this.value).hashCode();
    }

    public Object clone() {
        return new UnsignedInt16(this.value);
    }
}

